# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetReservedInstanceOfferingResult',
    'AwaitableGetReservedInstanceOfferingResult',
    'get_reserved_instance_offering',
    'get_reserved_instance_offering_output',
]

@pulumi.output_type
class GetReservedInstanceOfferingResult:
    """
    A collection of values returned by getReservedInstanceOffering.
    """
    def __init__(__self__, currency_code=None, db_instance_class=None, duration=None, fixed_price=None, id=None, multi_az=None, offering_id=None, offering_type=None, product_description=None):
        if currency_code and not isinstance(currency_code, str):
            raise TypeError("Expected argument 'currency_code' to be a str")
        pulumi.set(__self__, "currency_code", currency_code)
        if db_instance_class and not isinstance(db_instance_class, str):
            raise TypeError("Expected argument 'db_instance_class' to be a str")
        pulumi.set(__self__, "db_instance_class", db_instance_class)
        if duration and not isinstance(duration, int):
            raise TypeError("Expected argument 'duration' to be a int")
        pulumi.set(__self__, "duration", duration)
        if fixed_price and not isinstance(fixed_price, float):
            raise TypeError("Expected argument 'fixed_price' to be a float")
        pulumi.set(__self__, "fixed_price", fixed_price)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if multi_az and not isinstance(multi_az, bool):
            raise TypeError("Expected argument 'multi_az' to be a bool")
        pulumi.set(__self__, "multi_az", multi_az)
        if offering_id and not isinstance(offering_id, str):
            raise TypeError("Expected argument 'offering_id' to be a str")
        pulumi.set(__self__, "offering_id", offering_id)
        if offering_type and not isinstance(offering_type, str):
            raise TypeError("Expected argument 'offering_type' to be a str")
        pulumi.set(__self__, "offering_type", offering_type)
        if product_description and not isinstance(product_description, str):
            raise TypeError("Expected argument 'product_description' to be a str")
        pulumi.set(__self__, "product_description", product_description)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code for the reserved DB instance.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> str:
        return pulumi.get(self, "db_instance_class")

    @property
    @pulumi.getter
    def duration(self) -> int:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="fixedPrice")
    def fixed_price(self) -> float:
        """
        Fixed price charged for this reserved DB instance.
        """
        return pulumi.get(self, "fixed_price")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> bool:
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter(name="offeringId")
    def offering_id(self) -> str:
        """
        Unique identifier for the reservation.
        """
        return pulumi.get(self, "offering_id")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> str:
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="productDescription")
    def product_description(self) -> str:
        return pulumi.get(self, "product_description")


class AwaitableGetReservedInstanceOfferingResult(GetReservedInstanceOfferingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReservedInstanceOfferingResult(
            currency_code=self.currency_code,
            db_instance_class=self.db_instance_class,
            duration=self.duration,
            fixed_price=self.fixed_price,
            id=self.id,
            multi_az=self.multi_az,
            offering_id=self.offering_id,
            offering_type=self.offering_type,
            product_description=self.product_description)


def get_reserved_instance_offering(db_instance_class: Optional[str] = None,
                                   duration: Optional[int] = None,
                                   multi_az: Optional[bool] = None,
                                   offering_type: Optional[str] = None,
                                   product_description: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReservedInstanceOfferingResult:
    """
    Information about a single RDS Reserved Instance Offering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.rds.get_reserved_instance_offering(db_instance_class="db.t2.micro",
        duration=31536000,
        multi_az=False,
        offering_type="All Upfront",
        product_description="mysql")
    ```


    :param str db_instance_class: DB instance class for the reserved DB instance.
    :param int duration: Duration of the reservation in years or seconds. Valid values are `1`, `3`, `31536000`, `94608000`
    :param bool multi_az: Whether the reservation applies to Multi-AZ deployments.
    :param str offering_type: Offering type of this reserved DB instance. Valid values are `No Upfront`, `Partial Upfront`, `All Upfront`.
    :param str product_description: Description of the reserved DB instance.
    """
    __args__ = dict()
    __args__['dbInstanceClass'] = db_instance_class
    __args__['duration'] = duration
    __args__['multiAz'] = multi_az
    __args__['offeringType'] = offering_type
    __args__['productDescription'] = product_description
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:rds/getReservedInstanceOffering:getReservedInstanceOffering', __args__, opts=opts, typ=GetReservedInstanceOfferingResult).value

    return AwaitableGetReservedInstanceOfferingResult(
        currency_code=pulumi.get(__ret__, 'currency_code'),
        db_instance_class=pulumi.get(__ret__, 'db_instance_class'),
        duration=pulumi.get(__ret__, 'duration'),
        fixed_price=pulumi.get(__ret__, 'fixed_price'),
        id=pulumi.get(__ret__, 'id'),
        multi_az=pulumi.get(__ret__, 'multi_az'),
        offering_id=pulumi.get(__ret__, 'offering_id'),
        offering_type=pulumi.get(__ret__, 'offering_type'),
        product_description=pulumi.get(__ret__, 'product_description'))
def get_reserved_instance_offering_output(db_instance_class: Optional[pulumi.Input[str]] = None,
                                          duration: Optional[pulumi.Input[int]] = None,
                                          multi_az: Optional[pulumi.Input[bool]] = None,
                                          offering_type: Optional[pulumi.Input[str]] = None,
                                          product_description: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReservedInstanceOfferingResult]:
    """
    Information about a single RDS Reserved Instance Offering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.rds.get_reserved_instance_offering(db_instance_class="db.t2.micro",
        duration=31536000,
        multi_az=False,
        offering_type="All Upfront",
        product_description="mysql")
    ```


    :param str db_instance_class: DB instance class for the reserved DB instance.
    :param int duration: Duration of the reservation in years or seconds. Valid values are `1`, `3`, `31536000`, `94608000`
    :param bool multi_az: Whether the reservation applies to Multi-AZ deployments.
    :param str offering_type: Offering type of this reserved DB instance. Valid values are `No Upfront`, `Partial Upfront`, `All Upfront`.
    :param str product_description: Description of the reserved DB instance.
    """
    __args__ = dict()
    __args__['dbInstanceClass'] = db_instance_class
    __args__['duration'] = duration
    __args__['multiAz'] = multi_az
    __args__['offeringType'] = offering_type
    __args__['productDescription'] = product_description
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:rds/getReservedInstanceOffering:getReservedInstanceOffering', __args__, opts=opts, typ=GetReservedInstanceOfferingResult)
    return __ret__.apply(lambda __response__: GetReservedInstanceOfferingResult(
        currency_code=pulumi.get(__response__, 'currency_code'),
        db_instance_class=pulumi.get(__response__, 'db_instance_class'),
        duration=pulumi.get(__response__, 'duration'),
        fixed_price=pulumi.get(__response__, 'fixed_price'),
        id=pulumi.get(__response__, 'id'),
        multi_az=pulumi.get(__response__, 'multi_az'),
        offering_id=pulumi.get(__response__, 'offering_id'),
        offering_type=pulumi.get(__response__, 'offering_type'),
        product_description=pulumi.get(__response__, 'product_description')))
