# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GlobalClusterArgs', 'GlobalCluster']

@pulumi.input_type
class GlobalClusterArgs:
    def __init__(__self__, *,
                 global_cluster_identifier: pulumi.Input[str],
                 database_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a GlobalCluster resource.
        :param pulumi.Input[str] global_cluster_identifier: Global cluster identifier.
        :param pulumi.Input[str] database_name: Name for an automatically created database on cluster creation. Pulumi will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[bool] deletion_protection: If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        :param pulumi.Input[str] engine: Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Valid values: `aurora`, `aurora-mysql`, `aurora-postgresql`. Defaults to `aurora`. Conflicts with `source_db_cluster_identifier`.
        :param pulumi.Input[str] engine_lifecycle_support: The life cycle type for this DB instance. This setting applies only to Aurora PostgreSQL-based global databases. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        :param pulumi.Input[str] engine_version: Engine version of the Aurora global database. The `engine`, `engine_version`, and `instance_class` (on the `rds.ClusterInstance`) must together support global databases. See [Using Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) for more information. By upgrading the engine version, the provider will upgrade cluster members. **NOTE:** To avoid an `inconsistent final plan` error while upgrading, use the `lifecycle` `ignore_changes` for `engine_version` meta argument on the associated `rds.Cluster` resource as shown above in Upgrading Engine Versions example.
        :param pulumi.Input[bool] force_destroy: Enable to remove DB Cluster members from Global Cluster on destroy. Required with `source_db_cluster_identifier`.
        :param pulumi.Input[str] source_db_cluster_identifier: Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "global_cluster_identifier", global_cluster_identifier)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_lifecycle_support is not None:
            pulumi.set(__self__, "engine_lifecycle_support", engine_lifecycle_support)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if source_db_cluster_identifier is not None:
            pulumi.set(__self__, "source_db_cluster_identifier", source_db_cluster_identifier)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> pulumi.Input[str]:
        """
        Global cluster identifier.
        """
        return pulumi.get(self, "global_cluster_identifier")

    @global_cluster_identifier.setter
    def global_cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "global_cluster_identifier", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for an automatically created database on cluster creation. Pulumi will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Valid values: `aurora`, `aurora-mysql`, `aurora-postgresql`. Defaults to `aurora`. Conflicts with `source_db_cluster_identifier`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> Optional[pulumi.Input[str]]:
        """
        The life cycle type for this DB instance. This setting applies only to Aurora PostgreSQL-based global databases. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @engine_lifecycle_support.setter
    def engine_lifecycle_support(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_lifecycle_support", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Engine version of the Aurora global database. The `engine`, `engine_version`, and `instance_class` (on the `rds.ClusterInstance`) must together support global databases. See [Using Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) for more information. By upgrading the engine version, the provider will upgrade cluster members. **NOTE:** To avoid an `inconsistent final plan` error while upgrading, use the `lifecycle` `ignore_changes` for `engine_version` meta argument on the associated `rds.Cluster` resource as shown above in Upgrading Engine Versions example.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to remove DB Cluster members from Global Cluster on destroy. Required with `source_db_cluster_identifier`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @source_db_cluster_identifier.setter
    def source_db_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_cluster_identifier", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GlobalClusterState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 engine_version_actual: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 global_cluster_members: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalClusterGlobalClusterMemberArgs']]]] = None,
                 global_cluster_resource_id: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering GlobalCluster resources.
        :param pulumi.Input[str] arn: RDS Global Cluster Amazon Resource Name (ARN).
        :param pulumi.Input[str] database_name: Name for an automatically created database on cluster creation. Pulumi will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[bool] deletion_protection: If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        :param pulumi.Input[str] endpoint: Writer endpoint for the new global database cluster. This endpoint always points to the writer DB instance in the current primary cluster.
        :param pulumi.Input[str] engine: Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Valid values: `aurora`, `aurora-mysql`, `aurora-postgresql`. Defaults to `aurora`. Conflicts with `source_db_cluster_identifier`.
        :param pulumi.Input[str] engine_lifecycle_support: The life cycle type for this DB instance. This setting applies only to Aurora PostgreSQL-based global databases. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        :param pulumi.Input[str] engine_version: Engine version of the Aurora global database. The `engine`, `engine_version`, and `instance_class` (on the `rds.ClusterInstance`) must together support global databases. See [Using Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) for more information. By upgrading the engine version, the provider will upgrade cluster members. **NOTE:** To avoid an `inconsistent final plan` error while upgrading, use the `lifecycle` `ignore_changes` for `engine_version` meta argument on the associated `rds.Cluster` resource as shown above in Upgrading Engine Versions example.
        :param pulumi.Input[bool] force_destroy: Enable to remove DB Cluster members from Global Cluster on destroy. Required with `source_db_cluster_identifier`.
        :param pulumi.Input[str] global_cluster_identifier: Global cluster identifier.
        :param pulumi.Input[Sequence[pulumi.Input['GlobalClusterGlobalClusterMemberArgs']]] global_cluster_members: Set of objects containing Global Cluster members.
        :param pulumi.Input[str] global_cluster_resource_id: AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.
        :param pulumi.Input[str] source_db_cluster_identifier: Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_lifecycle_support is not None:
            pulumi.set(__self__, "engine_lifecycle_support", engine_lifecycle_support)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if engine_version_actual is not None:
            pulumi.set(__self__, "engine_version_actual", engine_version_actual)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if global_cluster_identifier is not None:
            pulumi.set(__self__, "global_cluster_identifier", global_cluster_identifier)
        if global_cluster_members is not None:
            pulumi.set(__self__, "global_cluster_members", global_cluster_members)
        if global_cluster_resource_id is not None:
            pulumi.set(__self__, "global_cluster_resource_id", global_cluster_resource_id)
        if source_db_cluster_identifier is not None:
            pulumi.set(__self__, "source_db_cluster_identifier", source_db_cluster_identifier)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        RDS Global Cluster Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for an automatically created database on cluster creation. Pulumi will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Writer endpoint for the new global database cluster. This endpoint always points to the writer DB instance in the current primary cluster.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Valid values: `aurora`, `aurora-mysql`, `aurora-postgresql`. Defaults to `aurora`. Conflicts with `source_db_cluster_identifier`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> Optional[pulumi.Input[str]]:
        """
        The life cycle type for this DB instance. This setting applies only to Aurora PostgreSQL-based global databases. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @engine_lifecycle_support.setter
    def engine_lifecycle_support(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_lifecycle_support", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Engine version of the Aurora global database. The `engine`, `engine_version`, and `instance_class` (on the `rds.ClusterInstance`) must together support global databases. See [Using Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) for more information. By upgrading the engine version, the provider will upgrade cluster members. **NOTE:** To avoid an `inconsistent final plan` error while upgrading, use the `lifecycle` `ignore_changes` for `engine_version` meta argument on the associated `rds.Cluster` resource as shown above in Upgrading Engine Versions example.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "engine_version_actual")

    @engine_version_actual.setter
    def engine_version_actual(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version_actual", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to remove DB Cluster members from Global Cluster on destroy. Required with `source_db_cluster_identifier`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Global cluster identifier.
        """
        return pulumi.get(self, "global_cluster_identifier")

    @global_cluster_identifier.setter
    def global_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_cluster_identifier", value)

    @property
    @pulumi.getter(name="globalClusterMembers")
    def global_cluster_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GlobalClusterGlobalClusterMemberArgs']]]]:
        """
        Set of objects containing Global Cluster members.
        """
        return pulumi.get(self, "global_cluster_members")

    @global_cluster_members.setter
    def global_cluster_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalClusterGlobalClusterMemberArgs']]]]):
        pulumi.set(self, "global_cluster_members", value)

    @property
    @pulumi.getter(name="globalClusterResourceId")
    def global_cluster_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.
        """
        return pulumi.get(self, "global_cluster_resource_id")

    @global_cluster_resource_id.setter
    def global_cluster_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_cluster_resource_id", value)

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @source_db_cluster_identifier.setter
    def source_db_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_cluster_identifier", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class GlobalCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages an RDS Global Cluster, which is an Aurora global database spread across multiple regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.

        More information about Aurora global databases can be found in the [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database-creating).

        ## Example Usage

        ### New MySQL Global Cluster

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.GlobalCluster("example",
            global_cluster_identifier="global-test",
            engine="aurora",
            engine_version="5.6.mysql_aurora.1.22.2",
            database_name="example_db")
        primary = aws.rds.Cluster("primary",
            engine=example.engine,
            engine_version=example.engine_version,
            cluster_identifier="test-primary-cluster",
            master_username="username",
            master_password="somepass123",
            database_name="example_db",
            global_cluster_identifier=example.id,
            db_subnet_group_name="default")
        primary_cluster_instance = aws.rds.ClusterInstance("primary",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="test-primary-cluster-instance",
            cluster_identifier=primary.id,
            instance_class=aws.rds.InstanceType.R4_LARGE,
            db_subnet_group_name="default")
        secondary = aws.rds.Cluster("secondary",
            engine=example.engine,
            engine_version=example.engine_version,
            cluster_identifier="test-secondary-cluster",
            global_cluster_identifier=example.id,
            db_subnet_group_name="default",
            opts = pulumi.ResourceOptions(depends_on=[primary_cluster_instance]))
        secondary_cluster_instance = aws.rds.ClusterInstance("secondary",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="test-secondary-cluster-instance",
            cluster_identifier=secondary.id,
            instance_class=aws.rds.InstanceType.R4_LARGE,
            db_subnet_group_name="default")
        ```

        ### New PostgreSQL Global Cluster

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.GlobalCluster("example",
            global_cluster_identifier="global-test",
            engine="aurora-postgresql",
            engine_version="11.9",
            database_name="example_db")
        primary = aws.rds.Cluster("primary",
            engine=example.engine,
            engine_version=example.engine_version,
            cluster_identifier="test-primary-cluster",
            master_username="username",
            master_password="somepass123",
            database_name="example_db",
            global_cluster_identifier=example.id,
            db_subnet_group_name="default")
        primary_cluster_instance = aws.rds.ClusterInstance("primary",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="test-primary-cluster-instance",
            cluster_identifier=primary.id,
            instance_class=aws.rds.InstanceType.R4_LARGE,
            db_subnet_group_name="default")
        secondary = aws.rds.Cluster("secondary",
            engine=example.engine,
            engine_version=example.engine_version,
            cluster_identifier="test-secondary-cluster",
            global_cluster_identifier=example.id,
            skip_final_snapshot=True,
            db_subnet_group_name="default",
            opts = pulumi.ResourceOptions(depends_on=[primary_cluster_instance]))
        secondary_cluster_instance = aws.rds.ClusterInstance("secondary",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="test-secondary-cluster-instance",
            cluster_identifier=secondary.id,
            instance_class=aws.rds.InstanceType.R4_LARGE,
            db_subnet_group_name="default")
        ```

        ### New Global Cluster From Existing DB Cluster

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Cluster("example")
        example_global_cluster = aws.rds.GlobalCluster("example",
            force_destroy=True,
            global_cluster_identifier="example",
            source_db_cluster_identifier=example.arn)
        ```

        ### Upgrading Engine Versions

        When you upgrade the version of an `rds.GlobalCluster`, the provider will attempt to in-place upgrade the engine versions of all associated clusters. Since the `rds.Cluster` resource is being updated through the `rds.GlobalCluster`, you are likely to get an error (`Provider produced inconsistent final plan`). To avoid this, use the `lifecycle` `ignore_changes` meta argument as shown below on the `rds.Cluster`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.GlobalCluster("example",
            global_cluster_identifier="kyivkharkiv",
            engine="aurora-mysql",
            engine_version="5.7.mysql_aurora.2.07.5")
        primary = aws.rds.Cluster("primary",
            allow_major_version_upgrade=True,
            apply_immediately=True,
            cluster_identifier="odessadnipro",
            database_name="totoro",
            engine=example.engine,
            engine_version=example.engine_version,
            global_cluster_identifier=example.id,
            master_password="satsukimae",
            master_username="maesatsuki",
            skip_final_snapshot=True)
        primary_cluster_instance = aws.rds.ClusterInstance("primary",
            apply_immediately=True,
            cluster_identifier=primary.id,
            engine=primary.engine,
            engine_version=primary.engine_version,
            identifier="donetsklviv",
            instance_class=aws.rds.InstanceType.R4_LARGE)
        ```

        ## Import

        Using `pulumi import`, import `aws_rds_global_cluster` using the RDS Global Cluster identifier. For example:

        ```sh
        $ pulumi import aws:rds/globalCluster:GlobalCluster example example
        ```
        Certain resource arguments, like `force_destroy`, only exist within this provider. If the argument is set in the the provider configuration on an imported resource, This provider will show a difference on the first plan after import to update the state value. This change is safe to apply immediately so the state matches the desired configuration.

        Certain resource arguments, like `source_db_cluster_identifier`, do not have an API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: Name for an automatically created database on cluster creation. Pulumi will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[bool] deletion_protection: If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        :param pulumi.Input[str] engine: Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Valid values: `aurora`, `aurora-mysql`, `aurora-postgresql`. Defaults to `aurora`. Conflicts with `source_db_cluster_identifier`.
        :param pulumi.Input[str] engine_lifecycle_support: The life cycle type for this DB instance. This setting applies only to Aurora PostgreSQL-based global databases. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        :param pulumi.Input[str] engine_version: Engine version of the Aurora global database. The `engine`, `engine_version`, and `instance_class` (on the `rds.ClusterInstance`) must together support global databases. See [Using Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) for more information. By upgrading the engine version, the provider will upgrade cluster members. **NOTE:** To avoid an `inconsistent final plan` error while upgrading, use the `lifecycle` `ignore_changes` for `engine_version` meta argument on the associated `rds.Cluster` resource as shown above in Upgrading Engine Versions example.
        :param pulumi.Input[bool] force_destroy: Enable to remove DB Cluster members from Global Cluster on destroy. Required with `source_db_cluster_identifier`.
        :param pulumi.Input[str] global_cluster_identifier: Global cluster identifier.
        :param pulumi.Input[str] source_db_cluster_identifier: Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlobalClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an RDS Global Cluster, which is an Aurora global database spread across multiple regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.

        More information about Aurora global databases can be found in the [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database-creating).

        ## Example Usage

        ### New MySQL Global Cluster

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.GlobalCluster("example",
            global_cluster_identifier="global-test",
            engine="aurora",
            engine_version="5.6.mysql_aurora.1.22.2",
            database_name="example_db")
        primary = aws.rds.Cluster("primary",
            engine=example.engine,
            engine_version=example.engine_version,
            cluster_identifier="test-primary-cluster",
            master_username="username",
            master_password="somepass123",
            database_name="example_db",
            global_cluster_identifier=example.id,
            db_subnet_group_name="default")
        primary_cluster_instance = aws.rds.ClusterInstance("primary",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="test-primary-cluster-instance",
            cluster_identifier=primary.id,
            instance_class=aws.rds.InstanceType.R4_LARGE,
            db_subnet_group_name="default")
        secondary = aws.rds.Cluster("secondary",
            engine=example.engine,
            engine_version=example.engine_version,
            cluster_identifier="test-secondary-cluster",
            global_cluster_identifier=example.id,
            db_subnet_group_name="default",
            opts = pulumi.ResourceOptions(depends_on=[primary_cluster_instance]))
        secondary_cluster_instance = aws.rds.ClusterInstance("secondary",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="test-secondary-cluster-instance",
            cluster_identifier=secondary.id,
            instance_class=aws.rds.InstanceType.R4_LARGE,
            db_subnet_group_name="default")
        ```

        ### New PostgreSQL Global Cluster

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.GlobalCluster("example",
            global_cluster_identifier="global-test",
            engine="aurora-postgresql",
            engine_version="11.9",
            database_name="example_db")
        primary = aws.rds.Cluster("primary",
            engine=example.engine,
            engine_version=example.engine_version,
            cluster_identifier="test-primary-cluster",
            master_username="username",
            master_password="somepass123",
            database_name="example_db",
            global_cluster_identifier=example.id,
            db_subnet_group_name="default")
        primary_cluster_instance = aws.rds.ClusterInstance("primary",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="test-primary-cluster-instance",
            cluster_identifier=primary.id,
            instance_class=aws.rds.InstanceType.R4_LARGE,
            db_subnet_group_name="default")
        secondary = aws.rds.Cluster("secondary",
            engine=example.engine,
            engine_version=example.engine_version,
            cluster_identifier="test-secondary-cluster",
            global_cluster_identifier=example.id,
            skip_final_snapshot=True,
            db_subnet_group_name="default",
            opts = pulumi.ResourceOptions(depends_on=[primary_cluster_instance]))
        secondary_cluster_instance = aws.rds.ClusterInstance("secondary",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="test-secondary-cluster-instance",
            cluster_identifier=secondary.id,
            instance_class=aws.rds.InstanceType.R4_LARGE,
            db_subnet_group_name="default")
        ```

        ### New Global Cluster From Existing DB Cluster

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Cluster("example")
        example_global_cluster = aws.rds.GlobalCluster("example",
            force_destroy=True,
            global_cluster_identifier="example",
            source_db_cluster_identifier=example.arn)
        ```

        ### Upgrading Engine Versions

        When you upgrade the version of an `rds.GlobalCluster`, the provider will attempt to in-place upgrade the engine versions of all associated clusters. Since the `rds.Cluster` resource is being updated through the `rds.GlobalCluster`, you are likely to get an error (`Provider produced inconsistent final plan`). To avoid this, use the `lifecycle` `ignore_changes` meta argument as shown below on the `rds.Cluster`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.GlobalCluster("example",
            global_cluster_identifier="kyivkharkiv",
            engine="aurora-mysql",
            engine_version="5.7.mysql_aurora.2.07.5")
        primary = aws.rds.Cluster("primary",
            allow_major_version_upgrade=True,
            apply_immediately=True,
            cluster_identifier="odessadnipro",
            database_name="totoro",
            engine=example.engine,
            engine_version=example.engine_version,
            global_cluster_identifier=example.id,
            master_password="satsukimae",
            master_username="maesatsuki",
            skip_final_snapshot=True)
        primary_cluster_instance = aws.rds.ClusterInstance("primary",
            apply_immediately=True,
            cluster_identifier=primary.id,
            engine=primary.engine,
            engine_version=primary.engine_version,
            identifier="donetsklviv",
            instance_class=aws.rds.InstanceType.R4_LARGE)
        ```

        ## Import

        Using `pulumi import`, import `aws_rds_global_cluster` using the RDS Global Cluster identifier. For example:

        ```sh
        $ pulumi import aws:rds/globalCluster:GlobalCluster example example
        ```
        Certain resource arguments, like `force_destroy`, only exist within this provider. If the argument is set in the the provider configuration on an imported resource, This provider will show a difference on the first plan after import to update the state value. This change is safe to apply immediately so the state matches the desired configuration.

        Certain resource arguments, like `source_db_cluster_identifier`, do not have an API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param GlobalClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalClusterArgs.__new__(GlobalClusterArgs)

            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_lifecycle_support"] = engine_lifecycle_support
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["force_destroy"] = force_destroy
            if global_cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'global_cluster_identifier'")
            __props__.__dict__["global_cluster_identifier"] = global_cluster_identifier
            __props__.__dict__["source_db_cluster_identifier"] = source_db_cluster_identifier
            __props__.__dict__["storage_encrypted"] = storage_encrypted
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["engine_version_actual"] = None
            __props__.__dict__["global_cluster_members"] = None
            __props__.__dict__["global_cluster_resource_id"] = None
            __props__.__dict__["tags_all"] = None
        super(GlobalCluster, __self__).__init__(
            'aws:rds/globalCluster:GlobalCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            engine_version_actual: Optional[pulumi.Input[str]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            global_cluster_identifier: Optional[pulumi.Input[str]] = None,
            global_cluster_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GlobalClusterGlobalClusterMemberArgs', 'GlobalClusterGlobalClusterMemberArgsDict']]]]] = None,
            global_cluster_resource_id: Optional[pulumi.Input[str]] = None,
            source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
            storage_encrypted: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'GlobalCluster':
        """
        Get an existing GlobalCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: RDS Global Cluster Amazon Resource Name (ARN).
        :param pulumi.Input[str] database_name: Name for an automatically created database on cluster creation. Pulumi will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[bool] deletion_protection: If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        :param pulumi.Input[str] endpoint: Writer endpoint for the new global database cluster. This endpoint always points to the writer DB instance in the current primary cluster.
        :param pulumi.Input[str] engine: Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Valid values: `aurora`, `aurora-mysql`, `aurora-postgresql`. Defaults to `aurora`. Conflicts with `source_db_cluster_identifier`.
        :param pulumi.Input[str] engine_lifecycle_support: The life cycle type for this DB instance. This setting applies only to Aurora PostgreSQL-based global databases. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        :param pulumi.Input[str] engine_version: Engine version of the Aurora global database. The `engine`, `engine_version`, and `instance_class` (on the `rds.ClusterInstance`) must together support global databases. See [Using Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) for more information. By upgrading the engine version, the provider will upgrade cluster members. **NOTE:** To avoid an `inconsistent final plan` error while upgrading, use the `lifecycle` `ignore_changes` for `engine_version` meta argument on the associated `rds.Cluster` resource as shown above in Upgrading Engine Versions example.
        :param pulumi.Input[bool] force_destroy: Enable to remove DB Cluster members from Global Cluster on destroy. Required with `source_db_cluster_identifier`.
        :param pulumi.Input[str] global_cluster_identifier: Global cluster identifier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GlobalClusterGlobalClusterMemberArgs', 'GlobalClusterGlobalClusterMemberArgsDict']]]] global_cluster_members: Set of objects containing Global Cluster members.
        :param pulumi.Input[str] global_cluster_resource_id: AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.
        :param pulumi.Input[str] source_db_cluster_identifier: Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalClusterState.__new__(_GlobalClusterState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_lifecycle_support"] = engine_lifecycle_support
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["engine_version_actual"] = engine_version_actual
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["global_cluster_identifier"] = global_cluster_identifier
        __props__.__dict__["global_cluster_members"] = global_cluster_members
        __props__.__dict__["global_cluster_resource_id"] = global_cluster_resource_id
        __props__.__dict__["source_db_cluster_identifier"] = source_db_cluster_identifier
        __props__.__dict__["storage_encrypted"] = storage_encrypted
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return GlobalCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        RDS Global Cluster Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        Name for an automatically created database on cluster creation. Pulumi will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        Writer endpoint for the new global database cluster. This endpoint always points to the writer DB instance in the current primary cluster.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Valid values: `aurora`, `aurora-mysql`, `aurora-postgresql`. Defaults to `aurora`. Conflicts with `source_db_cluster_identifier`.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> pulumi.Output[str]:
        """
        The life cycle type for this DB instance. This setting applies only to Aurora PostgreSQL-based global databases. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        Engine version of the Aurora global database. The `engine`, `engine_version`, and `instance_class` (on the `rds.ClusterInstance`) must together support global databases. See [Using Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) for more information. By upgrading the engine version, the provider will upgrade cluster members. **NOTE:** To avoid an `inconsistent final plan` error while upgrading, use the `lifecycle` `ignore_changes` for `engine_version` meta argument on the associated `rds.Cluster` resource as shown above in Upgrading Engine Versions example.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> pulumi.Output[str]:
        return pulumi.get(self, "engine_version_actual")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable to remove DB Cluster members from Global Cluster on destroy. Required with `source_db_cluster_identifier`.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> pulumi.Output[str]:
        """
        Global cluster identifier.
        """
        return pulumi.get(self, "global_cluster_identifier")

    @property
    @pulumi.getter(name="globalClusterMembers")
    def global_cluster_members(self) -> pulumi.Output[Sequence['outputs.GlobalClusterGlobalClusterMember']]:
        """
        Set of objects containing Global Cluster members.
        """
        return pulumi.get(self, "global_cluster_members")

    @property
    @pulumi.getter(name="globalClusterResourceId")
    def global_cluster_resource_id(self) -> pulumi.Output[str]:
        """
        AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed.
        """
        return pulumi.get(self, "global_cluster_resource_id")

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[bool]:
        """
        Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

