# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_class: pulumi.Input[Union[str, 'InstanceType']],
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 allow_major_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 backup_target: Optional[pulumi.Input[str]] = None,
                 backup_window: Optional[pulumi.Input[str]] = None,
                 blue_green_update: Optional[pulumi.Input['InstanceBlueGreenUpdateArgs']] = None,
                 ca_cert_identifier: Optional[pulumi.Input[str]] = None,
                 character_set_name: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 customer_owned_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 dedicated_log_volume: Optional[pulumi.Input[bool]] = None,
                 delete_automated_backups: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_auth_secret_arn: Optional[pulumi.Input[str]] = None,
                 domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_fqdn: Optional[pulumi.Input[str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[str]] = None,
                 domain_ou: Optional[pulumi.Input[str]] = None,
                 enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 iam_database_authentication_enabled: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 identifier_prefix: Optional[pulumi.Input[str]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[bool]] = None,
                 master_user_secret_kms_key_id: Optional[pulumi.Input[str]] = None,
                 max_allocated_storage: Optional[pulumi.Input[int]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nchar_character_set_name: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 option_group_name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 replica_mode: Optional[pulumi.Input[str]] = None,
                 replicate_source_db: Optional[pulumi.Input[str]] = None,
                 restore_to_point_in_time: Optional[pulumi.Input['InstanceRestoreToPointInTimeArgs']] = None,
                 s3_import: Optional[pulumi.Input['InstanceS3ImportArgs']] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 storage_throughput: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 upgrade_storage_config: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_class: The instance type of the RDS instance.
        :param pulumi.Input[int] allocated_storage: The allocated storage in gibibytes. If `max_allocated_storage` is configured, this argument represents the initial storage allocation and differences from the configuration will be ignored automatically when Storage Autoscaling occurs. If `replicate_source_db` is set, the value is ignored during the creation of the instance.
        :param pulumi.Input[bool] allow_major_version_upgrade: Indicates that major version
               upgrades are allowed. Changing this parameter does not result in an outage and
               the change is asynchronously applied as soon as possible.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any database modifications
               are applied immediately, or during the next maintenance window. Default is
               `false`. See [Amazon RDS Documentation for more
               information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
        :param pulumi.Input[bool] auto_minor_version_upgrade: Indicates that minor engine upgrades
               will be applied automatically to the DB instance during the maintenance window.
               Defaults to true.
        :param pulumi.Input[str] availability_zone: The AZ for the RDS instance.
        :param pulumi.Input[int] backup_retention_period: The days to retain backups for.
               Must be between `0` and `35`.
               Default is `0`.
               Must be greater than `0` if the database is used as a source for a [Read Replica][instance-replication],
               uses low-downtime updates,
               or will use [RDS Blue/Green deployments][blue-green].
        :param pulumi.Input[str] backup_target: Specifies where automated backups and manual snapshots are stored. Possible values are `region` (default) and `outposts`. See [Working with Amazon RDS on AWS Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) for more information.
        :param pulumi.Input[str] backup_window: The daily time range (in UTC) during which automated backups are created if they are enabled.
               Example: "09:46-10:16". Must not overlap with `maintenance_window`.
        :param pulumi.Input['InstanceBlueGreenUpdateArgs'] blue_green_update: Enables low-downtime updates using [RDS Blue/Green deployments][blue-green].
               See `blue_green_update` below.
        :param pulumi.Input[str] ca_cert_identifier: The identifier of the CA certificate for the DB instance.
        :param pulumi.Input[str] character_set_name: The character set name to use for DB encoding in Oracle and Microsoft SQL instances (collation).
               This can't be changed.
               See [Oracle Character Sets Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html) or
               [Server-Level Collation for Microsoft SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.CommonDBATasks.Collation.html) for more information.
               Cannot be set  with `replicate_source_db`, `restore_to_point_in_time`, `s3_import`, or `snapshot_identifier`.
        :param pulumi.Input[bool] copy_tags_to_snapshot: Copy all Instance `tags` to snapshots. Default is `false`.
        :param pulumi.Input[str] custom_iam_instance_profile: The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        :param pulumi.Input[bool] customer_owned_ip_enabled: Indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance. See [CoIP for RDS on Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html#rds-on-outposts.coip) for more information.
               
               > **NOTE:** Removing the `replicate_source_db` attribute from an existing RDS
               Replicate database managed by the provider will promote the database to a fully
               standalone database.
        :param pulumi.Input[str] db_name: The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. Note that this does not apply for Oracle or SQL Server engines. See the [AWS documentation](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/create-db-instance.html) for more details on what applies for those engines. If you are providing an Oracle db name, it needs to be in all upper case. Cannot be specified for a replica.
        :param pulumi.Input[str] db_subnet_group_name: Name of DB subnet group.
               DB instance will be created in the VPC associated with the DB subnet group.
               If unspecified, will be created in the `default` Subnet Group.
               When working with read replicas created in the same region, defaults to the Subnet Group Name of the source DB.
               When working with read replicas created in a different region, defaults to the `default` Subnet Group.
               See [DBSubnetGroupName in API action CreateDBInstanceReadReplica](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html) for additional read replica constraints.
        :param pulumi.Input[bool] dedicated_log_volume: Use a dedicated log volume (DLV) for the DB instance. Requires Provisioned IOPS. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.dlv) for more details.
        :param pulumi.Input[bool] delete_automated_backups: Specifies whether to remove automated backups immediately after the DB instance is deleted. Default is `true`.
        :param pulumi.Input[bool] deletion_protection: If the DB instance should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        :param pulumi.Input[str] domain: The ID of the Directory Service Active Directory domain to create the instance in. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        :param pulumi.Input[str] domain_auth_secret_arn: The ARN for the Secrets Manager secret with the self managed Active Directory credentials for the user joining the domain. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_dns_ips: The IPv4 DNS IP addresses of your primary and secondary self managed Active Directory domain controllers. Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[str] domain_fqdn: The fully qualified domain name (FQDN) of the self managed Active Directory domain. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[str] domain_iam_role_name: The name of the IAM role to be used when making API calls to the Directory Service. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        :param pulumi.Input[str] domain_ou: The self managed Active Directory organizational unit for your DB instance to join. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_cloudwatch_logs_exports: Set of log types to enable for exporting to CloudWatch logs. If omitted, no logs will be exported. For supported values, see the EnableCloudwatchLogsExports.member.N parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html).
        :param pulumi.Input[str] engine: The database engine to use. For supported values, see the Engine parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine must match the DB cluster's engine'. For information on the difference between the available Aurora MySQL engines see [Comparison between Aurora MySQL 1 and Aurora MySQL 2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Updates.20180206.html) in the Amazon RDS User Guide.
        :param pulumi.Input[str] engine_lifecycle_support: The life cycle type for this DB instance. This setting applies only to RDS for MySQL and RDS for PostgreSQL. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        :param pulumi.Input[str] engine_version: The engine version to use. If `auto_minor_version_upgrade` is enabled, you can provide a prefix of the version such as `8.0` (for `8.0.36`). The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. For supported values, see the EngineVersion parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine version must match the DB cluster's engine version'.
        :param pulumi.Input[str] final_snapshot_identifier: The name of your final DB snapshot
               when this DB instance is deleted. Must be provided if `skip_final_snapshot` is
               set to `false`. The value must begin with a letter, only contain alphanumeric characters and hyphens, and not end with a hyphen or contain two consecutive hyphens. Must not be provided when deleting a read replica.
        :param pulumi.Input[bool] iam_database_authentication_enabled: Specifies whether mappings of AWS Identity and Access Management (IAM) accounts to database
               accounts is enabled.
        :param pulumi.Input[str] identifier: The name of the RDS instance, if omitted, this provider will assign a random, unique identifier. Required if `restore_to_point_in_time` is specified.
        :param pulumi.Input[str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[int] iops: The amount of provisioned IOPS. Setting this implies a
               storage_type of "io1" or "io2". Can only be set when `storage_type` is `"io1"`, `"io2` or `"gp3"`.
               Cannot be specified for gp3 storage if the `allocated_storage` value is below a per-`engine` threshold.
               See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. If creating an
               encrypted replica, set this to the destination KMS ARN.
        :param pulumi.Input[str] license_model: License model information for this DB instance. Valid values for this field are as follows:
               * RDS for MariaDB: `general-public-license`
               * RDS for Microsoft SQL Server: `license-included`
               * RDS for MySQL: `general-public-license`
               * RDS for Oracle: `bring-your-own-license | license-included`
               * RDS for PostgreSQL: `postgresql-license`
        :param pulumi.Input[str] maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00". See [RDS
               Maintenance Window
               docs](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
               for more information.
        :param pulumi.Input[bool] manage_master_user_password: Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `password` is provided.
        :param pulumi.Input[str] master_user_secret_kms_key_id: The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
        :param pulumi.Input[int] max_allocated_storage: When configured, the upper limit to which Amazon RDS can automatically scale the storage of the DB instance. Configuring this will automatically ignore differences to `allocated_storage`. Must be greater than or equal to `allocated_storage` or `0` to disable Storage Autoscaling.
        :param pulumi.Input[int] monitoring_interval: The interval, in seconds, between points
               when Enhanced Monitoring metrics are collected for the DB instance. To disable
               collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid
               Values: 0, 1, 5, 10, 15, 30, 60.
        :param pulumi.Input[str] monitoring_role_arn: The ARN for the IAM role that permits RDS
               to send enhanced monitoring metrics to CloudWatch Logs. You can find more
               information on the [AWS
               Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html)
               what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ
        :param pulumi.Input[str] nchar_character_set_name: The national character set is used in the NCHAR, NVARCHAR2, and NCLOB data types for Oracle instances. This can't be changed. See [Oracle Character Sets
               Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html).
        :param pulumi.Input[str] network_type: The network type of the DB instance. Valid values: `IPV4`, `DUAL`.
        :param pulumi.Input[str] option_group_name: Name of the DB option group to associate.
        :param pulumi.Input[str] parameter_group_name: Name of the DB parameter group to associate.
        :param pulumi.Input[str] password: (Required unless `manage_master_user_password` is set to true or unless a `snapshot_identifier` or `replicate_source_db`
               is provided or `manage_master_user_password` is set.) Password for the master DB user. Note that this may show up in
               logs, and it will be stored in the state file. Cannot be set if `manage_master_user_password` is set to `true`.
        :param pulumi.Input[bool] performance_insights_enabled: Specifies whether Performance Insights are enabled. Defaults to false.
        :param pulumi.Input[str] performance_insights_kms_key_id: The ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true. Once KMS key is set, it can never be changed.
        :param pulumi.Input[int] performance_insights_retention_period: Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        :param pulumi.Input[int] port: The port on which the DB accepts connections.
        :param pulumi.Input[bool] publicly_accessible: Bool to control if instance is publicly
               accessible. Default is `false`.
        :param pulumi.Input[str] replica_mode: Specifies whether the replica is in either `mounted` or `open-read-only` mode. This attribute
               is only supported by Oracle instances. Oracle replicas operate in `open-read-only` mode unless otherwise specified. See [Working with Oracle Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) for more information.
        :param pulumi.Input[str] replicate_source_db: Specifies that this resource is a Replica database, and to use this value as the source database.
               If replicating an Amazon RDS Database Instance in the same region, use the `identifier` of the source DB, unless also specifying the `db_subnet_group_name`.
               If specifying the `db_subnet_group_name` in the same region, use the `arn` of the source DB.
               If replicating an Instance in a different region, use the `arn` of the source DB.
               Note that if you are creating a cross-region replica of an encrypted database you will also need to specify a `kms_key_id`.
               See [DB Instance Replication][instance-replication] and [Working with PostgreSQL and MySQL Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html) for more information on using Replication.
        :param pulumi.Input['InstanceRestoreToPointInTimeArgs'] restore_to_point_in_time: A configuration block for restoring a DB instance to an arbitrary point in time.
               Requires the `identifier` argument to be set with the name of the new DB instance to be created.
               See Restore To Point In Time below for details.
        :param pulumi.Input['InstanceS3ImportArgs'] s3_import: Restore from a Percona Xtrabackup in S3.  See [Importing Data into an Amazon RDS MySQL DB Instance](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final DB snapshot is
               created before the DB instance is deleted. If true is specified, no DBSnapshot
               is created. If false is specified, a DB snapshot is created before the DB
               instance is deleted, using the value from `final_snapshot_identifier`. Default
               is `false`.
        :param pulumi.Input[str] snapshot_identifier: Specifies whether or not to create this database from a snapshot.
               This corresponds to the snapshot ID you'd find in the RDS console, e.g: rds:production-2015-06-26-06-05.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB instance is
               encrypted. Note that if you are creating a cross-region read replica this field
               is ignored and you should instead declare `kms_key_id` with a valid ARN. The
               default is `false` if not specified.
        :param pulumi.Input[int] storage_throughput: The storage throughput value for the DB instance. Can only be set when `storage_type` is `"gp3"`. Cannot be specified if the `allocated_storage` value is below a per-`engine` threshold. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        :param pulumi.Input[Union[str, 'StorageType']] storage_type: One of "standard" (magnetic), "gp2" (general
               purpose SSD), "gp3" (general purpose SSD that needs `iops` independently)
               "io1" (provisioned IOPS SSD) or "io2" (block express storage provisioned IOPS
               SSD). The default is "io1" if `iops` is specified, "gp2" if not.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] timezone: Time zone of the DB instance. `timezone` is currently
               only supported by Microsoft SQL Server. The `timezone` can only be set on
               creation. See [MSSQL User
               Guide](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone)
               for more information.
        :param pulumi.Input[bool] upgrade_storage_config: Whether to upgrade the storage file system configuration on the read replica.
               Can only be set with `replicate_source_db`.
        :param pulumi.Input[str] username: (Required unless a `snapshot_identifier` or `replicate_source_db`
               is provided) Username for the master DB user. Cannot be specified for a replica.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: List of VPC security groups to
               associate.
        """
        pulumi.set(__self__, "instance_class", instance_class)
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if allow_major_version_upgrade is not None:
            pulumi.set(__self__, "allow_major_version_upgrade", allow_major_version_upgrade)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if backup_target is not None:
            pulumi.set(__self__, "backup_target", backup_target)
        if backup_window is not None:
            pulumi.set(__self__, "backup_window", backup_window)
        if blue_green_update is not None:
            pulumi.set(__self__, "blue_green_update", blue_green_update)
        if ca_cert_identifier is not None:
            pulumi.set(__self__, "ca_cert_identifier", ca_cert_identifier)
        if character_set_name is not None:
            pulumi.set(__self__, "character_set_name", character_set_name)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if custom_iam_instance_profile is not None:
            pulumi.set(__self__, "custom_iam_instance_profile", custom_iam_instance_profile)
        if customer_owned_ip_enabled is not None:
            pulumi.set(__self__, "customer_owned_ip_enabled", customer_owned_ip_enabled)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if dedicated_log_volume is not None:
            pulumi.set(__self__, "dedicated_log_volume", dedicated_log_volume)
        if delete_automated_backups is not None:
            pulumi.set(__self__, "delete_automated_backups", delete_automated_backups)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_auth_secret_arn is not None:
            pulumi.set(__self__, "domain_auth_secret_arn", domain_auth_secret_arn)
        if domain_dns_ips is not None:
            pulumi.set(__self__, "domain_dns_ips", domain_dns_ips)
        if domain_fqdn is not None:
            pulumi.set(__self__, "domain_fqdn", domain_fqdn)
        if domain_iam_role_name is not None:
            pulumi.set(__self__, "domain_iam_role_name", domain_iam_role_name)
        if domain_ou is not None:
            pulumi.set(__self__, "domain_ou", domain_ou)
        if enabled_cloudwatch_logs_exports is not None:
            pulumi.set(__self__, "enabled_cloudwatch_logs_exports", enabled_cloudwatch_logs_exports)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_lifecycle_support is not None:
            pulumi.set(__self__, "engine_lifecycle_support", engine_lifecycle_support)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if iam_database_authentication_enabled is not None:
            pulumi.set(__self__, "iam_database_authentication_enabled", iam_database_authentication_enabled)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if identifier_prefix is not None:
            pulumi.set(__self__, "identifier_prefix", identifier_prefix)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if manage_master_user_password is not None:
            pulumi.set(__self__, "manage_master_user_password", manage_master_user_password)
        if master_user_secret_kms_key_id is not None:
            pulumi.set(__self__, "master_user_secret_kms_key_id", master_user_secret_kms_key_id)
        if max_allocated_storage is not None:
            pulumi.set(__self__, "max_allocated_storage", max_allocated_storage)
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_role_arn is not None:
            pulumi.set(__self__, "monitoring_role_arn", monitoring_role_arn)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if name is not None:
            warnings.warn("""This property has been deprecated. Please use 'dbName' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: This property has been deprecated. Please use 'dbName' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nchar_character_set_name is not None:
            pulumi.set(__self__, "nchar_character_set_name", nchar_character_set_name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if option_group_name is not None:
            pulumi.set(__self__, "option_group_name", option_group_name)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if performance_insights_enabled is not None:
            pulumi.set(__self__, "performance_insights_enabled", performance_insights_enabled)
        if performance_insights_kms_key_id is not None:
            pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if performance_insights_retention_period is not None:
            pulumi.set(__self__, "performance_insights_retention_period", performance_insights_retention_period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if replica_mode is not None:
            pulumi.set(__self__, "replica_mode", replica_mode)
        if replicate_source_db is not None:
            pulumi.set(__self__, "replicate_source_db", replicate_source_db)
        if restore_to_point_in_time is not None:
            pulumi.set(__self__, "restore_to_point_in_time", restore_to_point_in_time)
        if s3_import is not None:
            pulumi.set(__self__, "s3_import", s3_import)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if storage_throughput is not None:
            pulumi.set(__self__, "storage_throughput", storage_throughput)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if upgrade_storage_config is not None:
            pulumi.set(__self__, "upgrade_storage_config", upgrade_storage_config)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Input[Union[str, 'InstanceType']]:
        """
        The instance type of the RDS instance.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: pulumi.Input[Union[str, 'InstanceType']]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The allocated storage in gibibytes. If `max_allocated_storage` is configured, this argument represents the initial storage allocation and differences from the configuration will be ignored automatically when Storage Autoscaling occurs. If `replicate_source_db` is set, the value is ignored during the creation of the instance.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter(name="allowMajorVersionUpgrade")
    def allow_major_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that major version
        upgrades are allowed. Changing this parameter does not result in an outage and
        the change is asynchronously applied as soon as possible.
        """
        return pulumi.get(self, "allow_major_version_upgrade")

    @allow_major_version_upgrade.setter
    def allow_major_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_major_version_upgrade", value)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether any database modifications
        are applied immediately, or during the next maintenance window. Default is
        `false`. See [Amazon RDS Documentation for more
        information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that minor engine upgrades
        will be applied automatically to the DB instance during the maintenance window.
        Defaults to true.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The AZ for the RDS instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The days to retain backups for.
        Must be between `0` and `35`.
        Default is `0`.
        Must be greater than `0` if the database is used as a source for a [Read Replica][instance-replication],
        uses low-downtime updates,
        or will use [RDS Blue/Green deployments][blue-green].
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_period", value)

    @property
    @pulumi.getter(name="backupTarget")
    def backup_target(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies where automated backups and manual snapshots are stored. Possible values are `region` (default) and `outposts`. See [Working with Amazon RDS on AWS Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) for more information.
        """
        return pulumi.get(self, "backup_target")

    @backup_target.setter
    def backup_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_target", value)

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        The daily time range (in UTC) during which automated backups are created if they are enabled.
        Example: "09:46-10:16". Must not overlap with `maintenance_window`.
        """
        return pulumi.get(self, "backup_window")

    @backup_window.setter
    def backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_window", value)

    @property
    @pulumi.getter(name="blueGreenUpdate")
    def blue_green_update(self) -> Optional[pulumi.Input['InstanceBlueGreenUpdateArgs']]:
        """
        Enables low-downtime updates using [RDS Blue/Green deployments][blue-green].
        See `blue_green_update` below.
        """
        return pulumi.get(self, "blue_green_update")

    @blue_green_update.setter
    def blue_green_update(self, value: Optional[pulumi.Input['InstanceBlueGreenUpdateArgs']]):
        pulumi.set(self, "blue_green_update", value)

    @property
    @pulumi.getter(name="caCertIdentifier")
    def ca_cert_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the CA certificate for the DB instance.
        """
        return pulumi.get(self, "ca_cert_identifier")

    @ca_cert_identifier.setter
    def ca_cert_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_identifier", value)

    @property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The character set name to use for DB encoding in Oracle and Microsoft SQL instances (collation).
        This can't be changed.
        See [Oracle Character Sets Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html) or
        [Server-Level Collation for Microsoft SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.CommonDBATasks.Collation.html) for more information.
        Cannot be set  with `replicate_source_db`, `restore_to_point_in_time`, `s3_import`, or `snapshot_identifier`.
        """
        return pulumi.get(self, "character_set_name")

    @character_set_name.setter
    def character_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "character_set_name", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Copy all Instance `tags` to snapshots. Default is `false`.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="customIamInstanceProfile")
    def custom_iam_instance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        """
        return pulumi.get(self, "custom_iam_instance_profile")

    @custom_iam_instance_profile.setter
    def custom_iam_instance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_iam_instance_profile", value)

    @property
    @pulumi.getter(name="customerOwnedIpEnabled")
    def customer_owned_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance. See [CoIP for RDS on Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html#rds-on-outposts.coip) for more information.

        > **NOTE:** Removing the `replicate_source_db` attribute from an existing RDS
        Replicate database managed by the provider will promote the database to a fully
        standalone database.
        """
        return pulumi.get(self, "customer_owned_ip_enabled")

    @customer_owned_ip_enabled.setter
    def customer_owned_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "customer_owned_ip_enabled", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. Note that this does not apply for Oracle or SQL Server engines. See the [AWS documentation](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/create-db-instance.html) for more details on what applies for those engines. If you are providing an Oracle db name, it needs to be in all upper case. Cannot be specified for a replica.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of DB subnet group.
        DB instance will be created in the VPC associated with the DB subnet group.
        If unspecified, will be created in the `default` Subnet Group.
        When working with read replicas created in the same region, defaults to the Subnet Group Name of the source DB.
        When working with read replicas created in a different region, defaults to the `default` Subnet Group.
        See [DBSubnetGroupName in API action CreateDBInstanceReadReplica](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html) for additional read replica constraints.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="dedicatedLogVolume")
    def dedicated_log_volume(self) -> Optional[pulumi.Input[bool]]:
        """
        Use a dedicated log volume (DLV) for the DB instance. Requires Provisioned IOPS. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.dlv) for more details.
        """
        return pulumi.get(self, "dedicated_log_volume")

    @dedicated_log_volume.setter
    def dedicated_log_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dedicated_log_volume", value)

    @property
    @pulumi.getter(name="deleteAutomatedBackups")
    def delete_automated_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to remove automated backups immediately after the DB instance is deleted. Default is `true`.
        """
        return pulumi.get(self, "delete_automated_backups")

    @delete_automated_backups.setter
    def delete_automated_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_automated_backups", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        If the DB instance should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Directory Service Active Directory domain to create the instance in. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="domainAuthSecretArn")
    def domain_auth_secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the Secrets Manager secret with the self managed Active Directory credentials for the user joining the domain. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_auth_secret_arn")

    @domain_auth_secret_arn.setter
    def domain_auth_secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_auth_secret_arn", value)

    @property
    @pulumi.getter(name="domainDnsIps")
    def domain_dns_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IPv4 DNS IP addresses of your primary and secondary self managed Active Directory domain controllers. Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_dns_ips")

    @domain_dns_ips.setter
    def domain_dns_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domain_dns_ips", value)

    @property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name (FQDN) of the self managed Active Directory domain. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_fqdn")

    @domain_fqdn.setter
    def domain_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_fqdn", value)

    @property
    @pulumi.getter(name="domainIamRoleName")
    def domain_iam_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IAM role to be used when making API calls to the Directory Service. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        """
        return pulumi.get(self, "domain_iam_role_name")

    @domain_iam_role_name.setter
    def domain_iam_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_iam_role_name", value)

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> Optional[pulumi.Input[str]]:
        """
        The self managed Active Directory organizational unit for your DB instance to join. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_ou")

    @domain_ou.setter
    def domain_ou(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ou", value)

    @property
    @pulumi.getter(name="enabledCloudwatchLogsExports")
    def enabled_cloudwatch_logs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of log types to enable for exporting to CloudWatch logs. If omitted, no logs will be exported. For supported values, see the EnableCloudwatchLogsExports.member.N parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html).
        """
        return pulumi.get(self, "enabled_cloudwatch_logs_exports")

    @enabled_cloudwatch_logs_exports.setter
    def enabled_cloudwatch_logs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_cloudwatch_logs_exports", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine to use. For supported values, see the Engine parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine must match the DB cluster's engine'. For information on the difference between the available Aurora MySQL engines see [Comparison between Aurora MySQL 1 and Aurora MySQL 2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Updates.20180206.html) in the Amazon RDS User Guide.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> Optional[pulumi.Input[str]]:
        """
        The life cycle type for this DB instance. This setting applies only to RDS for MySQL and RDS for PostgreSQL. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @engine_lifecycle_support.setter
    def engine_lifecycle_support(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_lifecycle_support", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The engine version to use. If `auto_minor_version_upgrade` is enabled, you can provide a prefix of the version such as `8.0` (for `8.0.36`). The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. For supported values, see the EngineVersion parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine version must match the DB cluster's engine version'.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name of your final DB snapshot
        when this DB instance is deleted. Must be provided if `skip_final_snapshot` is
        set to `false`. The value must begin with a letter, only contain alphanumeric characters and hyphens, and not end with a hyphen or contain two consecutive hyphens. Must not be provided when deleting a read replica.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @property
    @pulumi.getter(name="iamDatabaseAuthenticationEnabled")
    def iam_database_authentication_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether mappings of AWS Identity and Access Management (IAM) accounts to database
        accounts is enabled.
        """
        return pulumi.get(self, "iam_database_authentication_enabled")

    @iam_database_authentication_enabled.setter
    def iam_database_authentication_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "iam_database_authentication_enabled", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the RDS instance, if omitted, this provider will assign a random, unique identifier. Required if `restore_to_point_in_time` is specified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @identifier_prefix.setter
    def identifier_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier_prefix", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of provisioned IOPS. Setting this implies a
        storage_type of "io1" or "io2". Can only be set when `storage_type` is `"io1"`, `"io2` or `"gp3"`.
        Cannot be specified for gp3 storage if the `allocated_storage` value is below a per-`engine` threshold.
        See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the KMS encryption key. If creating an
        encrypted replica, set this to the destination KMS ARN.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        License model information for this DB instance. Valid values for this field are as follows:
        * RDS for MariaDB: `general-public-license`
        * RDS for Microsoft SQL Server: `license-included`
        * RDS for MySQL: `general-public-license`
        * RDS for Oracle: `bring-your-own-license | license-included`
        * RDS for PostgreSQL: `postgresql-license`
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        The window to perform maintenance in.
        Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00". See [RDS
        Maintenance Window
        docs](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
        for more information.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `password` is provided.
        """
        return pulumi.get(self, "manage_master_user_password")

    @manage_master_user_password.setter
    def manage_master_user_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_master_user_password", value)

    @property
    @pulumi.getter(name="masterUserSecretKmsKeyId")
    def master_user_secret_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
        """
        return pulumi.get(self, "master_user_secret_kms_key_id")

    @master_user_secret_kms_key_id.setter
    def master_user_secret_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_secret_kms_key_id", value)

    @property
    @pulumi.getter(name="maxAllocatedStorage")
    def max_allocated_storage(self) -> Optional[pulumi.Input[int]]:
        """
        When configured, the upper limit to which Amazon RDS can automatically scale the storage of the DB instance. Configuring this will automatically ignore differences to `allocated_storage`. Must be greater than or equal to `allocated_storage` or `0` to disable Storage Autoscaling.
        """
        return pulumi.get(self, "max_allocated_storage")

    @max_allocated_storage.setter
    def max_allocated_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_allocated_storage", value)

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval, in seconds, between points
        when Enhanced Monitoring metrics are collected for the DB instance. To disable
        collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid
        Values: 0, 1, 5, 10, 15, 30, 60.
        """
        return pulumi.get(self, "monitoring_interval")

    @monitoring_interval.setter
    def monitoring_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "monitoring_interval", value)

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the IAM role that permits RDS
        to send enhanced monitoring metrics to CloudWatch Logs. You can find more
        information on the [AWS
        Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html)
        what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @monitoring_role_arn.setter
    def monitoring_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitoring_role_arn", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the RDS instance is multi-AZ
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This property has been deprecated. Please use 'dbName' instead.""")
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ncharCharacterSetName")
    def nchar_character_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The national character set is used in the NCHAR, NVARCHAR2, and NCLOB data types for Oracle instances. This can't be changed. See [Oracle Character Sets
        Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html).
        """
        return pulumi.get(self, "nchar_character_set_name")

    @nchar_character_set_name.setter
    def nchar_character_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nchar_character_set_name", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of the DB instance. Valid values: `IPV4`, `DUAL`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="optionGroupName")
    def option_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the DB option group to associate.
        """
        return pulumi.get(self, "option_group_name")

    @option_group_name.setter
    def option_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option_group_name", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the DB parameter group to associate.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (Required unless `manage_master_user_password` is set to true or unless a `snapshot_identifier` or `replicate_source_db`
        is provided or `manage_master_user_password` is set.) Password for the master DB user. Note that this may show up in
        logs, and it will be stored in the state file. Cannot be set if `manage_master_user_password` is set to `true`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether Performance Insights are enabled. Defaults to false.
        """
        return pulumi.get(self, "performance_insights_enabled")

    @performance_insights_enabled.setter
    def performance_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "performance_insights_enabled", value)

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true. Once KMS key is set, it can never be changed.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @performance_insights_kms_key_id.setter
    def performance_insights_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_insights_kms_key_id", value)

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @performance_insights_retention_period.setter
    def performance_insights_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "performance_insights_retention_period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on which the DB accepts connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool to control if instance is publicly
        accessible. Default is `false`.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="replicaMode")
    def replica_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the replica is in either `mounted` or `open-read-only` mode. This attribute
        is only supported by Oracle instances. Oracle replicas operate in `open-read-only` mode unless otherwise specified. See [Working with Oracle Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) for more information.
        """
        return pulumi.get(self, "replica_mode")

    @replica_mode.setter
    def replica_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_mode", value)

    @property
    @pulumi.getter(name="replicateSourceDb")
    def replicate_source_db(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies that this resource is a Replica database, and to use this value as the source database.
        If replicating an Amazon RDS Database Instance in the same region, use the `identifier` of the source DB, unless also specifying the `db_subnet_group_name`.
        If specifying the `db_subnet_group_name` in the same region, use the `arn` of the source DB.
        If replicating an Instance in a different region, use the `arn` of the source DB.
        Note that if you are creating a cross-region replica of an encrypted database you will also need to specify a `kms_key_id`.
        See [DB Instance Replication][instance-replication] and [Working with PostgreSQL and MySQL Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html) for more information on using Replication.
        """
        return pulumi.get(self, "replicate_source_db")

    @replicate_source_db.setter
    def replicate_source_db(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replicate_source_db", value)

    @property
    @pulumi.getter(name="restoreToPointInTime")
    def restore_to_point_in_time(self) -> Optional[pulumi.Input['InstanceRestoreToPointInTimeArgs']]:
        """
        A configuration block for restoring a DB instance to an arbitrary point in time.
        Requires the `identifier` argument to be set with the name of the new DB instance to be created.
        See Restore To Point In Time below for details.
        """
        return pulumi.get(self, "restore_to_point_in_time")

    @restore_to_point_in_time.setter
    def restore_to_point_in_time(self, value: Optional[pulumi.Input['InstanceRestoreToPointInTimeArgs']]):
        pulumi.set(self, "restore_to_point_in_time", value)

    @property
    @pulumi.getter(name="s3Import")
    def s3_import(self) -> Optional[pulumi.Input['InstanceS3ImportArgs']]:
        """
        Restore from a Percona Xtrabackup in S3.  See [Importing Data into an Amazon RDS MySQL DB Instance](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
        """
        return pulumi.get(self, "s3_import")

    @s3_import.setter
    def s3_import(self, value: Optional[pulumi.Input['InstanceS3ImportArgs']]):
        pulumi.set(self, "s3_import", value)

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether a final DB snapshot is
        created before the DB instance is deleted. If true is specified, no DBSnapshot
        is created. If false is specified, a DB snapshot is created before the DB
        instance is deleted, using the value from `final_snapshot_identifier`. Default
        is `false`.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether or not to create this database from a snapshot.
        This corresponds to the snapshot ID you'd find in the RDS console, e.g: rds:production-2015-06-26-06-05.
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the DB instance is
        encrypted. Note that if you are creating a cross-region read replica this field
        is ignored and you should instead declare `kms_key_id` with a valid ARN. The
        default is `false` if not specified.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter(name="storageThroughput")
    def storage_throughput(self) -> Optional[pulumi.Input[int]]:
        """
        The storage throughput value for the DB instance. Can only be set when `storage_type` is `"gp3"`. Cannot be specified if the `allocated_storage` value is below a per-`engine` threshold. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        """
        return pulumi.get(self, "storage_throughput")

    @storage_throughput.setter
    def storage_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_throughput", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[Union[str, 'StorageType']]]:
        """
        One of "standard" (magnetic), "gp2" (general
        purpose SSD), "gp3" (general purpose SSD that needs `iops` independently)
        "io1" (provisioned IOPS SSD) or "io2" (block express storage provisioned IOPS
        SSD). The default is "io1" if `iops` is specified, "gp2" if not.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[Union[str, 'StorageType']]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Time zone of the DB instance. `timezone` is currently
        only supported by Microsoft SQL Server. The `timezone` can only be set on
        creation. See [MSSQL User
        Guide](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone)
        for more information.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="upgradeStorageConfig")
    def upgrade_storage_config(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to upgrade the storage file system configuration on the read replica.
        Can only be set with `replicate_source_db`.
        """
        return pulumi.get(self, "upgrade_storage_config")

    @upgrade_storage_config.setter
    def upgrade_storage_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_storage_config", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        (Required unless a `snapshot_identifier` or `replicate_source_db`
        is provided) Username for the master DB user. Cannot be specified for a replica.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPC security groups to
        associate.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 allow_major_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 backup_target: Optional[pulumi.Input[str]] = None,
                 backup_window: Optional[pulumi.Input[str]] = None,
                 blue_green_update: Optional[pulumi.Input['InstanceBlueGreenUpdateArgs']] = None,
                 ca_cert_identifier: Optional[pulumi.Input[str]] = None,
                 character_set_name: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 customer_owned_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 dedicated_log_volume: Optional[pulumi.Input[bool]] = None,
                 delete_automated_backups: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_auth_secret_arn: Optional[pulumi.Input[str]] = None,
                 domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_fqdn: Optional[pulumi.Input[str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[str]] = None,
                 domain_ou: Optional[pulumi.Input[str]] = None,
                 enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 engine_version_actual: Optional[pulumi.Input[str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 hosted_zone_id: Optional[pulumi.Input[str]] = None,
                 iam_database_authentication_enabled: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 identifier_prefix: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 latest_restorable_time: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 listener_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceListenerEndpointArgs']]]] = None,
                 maintenance_window: Optional[pulumi.Input[str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[bool]] = None,
                 master_user_secret_kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_user_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMasterUserSecretArgs']]]] = None,
                 max_allocated_storage: Optional[pulumi.Input[int]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nchar_character_set_name: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 option_group_name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 replica_mode: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 replicate_source_db: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 restore_to_point_in_time: Optional[pulumi.Input['InstanceRestoreToPointInTimeArgs']] = None,
                 s3_import: Optional[pulumi.Input['InstanceS3ImportArgs']] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 storage_throughput: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 upgrade_storage_config: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] address: Specifies the DNS address of the DB instance.
        :param pulumi.Input[int] allocated_storage: The allocated storage in gibibytes. If `max_allocated_storage` is configured, this argument represents the initial storage allocation and differences from the configuration will be ignored automatically when Storage Autoscaling occurs. If `replicate_source_db` is set, the value is ignored during the creation of the instance.
        :param pulumi.Input[bool] allow_major_version_upgrade: Indicates that major version
               upgrades are allowed. Changing this parameter does not result in an outage and
               the change is asynchronously applied as soon as possible.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any database modifications
               are applied immediately, or during the next maintenance window. Default is
               `false`. See [Amazon RDS Documentation for more
               information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
        :param pulumi.Input[str] arn: The ARN of the RDS instance.
        :param pulumi.Input[bool] auto_minor_version_upgrade: Indicates that minor engine upgrades
               will be applied automatically to the DB instance during the maintenance window.
               Defaults to true.
        :param pulumi.Input[str] availability_zone: The AZ for the RDS instance.
        :param pulumi.Input[int] backup_retention_period: The days to retain backups for.
               Must be between `0` and `35`.
               Default is `0`.
               Must be greater than `0` if the database is used as a source for a [Read Replica][instance-replication],
               uses low-downtime updates,
               or will use [RDS Blue/Green deployments][blue-green].
        :param pulumi.Input[str] backup_target: Specifies where automated backups and manual snapshots are stored. Possible values are `region` (default) and `outposts`. See [Working with Amazon RDS on AWS Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) for more information.
        :param pulumi.Input[str] backup_window: The daily time range (in UTC) during which automated backups are created if they are enabled.
               Example: "09:46-10:16". Must not overlap with `maintenance_window`.
        :param pulumi.Input['InstanceBlueGreenUpdateArgs'] blue_green_update: Enables low-downtime updates using [RDS Blue/Green deployments][blue-green].
               See `blue_green_update` below.
        :param pulumi.Input[str] ca_cert_identifier: The identifier of the CA certificate for the DB instance.
        :param pulumi.Input[str] character_set_name: The character set name to use for DB encoding in Oracle and Microsoft SQL instances (collation).
               This can't be changed.
               See [Oracle Character Sets Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html) or
               [Server-Level Collation for Microsoft SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.CommonDBATasks.Collation.html) for more information.
               Cannot be set  with `replicate_source_db`, `restore_to_point_in_time`, `s3_import`, or `snapshot_identifier`.
        :param pulumi.Input[bool] copy_tags_to_snapshot: Copy all Instance `tags` to snapshots. Default is `false`.
        :param pulumi.Input[str] custom_iam_instance_profile: The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        :param pulumi.Input[bool] customer_owned_ip_enabled: Indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance. See [CoIP for RDS on Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html#rds-on-outposts.coip) for more information.
               
               > **NOTE:** Removing the `replicate_source_db` attribute from an existing RDS
               Replicate database managed by the provider will promote the database to a fully
               standalone database.
        :param pulumi.Input[str] db_name: The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. Note that this does not apply for Oracle or SQL Server engines. See the [AWS documentation](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/create-db-instance.html) for more details on what applies for those engines. If you are providing an Oracle db name, it needs to be in all upper case. Cannot be specified for a replica.
        :param pulumi.Input[str] db_subnet_group_name: Name of DB subnet group.
               DB instance will be created in the VPC associated with the DB subnet group.
               If unspecified, will be created in the `default` Subnet Group.
               When working with read replicas created in the same region, defaults to the Subnet Group Name of the source DB.
               When working with read replicas created in a different region, defaults to the `default` Subnet Group.
               See [DBSubnetGroupName in API action CreateDBInstanceReadReplica](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html) for additional read replica constraints.
        :param pulumi.Input[bool] dedicated_log_volume: Use a dedicated log volume (DLV) for the DB instance. Requires Provisioned IOPS. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.dlv) for more details.
        :param pulumi.Input[bool] delete_automated_backups: Specifies whether to remove automated backups immediately after the DB instance is deleted. Default is `true`.
        :param pulumi.Input[bool] deletion_protection: If the DB instance should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        :param pulumi.Input[str] domain: The ID of the Directory Service Active Directory domain to create the instance in. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        :param pulumi.Input[str] domain_auth_secret_arn: The ARN for the Secrets Manager secret with the self managed Active Directory credentials for the user joining the domain. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_dns_ips: The IPv4 DNS IP addresses of your primary and secondary self managed Active Directory domain controllers. Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[str] domain_fqdn: The fully qualified domain name (FQDN) of the self managed Active Directory domain. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[str] domain_iam_role_name: The name of the IAM role to be used when making API calls to the Directory Service. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        :param pulumi.Input[str] domain_ou: The self managed Active Directory organizational unit for your DB instance to join. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_cloudwatch_logs_exports: Set of log types to enable for exporting to CloudWatch logs. If omitted, no logs will be exported. For supported values, see the EnableCloudwatchLogsExports.member.N parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html).
        :param pulumi.Input[str] endpoint: The connection endpoint in `address:port` format.
        :param pulumi.Input[str] engine: The database engine to use. For supported values, see the Engine parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine must match the DB cluster's engine'. For information on the difference between the available Aurora MySQL engines see [Comparison between Aurora MySQL 1 and Aurora MySQL 2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Updates.20180206.html) in the Amazon RDS User Guide.
        :param pulumi.Input[str] engine_lifecycle_support: The life cycle type for this DB instance. This setting applies only to RDS for MySQL and RDS for PostgreSQL. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        :param pulumi.Input[str] engine_version: The engine version to use. If `auto_minor_version_upgrade` is enabled, you can provide a prefix of the version such as `8.0` (for `8.0.36`). The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. For supported values, see the EngineVersion parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine version must match the DB cluster's engine version'.
        :param pulumi.Input[str] engine_version_actual: The running version of the database.
        :param pulumi.Input[str] final_snapshot_identifier: The name of your final DB snapshot
               when this DB instance is deleted. Must be provided if `skip_final_snapshot` is
               set to `false`. The value must begin with a letter, only contain alphanumeric characters and hyphens, and not end with a hyphen or contain two consecutive hyphens. Must not be provided when deleting a read replica.
        :param pulumi.Input[str] hosted_zone_id: Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        :param pulumi.Input[bool] iam_database_authentication_enabled: Specifies whether mappings of AWS Identity and Access Management (IAM) accounts to database
               accounts is enabled.
        :param pulumi.Input[str] identifier: The name of the RDS instance, if omitted, this provider will assign a random, unique identifier. Required if `restore_to_point_in_time` is specified.
        :param pulumi.Input[str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_class: The instance type of the RDS instance.
        :param pulumi.Input[int] iops: The amount of provisioned IOPS. Setting this implies a
               storage_type of "io1" or "io2". Can only be set when `storage_type` is `"io1"`, `"io2` or `"gp3"`.
               Cannot be specified for gp3 storage if the `allocated_storage` value is below a per-`engine` threshold.
               See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. If creating an
               encrypted replica, set this to the destination KMS ARN.
        :param pulumi.Input[str] latest_restorable_time: The latest time, in UTC [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), to which a database can be restored with point-in-time restore.
        :param pulumi.Input[str] license_model: License model information for this DB instance. Valid values for this field are as follows:
               * RDS for MariaDB: `general-public-license`
               * RDS for Microsoft SQL Server: `license-included`
               * RDS for MySQL: `general-public-license`
               * RDS for Oracle: `bring-your-own-license | license-included`
               * RDS for PostgreSQL: `postgresql-license`
        :param pulumi.Input[Sequence[pulumi.Input['InstanceListenerEndpointArgs']]] listener_endpoints: Specifies the listener connection endpoint for SQL Server Always On. See endpoint below.
        :param pulumi.Input[str] maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00". See [RDS
               Maintenance Window
               docs](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
               for more information.
        :param pulumi.Input[bool] manage_master_user_password: Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `password` is provided.
        :param pulumi.Input[str] master_user_secret_kms_key_id: The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMasterUserSecretArgs']]] master_user_secrets: A block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
        :param pulumi.Input[int] max_allocated_storage: When configured, the upper limit to which Amazon RDS can automatically scale the storage of the DB instance. Configuring this will automatically ignore differences to `allocated_storage`. Must be greater than or equal to `allocated_storage` or `0` to disable Storage Autoscaling.
        :param pulumi.Input[int] monitoring_interval: The interval, in seconds, between points
               when Enhanced Monitoring metrics are collected for the DB instance. To disable
               collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid
               Values: 0, 1, 5, 10, 15, 30, 60.
        :param pulumi.Input[str] monitoring_role_arn: The ARN for the IAM role that permits RDS
               to send enhanced monitoring metrics to CloudWatch Logs. You can find more
               information on the [AWS
               Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html)
               what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ
        :param pulumi.Input[str] nchar_character_set_name: The national character set is used in the NCHAR, NVARCHAR2, and NCLOB data types for Oracle instances. This can't be changed. See [Oracle Character Sets
               Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html).
        :param pulumi.Input[str] network_type: The network type of the DB instance. Valid values: `IPV4`, `DUAL`.
        :param pulumi.Input[str] option_group_name: Name of the DB option group to associate.
        :param pulumi.Input[str] parameter_group_name: Name of the DB parameter group to associate.
        :param pulumi.Input[str] password: (Required unless `manage_master_user_password` is set to true or unless a `snapshot_identifier` or `replicate_source_db`
               is provided or `manage_master_user_password` is set.) Password for the master DB user. Note that this may show up in
               logs, and it will be stored in the state file. Cannot be set if `manage_master_user_password` is set to `true`.
        :param pulumi.Input[bool] performance_insights_enabled: Specifies whether Performance Insights are enabled. Defaults to false.
        :param pulumi.Input[str] performance_insights_kms_key_id: The ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true. Once KMS key is set, it can never be changed.
        :param pulumi.Input[int] performance_insights_retention_period: Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        :param pulumi.Input[int] port: The port on which the DB accepts connections.
        :param pulumi.Input[bool] publicly_accessible: Bool to control if instance is publicly
               accessible. Default is `false`.
        :param pulumi.Input[str] replica_mode: Specifies whether the replica is in either `mounted` or `open-read-only` mode. This attribute
               is only supported by Oracle instances. Oracle replicas operate in `open-read-only` mode unless otherwise specified. See [Working with Oracle Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) for more information.
        :param pulumi.Input[str] replicate_source_db: Specifies that this resource is a Replica database, and to use this value as the source database.
               If replicating an Amazon RDS Database Instance in the same region, use the `identifier` of the source DB, unless also specifying the `db_subnet_group_name`.
               If specifying the `db_subnet_group_name` in the same region, use the `arn` of the source DB.
               If replicating an Instance in a different region, use the `arn` of the source DB.
               Note that if you are creating a cross-region replica of an encrypted database you will also need to specify a `kms_key_id`.
               See [DB Instance Replication][instance-replication] and [Working with PostgreSQL and MySQL Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html) for more information on using Replication.
        :param pulumi.Input[str] resource_id: The RDS Resource ID of this instance.
        :param pulumi.Input['InstanceRestoreToPointInTimeArgs'] restore_to_point_in_time: A configuration block for restoring a DB instance to an arbitrary point in time.
               Requires the `identifier` argument to be set with the name of the new DB instance to be created.
               See Restore To Point In Time below for details.
        :param pulumi.Input['InstanceS3ImportArgs'] s3_import: Restore from a Percona Xtrabackup in S3.  See [Importing Data into an Amazon RDS MySQL DB Instance](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final DB snapshot is
               created before the DB instance is deleted. If true is specified, no DBSnapshot
               is created. If false is specified, a DB snapshot is created before the DB
               instance is deleted, using the value from `final_snapshot_identifier`. Default
               is `false`.
        :param pulumi.Input[str] snapshot_identifier: Specifies whether or not to create this database from a snapshot.
               This corresponds to the snapshot ID you'd find in the RDS console, e.g: rds:production-2015-06-26-06-05.
        :param pulumi.Input[str] status: The RDS instance status.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB instance is
               encrypted. Note that if you are creating a cross-region read replica this field
               is ignored and you should instead declare `kms_key_id` with a valid ARN. The
               default is `false` if not specified.
        :param pulumi.Input[int] storage_throughput: The storage throughput value for the DB instance. Can only be set when `storage_type` is `"gp3"`. Cannot be specified if the `allocated_storage` value is below a per-`engine` threshold. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        :param pulumi.Input[Union[str, 'StorageType']] storage_type: One of "standard" (magnetic), "gp2" (general
               purpose SSD), "gp3" (general purpose SSD that needs `iops` independently)
               "io1" (provisioned IOPS SSD) or "io2" (block express storage provisioned IOPS
               SSD). The default is "io1" if `iops` is specified, "gp2" if not.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] timezone: Time zone of the DB instance. `timezone` is currently
               only supported by Microsoft SQL Server. The `timezone` can only be set on
               creation. See [MSSQL User
               Guide](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone)
               for more information.
        :param pulumi.Input[bool] upgrade_storage_config: Whether to upgrade the storage file system configuration on the read replica.
               Can only be set with `replicate_source_db`.
        :param pulumi.Input[str] username: (Required unless a `snapshot_identifier` or `replicate_source_db`
               is provided) Username for the master DB user. Cannot be specified for a replica.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: List of VPC security groups to
               associate.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if allow_major_version_upgrade is not None:
            pulumi.set(__self__, "allow_major_version_upgrade", allow_major_version_upgrade)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if backup_target is not None:
            pulumi.set(__self__, "backup_target", backup_target)
        if backup_window is not None:
            pulumi.set(__self__, "backup_window", backup_window)
        if blue_green_update is not None:
            pulumi.set(__self__, "blue_green_update", blue_green_update)
        if ca_cert_identifier is not None:
            pulumi.set(__self__, "ca_cert_identifier", ca_cert_identifier)
        if character_set_name is not None:
            pulumi.set(__self__, "character_set_name", character_set_name)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if custom_iam_instance_profile is not None:
            pulumi.set(__self__, "custom_iam_instance_profile", custom_iam_instance_profile)
        if customer_owned_ip_enabled is not None:
            pulumi.set(__self__, "customer_owned_ip_enabled", customer_owned_ip_enabled)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if dedicated_log_volume is not None:
            pulumi.set(__self__, "dedicated_log_volume", dedicated_log_volume)
        if delete_automated_backups is not None:
            pulumi.set(__self__, "delete_automated_backups", delete_automated_backups)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_auth_secret_arn is not None:
            pulumi.set(__self__, "domain_auth_secret_arn", domain_auth_secret_arn)
        if domain_dns_ips is not None:
            pulumi.set(__self__, "domain_dns_ips", domain_dns_ips)
        if domain_fqdn is not None:
            pulumi.set(__self__, "domain_fqdn", domain_fqdn)
        if domain_iam_role_name is not None:
            pulumi.set(__self__, "domain_iam_role_name", domain_iam_role_name)
        if domain_ou is not None:
            pulumi.set(__self__, "domain_ou", domain_ou)
        if enabled_cloudwatch_logs_exports is not None:
            pulumi.set(__self__, "enabled_cloudwatch_logs_exports", enabled_cloudwatch_logs_exports)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_lifecycle_support is not None:
            pulumi.set(__self__, "engine_lifecycle_support", engine_lifecycle_support)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if engine_version_actual is not None:
            pulumi.set(__self__, "engine_version_actual", engine_version_actual)
        if final_snapshot_identifier is not None:
            pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if iam_database_authentication_enabled is not None:
            pulumi.set(__self__, "iam_database_authentication_enabled", iam_database_authentication_enabled)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if identifier_prefix is not None:
            pulumi.set(__self__, "identifier_prefix", identifier_prefix)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if latest_restorable_time is not None:
            pulumi.set(__self__, "latest_restorable_time", latest_restorable_time)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if listener_endpoints is not None:
            pulumi.set(__self__, "listener_endpoints", listener_endpoints)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if manage_master_user_password is not None:
            pulumi.set(__self__, "manage_master_user_password", manage_master_user_password)
        if master_user_secret_kms_key_id is not None:
            pulumi.set(__self__, "master_user_secret_kms_key_id", master_user_secret_kms_key_id)
        if master_user_secrets is not None:
            pulumi.set(__self__, "master_user_secrets", master_user_secrets)
        if max_allocated_storage is not None:
            pulumi.set(__self__, "max_allocated_storage", max_allocated_storage)
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_role_arn is not None:
            pulumi.set(__self__, "monitoring_role_arn", monitoring_role_arn)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if name is not None:
            warnings.warn("""This property has been deprecated. Please use 'dbName' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: This property has been deprecated. Please use 'dbName' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nchar_character_set_name is not None:
            pulumi.set(__self__, "nchar_character_set_name", nchar_character_set_name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if option_group_name is not None:
            pulumi.set(__self__, "option_group_name", option_group_name)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if performance_insights_enabled is not None:
            pulumi.set(__self__, "performance_insights_enabled", performance_insights_enabled)
        if performance_insights_kms_key_id is not None:
            pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if performance_insights_retention_period is not None:
            pulumi.set(__self__, "performance_insights_retention_period", performance_insights_retention_period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if replica_mode is not None:
            pulumi.set(__self__, "replica_mode", replica_mode)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if replicate_source_db is not None:
            pulumi.set(__self__, "replicate_source_db", replicate_source_db)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if restore_to_point_in_time is not None:
            pulumi.set(__self__, "restore_to_point_in_time", restore_to_point_in_time)
        if s3_import is not None:
            pulumi.set(__self__, "s3_import", s3_import)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if storage_throughput is not None:
            pulumi.set(__self__, "storage_throughput", storage_throughput)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if upgrade_storage_config is not None:
            pulumi.set(__self__, "upgrade_storage_config", upgrade_storage_config)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DNS address of the DB instance.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The allocated storage in gibibytes. If `max_allocated_storage` is configured, this argument represents the initial storage allocation and differences from the configuration will be ignored automatically when Storage Autoscaling occurs. If `replicate_source_db` is set, the value is ignored during the creation of the instance.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter(name="allowMajorVersionUpgrade")
    def allow_major_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that major version
        upgrades are allowed. Changing this parameter does not result in an outage and
        the change is asynchronously applied as soon as possible.
        """
        return pulumi.get(self, "allow_major_version_upgrade")

    @allow_major_version_upgrade.setter
    def allow_major_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_major_version_upgrade", value)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether any database modifications
        are applied immediately, or during the next maintenance window. Default is
        `false`. See [Amazon RDS Documentation for more
        information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the RDS instance.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that minor engine upgrades
        will be applied automatically to the DB instance during the maintenance window.
        Defaults to true.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The AZ for the RDS instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The days to retain backups for.
        Must be between `0` and `35`.
        Default is `0`.
        Must be greater than `0` if the database is used as a source for a [Read Replica][instance-replication],
        uses low-downtime updates,
        or will use [RDS Blue/Green deployments][blue-green].
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_period", value)

    @property
    @pulumi.getter(name="backupTarget")
    def backup_target(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies where automated backups and manual snapshots are stored. Possible values are `region` (default) and `outposts`. See [Working with Amazon RDS on AWS Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) for more information.
        """
        return pulumi.get(self, "backup_target")

    @backup_target.setter
    def backup_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_target", value)

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        The daily time range (in UTC) during which automated backups are created if they are enabled.
        Example: "09:46-10:16". Must not overlap with `maintenance_window`.
        """
        return pulumi.get(self, "backup_window")

    @backup_window.setter
    def backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_window", value)

    @property
    @pulumi.getter(name="blueGreenUpdate")
    def blue_green_update(self) -> Optional[pulumi.Input['InstanceBlueGreenUpdateArgs']]:
        """
        Enables low-downtime updates using [RDS Blue/Green deployments][blue-green].
        See `blue_green_update` below.
        """
        return pulumi.get(self, "blue_green_update")

    @blue_green_update.setter
    def blue_green_update(self, value: Optional[pulumi.Input['InstanceBlueGreenUpdateArgs']]):
        pulumi.set(self, "blue_green_update", value)

    @property
    @pulumi.getter(name="caCertIdentifier")
    def ca_cert_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the CA certificate for the DB instance.
        """
        return pulumi.get(self, "ca_cert_identifier")

    @ca_cert_identifier.setter
    def ca_cert_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_identifier", value)

    @property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The character set name to use for DB encoding in Oracle and Microsoft SQL instances (collation).
        This can't be changed.
        See [Oracle Character Sets Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html) or
        [Server-Level Collation for Microsoft SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.CommonDBATasks.Collation.html) for more information.
        Cannot be set  with `replicate_source_db`, `restore_to_point_in_time`, `s3_import`, or `snapshot_identifier`.
        """
        return pulumi.get(self, "character_set_name")

    @character_set_name.setter
    def character_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "character_set_name", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Copy all Instance `tags` to snapshots. Default is `false`.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="customIamInstanceProfile")
    def custom_iam_instance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        """
        return pulumi.get(self, "custom_iam_instance_profile")

    @custom_iam_instance_profile.setter
    def custom_iam_instance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_iam_instance_profile", value)

    @property
    @pulumi.getter(name="customerOwnedIpEnabled")
    def customer_owned_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance. See [CoIP for RDS on Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html#rds-on-outposts.coip) for more information.

        > **NOTE:** Removing the `replicate_source_db` attribute from an existing RDS
        Replicate database managed by the provider will promote the database to a fully
        standalone database.
        """
        return pulumi.get(self, "customer_owned_ip_enabled")

    @customer_owned_ip_enabled.setter
    def customer_owned_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "customer_owned_ip_enabled", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. Note that this does not apply for Oracle or SQL Server engines. See the [AWS documentation](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/create-db-instance.html) for more details on what applies for those engines. If you are providing an Oracle db name, it needs to be in all upper case. Cannot be specified for a replica.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of DB subnet group.
        DB instance will be created in the VPC associated with the DB subnet group.
        If unspecified, will be created in the `default` Subnet Group.
        When working with read replicas created in the same region, defaults to the Subnet Group Name of the source DB.
        When working with read replicas created in a different region, defaults to the `default` Subnet Group.
        See [DBSubnetGroupName in API action CreateDBInstanceReadReplica](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html) for additional read replica constraints.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="dedicatedLogVolume")
    def dedicated_log_volume(self) -> Optional[pulumi.Input[bool]]:
        """
        Use a dedicated log volume (DLV) for the DB instance. Requires Provisioned IOPS. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.dlv) for more details.
        """
        return pulumi.get(self, "dedicated_log_volume")

    @dedicated_log_volume.setter
    def dedicated_log_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dedicated_log_volume", value)

    @property
    @pulumi.getter(name="deleteAutomatedBackups")
    def delete_automated_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to remove automated backups immediately after the DB instance is deleted. Default is `true`.
        """
        return pulumi.get(self, "delete_automated_backups")

    @delete_automated_backups.setter
    def delete_automated_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_automated_backups", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        If the DB instance should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Directory Service Active Directory domain to create the instance in. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="domainAuthSecretArn")
    def domain_auth_secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the Secrets Manager secret with the self managed Active Directory credentials for the user joining the domain. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_auth_secret_arn")

    @domain_auth_secret_arn.setter
    def domain_auth_secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_auth_secret_arn", value)

    @property
    @pulumi.getter(name="domainDnsIps")
    def domain_dns_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IPv4 DNS IP addresses of your primary and secondary self managed Active Directory domain controllers. Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_dns_ips")

    @domain_dns_ips.setter
    def domain_dns_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domain_dns_ips", value)

    @property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name (FQDN) of the self managed Active Directory domain. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_fqdn")

    @domain_fqdn.setter
    def domain_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_fqdn", value)

    @property
    @pulumi.getter(name="domainIamRoleName")
    def domain_iam_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IAM role to be used when making API calls to the Directory Service. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        """
        return pulumi.get(self, "domain_iam_role_name")

    @domain_iam_role_name.setter
    def domain_iam_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_iam_role_name", value)

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> Optional[pulumi.Input[str]]:
        """
        The self managed Active Directory organizational unit for your DB instance to join. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_ou")

    @domain_ou.setter
    def domain_ou(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ou", value)

    @property
    @pulumi.getter(name="enabledCloudwatchLogsExports")
    def enabled_cloudwatch_logs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of log types to enable for exporting to CloudWatch logs. If omitted, no logs will be exported. For supported values, see the EnableCloudwatchLogsExports.member.N parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html).
        """
        return pulumi.get(self, "enabled_cloudwatch_logs_exports")

    @enabled_cloudwatch_logs_exports.setter
    def enabled_cloudwatch_logs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_cloudwatch_logs_exports", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The connection endpoint in `address:port` format.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine to use. For supported values, see the Engine parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine must match the DB cluster's engine'. For information on the difference between the available Aurora MySQL engines see [Comparison between Aurora MySQL 1 and Aurora MySQL 2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Updates.20180206.html) in the Amazon RDS User Guide.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> Optional[pulumi.Input[str]]:
        """
        The life cycle type for this DB instance. This setting applies only to RDS for MySQL and RDS for PostgreSQL. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @engine_lifecycle_support.setter
    def engine_lifecycle_support(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_lifecycle_support", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The engine version to use. If `auto_minor_version_upgrade` is enabled, you can provide a prefix of the version such as `8.0` (for `8.0.36`). The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. For supported values, see the EngineVersion parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine version must match the DB cluster's engine version'.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> Optional[pulumi.Input[str]]:
        """
        The running version of the database.
        """
        return pulumi.get(self, "engine_version_actual")

    @engine_version_actual.setter
    def engine_version_actual(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version_actual", value)

    @property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name of your final DB snapshot
        when this DB instance is deleted. Must be provided if `skip_final_snapshot` is
        set to `false`. The value must begin with a letter, only contain alphanumeric characters and hyphens, and not end with a hyphen or contain two consecutive hyphens. Must not be provided when deleting a read replica.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @final_snapshot_identifier.setter
    def final_snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_snapshot_identifier", value)

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hosted_zone_id", value)

    @property
    @pulumi.getter(name="iamDatabaseAuthenticationEnabled")
    def iam_database_authentication_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether mappings of AWS Identity and Access Management (IAM) accounts to database
        accounts is enabled.
        """
        return pulumi.get(self, "iam_database_authentication_enabled")

    @iam_database_authentication_enabled.setter
    def iam_database_authentication_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "iam_database_authentication_enabled", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the RDS instance, if omitted, this provider will assign a random, unique identifier. Required if `restore_to_point_in_time` is specified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @identifier_prefix.setter
    def identifier_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier_prefix", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[Union[str, 'InstanceType']]]:
        """
        The instance type of the RDS instance.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[Union[str, 'InstanceType']]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of provisioned IOPS. Setting this implies a
        storage_type of "io1" or "io2". Can only be set when `storage_type` is `"io1"`, `"io2` or `"gp3"`.
        Cannot be specified for gp3 storage if the `allocated_storage` value is below a per-`engine` threshold.
        See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the KMS encryption key. If creating an
        encrypted replica, set this to the destination KMS ARN.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="latestRestorableTime")
    def latest_restorable_time(self) -> Optional[pulumi.Input[str]]:
        """
        The latest time, in UTC [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), to which a database can be restored with point-in-time restore.
        """
        return pulumi.get(self, "latest_restorable_time")

    @latest_restorable_time.setter
    def latest_restorable_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_restorable_time", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        License model information for this DB instance. Valid values for this field are as follows:
        * RDS for MariaDB: `general-public-license`
        * RDS for Microsoft SQL Server: `license-included`
        * RDS for MySQL: `general-public-license`
        * RDS for Oracle: `bring-your-own-license | license-included`
        * RDS for PostgreSQL: `postgresql-license`
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="listenerEndpoints")
    def listener_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceListenerEndpointArgs']]]]:
        """
        Specifies the listener connection endpoint for SQL Server Always On. See endpoint below.
        """
        return pulumi.get(self, "listener_endpoints")

    @listener_endpoints.setter
    def listener_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceListenerEndpointArgs']]]]):
        pulumi.set(self, "listener_endpoints", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        The window to perform maintenance in.
        Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00". See [RDS
        Maintenance Window
        docs](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
        for more information.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `password` is provided.
        """
        return pulumi.get(self, "manage_master_user_password")

    @manage_master_user_password.setter
    def manage_master_user_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_master_user_password", value)

    @property
    @pulumi.getter(name="masterUserSecretKmsKeyId")
    def master_user_secret_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
        """
        return pulumi.get(self, "master_user_secret_kms_key_id")

    @master_user_secret_kms_key_id.setter
    def master_user_secret_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_secret_kms_key_id", value)

    @property
    @pulumi.getter(name="masterUserSecrets")
    def master_user_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMasterUserSecretArgs']]]]:
        """
        A block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
        """
        return pulumi.get(self, "master_user_secrets")

    @master_user_secrets.setter
    def master_user_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMasterUserSecretArgs']]]]):
        pulumi.set(self, "master_user_secrets", value)

    @property
    @pulumi.getter(name="maxAllocatedStorage")
    def max_allocated_storage(self) -> Optional[pulumi.Input[int]]:
        """
        When configured, the upper limit to which Amazon RDS can automatically scale the storage of the DB instance. Configuring this will automatically ignore differences to `allocated_storage`. Must be greater than or equal to `allocated_storage` or `0` to disable Storage Autoscaling.
        """
        return pulumi.get(self, "max_allocated_storage")

    @max_allocated_storage.setter
    def max_allocated_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_allocated_storage", value)

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval, in seconds, between points
        when Enhanced Monitoring metrics are collected for the DB instance. To disable
        collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid
        Values: 0, 1, 5, 10, 15, 30, 60.
        """
        return pulumi.get(self, "monitoring_interval")

    @monitoring_interval.setter
    def monitoring_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "monitoring_interval", value)

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the IAM role that permits RDS
        to send enhanced monitoring metrics to CloudWatch Logs. You can find more
        information on the [AWS
        Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html)
        what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @monitoring_role_arn.setter
    def monitoring_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitoring_role_arn", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the RDS instance is multi-AZ
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This property has been deprecated. Please use 'dbName' instead.""")
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ncharCharacterSetName")
    def nchar_character_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The national character set is used in the NCHAR, NVARCHAR2, and NCLOB data types for Oracle instances. This can't be changed. See [Oracle Character Sets
        Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html).
        """
        return pulumi.get(self, "nchar_character_set_name")

    @nchar_character_set_name.setter
    def nchar_character_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nchar_character_set_name", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of the DB instance. Valid values: `IPV4`, `DUAL`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="optionGroupName")
    def option_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the DB option group to associate.
        """
        return pulumi.get(self, "option_group_name")

    @option_group_name.setter
    def option_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option_group_name", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the DB parameter group to associate.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (Required unless `manage_master_user_password` is set to true or unless a `snapshot_identifier` or `replicate_source_db`
        is provided or `manage_master_user_password` is set.) Password for the master DB user. Note that this may show up in
        logs, and it will be stored in the state file. Cannot be set if `manage_master_user_password` is set to `true`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether Performance Insights are enabled. Defaults to false.
        """
        return pulumi.get(self, "performance_insights_enabled")

    @performance_insights_enabled.setter
    def performance_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "performance_insights_enabled", value)

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true. Once KMS key is set, it can never be changed.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @performance_insights_kms_key_id.setter
    def performance_insights_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_insights_kms_key_id", value)

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @performance_insights_retention_period.setter
    def performance_insights_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "performance_insights_retention_period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on which the DB accepts connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool to control if instance is publicly
        accessible. Default is `false`.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="replicaMode")
    def replica_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the replica is in either `mounted` or `open-read-only` mode. This attribute
        is only supported by Oracle instances. Oracle replicas operate in `open-read-only` mode unless otherwise specified. See [Working with Oracle Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) for more information.
        """
        return pulumi.get(self, "replica_mode")

    @replica_mode.setter
    def replica_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_mode", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="replicateSourceDb")
    def replicate_source_db(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies that this resource is a Replica database, and to use this value as the source database.
        If replicating an Amazon RDS Database Instance in the same region, use the `identifier` of the source DB, unless also specifying the `db_subnet_group_name`.
        If specifying the `db_subnet_group_name` in the same region, use the `arn` of the source DB.
        If replicating an Instance in a different region, use the `arn` of the source DB.
        Note that if you are creating a cross-region replica of an encrypted database you will also need to specify a `kms_key_id`.
        See [DB Instance Replication][instance-replication] and [Working with PostgreSQL and MySQL Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html) for more information on using Replication.
        """
        return pulumi.get(self, "replicate_source_db")

    @replicate_source_db.setter
    def replicate_source_db(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replicate_source_db", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The RDS Resource ID of this instance.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="restoreToPointInTime")
    def restore_to_point_in_time(self) -> Optional[pulumi.Input['InstanceRestoreToPointInTimeArgs']]:
        """
        A configuration block for restoring a DB instance to an arbitrary point in time.
        Requires the `identifier` argument to be set with the name of the new DB instance to be created.
        See Restore To Point In Time below for details.
        """
        return pulumi.get(self, "restore_to_point_in_time")

    @restore_to_point_in_time.setter
    def restore_to_point_in_time(self, value: Optional[pulumi.Input['InstanceRestoreToPointInTimeArgs']]):
        pulumi.set(self, "restore_to_point_in_time", value)

    @property
    @pulumi.getter(name="s3Import")
    def s3_import(self) -> Optional[pulumi.Input['InstanceS3ImportArgs']]:
        """
        Restore from a Percona Xtrabackup in S3.  See [Importing Data into an Amazon RDS MySQL DB Instance](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
        """
        return pulumi.get(self, "s3_import")

    @s3_import.setter
    def s3_import(self, value: Optional[pulumi.Input['InstanceS3ImportArgs']]):
        pulumi.set(self, "s3_import", value)

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether a final DB snapshot is
        created before the DB instance is deleted. If true is specified, no DBSnapshot
        is created. If false is specified, a DB snapshot is created before the DB
        instance is deleted, using the value from `final_snapshot_identifier`. Default
        is `false`.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether or not to create this database from a snapshot.
        This corresponds to the snapshot ID you'd find in the RDS console, e.g: rds:production-2015-06-26-06-05.
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The RDS instance status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the DB instance is
        encrypted. Note that if you are creating a cross-region read replica this field
        is ignored and you should instead declare `kms_key_id` with a valid ARN. The
        default is `false` if not specified.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter(name="storageThroughput")
    def storage_throughput(self) -> Optional[pulumi.Input[int]]:
        """
        The storage throughput value for the DB instance. Can only be set when `storage_type` is `"gp3"`. Cannot be specified if the `allocated_storage` value is below a per-`engine` threshold. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        """
        return pulumi.get(self, "storage_throughput")

    @storage_throughput.setter
    def storage_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_throughput", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[Union[str, 'StorageType']]]:
        """
        One of "standard" (magnetic), "gp2" (general
        purpose SSD), "gp3" (general purpose SSD that needs `iops` independently)
        "io1" (provisioned IOPS SSD) or "io2" (block express storage provisioned IOPS
        SSD). The default is "io1" if `iops` is specified, "gp2" if not.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[Union[str, 'StorageType']]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Time zone of the DB instance. `timezone` is currently
        only supported by Microsoft SQL Server. The `timezone` can only be set on
        creation. See [MSSQL User
        Guide](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone)
        for more information.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="upgradeStorageConfig")
    def upgrade_storage_config(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to upgrade the storage file system configuration on the read replica.
        Can only be set with `replicate_source_db`.
        """
        return pulumi.get(self, "upgrade_storage_config")

    @upgrade_storage_config.setter
    def upgrade_storage_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_storage_config", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        (Required unless a `snapshot_identifier` or `replicate_source_db`
        is provided) Username for the master DB user. Cannot be specified for a replica.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPC security groups to
        associate.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 allow_major_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 backup_target: Optional[pulumi.Input[str]] = None,
                 backup_window: Optional[pulumi.Input[str]] = None,
                 blue_green_update: Optional[pulumi.Input[Union['InstanceBlueGreenUpdateArgs', 'InstanceBlueGreenUpdateArgsDict']]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[str]] = None,
                 character_set_name: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 customer_owned_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 dedicated_log_volume: Optional[pulumi.Input[bool]] = None,
                 delete_automated_backups: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_auth_secret_arn: Optional[pulumi.Input[str]] = None,
                 domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_fqdn: Optional[pulumi.Input[str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[str]] = None,
                 domain_ou: Optional[pulumi.Input[str]] = None,
                 enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 iam_database_authentication_enabled: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 identifier_prefix: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[bool]] = None,
                 master_user_secret_kms_key_id: Optional[pulumi.Input[str]] = None,
                 max_allocated_storage: Optional[pulumi.Input[int]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nchar_character_set_name: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 option_group_name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 replica_mode: Optional[pulumi.Input[str]] = None,
                 replicate_source_db: Optional[pulumi.Input[str]] = None,
                 restore_to_point_in_time: Optional[pulumi.Input[Union['InstanceRestoreToPointInTimeArgs', 'InstanceRestoreToPointInTimeArgsDict']]] = None,
                 s3_import: Optional[pulumi.Input[Union['InstanceS3ImportArgs', 'InstanceS3ImportArgsDict']]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 storage_throughput: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 upgrade_storage_config: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides an RDS instance resource.  A DB instance is an isolated database
        environment in the cloud.  A DB instance can contain multiple user-created
        databases.

        Changes to a DB instance can occur when you manually change a parameter, such as
        `allocated_storage`, and are reflected in the next maintenance window. Because
        of this, this provider may report a difference in its planning phase because a
        modification has not yet taken place. You can use the `apply_immediately` flag
        to instruct the service to apply the change immediately (see documentation
        below).

        When upgrading the major version of an engine, `allow_major_version_upgrade` must be set to `true`.

        > **Note:** using `apply_immediately` can result in a brief downtime as the server reboots.
        See the AWS Docs on [RDS Instance Maintenance][instance-maintenance] for more information.

        > **Note:** All arguments including the username and password will be stored in the raw state as plain-text.
        Read more about sensitive data instate.

        ## RDS Instance Class Types

        Amazon RDS supports instance classes for the following use cases: General-purpose, Memory-optimized, Burstable Performance, and Optimized-reads.
        For more information please read the AWS RDS documentation about [DB Instance Class Types](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)

        ## Low-Downtime Updates

        By default, RDS applies updates to DB Instances in-place, which can lead to service interruptions.
        Low-downtime updates minimize service interruptions by performing the updates with an [RDS Blue/Green deployment][blue-green] and switching over the instances when complete.

        Low-downtime updates are only available for DB Instances using MySQL, MariaDB and PostgreSQL,
        as other engines are not supported by RDS Blue/Green deployments.
        They cannot be used with DB Instances with replicas.

        Backups must be enabled to use low-downtime updates.

        Enable low-downtime updates by setting `blue_green_update.enabled` to `true`.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.rds.Instance("default",
            allocated_storage=10,
            db_name="mydb",
            engine="mysql",
            engine_version="8.0",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            username="foo",
            password="foobarbaz",
            parameter_group_name="default.mysql8.0",
            skip_final_snapshot=True)
        ```

        ### RDS Custom for Oracle Usage with Replica

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lookup the available instance classes for the custom engine for the region being operated in
        custom_oracle = aws.rds.get_orderable_db_instance(engine="custom-oracle-ee",
            engine_version="19.c.ee.002",
            license_model="bring-your-own-license",
            storage_type="gp3",
            preferred_instance_classes=[
                "db.r5.xlarge",
                "db.r5.2xlarge",
                "db.r5.4xlarge",
            ])
        # The RDS instance resource requires an ARN. Look up the ARN of the KMS key associated with the CEV.
        by_id = aws.kms.get_key(key_id="example-ef278353ceba4a5a97de6784565b9f78")
        default = aws.rds.Instance("default",
            allocated_storage=50,
            auto_minor_version_upgrade=False,
            custom_iam_instance_profile="AWSRDSCustomInstanceProfile",
            backup_retention_period=7,
            db_subnet_group_name=db_subnet_group_name,
            engine=custom_oracle.engine,
            engine_version=custom_oracle.engine_version,
            identifier="ee-instance-demo",
            instance_class=custom_oracle.instance_class.apply(lambda x: aws.rds.InstanceType(x)),
            kms_key_id=by_id.arn,
            license_model=custom_oracle.license_model,
            multi_az=False,
            password="avoid-plaintext-passwords",
            username="test",
            storage_encrypted=True)
        test_replica = aws.rds.Instance("test-replica",
            replicate_source_db=default.identifier,
            replica_mode="mounted",
            auto_minor_version_upgrade=False,
            custom_iam_instance_profile="AWSRDSCustomInstanceProfile",
            backup_retention_period=7,
            identifier="ee-instance-replica",
            instance_class=custom_oracle.instance_class.apply(lambda x: aws.rds.InstanceType(x)),
            kms_key_id=by_id.arn,
            multi_az=False,
            skip_final_snapshot=True,
            storage_encrypted=True)
        ```

        ### RDS Custom for SQL Server

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lookup the available instance classes for the custom engine for the region being operated in
        custom_sqlserver = aws.rds.get_orderable_db_instance(engine="custom-sqlserver-se",
            engine_version="15.00.4249.2.v1",
            storage_type="gp3",
            preferred_instance_classes=[
                "db.r5.xlarge",
                "db.r5.2xlarge",
                "db.r5.4xlarge",
            ])
        # The RDS instance resource requires an ARN. Look up the ARN of the KMS key.
        by_id = aws.kms.get_key(key_id="example-ef278353ceba4a5a97de6784565b9f78")
        example = aws.rds.Instance("example",
            allocated_storage=500,
            auto_minor_version_upgrade=False,
            custom_iam_instance_profile="AWSRDSCustomSQLServerInstanceProfile",
            backup_retention_period=7,
            db_subnet_group_name=db_subnet_group_name,
            engine=custom_sqlserver.engine,
            engine_version=custom_sqlserver.engine_version,
            identifier="sql-instance-demo",
            instance_class=custom_sqlserver.instance_class.apply(lambda x: aws.rds.InstanceType(x)),
            kms_key_id=by_id.arn,
            multi_az=False,
            password="avoid-plaintext-passwords",
            storage_encrypted=True,
            username="test")
        ```

        ### RDS Db2 Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lookup the default version for the engine. Db2 Standard Edition is `db2-se`, Db2 Advanced Edition is `db2-ae`.
        default = aws.rds.get_engine_version(engine="db2-se")
        # Lookup the available instance classes for the engine in the region being operated in
        example = aws.rds.get_orderable_db_instance(engine=default.engine,
            engine_version=default.version,
            license_model="bring-your-own-license",
            storage_type="gp3",
            preferred_instance_classes=[
                "db.t3.small",
                "db.r6i.large",
                "db.m6i.large",
            ])
        # The RDS Db2 instance resource requires licensing information. Create a new parameter group using the default paramater group as a source, and set license information.
        example_parameter_group = aws.rds.ParameterGroup("example",
            name="db-db2-params",
            family=default.parameter_group_family,
            parameters=[
                {
                    "apply_method": "immediate",
                    "name": "rds.ibm_customer_id",
                    "value": "0",
                },
                {
                    "apply_method": "immediate",
                    "name": "rds.ibm_site_id",
                    "value": "0",
                },
            ])
        # Create the RDS Db2 instance, use the data sources defined to set attributes
        example_instance = aws.rds.Instance("example",
            allocated_storage=100,
            backup_retention_period=7,
            db_name="test",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="db2-instance-demo",
            instance_class=example.instance_class.apply(lambda x: aws.rds.InstanceType(x)),
            parameter_group_name=example_parameter_group.name,
            password="avoid-plaintext-passwords",
            username="test")
        ```

        ### Storage Autoscaling

        To enable Storage Autoscaling with instances that support the feature, define the `max_allocated_storage` argument higher than the `allocated_storage` argument. This provider will automatically hide differences with the `allocated_storage` argument value if autoscaling occurs.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Instance("example",
            allocated_storage=50,
            max_allocated_storage=100)
        ```

        ### Managed Master Passwords via Secrets Manager, default KMS Key

        > More information about RDS/Aurora Aurora integrates with Secrets Manager to manage master user passwords for your DB clusters can be found in the [RDS User Guide](https://aws.amazon.com/about-aws/whats-new/2022/12/amazon-rds-integration-aws-secrets-manager/) and [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html).

        You can specify the `manage_master_user_password` attribute to enable managing the master password with Secrets Manager. You can also update an existing cluster to use Secrets Manager by specify the `manage_master_user_password` attribute and removing the `password` attribute (removal is required).

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.rds.Instance("default",
            allocated_storage=10,
            db_name="mydb",
            engine="mysql",
            engine_version="8.0",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            manage_master_user_password=True,
            username="foo",
            parameter_group_name="default.mysql8.0")
        ```

        ### Managed Master Passwords via Secrets Manager, specific KMS Key

        > More information about RDS/Aurora Aurora integrates with Secrets Manager to manage master user passwords for your DB clusters can be found in the [RDS User Guide](https://aws.amazon.com/about-aws/whats-new/2022/12/amazon-rds-integration-aws-secrets-manager/) and [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html).

        You can specify the `master_user_secret_kms_key_id` attribute to specify a specific KMS Key.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example", description="Example KMS Key")
        default = aws.rds.Instance("default",
            allocated_storage=10,
            db_name="mydb",
            engine="mysql",
            engine_version="8.0",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            manage_master_user_password=True,
            master_user_secret_kms_key_id=example.key_id,
            username="foo",
            parameter_group_name="default.mysql8.0")
        ```

        ## Import

        Using `pulumi import`, import DB Instances using the `identifier`. For example:

        ```sh
        $ pulumi import aws:rds/instance:Instance default mydb-rds-instance
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] allocated_storage: The allocated storage in gibibytes. If `max_allocated_storage` is configured, this argument represents the initial storage allocation and differences from the configuration will be ignored automatically when Storage Autoscaling occurs. If `replicate_source_db` is set, the value is ignored during the creation of the instance.
        :param pulumi.Input[bool] allow_major_version_upgrade: Indicates that major version
               upgrades are allowed. Changing this parameter does not result in an outage and
               the change is asynchronously applied as soon as possible.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any database modifications
               are applied immediately, or during the next maintenance window. Default is
               `false`. See [Amazon RDS Documentation for more
               information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
        :param pulumi.Input[bool] auto_minor_version_upgrade: Indicates that minor engine upgrades
               will be applied automatically to the DB instance during the maintenance window.
               Defaults to true.
        :param pulumi.Input[str] availability_zone: The AZ for the RDS instance.
        :param pulumi.Input[int] backup_retention_period: The days to retain backups for.
               Must be between `0` and `35`.
               Default is `0`.
               Must be greater than `0` if the database is used as a source for a [Read Replica][instance-replication],
               uses low-downtime updates,
               or will use [RDS Blue/Green deployments][blue-green].
        :param pulumi.Input[str] backup_target: Specifies where automated backups and manual snapshots are stored. Possible values are `region` (default) and `outposts`. See [Working with Amazon RDS on AWS Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) for more information.
        :param pulumi.Input[str] backup_window: The daily time range (in UTC) during which automated backups are created if they are enabled.
               Example: "09:46-10:16". Must not overlap with `maintenance_window`.
        :param pulumi.Input[Union['InstanceBlueGreenUpdateArgs', 'InstanceBlueGreenUpdateArgsDict']] blue_green_update: Enables low-downtime updates using [RDS Blue/Green deployments][blue-green].
               See `blue_green_update` below.
        :param pulumi.Input[str] ca_cert_identifier: The identifier of the CA certificate for the DB instance.
        :param pulumi.Input[str] character_set_name: The character set name to use for DB encoding in Oracle and Microsoft SQL instances (collation).
               This can't be changed.
               See [Oracle Character Sets Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html) or
               [Server-Level Collation for Microsoft SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.CommonDBATasks.Collation.html) for more information.
               Cannot be set  with `replicate_source_db`, `restore_to_point_in_time`, `s3_import`, or `snapshot_identifier`.
        :param pulumi.Input[bool] copy_tags_to_snapshot: Copy all Instance `tags` to snapshots. Default is `false`.
        :param pulumi.Input[str] custom_iam_instance_profile: The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        :param pulumi.Input[bool] customer_owned_ip_enabled: Indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance. See [CoIP for RDS on Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html#rds-on-outposts.coip) for more information.
               
               > **NOTE:** Removing the `replicate_source_db` attribute from an existing RDS
               Replicate database managed by the provider will promote the database to a fully
               standalone database.
        :param pulumi.Input[str] db_name: The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. Note that this does not apply for Oracle or SQL Server engines. See the [AWS documentation](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/create-db-instance.html) for more details on what applies for those engines. If you are providing an Oracle db name, it needs to be in all upper case. Cannot be specified for a replica.
        :param pulumi.Input[str] db_subnet_group_name: Name of DB subnet group.
               DB instance will be created in the VPC associated with the DB subnet group.
               If unspecified, will be created in the `default` Subnet Group.
               When working with read replicas created in the same region, defaults to the Subnet Group Name of the source DB.
               When working with read replicas created in a different region, defaults to the `default` Subnet Group.
               See [DBSubnetGroupName in API action CreateDBInstanceReadReplica](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html) for additional read replica constraints.
        :param pulumi.Input[bool] dedicated_log_volume: Use a dedicated log volume (DLV) for the DB instance. Requires Provisioned IOPS. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.dlv) for more details.
        :param pulumi.Input[bool] delete_automated_backups: Specifies whether to remove automated backups immediately after the DB instance is deleted. Default is `true`.
        :param pulumi.Input[bool] deletion_protection: If the DB instance should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        :param pulumi.Input[str] domain: The ID of the Directory Service Active Directory domain to create the instance in. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        :param pulumi.Input[str] domain_auth_secret_arn: The ARN for the Secrets Manager secret with the self managed Active Directory credentials for the user joining the domain. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_dns_ips: The IPv4 DNS IP addresses of your primary and secondary self managed Active Directory domain controllers. Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[str] domain_fqdn: The fully qualified domain name (FQDN) of the self managed Active Directory domain. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[str] domain_iam_role_name: The name of the IAM role to be used when making API calls to the Directory Service. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        :param pulumi.Input[str] domain_ou: The self managed Active Directory organizational unit for your DB instance to join. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_cloudwatch_logs_exports: Set of log types to enable for exporting to CloudWatch logs. If omitted, no logs will be exported. For supported values, see the EnableCloudwatchLogsExports.member.N parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html).
        :param pulumi.Input[str] engine: The database engine to use. For supported values, see the Engine parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine must match the DB cluster's engine'. For information on the difference between the available Aurora MySQL engines see [Comparison between Aurora MySQL 1 and Aurora MySQL 2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Updates.20180206.html) in the Amazon RDS User Guide.
        :param pulumi.Input[str] engine_lifecycle_support: The life cycle type for this DB instance. This setting applies only to RDS for MySQL and RDS for PostgreSQL. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        :param pulumi.Input[str] engine_version: The engine version to use. If `auto_minor_version_upgrade` is enabled, you can provide a prefix of the version such as `8.0` (for `8.0.36`). The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. For supported values, see the EngineVersion parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine version must match the DB cluster's engine version'.
        :param pulumi.Input[str] final_snapshot_identifier: The name of your final DB snapshot
               when this DB instance is deleted. Must be provided if `skip_final_snapshot` is
               set to `false`. The value must begin with a letter, only contain alphanumeric characters and hyphens, and not end with a hyphen or contain two consecutive hyphens. Must not be provided when deleting a read replica.
        :param pulumi.Input[bool] iam_database_authentication_enabled: Specifies whether mappings of AWS Identity and Access Management (IAM) accounts to database
               accounts is enabled.
        :param pulumi.Input[str] identifier: The name of the RDS instance, if omitted, this provider will assign a random, unique identifier. Required if `restore_to_point_in_time` is specified.
        :param pulumi.Input[str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_class: The instance type of the RDS instance.
        :param pulumi.Input[int] iops: The amount of provisioned IOPS. Setting this implies a
               storage_type of "io1" or "io2". Can only be set when `storage_type` is `"io1"`, `"io2` or `"gp3"`.
               Cannot be specified for gp3 storage if the `allocated_storage` value is below a per-`engine` threshold.
               See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. If creating an
               encrypted replica, set this to the destination KMS ARN.
        :param pulumi.Input[str] license_model: License model information for this DB instance. Valid values for this field are as follows:
               * RDS for MariaDB: `general-public-license`
               * RDS for Microsoft SQL Server: `license-included`
               * RDS for MySQL: `general-public-license`
               * RDS for Oracle: `bring-your-own-license | license-included`
               * RDS for PostgreSQL: `postgresql-license`
        :param pulumi.Input[str] maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00". See [RDS
               Maintenance Window
               docs](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
               for more information.
        :param pulumi.Input[bool] manage_master_user_password: Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `password` is provided.
        :param pulumi.Input[str] master_user_secret_kms_key_id: The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
        :param pulumi.Input[int] max_allocated_storage: When configured, the upper limit to which Amazon RDS can automatically scale the storage of the DB instance. Configuring this will automatically ignore differences to `allocated_storage`. Must be greater than or equal to `allocated_storage` or `0` to disable Storage Autoscaling.
        :param pulumi.Input[int] monitoring_interval: The interval, in seconds, between points
               when Enhanced Monitoring metrics are collected for the DB instance. To disable
               collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid
               Values: 0, 1, 5, 10, 15, 30, 60.
        :param pulumi.Input[str] monitoring_role_arn: The ARN for the IAM role that permits RDS
               to send enhanced monitoring metrics to CloudWatch Logs. You can find more
               information on the [AWS
               Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html)
               what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ
        :param pulumi.Input[str] nchar_character_set_name: The national character set is used in the NCHAR, NVARCHAR2, and NCLOB data types for Oracle instances. This can't be changed. See [Oracle Character Sets
               Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html).
        :param pulumi.Input[str] network_type: The network type of the DB instance. Valid values: `IPV4`, `DUAL`.
        :param pulumi.Input[str] option_group_name: Name of the DB option group to associate.
        :param pulumi.Input[str] parameter_group_name: Name of the DB parameter group to associate.
        :param pulumi.Input[str] password: (Required unless `manage_master_user_password` is set to true or unless a `snapshot_identifier` or `replicate_source_db`
               is provided or `manage_master_user_password` is set.) Password for the master DB user. Note that this may show up in
               logs, and it will be stored in the state file. Cannot be set if `manage_master_user_password` is set to `true`.
        :param pulumi.Input[bool] performance_insights_enabled: Specifies whether Performance Insights are enabled. Defaults to false.
        :param pulumi.Input[str] performance_insights_kms_key_id: The ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true. Once KMS key is set, it can never be changed.
        :param pulumi.Input[int] performance_insights_retention_period: Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        :param pulumi.Input[int] port: The port on which the DB accepts connections.
        :param pulumi.Input[bool] publicly_accessible: Bool to control if instance is publicly
               accessible. Default is `false`.
        :param pulumi.Input[str] replica_mode: Specifies whether the replica is in either `mounted` or `open-read-only` mode. This attribute
               is only supported by Oracle instances. Oracle replicas operate in `open-read-only` mode unless otherwise specified. See [Working with Oracle Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) for more information.
        :param pulumi.Input[str] replicate_source_db: Specifies that this resource is a Replica database, and to use this value as the source database.
               If replicating an Amazon RDS Database Instance in the same region, use the `identifier` of the source DB, unless also specifying the `db_subnet_group_name`.
               If specifying the `db_subnet_group_name` in the same region, use the `arn` of the source DB.
               If replicating an Instance in a different region, use the `arn` of the source DB.
               Note that if you are creating a cross-region replica of an encrypted database you will also need to specify a `kms_key_id`.
               See [DB Instance Replication][instance-replication] and [Working with PostgreSQL and MySQL Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html) for more information on using Replication.
        :param pulumi.Input[Union['InstanceRestoreToPointInTimeArgs', 'InstanceRestoreToPointInTimeArgsDict']] restore_to_point_in_time: A configuration block for restoring a DB instance to an arbitrary point in time.
               Requires the `identifier` argument to be set with the name of the new DB instance to be created.
               See Restore To Point In Time below for details.
        :param pulumi.Input[Union['InstanceS3ImportArgs', 'InstanceS3ImportArgsDict']] s3_import: Restore from a Percona Xtrabackup in S3.  See [Importing Data into an Amazon RDS MySQL DB Instance](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final DB snapshot is
               created before the DB instance is deleted. If true is specified, no DBSnapshot
               is created. If false is specified, a DB snapshot is created before the DB
               instance is deleted, using the value from `final_snapshot_identifier`. Default
               is `false`.
        :param pulumi.Input[str] snapshot_identifier: Specifies whether or not to create this database from a snapshot.
               This corresponds to the snapshot ID you'd find in the RDS console, e.g: rds:production-2015-06-26-06-05.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB instance is
               encrypted. Note that if you are creating a cross-region read replica this field
               is ignored and you should instead declare `kms_key_id` with a valid ARN. The
               default is `false` if not specified.
        :param pulumi.Input[int] storage_throughput: The storage throughput value for the DB instance. Can only be set when `storage_type` is `"gp3"`. Cannot be specified if the `allocated_storage` value is below a per-`engine` threshold. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        :param pulumi.Input[Union[str, 'StorageType']] storage_type: One of "standard" (magnetic), "gp2" (general
               purpose SSD), "gp3" (general purpose SSD that needs `iops` independently)
               "io1" (provisioned IOPS SSD) or "io2" (block express storage provisioned IOPS
               SSD). The default is "io1" if `iops` is specified, "gp2" if not.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] timezone: Time zone of the DB instance. `timezone` is currently
               only supported by Microsoft SQL Server. The `timezone` can only be set on
               creation. See [MSSQL User
               Guide](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone)
               for more information.
        :param pulumi.Input[bool] upgrade_storage_config: Whether to upgrade the storage file system configuration on the read replica.
               Can only be set with `replicate_source_db`.
        :param pulumi.Input[str] username: (Required unless a `snapshot_identifier` or `replicate_source_db`
               is provided) Username for the master DB user. Cannot be specified for a replica.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: List of VPC security groups to
               associate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an RDS instance resource.  A DB instance is an isolated database
        environment in the cloud.  A DB instance can contain multiple user-created
        databases.

        Changes to a DB instance can occur when you manually change a parameter, such as
        `allocated_storage`, and are reflected in the next maintenance window. Because
        of this, this provider may report a difference in its planning phase because a
        modification has not yet taken place. You can use the `apply_immediately` flag
        to instruct the service to apply the change immediately (see documentation
        below).

        When upgrading the major version of an engine, `allow_major_version_upgrade` must be set to `true`.

        > **Note:** using `apply_immediately` can result in a brief downtime as the server reboots.
        See the AWS Docs on [RDS Instance Maintenance][instance-maintenance] for more information.

        > **Note:** All arguments including the username and password will be stored in the raw state as plain-text.
        Read more about sensitive data instate.

        ## RDS Instance Class Types

        Amazon RDS supports instance classes for the following use cases: General-purpose, Memory-optimized, Burstable Performance, and Optimized-reads.
        For more information please read the AWS RDS documentation about [DB Instance Class Types](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)

        ## Low-Downtime Updates

        By default, RDS applies updates to DB Instances in-place, which can lead to service interruptions.
        Low-downtime updates minimize service interruptions by performing the updates with an [RDS Blue/Green deployment][blue-green] and switching over the instances when complete.

        Low-downtime updates are only available for DB Instances using MySQL, MariaDB and PostgreSQL,
        as other engines are not supported by RDS Blue/Green deployments.
        They cannot be used with DB Instances with replicas.

        Backups must be enabled to use low-downtime updates.

        Enable low-downtime updates by setting `blue_green_update.enabled` to `true`.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.rds.Instance("default",
            allocated_storage=10,
            db_name="mydb",
            engine="mysql",
            engine_version="8.0",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            username="foo",
            password="foobarbaz",
            parameter_group_name="default.mysql8.0",
            skip_final_snapshot=True)
        ```

        ### RDS Custom for Oracle Usage with Replica

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lookup the available instance classes for the custom engine for the region being operated in
        custom_oracle = aws.rds.get_orderable_db_instance(engine="custom-oracle-ee",
            engine_version="19.c.ee.002",
            license_model="bring-your-own-license",
            storage_type="gp3",
            preferred_instance_classes=[
                "db.r5.xlarge",
                "db.r5.2xlarge",
                "db.r5.4xlarge",
            ])
        # The RDS instance resource requires an ARN. Look up the ARN of the KMS key associated with the CEV.
        by_id = aws.kms.get_key(key_id="example-ef278353ceba4a5a97de6784565b9f78")
        default = aws.rds.Instance("default",
            allocated_storage=50,
            auto_minor_version_upgrade=False,
            custom_iam_instance_profile="AWSRDSCustomInstanceProfile",
            backup_retention_period=7,
            db_subnet_group_name=db_subnet_group_name,
            engine=custom_oracle.engine,
            engine_version=custom_oracle.engine_version,
            identifier="ee-instance-demo",
            instance_class=custom_oracle.instance_class.apply(lambda x: aws.rds.InstanceType(x)),
            kms_key_id=by_id.arn,
            license_model=custom_oracle.license_model,
            multi_az=False,
            password="avoid-plaintext-passwords",
            username="test",
            storage_encrypted=True)
        test_replica = aws.rds.Instance("test-replica",
            replicate_source_db=default.identifier,
            replica_mode="mounted",
            auto_minor_version_upgrade=False,
            custom_iam_instance_profile="AWSRDSCustomInstanceProfile",
            backup_retention_period=7,
            identifier="ee-instance-replica",
            instance_class=custom_oracle.instance_class.apply(lambda x: aws.rds.InstanceType(x)),
            kms_key_id=by_id.arn,
            multi_az=False,
            skip_final_snapshot=True,
            storage_encrypted=True)
        ```

        ### RDS Custom for SQL Server

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lookup the available instance classes for the custom engine for the region being operated in
        custom_sqlserver = aws.rds.get_orderable_db_instance(engine="custom-sqlserver-se",
            engine_version="15.00.4249.2.v1",
            storage_type="gp3",
            preferred_instance_classes=[
                "db.r5.xlarge",
                "db.r5.2xlarge",
                "db.r5.4xlarge",
            ])
        # The RDS instance resource requires an ARN. Look up the ARN of the KMS key.
        by_id = aws.kms.get_key(key_id="example-ef278353ceba4a5a97de6784565b9f78")
        example = aws.rds.Instance("example",
            allocated_storage=500,
            auto_minor_version_upgrade=False,
            custom_iam_instance_profile="AWSRDSCustomSQLServerInstanceProfile",
            backup_retention_period=7,
            db_subnet_group_name=db_subnet_group_name,
            engine=custom_sqlserver.engine,
            engine_version=custom_sqlserver.engine_version,
            identifier="sql-instance-demo",
            instance_class=custom_sqlserver.instance_class.apply(lambda x: aws.rds.InstanceType(x)),
            kms_key_id=by_id.arn,
            multi_az=False,
            password="avoid-plaintext-passwords",
            storage_encrypted=True,
            username="test")
        ```

        ### RDS Db2 Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lookup the default version for the engine. Db2 Standard Edition is `db2-se`, Db2 Advanced Edition is `db2-ae`.
        default = aws.rds.get_engine_version(engine="db2-se")
        # Lookup the available instance classes for the engine in the region being operated in
        example = aws.rds.get_orderable_db_instance(engine=default.engine,
            engine_version=default.version,
            license_model="bring-your-own-license",
            storage_type="gp3",
            preferred_instance_classes=[
                "db.t3.small",
                "db.r6i.large",
                "db.m6i.large",
            ])
        # The RDS Db2 instance resource requires licensing information. Create a new parameter group using the default paramater group as a source, and set license information.
        example_parameter_group = aws.rds.ParameterGroup("example",
            name="db-db2-params",
            family=default.parameter_group_family,
            parameters=[
                {
                    "apply_method": "immediate",
                    "name": "rds.ibm_customer_id",
                    "value": "0",
                },
                {
                    "apply_method": "immediate",
                    "name": "rds.ibm_site_id",
                    "value": "0",
                },
            ])
        # Create the RDS Db2 instance, use the data sources defined to set attributes
        example_instance = aws.rds.Instance("example",
            allocated_storage=100,
            backup_retention_period=7,
            db_name="test",
            engine=example.engine,
            engine_version=example.engine_version,
            identifier="db2-instance-demo",
            instance_class=example.instance_class.apply(lambda x: aws.rds.InstanceType(x)),
            parameter_group_name=example_parameter_group.name,
            password="avoid-plaintext-passwords",
            username="test")
        ```

        ### Storage Autoscaling

        To enable Storage Autoscaling with instances that support the feature, define the `max_allocated_storage` argument higher than the `allocated_storage` argument. This provider will automatically hide differences with the `allocated_storage` argument value if autoscaling occurs.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Instance("example",
            allocated_storage=50,
            max_allocated_storage=100)
        ```

        ### Managed Master Passwords via Secrets Manager, default KMS Key

        > More information about RDS/Aurora Aurora integrates with Secrets Manager to manage master user passwords for your DB clusters can be found in the [RDS User Guide](https://aws.amazon.com/about-aws/whats-new/2022/12/amazon-rds-integration-aws-secrets-manager/) and [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html).

        You can specify the `manage_master_user_password` attribute to enable managing the master password with Secrets Manager. You can also update an existing cluster to use Secrets Manager by specify the `manage_master_user_password` attribute and removing the `password` attribute (removal is required).

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.rds.Instance("default",
            allocated_storage=10,
            db_name="mydb",
            engine="mysql",
            engine_version="8.0",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            manage_master_user_password=True,
            username="foo",
            parameter_group_name="default.mysql8.0")
        ```

        ### Managed Master Passwords via Secrets Manager, specific KMS Key

        > More information about RDS/Aurora Aurora integrates with Secrets Manager to manage master user passwords for your DB clusters can be found in the [RDS User Guide](https://aws.amazon.com/about-aws/whats-new/2022/12/amazon-rds-integration-aws-secrets-manager/) and [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html).

        You can specify the `master_user_secret_kms_key_id` attribute to specify a specific KMS Key.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example", description="Example KMS Key")
        default = aws.rds.Instance("default",
            allocated_storage=10,
            db_name="mydb",
            engine="mysql",
            engine_version="8.0",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            manage_master_user_password=True,
            master_user_secret_kms_key_id=example.key_id,
            username="foo",
            parameter_group_name="default.mysql8.0")
        ```

        ## Import

        Using `pulumi import`, import DB Instances using the `identifier`. For example:

        ```sh
        $ pulumi import aws:rds/instance:Instance default mydb-rds-instance
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 allow_major_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 backup_target: Optional[pulumi.Input[str]] = None,
                 backup_window: Optional[pulumi.Input[str]] = None,
                 blue_green_update: Optional[pulumi.Input[Union['InstanceBlueGreenUpdateArgs', 'InstanceBlueGreenUpdateArgsDict']]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[str]] = None,
                 character_set_name: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 customer_owned_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 dedicated_log_volume: Optional[pulumi.Input[bool]] = None,
                 delete_automated_backups: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_auth_secret_arn: Optional[pulumi.Input[str]] = None,
                 domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_fqdn: Optional[pulumi.Input[str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[str]] = None,
                 domain_ou: Optional[pulumi.Input[str]] = None,
                 enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 iam_database_authentication_enabled: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 identifier_prefix: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[bool]] = None,
                 master_user_secret_kms_key_id: Optional[pulumi.Input[str]] = None,
                 max_allocated_storage: Optional[pulumi.Input[int]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nchar_character_set_name: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 option_group_name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 replica_mode: Optional[pulumi.Input[str]] = None,
                 replicate_source_db: Optional[pulumi.Input[str]] = None,
                 restore_to_point_in_time: Optional[pulumi.Input[Union['InstanceRestoreToPointInTimeArgs', 'InstanceRestoreToPointInTimeArgsDict']]] = None,
                 s3_import: Optional[pulumi.Input[Union['InstanceS3ImportArgs', 'InstanceS3ImportArgsDict']]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 storage_throughput: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 upgrade_storage_config: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["allocated_storage"] = allocated_storage
            __props__.__dict__["allow_major_version_upgrade"] = allow_major_version_upgrade
            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["backup_target"] = backup_target
            __props__.__dict__["backup_window"] = backup_window
            __props__.__dict__["blue_green_update"] = blue_green_update
            __props__.__dict__["ca_cert_identifier"] = ca_cert_identifier
            __props__.__dict__["character_set_name"] = character_set_name
            __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
            __props__.__dict__["custom_iam_instance_profile"] = custom_iam_instance_profile
            __props__.__dict__["customer_owned_ip_enabled"] = customer_owned_ip_enabled
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
            __props__.__dict__["dedicated_log_volume"] = dedicated_log_volume
            __props__.__dict__["delete_automated_backups"] = delete_automated_backups
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["domain"] = domain
            __props__.__dict__["domain_auth_secret_arn"] = domain_auth_secret_arn
            __props__.__dict__["domain_dns_ips"] = domain_dns_ips
            __props__.__dict__["domain_fqdn"] = domain_fqdn
            __props__.__dict__["domain_iam_role_name"] = domain_iam_role_name
            __props__.__dict__["domain_ou"] = domain_ou
            __props__.__dict__["enabled_cloudwatch_logs_exports"] = enabled_cloudwatch_logs_exports
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_lifecycle_support"] = engine_lifecycle_support
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
            __props__.__dict__["iam_database_authentication_enabled"] = iam_database_authentication_enabled
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["identifier_prefix"] = identifier_prefix
            if instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'instance_class'")
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["iops"] = iops
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["manage_master_user_password"] = manage_master_user_password
            __props__.__dict__["master_user_secret_kms_key_id"] = master_user_secret_kms_key_id
            __props__.__dict__["max_allocated_storage"] = max_allocated_storage
            __props__.__dict__["monitoring_interval"] = monitoring_interval
            __props__.__dict__["monitoring_role_arn"] = monitoring_role_arn
            __props__.__dict__["multi_az"] = multi_az
            __props__.__dict__["name"] = name
            __props__.__dict__["nchar_character_set_name"] = nchar_character_set_name
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["option_group_name"] = option_group_name
            __props__.__dict__["parameter_group_name"] = parameter_group_name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["performance_insights_enabled"] = performance_insights_enabled
            __props__.__dict__["performance_insights_kms_key_id"] = performance_insights_kms_key_id
            __props__.__dict__["performance_insights_retention_period"] = performance_insights_retention_period
            __props__.__dict__["port"] = port
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["replica_mode"] = replica_mode
            __props__.__dict__["replicate_source_db"] = replicate_source_db
            __props__.__dict__["restore_to_point_in_time"] = restore_to_point_in_time
            __props__.__dict__["s3_import"] = s3_import
            __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
            __props__.__dict__["snapshot_identifier"] = snapshot_identifier
            __props__.__dict__["storage_encrypted"] = storage_encrypted
            __props__.__dict__["storage_throughput"] = storage_throughput
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["upgrade_storage_config"] = upgrade_storage_config
            __props__.__dict__["username"] = username
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["address"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["engine_version_actual"] = None
            __props__.__dict__["hosted_zone_id"] = None
            __props__.__dict__["latest_restorable_time"] = None
            __props__.__dict__["listener_endpoints"] = None
            __props__.__dict__["master_user_secrets"] = None
            __props__.__dict__["replicas"] = None
            __props__.__dict__["resource_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'aws:rds/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            allocated_storage: Optional[pulumi.Input[int]] = None,
            allow_major_version_upgrade: Optional[pulumi.Input[bool]] = None,
            apply_immediately: Optional[pulumi.Input[bool]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            backup_retention_period: Optional[pulumi.Input[int]] = None,
            backup_target: Optional[pulumi.Input[str]] = None,
            backup_window: Optional[pulumi.Input[str]] = None,
            blue_green_update: Optional[pulumi.Input[Union['InstanceBlueGreenUpdateArgs', 'InstanceBlueGreenUpdateArgsDict']]] = None,
            ca_cert_identifier: Optional[pulumi.Input[str]] = None,
            character_set_name: Optional[pulumi.Input[str]] = None,
            copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
            custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
            customer_owned_ip_enabled: Optional[pulumi.Input[bool]] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            db_subnet_group_name: Optional[pulumi.Input[str]] = None,
            dedicated_log_volume: Optional[pulumi.Input[bool]] = None,
            delete_automated_backups: Optional[pulumi.Input[bool]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            domain_auth_secret_arn: Optional[pulumi.Input[str]] = None,
            domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            domain_fqdn: Optional[pulumi.Input[str]] = None,
            domain_iam_role_name: Optional[pulumi.Input[str]] = None,
            domain_ou: Optional[pulumi.Input[str]] = None,
            enabled_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_lifecycle_support: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            engine_version_actual: Optional[pulumi.Input[str]] = None,
            final_snapshot_identifier: Optional[pulumi.Input[str]] = None,
            hosted_zone_id: Optional[pulumi.Input[str]] = None,
            iam_database_authentication_enabled: Optional[pulumi.Input[bool]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            identifier_prefix: Optional[pulumi.Input[str]] = None,
            instance_class: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
            iops: Optional[pulumi.Input[int]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            latest_restorable_time: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            listener_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceListenerEndpointArgs', 'InstanceListenerEndpointArgsDict']]]]] = None,
            maintenance_window: Optional[pulumi.Input[str]] = None,
            manage_master_user_password: Optional[pulumi.Input[bool]] = None,
            master_user_secret_kms_key_id: Optional[pulumi.Input[str]] = None,
            master_user_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMasterUserSecretArgs', 'InstanceMasterUserSecretArgsDict']]]]] = None,
            max_allocated_storage: Optional[pulumi.Input[int]] = None,
            monitoring_interval: Optional[pulumi.Input[int]] = None,
            monitoring_role_arn: Optional[pulumi.Input[str]] = None,
            multi_az: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nchar_character_set_name: Optional[pulumi.Input[str]] = None,
            network_type: Optional[pulumi.Input[str]] = None,
            option_group_name: Optional[pulumi.Input[str]] = None,
            parameter_group_name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
            performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
            performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
            port: Optional[pulumi.Input[int]] = None,
            publicly_accessible: Optional[pulumi.Input[bool]] = None,
            replica_mode: Optional[pulumi.Input[str]] = None,
            replicas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            replicate_source_db: Optional[pulumi.Input[str]] = None,
            resource_id: Optional[pulumi.Input[str]] = None,
            restore_to_point_in_time: Optional[pulumi.Input[Union['InstanceRestoreToPointInTimeArgs', 'InstanceRestoreToPointInTimeArgsDict']]] = None,
            s3_import: Optional[pulumi.Input[Union['InstanceS3ImportArgs', 'InstanceS3ImportArgsDict']]] = None,
            skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
            snapshot_identifier: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_encrypted: Optional[pulumi.Input[bool]] = None,
            storage_throughput: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            upgrade_storage_config: Optional[pulumi.Input[bool]] = None,
            username: Optional[pulumi.Input[str]] = None,
            vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: Specifies the DNS address of the DB instance.
        :param pulumi.Input[int] allocated_storage: The allocated storage in gibibytes. If `max_allocated_storage` is configured, this argument represents the initial storage allocation and differences from the configuration will be ignored automatically when Storage Autoscaling occurs. If `replicate_source_db` is set, the value is ignored during the creation of the instance.
        :param pulumi.Input[bool] allow_major_version_upgrade: Indicates that major version
               upgrades are allowed. Changing this parameter does not result in an outage and
               the change is asynchronously applied as soon as possible.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any database modifications
               are applied immediately, or during the next maintenance window. Default is
               `false`. See [Amazon RDS Documentation for more
               information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
        :param pulumi.Input[str] arn: The ARN of the RDS instance.
        :param pulumi.Input[bool] auto_minor_version_upgrade: Indicates that minor engine upgrades
               will be applied automatically to the DB instance during the maintenance window.
               Defaults to true.
        :param pulumi.Input[str] availability_zone: The AZ for the RDS instance.
        :param pulumi.Input[int] backup_retention_period: The days to retain backups for.
               Must be between `0` and `35`.
               Default is `0`.
               Must be greater than `0` if the database is used as a source for a [Read Replica][instance-replication],
               uses low-downtime updates,
               or will use [RDS Blue/Green deployments][blue-green].
        :param pulumi.Input[str] backup_target: Specifies where automated backups and manual snapshots are stored. Possible values are `region` (default) and `outposts`. See [Working with Amazon RDS on AWS Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) for more information.
        :param pulumi.Input[str] backup_window: The daily time range (in UTC) during which automated backups are created if they are enabled.
               Example: "09:46-10:16". Must not overlap with `maintenance_window`.
        :param pulumi.Input[Union['InstanceBlueGreenUpdateArgs', 'InstanceBlueGreenUpdateArgsDict']] blue_green_update: Enables low-downtime updates using [RDS Blue/Green deployments][blue-green].
               See `blue_green_update` below.
        :param pulumi.Input[str] ca_cert_identifier: The identifier of the CA certificate for the DB instance.
        :param pulumi.Input[str] character_set_name: The character set name to use for DB encoding in Oracle and Microsoft SQL instances (collation).
               This can't be changed.
               See [Oracle Character Sets Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html) or
               [Server-Level Collation for Microsoft SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.CommonDBATasks.Collation.html) for more information.
               Cannot be set  with `replicate_source_db`, `restore_to_point_in_time`, `s3_import`, or `snapshot_identifier`.
        :param pulumi.Input[bool] copy_tags_to_snapshot: Copy all Instance `tags` to snapshots. Default is `false`.
        :param pulumi.Input[str] custom_iam_instance_profile: The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        :param pulumi.Input[bool] customer_owned_ip_enabled: Indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance. See [CoIP for RDS on Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html#rds-on-outposts.coip) for more information.
               
               > **NOTE:** Removing the `replicate_source_db` attribute from an existing RDS
               Replicate database managed by the provider will promote the database to a fully
               standalone database.
        :param pulumi.Input[str] db_name: The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. Note that this does not apply for Oracle or SQL Server engines. See the [AWS documentation](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/create-db-instance.html) for more details on what applies for those engines. If you are providing an Oracle db name, it needs to be in all upper case. Cannot be specified for a replica.
        :param pulumi.Input[str] db_subnet_group_name: Name of DB subnet group.
               DB instance will be created in the VPC associated with the DB subnet group.
               If unspecified, will be created in the `default` Subnet Group.
               When working with read replicas created in the same region, defaults to the Subnet Group Name of the source DB.
               When working with read replicas created in a different region, defaults to the `default` Subnet Group.
               See [DBSubnetGroupName in API action CreateDBInstanceReadReplica](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html) for additional read replica constraints.
        :param pulumi.Input[bool] dedicated_log_volume: Use a dedicated log volume (DLV) for the DB instance. Requires Provisioned IOPS. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.dlv) for more details.
        :param pulumi.Input[bool] delete_automated_backups: Specifies whether to remove automated backups immediately after the DB instance is deleted. Default is `true`.
        :param pulumi.Input[bool] deletion_protection: If the DB instance should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        :param pulumi.Input[str] domain: The ID of the Directory Service Active Directory domain to create the instance in. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        :param pulumi.Input[str] domain_auth_secret_arn: The ARN for the Secrets Manager secret with the self managed Active Directory credentials for the user joining the domain. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_dns_ips: The IPv4 DNS IP addresses of your primary and secondary self managed Active Directory domain controllers. Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[str] domain_fqdn: The fully qualified domain name (FQDN) of the self managed Active Directory domain. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[str] domain_iam_role_name: The name of the IAM role to be used when making API calls to the Directory Service. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        :param pulumi.Input[str] domain_ou: The self managed Active Directory organizational unit for your DB instance to join. Conflicts with `domain` and `domain_iam_role_name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_cloudwatch_logs_exports: Set of log types to enable for exporting to CloudWatch logs. If omitted, no logs will be exported. For supported values, see the EnableCloudwatchLogsExports.member.N parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html).
        :param pulumi.Input[str] endpoint: The connection endpoint in `address:port` format.
        :param pulumi.Input[str] engine: The database engine to use. For supported values, see the Engine parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine must match the DB cluster's engine'. For information on the difference between the available Aurora MySQL engines see [Comparison between Aurora MySQL 1 and Aurora MySQL 2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Updates.20180206.html) in the Amazon RDS User Guide.
        :param pulumi.Input[str] engine_lifecycle_support: The life cycle type for this DB instance. This setting applies only to RDS for MySQL and RDS for PostgreSQL. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        :param pulumi.Input[str] engine_version: The engine version to use. If `auto_minor_version_upgrade` is enabled, you can provide a prefix of the version such as `8.0` (for `8.0.36`). The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. For supported values, see the EngineVersion parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine version must match the DB cluster's engine version'.
        :param pulumi.Input[str] engine_version_actual: The running version of the database.
        :param pulumi.Input[str] final_snapshot_identifier: The name of your final DB snapshot
               when this DB instance is deleted. Must be provided if `skip_final_snapshot` is
               set to `false`. The value must begin with a letter, only contain alphanumeric characters and hyphens, and not end with a hyphen or contain two consecutive hyphens. Must not be provided when deleting a read replica.
        :param pulumi.Input[str] hosted_zone_id: Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        :param pulumi.Input[bool] iam_database_authentication_enabled: Specifies whether mappings of AWS Identity and Access Management (IAM) accounts to database
               accounts is enabled.
        :param pulumi.Input[str] identifier: The name of the RDS instance, if omitted, this provider will assign a random, unique identifier. Required if `restore_to_point_in_time` is specified.
        :param pulumi.Input[str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_class: The instance type of the RDS instance.
        :param pulumi.Input[int] iops: The amount of provisioned IOPS. Setting this implies a
               storage_type of "io1" or "io2". Can only be set when `storage_type` is `"io1"`, `"io2` or `"gp3"`.
               Cannot be specified for gp3 storage if the `allocated_storage` value is below a per-`engine` threshold.
               See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. If creating an
               encrypted replica, set this to the destination KMS ARN.
        :param pulumi.Input[str] latest_restorable_time: The latest time, in UTC [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), to which a database can be restored with point-in-time restore.
        :param pulumi.Input[str] license_model: License model information for this DB instance. Valid values for this field are as follows:
               * RDS for MariaDB: `general-public-license`
               * RDS for Microsoft SQL Server: `license-included`
               * RDS for MySQL: `general-public-license`
               * RDS for Oracle: `bring-your-own-license | license-included`
               * RDS for PostgreSQL: `postgresql-license`
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceListenerEndpointArgs', 'InstanceListenerEndpointArgsDict']]]] listener_endpoints: Specifies the listener connection endpoint for SQL Server Always On. See endpoint below.
        :param pulumi.Input[str] maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00". See [RDS
               Maintenance Window
               docs](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
               for more information.
        :param pulumi.Input[bool] manage_master_user_password: Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `password` is provided.
        :param pulumi.Input[str] master_user_secret_kms_key_id: The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceMasterUserSecretArgs', 'InstanceMasterUserSecretArgsDict']]]] master_user_secrets: A block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
        :param pulumi.Input[int] max_allocated_storage: When configured, the upper limit to which Amazon RDS can automatically scale the storage of the DB instance. Configuring this will automatically ignore differences to `allocated_storage`. Must be greater than or equal to `allocated_storage` or `0` to disable Storage Autoscaling.
        :param pulumi.Input[int] monitoring_interval: The interval, in seconds, between points
               when Enhanced Monitoring metrics are collected for the DB instance. To disable
               collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid
               Values: 0, 1, 5, 10, 15, 30, 60.
        :param pulumi.Input[str] monitoring_role_arn: The ARN for the IAM role that permits RDS
               to send enhanced monitoring metrics to CloudWatch Logs. You can find more
               information on the [AWS
               Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html)
               what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ
        :param pulumi.Input[str] nchar_character_set_name: The national character set is used in the NCHAR, NVARCHAR2, and NCLOB data types for Oracle instances. This can't be changed. See [Oracle Character Sets
               Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html).
        :param pulumi.Input[str] network_type: The network type of the DB instance. Valid values: `IPV4`, `DUAL`.
        :param pulumi.Input[str] option_group_name: Name of the DB option group to associate.
        :param pulumi.Input[str] parameter_group_name: Name of the DB parameter group to associate.
        :param pulumi.Input[str] password: (Required unless `manage_master_user_password` is set to true or unless a `snapshot_identifier` or `replicate_source_db`
               is provided or `manage_master_user_password` is set.) Password for the master DB user. Note that this may show up in
               logs, and it will be stored in the state file. Cannot be set if `manage_master_user_password` is set to `true`.
        :param pulumi.Input[bool] performance_insights_enabled: Specifies whether Performance Insights are enabled. Defaults to false.
        :param pulumi.Input[str] performance_insights_kms_key_id: The ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true. Once KMS key is set, it can never be changed.
        :param pulumi.Input[int] performance_insights_retention_period: Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        :param pulumi.Input[int] port: The port on which the DB accepts connections.
        :param pulumi.Input[bool] publicly_accessible: Bool to control if instance is publicly
               accessible. Default is `false`.
        :param pulumi.Input[str] replica_mode: Specifies whether the replica is in either `mounted` or `open-read-only` mode. This attribute
               is only supported by Oracle instances. Oracle replicas operate in `open-read-only` mode unless otherwise specified. See [Working with Oracle Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) for more information.
        :param pulumi.Input[str] replicate_source_db: Specifies that this resource is a Replica database, and to use this value as the source database.
               If replicating an Amazon RDS Database Instance in the same region, use the `identifier` of the source DB, unless also specifying the `db_subnet_group_name`.
               If specifying the `db_subnet_group_name` in the same region, use the `arn` of the source DB.
               If replicating an Instance in a different region, use the `arn` of the source DB.
               Note that if you are creating a cross-region replica of an encrypted database you will also need to specify a `kms_key_id`.
               See [DB Instance Replication][instance-replication] and [Working with PostgreSQL and MySQL Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html) for more information on using Replication.
        :param pulumi.Input[str] resource_id: The RDS Resource ID of this instance.
        :param pulumi.Input[Union['InstanceRestoreToPointInTimeArgs', 'InstanceRestoreToPointInTimeArgsDict']] restore_to_point_in_time: A configuration block for restoring a DB instance to an arbitrary point in time.
               Requires the `identifier` argument to be set with the name of the new DB instance to be created.
               See Restore To Point In Time below for details.
        :param pulumi.Input[Union['InstanceS3ImportArgs', 'InstanceS3ImportArgsDict']] s3_import: Restore from a Percona Xtrabackup in S3.  See [Importing Data into an Amazon RDS MySQL DB Instance](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final DB snapshot is
               created before the DB instance is deleted. If true is specified, no DBSnapshot
               is created. If false is specified, a DB snapshot is created before the DB
               instance is deleted, using the value from `final_snapshot_identifier`. Default
               is `false`.
        :param pulumi.Input[str] snapshot_identifier: Specifies whether or not to create this database from a snapshot.
               This corresponds to the snapshot ID you'd find in the RDS console, e.g: rds:production-2015-06-26-06-05.
        :param pulumi.Input[str] status: The RDS instance status.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB instance is
               encrypted. Note that if you are creating a cross-region read replica this field
               is ignored and you should instead declare `kms_key_id` with a valid ARN. The
               default is `false` if not specified.
        :param pulumi.Input[int] storage_throughput: The storage throughput value for the DB instance. Can only be set when `storage_type` is `"gp3"`. Cannot be specified if the `allocated_storage` value is below a per-`engine` threshold. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        :param pulumi.Input[Union[str, 'StorageType']] storage_type: One of "standard" (magnetic), "gp2" (general
               purpose SSD), "gp3" (general purpose SSD that needs `iops` independently)
               "io1" (provisioned IOPS SSD) or "io2" (block express storage provisioned IOPS
               SSD). The default is "io1" if `iops` is specified, "gp2" if not.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] timezone: Time zone of the DB instance. `timezone` is currently
               only supported by Microsoft SQL Server. The `timezone` can only be set on
               creation. See [MSSQL User
               Guide](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone)
               for more information.
        :param pulumi.Input[bool] upgrade_storage_config: Whether to upgrade the storage file system configuration on the read replica.
               Can only be set with `replicate_source_db`.
        :param pulumi.Input[str] username: (Required unless a `snapshot_identifier` or `replicate_source_db`
               is provided) Username for the master DB user. Cannot be specified for a replica.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: List of VPC security groups to
               associate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["address"] = address
        __props__.__dict__["allocated_storage"] = allocated_storage
        __props__.__dict__["allow_major_version_upgrade"] = allow_major_version_upgrade
        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_retention_period"] = backup_retention_period
        __props__.__dict__["backup_target"] = backup_target
        __props__.__dict__["backup_window"] = backup_window
        __props__.__dict__["blue_green_update"] = blue_green_update
        __props__.__dict__["ca_cert_identifier"] = ca_cert_identifier
        __props__.__dict__["character_set_name"] = character_set_name
        __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
        __props__.__dict__["custom_iam_instance_profile"] = custom_iam_instance_profile
        __props__.__dict__["customer_owned_ip_enabled"] = customer_owned_ip_enabled
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
        __props__.__dict__["dedicated_log_volume"] = dedicated_log_volume
        __props__.__dict__["delete_automated_backups"] = delete_automated_backups
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["domain"] = domain
        __props__.__dict__["domain_auth_secret_arn"] = domain_auth_secret_arn
        __props__.__dict__["domain_dns_ips"] = domain_dns_ips
        __props__.__dict__["domain_fqdn"] = domain_fqdn
        __props__.__dict__["domain_iam_role_name"] = domain_iam_role_name
        __props__.__dict__["domain_ou"] = domain_ou
        __props__.__dict__["enabled_cloudwatch_logs_exports"] = enabled_cloudwatch_logs_exports
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_lifecycle_support"] = engine_lifecycle_support
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["engine_version_actual"] = engine_version_actual
        __props__.__dict__["final_snapshot_identifier"] = final_snapshot_identifier
        __props__.__dict__["hosted_zone_id"] = hosted_zone_id
        __props__.__dict__["iam_database_authentication_enabled"] = iam_database_authentication_enabled
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["identifier_prefix"] = identifier_prefix
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["iops"] = iops
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["latest_restorable_time"] = latest_restorable_time
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["listener_endpoints"] = listener_endpoints
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["manage_master_user_password"] = manage_master_user_password
        __props__.__dict__["master_user_secret_kms_key_id"] = master_user_secret_kms_key_id
        __props__.__dict__["master_user_secrets"] = master_user_secrets
        __props__.__dict__["max_allocated_storage"] = max_allocated_storage
        __props__.__dict__["monitoring_interval"] = monitoring_interval
        __props__.__dict__["monitoring_role_arn"] = monitoring_role_arn
        __props__.__dict__["multi_az"] = multi_az
        __props__.__dict__["name"] = name
        __props__.__dict__["nchar_character_set_name"] = nchar_character_set_name
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["option_group_name"] = option_group_name
        __props__.__dict__["parameter_group_name"] = parameter_group_name
        __props__.__dict__["password"] = password
        __props__.__dict__["performance_insights_enabled"] = performance_insights_enabled
        __props__.__dict__["performance_insights_kms_key_id"] = performance_insights_kms_key_id
        __props__.__dict__["performance_insights_retention_period"] = performance_insights_retention_period
        __props__.__dict__["port"] = port
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["replica_mode"] = replica_mode
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["replicate_source_db"] = replicate_source_db
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["restore_to_point_in_time"] = restore_to_point_in_time
        __props__.__dict__["s3_import"] = s3_import
        __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
        __props__.__dict__["snapshot_identifier"] = snapshot_identifier
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_encrypted"] = storage_encrypted
        __props__.__dict__["storage_throughput"] = storage_throughput
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["upgrade_storage_config"] = upgrade_storage_config
        __props__.__dict__["username"] = username
        __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        Specifies the DNS address of the DB instance.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Output[int]:
        """
        The allocated storage in gibibytes. If `max_allocated_storage` is configured, this argument represents the initial storage allocation and differences from the configuration will be ignored automatically when Storage Autoscaling occurs. If `replicate_source_db` is set, the value is ignored during the creation of the instance.
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter(name="allowMajorVersionUpgrade")
    def allow_major_version_upgrade(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates that major version
        upgrades are allowed. Changing this parameter does not result in an outage and
        the change is asynchronously applied as soon as possible.
        """
        return pulumi.get(self, "allow_major_version_upgrade")

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether any database modifications
        are applied immediately, or during the next maintenance window. Default is
        `false`. See [Amazon RDS Documentation for more
        information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
        """
        return pulumi.get(self, "apply_immediately")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the RDS instance.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates that minor engine upgrades
        will be applied automatically to the DB instance during the maintenance window.
        Defaults to true.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        The AZ for the RDS instance.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[int]:
        """
        The days to retain backups for.
        Must be between `0` and `35`.
        Default is `0`.
        Must be greater than `0` if the database is used as a source for a [Read Replica][instance-replication],
        uses low-downtime updates,
        or will use [RDS Blue/Green deployments][blue-green].
        """
        return pulumi.get(self, "backup_retention_period")

    @property
    @pulumi.getter(name="backupTarget")
    def backup_target(self) -> pulumi.Output[str]:
        """
        Specifies where automated backups and manual snapshots are stored. Possible values are `region` (default) and `outposts`. See [Working with Amazon RDS on AWS Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) for more information.
        """
        return pulumi.get(self, "backup_target")

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> pulumi.Output[str]:
        """
        The daily time range (in UTC) during which automated backups are created if they are enabled.
        Example: "09:46-10:16". Must not overlap with `maintenance_window`.
        """
        return pulumi.get(self, "backup_window")

    @property
    @pulumi.getter(name="blueGreenUpdate")
    def blue_green_update(self) -> pulumi.Output[Optional['outputs.InstanceBlueGreenUpdate']]:
        """
        Enables low-downtime updates using [RDS Blue/Green deployments][blue-green].
        See `blue_green_update` below.
        """
        return pulumi.get(self, "blue_green_update")

    @property
    @pulumi.getter(name="caCertIdentifier")
    def ca_cert_identifier(self) -> pulumi.Output[str]:
        """
        The identifier of the CA certificate for the DB instance.
        """
        return pulumi.get(self, "ca_cert_identifier")

    @property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> pulumi.Output[str]:
        """
        The character set name to use for DB encoding in Oracle and Microsoft SQL instances (collation).
        This can't be changed.
        See [Oracle Character Sets Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html) or
        [Server-Level Collation for Microsoft SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.CommonDBATasks.Collation.html) for more information.
        Cannot be set  with `replicate_source_db`, `restore_to_point_in_time`, `s3_import`, or `snapshot_identifier`.
        """
        return pulumi.get(self, "character_set_name")

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> pulumi.Output[Optional[bool]]:
        """
        Copy all Instance `tags` to snapshots. Default is `false`.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @property
    @pulumi.getter(name="customIamInstanceProfile")
    def custom_iam_instance_profile(self) -> pulumi.Output[Optional[str]]:
        """
        The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        """
        return pulumi.get(self, "custom_iam_instance_profile")

    @property
    @pulumi.getter(name="customerOwnedIpEnabled")
    def customer_owned_ip_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance. See [CoIP for RDS on Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html#rds-on-outposts.coip) for more information.

        > **NOTE:** Removing the `replicate_source_db` attribute from an existing RDS
        Replicate database managed by the provider will promote the database to a fully
        standalone database.
        """
        return pulumi.get(self, "customer_owned_ip_enabled")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. Note that this does not apply for Oracle or SQL Server engines. See the [AWS documentation](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/create-db-instance.html) for more details on what applies for those engines. If you are providing an Oracle db name, it needs to be in all upper case. Cannot be specified for a replica.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> pulumi.Output[str]:
        """
        Name of DB subnet group.
        DB instance will be created in the VPC associated with the DB subnet group.
        If unspecified, will be created in the `default` Subnet Group.
        When working with read replicas created in the same region, defaults to the Subnet Group Name of the source DB.
        When working with read replicas created in a different region, defaults to the `default` Subnet Group.
        See [DBSubnetGroupName in API action CreateDBInstanceReadReplica](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstanceReadReplica.html) for additional read replica constraints.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @property
    @pulumi.getter(name="dedicatedLogVolume")
    def dedicated_log_volume(self) -> pulumi.Output[Optional[bool]]:
        """
        Use a dedicated log volume (DLV) for the DB instance. Requires Provisioned IOPS. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.dlv) for more details.
        """
        return pulumi.get(self, "dedicated_log_volume")

    @property
    @pulumi.getter(name="deleteAutomatedBackups")
    def delete_automated_backups(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to remove automated backups immediately after the DB instance is deleted. Default is `true`.
        """
        return pulumi.get(self, "delete_automated_backups")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        If the DB instance should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Directory Service Active Directory domain to create the instance in. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainAuthSecretArn")
    def domain_auth_secret_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN for the Secrets Manager secret with the self managed Active Directory credentials for the user joining the domain. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_auth_secret_arn")

    @property
    @pulumi.getter(name="domainDnsIps")
    def domain_dns_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The IPv4 DNS IP addresses of your primary and secondary self managed Active Directory domain controllers. Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_dns_ips")

    @property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name (FQDN) of the self managed Active Directory domain. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_fqdn")

    @property
    @pulumi.getter(name="domainIamRoleName")
    def domain_iam_role_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the IAM role to be used when making API calls to the Directory Service. Conflicts with `domain_fqdn`, `domain_ou`, `domain_auth_secret_arn` and a `domain_dns_ips`.
        """
        return pulumi.get(self, "domain_iam_role_name")

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> pulumi.Output[Optional[str]]:
        """
        The self managed Active Directory organizational unit for your DB instance to join. Conflicts with `domain` and `domain_iam_role_name`.
        """
        return pulumi.get(self, "domain_ou")

    @property
    @pulumi.getter(name="enabledCloudwatchLogsExports")
    def enabled_cloudwatch_logs_exports(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set of log types to enable for exporting to CloudWatch logs. If omitted, no logs will be exported. For supported values, see the EnableCloudwatchLogsExports.member.N parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html).
        """
        return pulumi.get(self, "enabled_cloudwatch_logs_exports")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The connection endpoint in `address:port` format.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        The database engine to use. For supported values, see the Engine parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine must match the DB cluster's engine'. For information on the difference between the available Aurora MySQL engines see [Comparison between Aurora MySQL 1 and Aurora MySQL 2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Updates.20180206.html) in the Amazon RDS User Guide.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> pulumi.Output[str]:
        """
        The life cycle type for this DB instance. This setting applies only to RDS for MySQL and RDS for PostgreSQL. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        The engine version to use. If `auto_minor_version_upgrade` is enabled, you can provide a prefix of the version such as `8.0` (for `8.0.36`). The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below. For supported values, see the EngineVersion parameter in [API action CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html). Note that for Amazon Aurora instances the engine version must match the DB cluster's engine version'.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> pulumi.Output[str]:
        """
        The running version of the database.
        """
        return pulumi.get(self, "engine_version_actual")

    @property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The name of your final DB snapshot
        when this DB instance is deleted. Must be provided if `skip_final_snapshot` is
        set to `false`. The value must begin with a letter, only contain alphanumeric characters and hyphens, and not end with a hyphen or contain two consecutive hyphens. Must not be provided when deleting a read replica.
        """
        return pulumi.get(self, "final_snapshot_identifier")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter(name="iamDatabaseAuthenticationEnabled")
    def iam_database_authentication_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether mappings of AWS Identity and Access Management (IAM) accounts to database
        accounts is enabled.
        """
        return pulumi.get(self, "iam_database_authentication_enabled")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        The name of the RDS instance, if omitted, this provider will assign a random, unique identifier. Required if `restore_to_point_in_time` is specified.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> pulumi.Output[str]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[str]:
        """
        The instance type of the RDS instance.
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter
    def iops(self) -> pulumi.Output[int]:
        """
        The amount of provisioned IOPS. Setting this implies a
        storage_type of "io1" or "io2". Can only be set when `storage_type` is `"io1"`, `"io2` or `"gp3"`.
        Cannot be specified for gp3 storage if the `allocated_storage` value is below a per-`engine` threshold.
        See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The ARN for the KMS encryption key. If creating an
        encrypted replica, set this to the destination KMS ARN.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="latestRestorableTime")
    def latest_restorable_time(self) -> pulumi.Output[str]:
        """
        The latest time, in UTC [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8), to which a database can be restored with point-in-time restore.
        """
        return pulumi.get(self, "latest_restorable_time")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        License model information for this DB instance. Valid values for this field are as follows:
        * RDS for MariaDB: `general-public-license`
        * RDS for Microsoft SQL Server: `license-included`
        * RDS for MySQL: `general-public-license`
        * RDS for Oracle: `bring-your-own-license | license-included`
        * RDS for PostgreSQL: `postgresql-license`
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="listenerEndpoints")
    def listener_endpoints(self) -> pulumi.Output[Sequence['outputs.InstanceListenerEndpoint']]:
        """
        Specifies the listener connection endpoint for SQL Server Always On. See endpoint below.
        """
        return pulumi.get(self, "listener_endpoints")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[str]:
        """
        The window to perform maintenance in.
        Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00". See [RDS
        Maintenance Window
        docs](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
        for more information.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `password` is provided.
        """
        return pulumi.get(self, "manage_master_user_password")

    @property
    @pulumi.getter(name="masterUserSecretKmsKeyId")
    def master_user_secret_kms_key_id(self) -> pulumi.Output[str]:
        """
        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
        """
        return pulumi.get(self, "master_user_secret_kms_key_id")

    @property
    @pulumi.getter(name="masterUserSecrets")
    def master_user_secrets(self) -> pulumi.Output[Sequence['outputs.InstanceMasterUserSecret']]:
        """
        A block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
        """
        return pulumi.get(self, "master_user_secrets")

    @property
    @pulumi.getter(name="maxAllocatedStorage")
    def max_allocated_storage(self) -> pulumi.Output[Optional[int]]:
        """
        When configured, the upper limit to which Amazon RDS can automatically scale the storage of the DB instance. Configuring this will automatically ignore differences to `allocated_storage`. Must be greater than or equal to `allocated_storage` or `0` to disable Storage Autoscaling.
        """
        return pulumi.get(self, "max_allocated_storage")

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The interval, in seconds, between points
        when Enhanced Monitoring metrics are collected for the DB instance. To disable
        collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid
        Values: 0, 1, 5, 10, 15, 30, 60.
        """
        return pulumi.get(self, "monitoring_interval")

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> pulumi.Output[str]:
        """
        The ARN for the IAM role that permits RDS
        to send enhanced monitoring metrics to CloudWatch Logs. You can find more
        information on the [AWS
        Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html)
        what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> pulumi.Output[bool]:
        """
        Specifies if the RDS instance is multi-AZ
        """
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This property has been deprecated. Please use 'dbName' instead.""")
    def name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ncharCharacterSetName")
    def nchar_character_set_name(self) -> pulumi.Output[str]:
        """
        The national character set is used in the NCHAR, NVARCHAR2, and NCLOB data types for Oracle instances. This can't be changed. See [Oracle Character Sets
        Supported in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.OracleCharacterSets.html).
        """
        return pulumi.get(self, "nchar_character_set_name")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[str]:
        """
        The network type of the DB instance. Valid values: `IPV4`, `DUAL`.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="optionGroupName")
    def option_group_name(self) -> pulumi.Output[str]:
        """
        Name of the DB option group to associate.
        """
        return pulumi.get(self, "option_group_name")

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> pulumi.Output[str]:
        """
        Name of the DB parameter group to associate.
        """
        return pulumi.get(self, "parameter_group_name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        (Required unless `manage_master_user_password` is set to true or unless a `snapshot_identifier` or `replicate_source_db`
        is provided or `manage_master_user_password` is set.) Password for the master DB user. Note that this may show up in
        logs, and it will be stored in the state file. Cannot be set if `manage_master_user_password` is set to `true`.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether Performance Insights are enabled. Defaults to false.
        """
        return pulumi.get(self, "performance_insights_enabled")

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> pulumi.Output[str]:
        """
        The ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true. Once KMS key is set, it can never be changed.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> pulumi.Output[int]:
        """
        Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port on which the DB accepts connections.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[bool]]:
        """
        Bool to control if instance is publicly
        accessible. Default is `false`.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="replicaMode")
    def replica_mode(self) -> pulumi.Output[str]:
        """
        Specifies whether the replica is in either `mounted` or `open-read-only` mode. This attribute
        is only supported by Oracle instances. Oracle replicas operate in `open-read-only` mode unless otherwise specified. See [Working with Oracle Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) for more information.
        """
        return pulumi.get(self, "replica_mode")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="replicateSourceDb")
    def replicate_source_db(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies that this resource is a Replica database, and to use this value as the source database.
        If replicating an Amazon RDS Database Instance in the same region, use the `identifier` of the source DB, unless also specifying the `db_subnet_group_name`.
        If specifying the `db_subnet_group_name` in the same region, use the `arn` of the source DB.
        If replicating an Instance in a different region, use the `arn` of the source DB.
        Note that if you are creating a cross-region replica of an encrypted database you will also need to specify a `kms_key_id`.
        See [DB Instance Replication][instance-replication] and [Working with PostgreSQL and MySQL Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html) for more information on using Replication.
        """
        return pulumi.get(self, "replicate_source_db")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The RDS Resource ID of this instance.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="restoreToPointInTime")
    def restore_to_point_in_time(self) -> pulumi.Output[Optional['outputs.InstanceRestoreToPointInTime']]:
        """
        A configuration block for restoring a DB instance to an arbitrary point in time.
        Requires the `identifier` argument to be set with the name of the new DB instance to be created.
        See Restore To Point In Time below for details.
        """
        return pulumi.get(self, "restore_to_point_in_time")

    @property
    @pulumi.getter(name="s3Import")
    def s3_import(self) -> pulumi.Output[Optional['outputs.InstanceS3Import']]:
        """
        Restore from a Percona Xtrabackup in S3.  See [Importing Data into an Amazon RDS MySQL DB Instance](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
        """
        return pulumi.get(self, "s3_import")

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether a final DB snapshot is
        created before the DB instance is deleted. If true is specified, no DBSnapshot
        is created. If false is specified, a DB snapshot is created before the DB
        instance is deleted, using the value from `final_snapshot_identifier`. Default
        is `false`.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> pulumi.Output[str]:
        """
        Specifies whether or not to create this database from a snapshot.
        This corresponds to the snapshot ID you'd find in the RDS console, e.g: rds:production-2015-06-26-06-05.
        """
        return pulumi.get(self, "snapshot_identifier")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The RDS instance status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the DB instance is
        encrypted. Note that if you are creating a cross-region read replica this field
        is ignored and you should instead declare `kms_key_id` with a valid ARN. The
        default is `false` if not specified.
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter(name="storageThroughput")
    def storage_throughput(self) -> pulumi.Output[int]:
        """
        The storage throughput value for the DB instance. Can only be set when `storage_type` is `"gp3"`. Cannot be specified if the `allocated_storage` value is below a per-`engine` threshold. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#gp3-storage) for details.
        """
        return pulumi.get(self, "storage_throughput")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        One of "standard" (magnetic), "gp2" (general
        purpose SSD), "gp3" (general purpose SSD that needs `iops` independently)
        "io1" (provisioned IOPS SSD) or "io2" (block express storage provisioned IOPS
        SSD). The default is "io1" if `iops` is specified, "gp2" if not.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[str]:
        """
        Time zone of the DB instance. `timezone` is currently
        only supported by Microsoft SQL Server. The `timezone` can only be set on
        creation. See [MSSQL User
        Guide](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone)
        for more information.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="upgradeStorageConfig")
    def upgrade_storage_config(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to upgrade the storage file system configuration on the read replica.
        Can only be set with `replicate_source_db`.
        """
        return pulumi.get(self, "upgrade_storage_config")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        (Required unless a `snapshot_identifier` or `replicate_source_db`
        is provided) Username for the master DB user. Cannot be specified for a replica.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of VPC security groups to
        associate.
        """
        return pulumi.get(self, "vpc_security_group_ids")

