# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, allow_version_upgrade=None, aqua_configuration_status=None, arn=None, automated_snapshot_retention_period=None, availability_zone=None, availability_zone_relocation_enabled=None, bucket_name=None, cluster_identifier=None, cluster_namespace_arn=None, cluster_nodes=None, cluster_parameter_group_name=None, cluster_public_key=None, cluster_revision_number=None, cluster_subnet_group_name=None, cluster_type=None, cluster_version=None, database_name=None, default_iam_role_arn=None, elastic_ip=None, enable_logging=None, encrypted=None, endpoint=None, enhanced_vpc_routing=None, iam_roles=None, id=None, kms_key_id=None, log_destination_type=None, log_exports=None, maintenance_track_name=None, manual_snapshot_retention_period=None, master_username=None, multi_az=None, node_type=None, number_of_nodes=None, port=None, preferred_maintenance_window=None, publicly_accessible=None, s3_key_prefix=None, tags=None, vpc_id=None, vpc_security_group_ids=None):
        if allow_version_upgrade and not isinstance(allow_version_upgrade, bool):
            raise TypeError("Expected argument 'allow_version_upgrade' to be a bool")
        pulumi.set(__self__, "allow_version_upgrade", allow_version_upgrade)
        if aqua_configuration_status and not isinstance(aqua_configuration_status, str):
            raise TypeError("Expected argument 'aqua_configuration_status' to be a str")
        pulumi.set(__self__, "aqua_configuration_status", aqua_configuration_status)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if automated_snapshot_retention_period and not isinstance(automated_snapshot_retention_period, int):
            raise TypeError("Expected argument 'automated_snapshot_retention_period' to be a int")
        pulumi.set(__self__, "automated_snapshot_retention_period", automated_snapshot_retention_period)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_relocation_enabled and not isinstance(availability_zone_relocation_enabled, bool):
            raise TypeError("Expected argument 'availability_zone_relocation_enabled' to be a bool")
        pulumi.set(__self__, "availability_zone_relocation_enabled", availability_zone_relocation_enabled)
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if cluster_identifier and not isinstance(cluster_identifier, str):
            raise TypeError("Expected argument 'cluster_identifier' to be a str")
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if cluster_namespace_arn and not isinstance(cluster_namespace_arn, str):
            raise TypeError("Expected argument 'cluster_namespace_arn' to be a str")
        pulumi.set(__self__, "cluster_namespace_arn", cluster_namespace_arn)
        if cluster_nodes and not isinstance(cluster_nodes, list):
            raise TypeError("Expected argument 'cluster_nodes' to be a list")
        pulumi.set(__self__, "cluster_nodes", cluster_nodes)
        if cluster_parameter_group_name and not isinstance(cluster_parameter_group_name, str):
            raise TypeError("Expected argument 'cluster_parameter_group_name' to be a str")
        pulumi.set(__self__, "cluster_parameter_group_name", cluster_parameter_group_name)
        if cluster_public_key and not isinstance(cluster_public_key, str):
            raise TypeError("Expected argument 'cluster_public_key' to be a str")
        pulumi.set(__self__, "cluster_public_key", cluster_public_key)
        if cluster_revision_number and not isinstance(cluster_revision_number, str):
            raise TypeError("Expected argument 'cluster_revision_number' to be a str")
        pulumi.set(__self__, "cluster_revision_number", cluster_revision_number)
        if cluster_subnet_group_name and not isinstance(cluster_subnet_group_name, str):
            raise TypeError("Expected argument 'cluster_subnet_group_name' to be a str")
        pulumi.set(__self__, "cluster_subnet_group_name", cluster_subnet_group_name)
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_version and not isinstance(cluster_version, str):
            raise TypeError("Expected argument 'cluster_version' to be a str")
        pulumi.set(__self__, "cluster_version", cluster_version)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if default_iam_role_arn and not isinstance(default_iam_role_arn, str):
            raise TypeError("Expected argument 'default_iam_role_arn' to be a str")
        pulumi.set(__self__, "default_iam_role_arn", default_iam_role_arn)
        if elastic_ip and not isinstance(elastic_ip, str):
            raise TypeError("Expected argument 'elastic_ip' to be a str")
        pulumi.set(__self__, "elastic_ip", elastic_ip)
        if enable_logging and not isinstance(enable_logging, bool):
            raise TypeError("Expected argument 'enable_logging' to be a bool")
        pulumi.set(__self__, "enable_logging", enable_logging)
        if encrypted and not isinstance(encrypted, bool):
            raise TypeError("Expected argument 'encrypted' to be a bool")
        pulumi.set(__self__, "encrypted", encrypted)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if enhanced_vpc_routing and not isinstance(enhanced_vpc_routing, bool):
            raise TypeError("Expected argument 'enhanced_vpc_routing' to be a bool")
        pulumi.set(__self__, "enhanced_vpc_routing", enhanced_vpc_routing)
        if iam_roles and not isinstance(iam_roles, list):
            raise TypeError("Expected argument 'iam_roles' to be a list")
        pulumi.set(__self__, "iam_roles", iam_roles)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_destination_type and not isinstance(log_destination_type, str):
            raise TypeError("Expected argument 'log_destination_type' to be a str")
        pulumi.set(__self__, "log_destination_type", log_destination_type)
        if log_exports and not isinstance(log_exports, list):
            raise TypeError("Expected argument 'log_exports' to be a list")
        pulumi.set(__self__, "log_exports", log_exports)
        if maintenance_track_name and not isinstance(maintenance_track_name, str):
            raise TypeError("Expected argument 'maintenance_track_name' to be a str")
        pulumi.set(__self__, "maintenance_track_name", maintenance_track_name)
        if manual_snapshot_retention_period and not isinstance(manual_snapshot_retention_period, int):
            raise TypeError("Expected argument 'manual_snapshot_retention_period' to be a int")
        pulumi.set(__self__, "manual_snapshot_retention_period", manual_snapshot_retention_period)
        if master_username and not isinstance(master_username, str):
            raise TypeError("Expected argument 'master_username' to be a str")
        pulumi.set(__self__, "master_username", master_username)
        if multi_az and not isinstance(multi_az, bool):
            raise TypeError("Expected argument 'multi_az' to be a bool")
        pulumi.set(__self__, "multi_az", multi_az)
        if node_type and not isinstance(node_type, str):
            raise TypeError("Expected argument 'node_type' to be a str")
        pulumi.set(__self__, "node_type", node_type)
        if number_of_nodes and not isinstance(number_of_nodes, int):
            raise TypeError("Expected argument 'number_of_nodes' to be a int")
        pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if preferred_maintenance_window and not isinstance(preferred_maintenance_window, str):
            raise TypeError("Expected argument 'preferred_maintenance_window' to be a str")
        pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible and not isinstance(publicly_accessible, bool):
            raise TypeError("Expected argument 'publicly_accessible' to be a bool")
        pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if s3_key_prefix and not isinstance(s3_key_prefix, str):
            raise TypeError("Expected argument 's3_key_prefix' to be a str")
        pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_security_group_ids and not isinstance(vpc_security_group_ids, list):
            raise TypeError("Expected argument 'vpc_security_group_ids' to be a list")
        pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="allowVersionUpgrade")
    def allow_version_upgrade(self) -> bool:
        """
        Whether major version upgrades can be applied during maintenance period
        """
        return pulumi.get(self, "allow_version_upgrade")

    @property
    @pulumi.getter(name="aquaConfigurationStatus")
    def aqua_configuration_status(self) -> str:
        """
        The value represents how the cluster is configured to use AQUA.
        """
        return pulumi.get(self, "aqua_configuration_status")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="automatedSnapshotRetentionPeriod")
    def automated_snapshot_retention_period(self) -> int:
        """
        The backup retention period
        """
        return pulumi.get(self, "automated_snapshot_retention_period")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Availability zone of the cluster
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="availabilityZoneRelocationEnabled")
    def availability_zone_relocation_enabled(self) -> bool:
        """
        Indicates whether the cluster is able to be relocated to another availability zone.
        """
        return pulumi.get(self, "availability_zone_relocation_enabled")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Name of the S3 bucket where the log files are to be stored
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> str:
        """
        Cluster identifier
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="clusterNamespaceArn")
    def cluster_namespace_arn(self) -> str:
        """
        The namespace Amazon Resource Name (ARN) of the cluster
        """
        return pulumi.get(self, "cluster_namespace_arn")

    @property
    @pulumi.getter(name="clusterNodes")
    def cluster_nodes(self) -> Sequence['outputs.GetClusterClusterNodeResult']:
        """
        Nodes in the cluster. Cluster node blocks are documented below
        """
        return pulumi.get(self, "cluster_nodes")

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> str:
        """
        The name of the parameter group to be associated with this cluster
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @property
    @pulumi.getter(name="clusterPublicKey")
    def cluster_public_key(self) -> str:
        """
        Public key for the cluster
        """
        return pulumi.get(self, "cluster_public_key")

    @property
    @pulumi.getter(name="clusterRevisionNumber")
    def cluster_revision_number(self) -> str:
        """
        The cluster revision number
        """
        return pulumi.get(self, "cluster_revision_number")

    @property
    @pulumi.getter(name="clusterSubnetGroupName")
    def cluster_subnet_group_name(self) -> str:
        """
        The name of a cluster subnet group to be associated with this cluster
        """
        return pulumi.get(self, "cluster_subnet_group_name")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> str:
        """
        Cluster type
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> str:
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of the default database in the cluster
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="defaultIamRoleArn")
    def default_iam_role_arn(self) -> str:
        """
        The ARN for the IAM role that was set as default for the cluster when the cluster was created.
        """
        return pulumi.get(self, "default_iam_role_arn")

    @property
    @pulumi.getter(name="elasticIp")
    def elastic_ip(self) -> str:
        """
        Elastic IP of the cluster
        """
        return pulumi.get(self, "elastic_ip")

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> bool:
        """
        Whether cluster logging is enabled
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter
    def encrypted(self) -> bool:
        """
        Whether the cluster data is encrypted
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Cluster endpoint
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> bool:
        """
        Whether enhanced VPC routing is enabled
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> Sequence[str]:
        """
        IAM roles associated to the cluster
        """
        return pulumi.get(self, "iam_roles")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        KMS encryption key associated to the cluster
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> str:
        """
        The log destination type.
        """
        return pulumi.get(self, "log_destination_type")

    @property
    @pulumi.getter(name="logExports")
    def log_exports(self) -> Sequence[str]:
        """
        Collection of exported log types. Log types include the connection log, user log and user activity log.
        """
        return pulumi.get(self, "log_exports")

    @property
    @pulumi.getter(name="maintenanceTrackName")
    def maintenance_track_name(self) -> str:
        """
        The name of the maintenance track for the restored cluster.
        """
        return pulumi.get(self, "maintenance_track_name")

    @property
    @pulumi.getter(name="manualSnapshotRetentionPeriod")
    def manual_snapshot_retention_period(self) -> int:
        """
        (Optional)  The default number of days to retain a manual snapshot.
        """
        return pulumi.get(self, "manual_snapshot_retention_period")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> str:
        """
        Username for the master DB user
        """
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> bool:
        """
        If the cluster is a Multi-AZ deployment
        """
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        Cluster node type
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> int:
        """
        Number of nodes in the cluster
        """
        return pulumi.get(self, "number_of_nodes")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port the cluster responds on
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> str:
        """
        The maintenance window
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> bool:
        """
        Whether the cluster is publicly accessible
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> str:
        """
        Folder inside the S3 bucket where the log files are stored
        """
        return pulumi.get(self, "s3_key_prefix")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Tags associated to the cluster
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        VPC Id associated with the cluster
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Sequence[str]:
        """
        The VPC security group Ids associated with the cluster
        """
        return pulumi.get(self, "vpc_security_group_ids")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            allow_version_upgrade=self.allow_version_upgrade,
            aqua_configuration_status=self.aqua_configuration_status,
            arn=self.arn,
            automated_snapshot_retention_period=self.automated_snapshot_retention_period,
            availability_zone=self.availability_zone,
            availability_zone_relocation_enabled=self.availability_zone_relocation_enabled,
            bucket_name=self.bucket_name,
            cluster_identifier=self.cluster_identifier,
            cluster_namespace_arn=self.cluster_namespace_arn,
            cluster_nodes=self.cluster_nodes,
            cluster_parameter_group_name=self.cluster_parameter_group_name,
            cluster_public_key=self.cluster_public_key,
            cluster_revision_number=self.cluster_revision_number,
            cluster_subnet_group_name=self.cluster_subnet_group_name,
            cluster_type=self.cluster_type,
            cluster_version=self.cluster_version,
            database_name=self.database_name,
            default_iam_role_arn=self.default_iam_role_arn,
            elastic_ip=self.elastic_ip,
            enable_logging=self.enable_logging,
            encrypted=self.encrypted,
            endpoint=self.endpoint,
            enhanced_vpc_routing=self.enhanced_vpc_routing,
            iam_roles=self.iam_roles,
            id=self.id,
            kms_key_id=self.kms_key_id,
            log_destination_type=self.log_destination_type,
            log_exports=self.log_exports,
            maintenance_track_name=self.maintenance_track_name,
            manual_snapshot_retention_period=self.manual_snapshot_retention_period,
            master_username=self.master_username,
            multi_az=self.multi_az,
            node_type=self.node_type,
            number_of_nodes=self.number_of_nodes,
            port=self.port,
            preferred_maintenance_window=self.preferred_maintenance_window,
            publicly_accessible=self.publicly_accessible,
            s3_key_prefix=self.s3_key_prefix,
            tags=self.tags,
            vpc_id=self.vpc_id,
            vpc_security_group_ids=self.vpc_security_group_ids)


def get_cluster(cluster_identifier: Optional[str] = None,
                tags: Optional[Mapping[str, str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Provides details about a specific redshift cluster.


    :param str cluster_identifier: Cluster identifier
    :param Mapping[str, str] tags: Tags associated to the cluster
    """
    __args__ = dict()
    __args__['clusterIdentifier'] = cluster_identifier
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:redshift/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        allow_version_upgrade=pulumi.get(__ret__, 'allow_version_upgrade'),
        aqua_configuration_status=pulumi.get(__ret__, 'aqua_configuration_status'),
        arn=pulumi.get(__ret__, 'arn'),
        automated_snapshot_retention_period=pulumi.get(__ret__, 'automated_snapshot_retention_period'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        availability_zone_relocation_enabled=pulumi.get(__ret__, 'availability_zone_relocation_enabled'),
        bucket_name=pulumi.get(__ret__, 'bucket_name'),
        cluster_identifier=pulumi.get(__ret__, 'cluster_identifier'),
        cluster_namespace_arn=pulumi.get(__ret__, 'cluster_namespace_arn'),
        cluster_nodes=pulumi.get(__ret__, 'cluster_nodes'),
        cluster_parameter_group_name=pulumi.get(__ret__, 'cluster_parameter_group_name'),
        cluster_public_key=pulumi.get(__ret__, 'cluster_public_key'),
        cluster_revision_number=pulumi.get(__ret__, 'cluster_revision_number'),
        cluster_subnet_group_name=pulumi.get(__ret__, 'cluster_subnet_group_name'),
        cluster_type=pulumi.get(__ret__, 'cluster_type'),
        cluster_version=pulumi.get(__ret__, 'cluster_version'),
        database_name=pulumi.get(__ret__, 'database_name'),
        default_iam_role_arn=pulumi.get(__ret__, 'default_iam_role_arn'),
        elastic_ip=pulumi.get(__ret__, 'elastic_ip'),
        enable_logging=pulumi.get(__ret__, 'enable_logging'),
        encrypted=pulumi.get(__ret__, 'encrypted'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        enhanced_vpc_routing=pulumi.get(__ret__, 'enhanced_vpc_routing'),
        iam_roles=pulumi.get(__ret__, 'iam_roles'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        log_destination_type=pulumi.get(__ret__, 'log_destination_type'),
        log_exports=pulumi.get(__ret__, 'log_exports'),
        maintenance_track_name=pulumi.get(__ret__, 'maintenance_track_name'),
        manual_snapshot_retention_period=pulumi.get(__ret__, 'manual_snapshot_retention_period'),
        master_username=pulumi.get(__ret__, 'master_username'),
        multi_az=pulumi.get(__ret__, 'multi_az'),
        node_type=pulumi.get(__ret__, 'node_type'),
        number_of_nodes=pulumi.get(__ret__, 'number_of_nodes'),
        port=pulumi.get(__ret__, 'port'),
        preferred_maintenance_window=pulumi.get(__ret__, 'preferred_maintenance_window'),
        publicly_accessible=pulumi.get(__ret__, 'publicly_accessible'),
        s3_key_prefix=pulumi.get(__ret__, 's3_key_prefix'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vpc_security_group_ids=pulumi.get(__ret__, 'vpc_security_group_ids'))
def get_cluster_output(cluster_identifier: Optional[pulumi.Input[str]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Provides details about a specific redshift cluster.


    :param str cluster_identifier: Cluster identifier
    :param Mapping[str, str] tags: Tags associated to the cluster
    """
    __args__ = dict()
    __args__['clusterIdentifier'] = cluster_identifier
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:redshift/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        allow_version_upgrade=pulumi.get(__response__, 'allow_version_upgrade'),
        aqua_configuration_status=pulumi.get(__response__, 'aqua_configuration_status'),
        arn=pulumi.get(__response__, 'arn'),
        automated_snapshot_retention_period=pulumi.get(__response__, 'automated_snapshot_retention_period'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        availability_zone_relocation_enabled=pulumi.get(__response__, 'availability_zone_relocation_enabled'),
        bucket_name=pulumi.get(__response__, 'bucket_name'),
        cluster_identifier=pulumi.get(__response__, 'cluster_identifier'),
        cluster_namespace_arn=pulumi.get(__response__, 'cluster_namespace_arn'),
        cluster_nodes=pulumi.get(__response__, 'cluster_nodes'),
        cluster_parameter_group_name=pulumi.get(__response__, 'cluster_parameter_group_name'),
        cluster_public_key=pulumi.get(__response__, 'cluster_public_key'),
        cluster_revision_number=pulumi.get(__response__, 'cluster_revision_number'),
        cluster_subnet_group_name=pulumi.get(__response__, 'cluster_subnet_group_name'),
        cluster_type=pulumi.get(__response__, 'cluster_type'),
        cluster_version=pulumi.get(__response__, 'cluster_version'),
        database_name=pulumi.get(__response__, 'database_name'),
        default_iam_role_arn=pulumi.get(__response__, 'default_iam_role_arn'),
        elastic_ip=pulumi.get(__response__, 'elastic_ip'),
        enable_logging=pulumi.get(__response__, 'enable_logging'),
        encrypted=pulumi.get(__response__, 'encrypted'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        enhanced_vpc_routing=pulumi.get(__response__, 'enhanced_vpc_routing'),
        iam_roles=pulumi.get(__response__, 'iam_roles'),
        id=pulumi.get(__response__, 'id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        log_destination_type=pulumi.get(__response__, 'log_destination_type'),
        log_exports=pulumi.get(__response__, 'log_exports'),
        maintenance_track_name=pulumi.get(__response__, 'maintenance_track_name'),
        manual_snapshot_retention_period=pulumi.get(__response__, 'manual_snapshot_retention_period'),
        master_username=pulumi.get(__response__, 'master_username'),
        multi_az=pulumi.get(__response__, 'multi_az'),
        node_type=pulumi.get(__response__, 'node_type'),
        number_of_nodes=pulumi.get(__response__, 'number_of_nodes'),
        port=pulumi.get(__response__, 'port'),
        preferred_maintenance_window=pulumi.get(__response__, 'preferred_maintenance_window'),
        publicly_accessible=pulumi.get(__response__, 'publicly_accessible'),
        s3_key_prefix=pulumi.get(__response__, 's3_key_prefix'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        vpc_security_group_ids=pulumi.get(__response__, 'vpc_security_group_ids')))
