# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SnapshotCopyArgs', 'SnapshotCopy']

@pulumi.input_type
class SnapshotCopyArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[str],
                 destination_region: pulumi.Input[str],
                 manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 snapshot_copy_grant_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SnapshotCopy resource.
        :param pulumi.Input[str] cluster_identifier: Identifier of the source cluster.
        :param pulumi.Input[str] destination_region: AWS Region to copy snapshots to.
               
               The following arguments are optional:
        :param pulumi.Input[int] manual_snapshot_retention_period: Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
        :param pulumi.Input[int] retention_period: Number of days to retain automated snapshots in the destination region after they are copied from the source region.
        :param pulumi.Input[str] snapshot_copy_grant_name: Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        pulumi.set(__self__, "destination_region", destination_region)
        if manual_snapshot_retention_period is not None:
            pulumi.set(__self__, "manual_snapshot_retention_period", manual_snapshot_retention_period)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if snapshot_copy_grant_name is not None:
            pulumi.set(__self__, "snapshot_copy_grant_name", snapshot_copy_grant_name)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[str]:
        """
        Identifier of the source cluster.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Input[str]:
        """
        AWS Region to copy snapshots to.

        The following arguments are optional:
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_region", value)

    @property
    @pulumi.getter(name="manualSnapshotRetentionPeriod")
    def manual_snapshot_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
        """
        return pulumi.get(self, "manual_snapshot_retention_period")

    @manual_snapshot_retention_period.setter
    def manual_snapshot_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manual_snapshot_retention_period", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days to retain automated snapshots in the destination region after they are copied from the source region.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="snapshotCopyGrantName")
    def snapshot_copy_grant_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        return pulumi.get(self, "snapshot_copy_grant_name")

    @snapshot_copy_grant_name.setter
    def snapshot_copy_grant_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_copy_grant_name", value)


@pulumi.input_type
class _SnapshotCopyState:
    def __init__(__self__, *,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 destination_region: Optional[pulumi.Input[str]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 snapshot_copy_grant_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SnapshotCopy resources.
        :param pulumi.Input[str] cluster_identifier: Identifier of the source cluster.
        :param pulumi.Input[str] destination_region: AWS Region to copy snapshots to.
               
               The following arguments are optional:
        :param pulumi.Input[int] manual_snapshot_retention_period: Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
        :param pulumi.Input[int] retention_period: Number of days to retain automated snapshots in the destination region after they are copied from the source region.
        :param pulumi.Input[str] snapshot_copy_grant_name: Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if destination_region is not None:
            pulumi.set(__self__, "destination_region", destination_region)
        if manual_snapshot_retention_period is not None:
            pulumi.set(__self__, "manual_snapshot_retention_period", manual_snapshot_retention_period)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if snapshot_copy_grant_name is not None:
            pulumi.set(__self__, "snapshot_copy_grant_name", snapshot_copy_grant_name)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the source cluster.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Region to copy snapshots to.

        The following arguments are optional:
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_region", value)

    @property
    @pulumi.getter(name="manualSnapshotRetentionPeriod")
    def manual_snapshot_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
        """
        return pulumi.get(self, "manual_snapshot_retention_period")

    @manual_snapshot_retention_period.setter
    def manual_snapshot_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manual_snapshot_retention_period", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days to retain automated snapshots in the destination region after they are copied from the source region.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="snapshotCopyGrantName")
    def snapshot_copy_grant_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        return pulumi.get(self, "snapshot_copy_grant_name")

    @snapshot_copy_grant_name.setter
    def snapshot_copy_grant_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_copy_grant_name", value)


class SnapshotCopy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 destination_region: Optional[pulumi.Input[str]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 snapshot_copy_grant_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Redshift Snapshot Copy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.SnapshotCopy("example",
            cluster_identifier=example_aws_redshift_cluster["id"],
            destination_region="us-east-1")
        ```

        ## Import

        Using `pulumi import`, import Redshift Snapshot Copy using the `id`. For example:

        ```sh
        $ pulumi import aws:redshift/snapshotCopy:SnapshotCopy example cluster-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_identifier: Identifier of the source cluster.
        :param pulumi.Input[str] destination_region: AWS Region to copy snapshots to.
               
               The following arguments are optional:
        :param pulumi.Input[int] manual_snapshot_retention_period: Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
        :param pulumi.Input[int] retention_period: Number of days to retain automated snapshots in the destination region after they are copied from the source region.
        :param pulumi.Input[str] snapshot_copy_grant_name: Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotCopyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Redshift Snapshot Copy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.SnapshotCopy("example",
            cluster_identifier=example_aws_redshift_cluster["id"],
            destination_region="us-east-1")
        ```

        ## Import

        Using `pulumi import`, import Redshift Snapshot Copy using the `id`. For example:

        ```sh
        $ pulumi import aws:redshift/snapshotCopy:SnapshotCopy example cluster-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotCopyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotCopyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 destination_region: Optional[pulumi.Input[str]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 snapshot_copy_grant_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotCopyArgs.__new__(SnapshotCopyArgs)

            if cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_identifier'")
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            if destination_region is None and not opts.urn:
                raise TypeError("Missing required property 'destination_region'")
            __props__.__dict__["destination_region"] = destination_region
            __props__.__dict__["manual_snapshot_retention_period"] = manual_snapshot_retention_period
            __props__.__dict__["retention_period"] = retention_period
            __props__.__dict__["snapshot_copy_grant_name"] = snapshot_copy_grant_name
        super(SnapshotCopy, __self__).__init__(
            'aws:redshift/snapshotCopy:SnapshotCopy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_identifier: Optional[pulumi.Input[str]] = None,
            destination_region: Optional[pulumi.Input[str]] = None,
            manual_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
            retention_period: Optional[pulumi.Input[int]] = None,
            snapshot_copy_grant_name: Optional[pulumi.Input[str]] = None) -> 'SnapshotCopy':
        """
        Get an existing SnapshotCopy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_identifier: Identifier of the source cluster.
        :param pulumi.Input[str] destination_region: AWS Region to copy snapshots to.
               
               The following arguments are optional:
        :param pulumi.Input[int] manual_snapshot_retention_period: Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
        :param pulumi.Input[int] retention_period: Number of days to retain automated snapshots in the destination region after they are copied from the source region.
        :param pulumi.Input[str] snapshot_copy_grant_name: Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotCopyState.__new__(_SnapshotCopyState)

        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["destination_region"] = destination_region
        __props__.__dict__["manual_snapshot_retention_period"] = manual_snapshot_retention_period
        __props__.__dict__["retention_period"] = retention_period
        __props__.__dict__["snapshot_copy_grant_name"] = snapshot_copy_grant_name
        return SnapshotCopy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[str]:
        """
        Identifier of the source cluster.
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Output[str]:
        """
        AWS Region to copy snapshots to.

        The following arguments are optional:
        """
        return pulumi.get(self, "destination_region")

    @property
    @pulumi.getter(name="manualSnapshotRetentionPeriod")
    def manual_snapshot_retention_period(self) -> pulumi.Output[int]:
        """
        Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
        """
        return pulumi.get(self, "manual_snapshot_retention_period")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output[int]:
        """
        Number of days to retain automated snapshots in the destination region after they are copied from the source region.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="snapshotCopyGrantName")
    def snapshot_copy_grant_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        return pulumi.get(self, "snapshot_copy_grant_name")

