# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DelegationSignerRecordArgs', 'DelegationSignerRecord']

@pulumi.input_type
class DelegationSignerRecordArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 signing_attributes: Optional[pulumi.Input['DelegationSignerRecordSigningAttributesArgs']] = None,
                 timeouts: Optional[pulumi.Input['DelegationSignerRecordTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a DelegationSignerRecord resource.
        :param pulumi.Input[str] domain_name: The name of the domain that will have its parent DNS zone updated with the Delegation Signer record.
        :param pulumi.Input['DelegationSignerRecordSigningAttributesArgs'] signing_attributes: The information about a key, including the algorithm, public key-value, and flags.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if signing_attributes is not None:
            pulumi.set(__self__, "signing_attributes", signing_attributes)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The name of the domain that will have its parent DNS zone updated with the Delegation Signer record.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="signingAttributes")
    def signing_attributes(self) -> Optional[pulumi.Input['DelegationSignerRecordSigningAttributesArgs']]:
        """
        The information about a key, including the algorithm, public key-value, and flags.
        """
        return pulumi.get(self, "signing_attributes")

    @signing_attributes.setter
    def signing_attributes(self, value: Optional[pulumi.Input['DelegationSignerRecordSigningAttributesArgs']]):
        pulumi.set(self, "signing_attributes", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DelegationSignerRecordTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DelegationSignerRecordTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _DelegationSignerRecordState:
    def __init__(__self__, *,
                 dnssec_key_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 signing_attributes: Optional[pulumi.Input['DelegationSignerRecordSigningAttributesArgs']] = None,
                 timeouts: Optional[pulumi.Input['DelegationSignerRecordTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering DelegationSignerRecord resources.
        :param pulumi.Input[str] dnssec_key_id: An ID assigned to the created DS record.
        :param pulumi.Input[str] domain_name: The name of the domain that will have its parent DNS zone updated with the Delegation Signer record.
        :param pulumi.Input['DelegationSignerRecordSigningAttributesArgs'] signing_attributes: The information about a key, including the algorithm, public key-value, and flags.
        """
        if dnssec_key_id is not None:
            pulumi.set(__self__, "dnssec_key_id", dnssec_key_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if signing_attributes is not None:
            pulumi.set(__self__, "signing_attributes", signing_attributes)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="dnssecKeyId")
    def dnssec_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        An ID assigned to the created DS record.
        """
        return pulumi.get(self, "dnssec_key_id")

    @dnssec_key_id.setter
    def dnssec_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dnssec_key_id", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain that will have its parent DNS zone updated with the Delegation Signer record.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="signingAttributes")
    def signing_attributes(self) -> Optional[pulumi.Input['DelegationSignerRecordSigningAttributesArgs']]:
        """
        The information about a key, including the algorithm, public key-value, and flags.
        """
        return pulumi.get(self, "signing_attributes")

    @signing_attributes.setter
    def signing_attributes(self, value: Optional[pulumi.Input['DelegationSignerRecordSigningAttributesArgs']]):
        pulumi.set(self, "signing_attributes", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DelegationSignerRecordTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DelegationSignerRecordTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class DelegationSignerRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 signing_attributes: Optional[pulumi.Input[Union['DelegationSignerRecordSigningAttributesArgs', 'DelegationSignerRecordSigningAttributesArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['DelegationSignerRecordTimeoutsArgs', 'DelegationSignerRecordTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource to manage a [delegation signer record](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-enable-signing.html#dns-configuring-dnssec-enable-signing-step-1) in the parent DNS zone for domains registered with Route53.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.kms.Key("example",
            customer_master_key_spec="ECC_NIST_P256",
            deletion_window_in_days=7,
            key_usage="SIGN_VERIFY",
            policy=json.dumps({
                "Statement": [
                    {
                        "Action": [
                            "kms:DescribeKey",
                            "kms:GetPublicKey",
                            "kms:Sign",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "dnssec-route53.amazonaws.com",
                        },
                        "Sid": "Allow Route 53 DNSSEC Service",
                        "Resource": "*",
                        "Condition": {
                            "StringEquals": {
                                "aws:SourceAccount": current.account_id,
                            },
                            "ArnLike": {
                                "aws:SourceArn": "arn:aws:route53:::hostedzone/*",
                            },
                        },
                    },
                    {
                        "Action": "kms:CreateGrant",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "dnssec-route53.amazonaws.com",
                        },
                        "Sid": "Allow Route 53 DNSSEC Service to CreateGrant",
                        "Resource": "*",
                        "Condition": {
                            "Bool": {
                                "kms:GrantIsForAWSResource": "true",
                            },
                        },
                    },
                    {
                        "Action": "kms:*",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": f"arn:aws:iam::{current.account_id}:root",
                        },
                        "Resource": "*",
                        "Sid": "Enable IAM User Permissions",
                    },
                ],
                "Version": "2012-10-17",
            }))
        example_zone = aws.route53.Zone("example", name="example.com")
        example_key_signing_key = aws.route53.KeySigningKey("example",
            hosted_zone_id=test["id"],
            key_management_service_arn=test_aws_kms_key["arn"],
            name="example")
        example_hosted_zone_dns_sec = aws.route53.HostedZoneDnsSec("example", hosted_zone_id=example_key_signing_key.hosted_zone_id,
        opts = pulumi.ResourceOptions(depends_on=[example_key_signing_key]))
        example_delegation_signer_record = aws.route53domains.DelegationSignerRecord("example",
            domain_name="example.com",
            signing_attributes={
                "algorithm": example_key_signing_key.signing_algorithm_type,
                "flags": example_key_signing_key.flag,
                "public_key": example_key_signing_key.public_key,
            })
        ```

        ## Import

        Using `pulumi import`, import delegation signer records using the domain name and DNSSEC key ID, separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:route53domains/delegationSignerRecord:DelegationSignerRecord example example.com,40DE3534F5324DBDAC598ACEDB5B1E26A5368732D9C791D1347E4FBDDF6FC343
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: The name of the domain that will have its parent DNS zone updated with the Delegation Signer record.
        :param pulumi.Input[Union['DelegationSignerRecordSigningAttributesArgs', 'DelegationSignerRecordSigningAttributesArgsDict']] signing_attributes: The information about a key, including the algorithm, public key-value, and flags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DelegationSignerRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage a [delegation signer record](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-enable-signing.html#dns-configuring-dnssec-enable-signing-step-1) in the parent DNS zone for domains registered with Route53.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.kms.Key("example",
            customer_master_key_spec="ECC_NIST_P256",
            deletion_window_in_days=7,
            key_usage="SIGN_VERIFY",
            policy=json.dumps({
                "Statement": [
                    {
                        "Action": [
                            "kms:DescribeKey",
                            "kms:GetPublicKey",
                            "kms:Sign",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "dnssec-route53.amazonaws.com",
                        },
                        "Sid": "Allow Route 53 DNSSEC Service",
                        "Resource": "*",
                        "Condition": {
                            "StringEquals": {
                                "aws:SourceAccount": current.account_id,
                            },
                            "ArnLike": {
                                "aws:SourceArn": "arn:aws:route53:::hostedzone/*",
                            },
                        },
                    },
                    {
                        "Action": "kms:CreateGrant",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "dnssec-route53.amazonaws.com",
                        },
                        "Sid": "Allow Route 53 DNSSEC Service to CreateGrant",
                        "Resource": "*",
                        "Condition": {
                            "Bool": {
                                "kms:GrantIsForAWSResource": "true",
                            },
                        },
                    },
                    {
                        "Action": "kms:*",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": f"arn:aws:iam::{current.account_id}:root",
                        },
                        "Resource": "*",
                        "Sid": "Enable IAM User Permissions",
                    },
                ],
                "Version": "2012-10-17",
            }))
        example_zone = aws.route53.Zone("example", name="example.com")
        example_key_signing_key = aws.route53.KeySigningKey("example",
            hosted_zone_id=test["id"],
            key_management_service_arn=test_aws_kms_key["arn"],
            name="example")
        example_hosted_zone_dns_sec = aws.route53.HostedZoneDnsSec("example", hosted_zone_id=example_key_signing_key.hosted_zone_id,
        opts = pulumi.ResourceOptions(depends_on=[example_key_signing_key]))
        example_delegation_signer_record = aws.route53domains.DelegationSignerRecord("example",
            domain_name="example.com",
            signing_attributes={
                "algorithm": example_key_signing_key.signing_algorithm_type,
                "flags": example_key_signing_key.flag,
                "public_key": example_key_signing_key.public_key,
            })
        ```

        ## Import

        Using `pulumi import`, import delegation signer records using the domain name and DNSSEC key ID, separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:route53domains/delegationSignerRecord:DelegationSignerRecord example example.com,40DE3534F5324DBDAC598ACEDB5B1E26A5368732D9C791D1347E4FBDDF6FC343
        ```

        :param str resource_name: The name of the resource.
        :param DelegationSignerRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DelegationSignerRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 signing_attributes: Optional[pulumi.Input[Union['DelegationSignerRecordSigningAttributesArgs', 'DelegationSignerRecordSigningAttributesArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['DelegationSignerRecordTimeoutsArgs', 'DelegationSignerRecordTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DelegationSignerRecordArgs.__new__(DelegationSignerRecordArgs)

            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["signing_attributes"] = signing_attributes
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["dnssec_key_id"] = None
        super(DelegationSignerRecord, __self__).__init__(
            'aws:route53domains/delegationSignerRecord:DelegationSignerRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dnssec_key_id: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            signing_attributes: Optional[pulumi.Input[Union['DelegationSignerRecordSigningAttributesArgs', 'DelegationSignerRecordSigningAttributesArgsDict']]] = None,
            timeouts: Optional[pulumi.Input[Union['DelegationSignerRecordTimeoutsArgs', 'DelegationSignerRecordTimeoutsArgsDict']]] = None) -> 'DelegationSignerRecord':
        """
        Get an existing DelegationSignerRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dnssec_key_id: An ID assigned to the created DS record.
        :param pulumi.Input[str] domain_name: The name of the domain that will have its parent DNS zone updated with the Delegation Signer record.
        :param pulumi.Input[Union['DelegationSignerRecordSigningAttributesArgs', 'DelegationSignerRecordSigningAttributesArgsDict']] signing_attributes: The information about a key, including the algorithm, public key-value, and flags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DelegationSignerRecordState.__new__(_DelegationSignerRecordState)

        __props__.__dict__["dnssec_key_id"] = dnssec_key_id
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["signing_attributes"] = signing_attributes
        __props__.__dict__["timeouts"] = timeouts
        return DelegationSignerRecord(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dnssecKeyId")
    def dnssec_key_id(self) -> pulumi.Output[str]:
        """
        An ID assigned to the created DS record.
        """
        return pulumi.get(self, "dnssec_key_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The name of the domain that will have its parent DNS zone updated with the Delegation Signer record.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="signingAttributes")
    def signing_attributes(self) -> pulumi.Output[Optional['outputs.DelegationSignerRecordSigningAttributes']]:
        """
        The information about a key, including the algorithm, public key-value, and flags.
        """
        return pulumi.get(self, "signing_attributes")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DelegationSignerRecordTimeouts']]:
        return pulumi.get(self, "timeouts")

