# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DirectoryBucketArgs', 'DirectoryBucket']

@pulumi.input_type
class DirectoryBucketArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 data_redundancy: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input['DirectoryBucketLocationArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DirectoryBucket resource.
        :param pulumi.Input[str] bucket: Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.BucketV2` resource to manage general purpose buckets.
        :param pulumi.Input[str] data_redundancy: Data redundancy. Valid values: `SingleAvailabilityZone`.
        :param pulumi.Input[bool] force_destroy: Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input['DirectoryBucketLocationArgs'] location: Bucket location. See Location below for more details.
        :param pulumi.Input[str] type: Bucket type. Valid values: `Directory`.
        """
        pulumi.set(__self__, "bucket", bucket)
        if data_redundancy is not None:
            pulumi.set(__self__, "data_redundancy", data_redundancy)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.BucketV2` resource to manage general purpose buckets.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="dataRedundancy")
    def data_redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        Data redundancy. Valid values: `SingleAvailabilityZone`.
        """
        return pulumi.get(self, "data_redundancy")

    @data_redundancy.setter
    def data_redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_redundancy", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['DirectoryBucketLocationArgs']]:
        """
        Bucket location. See Location below for more details.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['DirectoryBucketLocationArgs']]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket type. Valid values: `Directory`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DirectoryBucketState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 data_redundancy: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input['DirectoryBucketLocationArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DirectoryBucket resources.
        :param pulumi.Input[str] arn: ARN of the bucket.
        :param pulumi.Input[str] bucket: Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.BucketV2` resource to manage general purpose buckets.
        :param pulumi.Input[str] data_redundancy: Data redundancy. Valid values: `SingleAvailabilityZone`.
        :param pulumi.Input[bool] force_destroy: Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input['DirectoryBucketLocationArgs'] location: Bucket location. See Location below for more details.
        :param pulumi.Input[str] type: Bucket type. Valid values: `Directory`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if data_redundancy is not None:
            pulumi.set(__self__, "data_redundancy", data_redundancy)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the bucket.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.BucketV2` resource to manage general purpose buckets.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="dataRedundancy")
    def data_redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        Data redundancy. Valid values: `SingleAvailabilityZone`.
        """
        return pulumi.get(self, "data_redundancy")

    @data_redundancy.setter
    def data_redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_redundancy", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['DirectoryBucketLocationArgs']]:
        """
        Bucket location. See Location below for more details.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['DirectoryBucketLocationArgs']]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket type. Valid values: `Directory`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class DirectoryBucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 data_redundancy: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[Union['DirectoryBucketLocationArgs', 'DirectoryBucketLocationArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Amazon S3 Express directory bucket resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.DirectoryBucket("example",
            bucket="example--usw2-az1--x-s3",
            location={
                "name": "usw2-az1",
            })
        ```

        ## Import

        Using `pulumi import`, import S3 bucket using `bucket`. For example:

        ```sh
        $ pulumi import aws:s3/directoryBucket:DirectoryBucket example example--usw2-az1--x-s3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.BucketV2` resource to manage general purpose buckets.
        :param pulumi.Input[str] data_redundancy: Data redundancy. Valid values: `SingleAvailabilityZone`.
        :param pulumi.Input[bool] force_destroy: Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[Union['DirectoryBucketLocationArgs', 'DirectoryBucketLocationArgsDict']] location: Bucket location. See Location below for more details.
        :param pulumi.Input[str] type: Bucket type. Valid values: `Directory`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DirectoryBucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amazon S3 Express directory bucket resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.DirectoryBucket("example",
            bucket="example--usw2-az1--x-s3",
            location={
                "name": "usw2-az1",
            })
        ```

        ## Import

        Using `pulumi import`, import S3 bucket using `bucket`. For example:

        ```sh
        $ pulumi import aws:s3/directoryBucket:DirectoryBucket example example--usw2-az1--x-s3
        ```

        :param str resource_name: The name of the resource.
        :param DirectoryBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DirectoryBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 data_redundancy: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[Union['DirectoryBucketLocationArgs', 'DirectoryBucketLocationArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DirectoryBucketArgs.__new__(DirectoryBucketArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["data_redundancy"] = data_redundancy
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["location"] = location
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
        super(DirectoryBucket, __self__).__init__(
            'aws:s3/directoryBucket:DirectoryBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            data_redundancy: Optional[pulumi.Input[str]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[Union['DirectoryBucketLocationArgs', 'DirectoryBucketLocationArgsDict']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'DirectoryBucket':
        """
        Get an existing DirectoryBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the bucket.
        :param pulumi.Input[str] bucket: Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.BucketV2` resource to manage general purpose buckets.
        :param pulumi.Input[str] data_redundancy: Data redundancy. Valid values: `SingleAvailabilityZone`.
        :param pulumi.Input[bool] force_destroy: Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[Union['DirectoryBucketLocationArgs', 'DirectoryBucketLocationArgsDict']] location: Bucket location. See Location below for more details.
        :param pulumi.Input[str] type: Bucket type. Valid values: `Directory`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DirectoryBucketState.__new__(_DirectoryBucketState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["data_redundancy"] = data_redundancy
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["location"] = location
        __props__.__dict__["type"] = type
        return DirectoryBucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the bucket.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        Name of the bucket. The name must be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.BucketV2` resource to manage general purpose buckets.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="dataRedundancy")
    def data_redundancy(self) -> pulumi.Output[str]:
        """
        Data redundancy. Valid values: `SingleAvailabilityZone`.
        """
        return pulumi.get(self, "data_redundancy")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[bool]:
        """
        Boolean that indicates all objects should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional['outputs.DirectoryBucketLocation']]:
        """
        Bucket location. See Location below for more details.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Bucket type. Valid values: `Directory`.
        """
        return pulumi.get(self, "type")

