# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 table_bucket_arn: pulumi.Input[str]):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[str] namespace: Name of the namespace.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] table_bucket_arn: ARN referencing the Table Bucket that contains this Namespace.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "table_bucket_arn", table_bucket_arn)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Name of the namespace.
        Must be between 1 and 255 characters in length.
        Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> pulumi.Input[str]:
        """
        ARN referencing the Table Bucket that contains this Namespace.
        """
        return pulumi.get(self, "table_bucket_arn")

    @table_bucket_arn.setter
    def table_bucket_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_bucket_arn", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 owner_account_id: Optional[pulumi.Input[str]] = None,
                 table_bucket_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input[str] created_at: Date and time when the namespace was created.
        :param pulumi.Input[str] created_by: Account ID of the account that created the namespace.
        :param pulumi.Input[str] namespace: Name of the namespace.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] owner_account_id: Account ID of the account that owns the namespace.
        :param pulumi.Input[str] table_bucket_arn: ARN referencing the Table Bucket that contains this Namespace.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if owner_account_id is not None:
            pulumi.set(__self__, "owner_account_id", owner_account_id)
        if table_bucket_arn is not None:
            pulumi.set(__self__, "table_bucket_arn", table_bucket_arn)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time when the namespace was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        Account ID of the account that created the namespace.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the namespace.
        Must be between 1 and 255 characters in length.
        Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Account ID of the account that owns the namespace.
        """
        return pulumi.get(self, "owner_account_id")

    @owner_account_id.setter
    def owner_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_account_id", value)

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN referencing the Table Bucket that contains this Namespace.
        """
        return pulumi.get(self, "table_bucket_arn")

    @table_bucket_arn.setter
    def table_bucket_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_bucket_arn", value)


class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 table_bucket_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon S3 Tables Namespace.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_table_bucket = aws.s3tables.TableBucket("example", name="example-bucket")
        example = aws.s3tables.Namespace("example",
            namespace="example-namespace",
            table_bucket_arn=example_table_bucket.arn)
        ```

        ## Import

        Using `pulumi import`, import S3 Tables Namespace using the `table_bucket_arn` and the value of `namespace`, separated by a semicolon (`;`). For example:

        ```sh
        $ pulumi import aws:s3tables/namespace:Namespace example 'arn:aws:s3tables:us-west-2:123456789012:bucket/example-bucket;example-namespace'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] namespace: Name of the namespace.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] table_bucket_arn: ARN referencing the Table Bucket that contains this Namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon S3 Tables Namespace.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_table_bucket = aws.s3tables.TableBucket("example", name="example-bucket")
        example = aws.s3tables.Namespace("example",
            namespace="example-namespace",
            table_bucket_arn=example_table_bucket.arn)
        ```

        ## Import

        Using `pulumi import`, import S3 Tables Namespace using the `table_bucket_arn` and the value of `namespace`, separated by a semicolon (`;`). For example:

        ```sh
        $ pulumi import aws:s3tables/namespace:Namespace example 'arn:aws:s3tables:us-west-2:123456789012:bucket/example-bucket;example-namespace'
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 table_bucket_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if table_bucket_arn is None and not opts.urn:
                raise TypeError("Missing required property 'table_bucket_arn'")
            __props__.__dict__["table_bucket_arn"] = table_bucket_arn
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["owner_account_id"] = None
        super(Namespace, __self__).__init__(
            'aws:s3tables/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            owner_account_id: Optional[pulumi.Input[str]] = None,
            table_bucket_arn: Optional[pulumi.Input[str]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Date and time when the namespace was created.
        :param pulumi.Input[str] created_by: Account ID of the account that created the namespace.
        :param pulumi.Input[str] namespace: Name of the namespace.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] owner_account_id: Account ID of the account that owns the namespace.
        :param pulumi.Input[str] table_bucket_arn: ARN referencing the Table Bucket that contains this Namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["owner_account_id"] = owner_account_id
        __props__.__dict__["table_bucket_arn"] = table_bucket_arn
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Date and time when the namespace was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        Account ID of the account that created the namespace.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        Name of the namespace.
        Must be between 1 and 255 characters in length.
        Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> pulumi.Output[str]:
        """
        Account ID of the account that owns the namespace.
        """
        return pulumi.get(self, "owner_account_id")

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> pulumi.Output[str]:
        """
        ARN referencing the Table Bucket that contains this Namespace.
        """
        return pulumi.get(self, "table_bucket_arn")

