# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableBucketArgs', 'TableBucket']

@pulumi.input_type
class TableBucketArgs:
    def __init__(__self__, *,
                 maintenance_configuration: Optional[pulumi.Input['TableBucketMaintenanceConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TableBucket resource.
        :param pulumi.Input['TableBucketMaintenanceConfigurationArgs'] maintenance_configuration: A single table bucket maintenance configuration block.
               See `maintenance_configuration` below
        :param pulumi.Input[str] name: Name of the table bucket.
               Must be between 3 and 63 characters in length.
               Can consist of lowercase letters, numbers, and hyphens, and must begin and end with a lowercase letter or number.
               A full list of bucket naming rules may be found in S3 Tables documentation.
               
               The following argument is optional:
        """
        if maintenance_configuration is not None:
            pulumi.set(__self__, "maintenance_configuration", maintenance_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="maintenanceConfiguration")
    def maintenance_configuration(self) -> Optional[pulumi.Input['TableBucketMaintenanceConfigurationArgs']]:
        """
        A single table bucket maintenance configuration block.
        See `maintenance_configuration` below
        """
        return pulumi.get(self, "maintenance_configuration")

    @maintenance_configuration.setter
    def maintenance_configuration(self, value: Optional[pulumi.Input['TableBucketMaintenanceConfigurationArgs']]):
        pulumi.set(self, "maintenance_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the table bucket.
        Must be between 3 and 63 characters in length.
        Can consist of lowercase letters, numbers, and hyphens, and must begin and end with a lowercase letter or number.
        A full list of bucket naming rules may be found in S3 Tables documentation.

        The following argument is optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TableBucketState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 maintenance_configuration: Optional[pulumi.Input['TableBucketMaintenanceConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner_account_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TableBucket resources.
        :param pulumi.Input[str] arn: ARN of the table bucket.
        :param pulumi.Input[str] created_at: Date and time when the bucket was created.
        :param pulumi.Input['TableBucketMaintenanceConfigurationArgs'] maintenance_configuration: A single table bucket maintenance configuration block.
               See `maintenance_configuration` below
        :param pulumi.Input[str] name: Name of the table bucket.
               Must be between 3 and 63 characters in length.
               Can consist of lowercase letters, numbers, and hyphens, and must begin and end with a lowercase letter or number.
               A full list of bucket naming rules may be found in S3 Tables documentation.
               
               The following argument is optional:
        :param pulumi.Input[str] owner_account_id: Account ID of the account that owns the table bucket.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if maintenance_configuration is not None:
            pulumi.set(__self__, "maintenance_configuration", maintenance_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_account_id is not None:
            pulumi.set(__self__, "owner_account_id", owner_account_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the table bucket.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time when the bucket was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="maintenanceConfiguration")
    def maintenance_configuration(self) -> Optional[pulumi.Input['TableBucketMaintenanceConfigurationArgs']]:
        """
        A single table bucket maintenance configuration block.
        See `maintenance_configuration` below
        """
        return pulumi.get(self, "maintenance_configuration")

    @maintenance_configuration.setter
    def maintenance_configuration(self, value: Optional[pulumi.Input['TableBucketMaintenanceConfigurationArgs']]):
        pulumi.set(self, "maintenance_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the table bucket.
        Must be between 3 and 63 characters in length.
        Can consist of lowercase letters, numbers, and hyphens, and must begin and end with a lowercase letter or number.
        A full list of bucket naming rules may be found in S3 Tables documentation.

        The following argument is optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Account ID of the account that owns the table bucket.
        """
        return pulumi.get(self, "owner_account_id")

    @owner_account_id.setter
    def owner_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_account_id", value)


class TableBucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 maintenance_configuration: Optional[pulumi.Input[Union['TableBucketMaintenanceConfigurationArgs', 'TableBucketMaintenanceConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon S3 Tables Table Bucket.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3tables.TableBucket("example", name="example-bucket")
        ```

        ## Import

        Using `pulumi import`, import S3 Tables Table Bucket using the `arn`. For example:

        ```sh
        $ pulumi import aws:s3tables/tableBucket:TableBucket example arn:aws:s3tables:us-west-2:123456789012:bucket/example-bucket
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableBucketMaintenanceConfigurationArgs', 'TableBucketMaintenanceConfigurationArgsDict']] maintenance_configuration: A single table bucket maintenance configuration block.
               See `maintenance_configuration` below
        :param pulumi.Input[str] name: Name of the table bucket.
               Must be between 3 and 63 characters in length.
               Can consist of lowercase letters, numbers, and hyphens, and must begin and end with a lowercase letter or number.
               A full list of bucket naming rules may be found in S3 Tables documentation.
               
               The following argument is optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TableBucketArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon S3 Tables Table Bucket.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3tables.TableBucket("example", name="example-bucket")
        ```

        ## Import

        Using `pulumi import`, import S3 Tables Table Bucket using the `arn`. For example:

        ```sh
        $ pulumi import aws:s3tables/tableBucket:TableBucket example arn:aws:s3tables:us-west-2:123456789012:bucket/example-bucket
        ```

        :param str resource_name: The name of the resource.
        :param TableBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 maintenance_configuration: Optional[pulumi.Input[Union['TableBucketMaintenanceConfigurationArgs', 'TableBucketMaintenanceConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableBucketArgs.__new__(TableBucketArgs)

            __props__.__dict__["maintenance_configuration"] = maintenance_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["owner_account_id"] = None
        super(TableBucket, __self__).__init__(
            'aws:s3tables/tableBucket:TableBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            maintenance_configuration: Optional[pulumi.Input[Union['TableBucketMaintenanceConfigurationArgs', 'TableBucketMaintenanceConfigurationArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            owner_account_id: Optional[pulumi.Input[str]] = None) -> 'TableBucket':
        """
        Get an existing TableBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the table bucket.
        :param pulumi.Input[str] created_at: Date and time when the bucket was created.
        :param pulumi.Input[Union['TableBucketMaintenanceConfigurationArgs', 'TableBucketMaintenanceConfigurationArgsDict']] maintenance_configuration: A single table bucket maintenance configuration block.
               See `maintenance_configuration` below
        :param pulumi.Input[str] name: Name of the table bucket.
               Must be between 3 and 63 characters in length.
               Can consist of lowercase letters, numbers, and hyphens, and must begin and end with a lowercase letter or number.
               A full list of bucket naming rules may be found in S3 Tables documentation.
               
               The following argument is optional:
        :param pulumi.Input[str] owner_account_id: Account ID of the account that owns the table bucket.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableBucketState.__new__(_TableBucketState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["maintenance_configuration"] = maintenance_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_account_id"] = owner_account_id
        return TableBucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the table bucket.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Date and time when the bucket was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="maintenanceConfiguration")
    def maintenance_configuration(self) -> pulumi.Output['outputs.TableBucketMaintenanceConfiguration']:
        """
        A single table bucket maintenance configuration block.
        See `maintenance_configuration` below
        """
        return pulumi.get(self, "maintenance_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the table bucket.
        Must be between 3 and 63 characters in length.
        Can consist of lowercase letters, numbers, and hyphens, and must begin and end with a lowercase letter or number.
        A full list of bucket naming rules may be found in S3 Tables documentation.

        The following argument is optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> pulumi.Output[str]:
        """
        Account ID of the account that owns the table bucket.
        """
        return pulumi.get(self, "owner_account_id")

