# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TablePolicyArgs', 'TablePolicy']

@pulumi.input_type
class TablePolicyArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 resource_policy: pulumi.Input[str],
                 table_bucket_arn: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TablePolicy resource.
        :param pulumi.Input[str] namespace: Name of the namespace for this table.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] resource_policy: Amazon Web Services resource-based policy document in JSON format.
        :param pulumi.Input[str] table_bucket_arn: ARN referencing the Table Bucket that contains this Namespace.
        :param pulumi.Input[str] name: Name of the table.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_policy", resource_policy)
        pulumi.set(__self__, "table_bucket_arn", table_bucket_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Name of the namespace for this table.
        Must be between 1 and 255 characters in length.
        Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> pulumi.Input[str]:
        """
        Amazon Web Services resource-based policy document in JSON format.
        """
        return pulumi.get(self, "resource_policy")

    @resource_policy.setter
    def resource_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_policy", value)

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> pulumi.Input[str]:
        """
        ARN referencing the Table Bucket that contains this Namespace.
        """
        return pulumi.get(self, "table_bucket_arn")

    @table_bucket_arn.setter
    def table_bucket_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_bucket_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the table.
        Must be between 1 and 255 characters in length.
        Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TablePolicyState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_policy: Optional[pulumi.Input[str]] = None,
                 table_bucket_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TablePolicy resources.
        :param pulumi.Input[str] name: Name of the table.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] namespace: Name of the namespace for this table.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] resource_policy: Amazon Web Services resource-based policy document in JSON format.
        :param pulumi.Input[str] table_bucket_arn: ARN referencing the Table Bucket that contains this Namespace.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_policy is not None:
            pulumi.set(__self__, "resource_policy", resource_policy)
        if table_bucket_arn is not None:
            pulumi.set(__self__, "table_bucket_arn", table_bucket_arn)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the table.
        Must be between 1 and 255 characters in length.
        Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the namespace for this table.
        Must be between 1 and 255 characters in length.
        Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Web Services resource-based policy document in JSON format.
        """
        return pulumi.get(self, "resource_policy")

    @resource_policy.setter
    def resource_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_policy", value)

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN referencing the Table Bucket that contains this Namespace.
        """
        return pulumi.get(self, "table_bucket_arn")

    @table_bucket_arn.setter
    def table_bucket_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_bucket_arn", value)


class TablePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_policy: Optional[pulumi.Input[str]] = None,
                 table_bucket_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon S3 Tables Table Policy.

        ## Example Usage

        ## Import

        Using `pulumi import`, import S3 Tables Table Policy using the `table_bucket_arn`, the value of `namespace`, and the value of `name`, separated by a semicolon (`;`). For example:

        ```sh
        $ pulumi import aws:s3tables/tablePolicy:TablePolicy example 'arn:aws:s3tables:us-west-2:123456789012:bucket/example-bucket;example-namespace;example-table'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name of the table.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] namespace: Name of the namespace for this table.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] resource_policy: Amazon Web Services resource-based policy document in JSON format.
        :param pulumi.Input[str] table_bucket_arn: ARN referencing the Table Bucket that contains this Namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TablePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon S3 Tables Table Policy.

        ## Example Usage

        ## Import

        Using `pulumi import`, import S3 Tables Table Policy using the `table_bucket_arn`, the value of `namespace`, and the value of `name`, separated by a semicolon (`;`). For example:

        ```sh
        $ pulumi import aws:s3tables/tablePolicy:TablePolicy example 'arn:aws:s3tables:us-west-2:123456789012:bucket/example-bucket;example-namespace;example-table'
        ```

        :param str resource_name: The name of the resource.
        :param TablePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TablePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_policy: Optional[pulumi.Input[str]] = None,
                 table_bucket_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TablePolicyArgs.__new__(TablePolicyArgs)

            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if resource_policy is None and not opts.urn:
                raise TypeError("Missing required property 'resource_policy'")
            __props__.__dict__["resource_policy"] = resource_policy
            if table_bucket_arn is None and not opts.urn:
                raise TypeError("Missing required property 'table_bucket_arn'")
            __props__.__dict__["table_bucket_arn"] = table_bucket_arn
        super(TablePolicy, __self__).__init__(
            'aws:s3tables/tablePolicy:TablePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            resource_policy: Optional[pulumi.Input[str]] = None,
            table_bucket_arn: Optional[pulumi.Input[str]] = None) -> 'TablePolicy':
        """
        Get an existing TablePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name of the table.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] namespace: Name of the namespace for this table.
               Must be between 1 and 255 characters in length.
               Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        :param pulumi.Input[str] resource_policy: Amazon Web Services resource-based policy document in JSON format.
        :param pulumi.Input[str] table_bucket_arn: ARN referencing the Table Bucket that contains this Namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TablePolicyState.__new__(_TablePolicyState)

        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["resource_policy"] = resource_policy
        __props__.__dict__["table_bucket_arn"] = table_bucket_arn
        return TablePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the table.
        Must be between 1 and 255 characters in length.
        Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        Name of the namespace for this table.
        Must be between 1 and 255 characters in length.
        Can consist of lowercase letters, numbers, and underscores, and must begin and end with a lowercase letter or number.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> pulumi.Output[str]:
        """
        Amazon Web Services resource-based policy document in JSON format.
        """
        return pulumi.get(self, "resource_policy")

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> pulumi.Output[str]:
        """
        ARN referencing the Table Bucket that contains this Namespace.
        """
        return pulumi.get(self, "table_bucket_arn")

