# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MlflowTrackingServerArgs', 'MlflowTrackingServer']

@pulumi.input_type
class MlflowTrackingServerArgs:
    def __init__(__self__, *,
                 artifact_store_uri: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 tracking_server_name: pulumi.Input[str],
                 automatic_model_registration: Optional[pulumi.Input[bool]] = None,
                 mlflow_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tracking_server_size: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MlflowTrackingServer resource.
        :param pulumi.Input[str] artifact_store_uri: The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the artifact store in Amazon S3. The role should have AmazonS3FullAccess permissions. For more information on IAM permissions for tracking server creation, see [Set up IAM permissions for MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
        :param pulumi.Input[str] tracking_server_name: A unique string identifying the tracking server name. This string is part of the tracking server ARN.
        :param pulumi.Input[bool] automatic_model_registration: A list of Member Definitions that contains objects that identify the workers that make up the work team.
        :param pulumi.Input[str] mlflow_version: The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see [How it works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] tracking_server_size: The size of the tracking server you want to create. You can choose between "Small", "Medium", and "Large". The default MLflow Tracking Server configuration size is "Small". You can choose a size depending on the projected use of the tracking server such as the volume of data logged, number of users, and frequency of use.
        :param pulumi.Input[str] weekly_maintenance_window_start: The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: TUE:03:30.
        """
        pulumi.set(__self__, "artifact_store_uri", artifact_store_uri)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "tracking_server_name", tracking_server_name)
        if automatic_model_registration is not None:
            pulumi.set(__self__, "automatic_model_registration", automatic_model_registration)
        if mlflow_version is not None:
            pulumi.set(__self__, "mlflow_version", mlflow_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tracking_server_size is not None:
            pulumi.set(__self__, "tracking_server_size", tracking_server_size)
        if weekly_maintenance_window_start is not None:
            pulumi.set(__self__, "weekly_maintenance_window_start", weekly_maintenance_window_start)

    @property
    @pulumi.getter(name="artifactStoreUri")
    def artifact_store_uri(self) -> pulumi.Input[str]:
        """
        The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
        """
        return pulumi.get(self, "artifact_store_uri")

    @artifact_store_uri.setter
    def artifact_store_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_store_uri", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the artifact store in Amazon S3. The role should have AmazonS3FullAccess permissions. For more information on IAM permissions for tracking server creation, see [Set up IAM permissions for MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="trackingServerName")
    def tracking_server_name(self) -> pulumi.Input[str]:
        """
        A unique string identifying the tracking server name. This string is part of the tracking server ARN.
        """
        return pulumi.get(self, "tracking_server_name")

    @tracking_server_name.setter
    def tracking_server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tracking_server_name", value)

    @property
    @pulumi.getter(name="automaticModelRegistration")
    def automatic_model_registration(self) -> Optional[pulumi.Input[bool]]:
        """
        A list of Member Definitions that contains objects that identify the workers that make up the work team.
        """
        return pulumi.get(self, "automatic_model_registration")

    @automatic_model_registration.setter
    def automatic_model_registration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_model_registration", value)

    @property
    @pulumi.getter(name="mlflowVersion")
    def mlflow_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see [How it works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
        """
        return pulumi.get(self, "mlflow_version")

    @mlflow_version.setter
    def mlflow_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mlflow_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trackingServerSize")
    def tracking_server_size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the tracking server you want to create. You can choose between "Small", "Medium", and "Large". The default MLflow Tracking Server configuration size is "Small". You can choose a size depending on the projected use of the tracking server such as the volume of data logged, number of users, and frequency of use.
        """
        return pulumi.get(self, "tracking_server_size")

    @tracking_server_size.setter
    def tracking_server_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracking_server_size", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> Optional[pulumi.Input[str]]:
        """
        The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: TUE:03:30.
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

    @weekly_maintenance_window_start.setter
    def weekly_maintenance_window_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_window_start", value)


@pulumi.input_type
class _MlflowTrackingServerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 artifact_store_uri: Optional[pulumi.Input[str]] = None,
                 automatic_model_registration: Optional[pulumi.Input[bool]] = None,
                 mlflow_version: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tracking_server_name: Optional[pulumi.Input[str]] = None,
                 tracking_server_size: Optional[pulumi.Input[str]] = None,
                 tracking_server_url: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MlflowTrackingServer resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) assigned by AWS to this MLFlow Tracking Server.
        :param pulumi.Input[str] artifact_store_uri: The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
        :param pulumi.Input[bool] automatic_model_registration: A list of Member Definitions that contains objects that identify the workers that make up the work team.
        :param pulumi.Input[str] mlflow_version: The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see [How it works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the artifact store in Amazon S3. The role should have AmazonS3FullAccess permissions. For more information on IAM permissions for tracking server creation, see [Set up IAM permissions for MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] tracking_server_name: A unique string identifying the tracking server name. This string is part of the tracking server ARN.
        :param pulumi.Input[str] tracking_server_size: The size of the tracking server you want to create. You can choose between "Small", "Medium", and "Large". The default MLflow Tracking Server configuration size is "Small". You can choose a size depending on the projected use of the tracking server such as the volume of data logged, number of users, and frequency of use.
        :param pulumi.Input[str] tracking_server_url: The URL to connect to the MLflow user interface for the described tracking server.
        :param pulumi.Input[str] weekly_maintenance_window_start: The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: TUE:03:30.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if artifact_store_uri is not None:
            pulumi.set(__self__, "artifact_store_uri", artifact_store_uri)
        if automatic_model_registration is not None:
            pulumi.set(__self__, "automatic_model_registration", automatic_model_registration)
        if mlflow_version is not None:
            pulumi.set(__self__, "mlflow_version", mlflow_version)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tracking_server_name is not None:
            pulumi.set(__self__, "tracking_server_name", tracking_server_name)
        if tracking_server_size is not None:
            pulumi.set(__self__, "tracking_server_size", tracking_server_size)
        if tracking_server_url is not None:
            pulumi.set(__self__, "tracking_server_url", tracking_server_url)
        if weekly_maintenance_window_start is not None:
            pulumi.set(__self__, "weekly_maintenance_window_start", weekly_maintenance_window_start)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this MLFlow Tracking Server.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="artifactStoreUri")
    def artifact_store_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
        """
        return pulumi.get(self, "artifact_store_uri")

    @artifact_store_uri.setter
    def artifact_store_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_store_uri", value)

    @property
    @pulumi.getter(name="automaticModelRegistration")
    def automatic_model_registration(self) -> Optional[pulumi.Input[bool]]:
        """
        A list of Member Definitions that contains objects that identify the workers that make up the work team.
        """
        return pulumi.get(self, "automatic_model_registration")

    @automatic_model_registration.setter
    def automatic_model_registration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_model_registration", value)

    @property
    @pulumi.getter(name="mlflowVersion")
    def mlflow_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see [How it works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
        """
        return pulumi.get(self, "mlflow_version")

    @mlflow_version.setter
    def mlflow_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mlflow_version", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the artifact store in Amazon S3. The role should have AmazonS3FullAccess permissions. For more information on IAM permissions for tracking server creation, see [Set up IAM permissions for MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="trackingServerName")
    def tracking_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique string identifying the tracking server name. This string is part of the tracking server ARN.
        """
        return pulumi.get(self, "tracking_server_name")

    @tracking_server_name.setter
    def tracking_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracking_server_name", value)

    @property
    @pulumi.getter(name="trackingServerSize")
    def tracking_server_size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the tracking server you want to create. You can choose between "Small", "Medium", and "Large". The default MLflow Tracking Server configuration size is "Small". You can choose a size depending on the projected use of the tracking server such as the volume of data logged, number of users, and frequency of use.
        """
        return pulumi.get(self, "tracking_server_size")

    @tracking_server_size.setter
    def tracking_server_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracking_server_size", value)

    @property
    @pulumi.getter(name="trackingServerUrl")
    def tracking_server_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to connect to the MLflow user interface for the described tracking server.
        """
        return pulumi.get(self, "tracking_server_url")

    @tracking_server_url.setter
    def tracking_server_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracking_server_url", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> Optional[pulumi.Input[str]]:
        """
        The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: TUE:03:30.
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

    @weekly_maintenance_window_start.setter
    def weekly_maintenance_window_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_window_start", value)


class MlflowTrackingServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_store_uri: Optional[pulumi.Input[str]] = None,
                 automatic_model_registration: Optional[pulumi.Input[bool]] = None,
                 mlflow_version: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tracking_server_name: Optional[pulumi.Input[str]] = None,
                 tracking_server_size: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a SageMaker MLFlow Tracking Server resource.

        ## Example Usage

        ### Cognito Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.MlflowTrackingServer("example",
            tracking_server_name="example",
            role_arn=example_aws_iam_role["arn"],
            artifact_store_uri=f"s3://{example_aws_s3_bucket['bucket']}/path")
        ```

        ## Import

        Using `pulumi import`, import SageMaker MLFlow Tracking Servers using the `workteam_name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/mlflowTrackingServer:MlflowTrackingServer example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_store_uri: The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
        :param pulumi.Input[bool] automatic_model_registration: A list of Member Definitions that contains objects that identify the workers that make up the work team.
        :param pulumi.Input[str] mlflow_version: The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see [How it works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the artifact store in Amazon S3. The role should have AmazonS3FullAccess permissions. For more information on IAM permissions for tracking server creation, see [Set up IAM permissions for MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] tracking_server_name: A unique string identifying the tracking server name. This string is part of the tracking server ARN.
        :param pulumi.Input[str] tracking_server_size: The size of the tracking server you want to create. You can choose between "Small", "Medium", and "Large". The default MLflow Tracking Server configuration size is "Small". You can choose a size depending on the projected use of the tracking server such as the volume of data logged, number of users, and frequency of use.
        :param pulumi.Input[str] weekly_maintenance_window_start: The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: TUE:03:30.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MlflowTrackingServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SageMaker MLFlow Tracking Server resource.

        ## Example Usage

        ### Cognito Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.sagemaker.MlflowTrackingServer("example",
            tracking_server_name="example",
            role_arn=example_aws_iam_role["arn"],
            artifact_store_uri=f"s3://{example_aws_s3_bucket['bucket']}/path")
        ```

        ## Import

        Using `pulumi import`, import SageMaker MLFlow Tracking Servers using the `workteam_name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/mlflowTrackingServer:MlflowTrackingServer example example
        ```

        :param str resource_name: The name of the resource.
        :param MlflowTrackingServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MlflowTrackingServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_store_uri: Optional[pulumi.Input[str]] = None,
                 automatic_model_registration: Optional[pulumi.Input[bool]] = None,
                 mlflow_version: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tracking_server_name: Optional[pulumi.Input[str]] = None,
                 tracking_server_size: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MlflowTrackingServerArgs.__new__(MlflowTrackingServerArgs)

            if artifact_store_uri is None and not opts.urn:
                raise TypeError("Missing required property 'artifact_store_uri'")
            __props__.__dict__["artifact_store_uri"] = artifact_store_uri
            __props__.__dict__["automatic_model_registration"] = automatic_model_registration
            __props__.__dict__["mlflow_version"] = mlflow_version
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            if tracking_server_name is None and not opts.urn:
                raise TypeError("Missing required property 'tracking_server_name'")
            __props__.__dict__["tracking_server_name"] = tracking_server_name
            __props__.__dict__["tracking_server_size"] = tracking_server_size
            __props__.__dict__["weekly_maintenance_window_start"] = weekly_maintenance_window_start
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["tracking_server_url"] = None
        super(MlflowTrackingServer, __self__).__init__(
            'aws:sagemaker/mlflowTrackingServer:MlflowTrackingServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            artifact_store_uri: Optional[pulumi.Input[str]] = None,
            automatic_model_registration: Optional[pulumi.Input[bool]] = None,
            mlflow_version: Optional[pulumi.Input[str]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tracking_server_name: Optional[pulumi.Input[str]] = None,
            tracking_server_size: Optional[pulumi.Input[str]] = None,
            tracking_server_url: Optional[pulumi.Input[str]] = None,
            weekly_maintenance_window_start: Optional[pulumi.Input[str]] = None) -> 'MlflowTrackingServer':
        """
        Get an existing MlflowTrackingServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) assigned by AWS to this MLFlow Tracking Server.
        :param pulumi.Input[str] artifact_store_uri: The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
        :param pulumi.Input[bool] automatic_model_registration: A list of Member Definitions that contains objects that identify the workers that make up the work team.
        :param pulumi.Input[str] mlflow_version: The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see [How it works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the artifact store in Amazon S3. The role should have AmazonS3FullAccess permissions. For more information on IAM permissions for tracking server creation, see [Set up IAM permissions for MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] tracking_server_name: A unique string identifying the tracking server name. This string is part of the tracking server ARN.
        :param pulumi.Input[str] tracking_server_size: The size of the tracking server you want to create. You can choose between "Small", "Medium", and "Large". The default MLflow Tracking Server configuration size is "Small". You can choose a size depending on the projected use of the tracking server such as the volume of data logged, number of users, and frequency of use.
        :param pulumi.Input[str] tracking_server_url: The URL to connect to the MLflow user interface for the described tracking server.
        :param pulumi.Input[str] weekly_maintenance_window_start: The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: TUE:03:30.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MlflowTrackingServerState.__new__(_MlflowTrackingServerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["artifact_store_uri"] = artifact_store_uri
        __props__.__dict__["automatic_model_registration"] = automatic_model_registration
        __props__.__dict__["mlflow_version"] = mlflow_version
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tracking_server_name"] = tracking_server_name
        __props__.__dict__["tracking_server_size"] = tracking_server_size
        __props__.__dict__["tracking_server_url"] = tracking_server_url
        __props__.__dict__["weekly_maintenance_window_start"] = weekly_maintenance_window_start
        return MlflowTrackingServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this MLFlow Tracking Server.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="artifactStoreUri")
    def artifact_store_uri(self) -> pulumi.Output[str]:
        """
        The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
        """
        return pulumi.get(self, "artifact_store_uri")

    @property
    @pulumi.getter(name="automaticModelRegistration")
    def automatic_model_registration(self) -> pulumi.Output[Optional[bool]]:
        """
        A list of Member Definitions that contains objects that identify the workers that make up the work team.
        """
        return pulumi.get(self, "automatic_model_registration")

    @property
    @pulumi.getter(name="mlflowVersion")
    def mlflow_version(self) -> pulumi.Output[str]:
        """
        The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see [How it works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
        """
        return pulumi.get(self, "mlflow_version")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the artifact store in Amazon S3. The role should have AmazonS3FullAccess permissions. For more information on IAM permissions for tracking server creation, see [Set up IAM permissions for MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="trackingServerName")
    def tracking_server_name(self) -> pulumi.Output[str]:
        """
        A unique string identifying the tracking server name. This string is part of the tracking server ARN.
        """
        return pulumi.get(self, "tracking_server_name")

    @property
    @pulumi.getter(name="trackingServerSize")
    def tracking_server_size(self) -> pulumi.Output[Optional[str]]:
        """
        The size of the tracking server you want to create. You can choose between "Small", "Medium", and "Large". The default MLflow Tracking Server configuration size is "Small". You can choose a size depending on the projected use of the tracking server such as the volume of data logged, number of users, and frequency of use.
        """
        return pulumi.get(self, "tracking_server_size")

    @property
    @pulumi.getter(name="trackingServerUrl")
    def tracking_server_url(self) -> pulumi.Output[str]:
        """
        The URL to connect to the MLflow user interface for the described tracking server.
        """
        return pulumi.get(self, "tracking_server_url")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> pulumi.Output[str]:
        """
        The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: TUE:03:30.
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

