# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomLogSourceArgs', 'CustomLogSource']

@pulumi.input_type
class CustomLogSourceArgs:
    def __init__(__self__, *,
                 source_name: pulumi.Input[str],
                 configuration: Optional[pulumi.Input['CustomLogSourceConfigurationArgs']] = None,
                 event_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CustomLogSource resource.
        :param pulumi.Input[str] source_name: Specify the name for a third-party custom source.
               This must be a Regionally unique value.
               Has a maximum length of 20.
        :param pulumi.Input['CustomLogSourceConfigurationArgs'] configuration: The configuration for the third-party custom source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] event_classes: The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
        :param pulumi.Input[str] source_version: Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
        """
        pulumi.set(__self__, "source_name", source_name)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if event_classes is not None:
            pulumi.set(__self__, "event_classes", event_classes)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> pulumi.Input[str]:
        """
        Specify the name for a third-party custom source.
        This must be a Regionally unique value.
        Has a maximum length of 20.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['CustomLogSourceConfigurationArgs']]:
        """
        The configuration for the third-party custom source.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['CustomLogSourceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="eventClasses")
    def event_classes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
        """
        return pulumi.get(self, "event_classes")

    @event_classes.setter
    def event_classes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "event_classes", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)


@pulumi.input_type
class _CustomLogSourceState:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['CustomLogSourceAttributeArgs']]]] = None,
                 configuration: Optional[pulumi.Input['CustomLogSourceConfigurationArgs']] = None,
                 event_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 provider_details: Optional[pulumi.Input[Sequence[pulumi.Input['CustomLogSourceProviderDetailArgs']]]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomLogSource resources.
        :param pulumi.Input[Sequence[pulumi.Input['CustomLogSourceAttributeArgs']]] attributes: The attributes of a third-party custom source.
        :param pulumi.Input['CustomLogSourceConfigurationArgs'] configuration: The configuration for the third-party custom source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] event_classes: The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
        :param pulumi.Input[Sequence[pulumi.Input['CustomLogSourceProviderDetailArgs']]] provider_details: The details of the log provider for a third-party custom source.
        :param pulumi.Input[str] source_name: Specify the name for a third-party custom source.
               This must be a Regionally unique value.
               Has a maximum length of 20.
        :param pulumi.Input[str] source_version: Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if event_classes is not None:
            pulumi.set(__self__, "event_classes", event_classes)
        if provider_details is not None:
            pulumi.set(__self__, "provider_details", provider_details)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomLogSourceAttributeArgs']]]]:
        """
        The attributes of a third-party custom source.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomLogSourceAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['CustomLogSourceConfigurationArgs']]:
        """
        The configuration for the third-party custom source.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['CustomLogSourceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="eventClasses")
    def event_classes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
        """
        return pulumi.get(self, "event_classes")

    @event_classes.setter
    def event_classes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "event_classes", value)

    @property
    @pulumi.getter(name="providerDetails")
    def provider_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomLogSourceProviderDetailArgs']]]]:
        """
        The details of the log provider for a third-party custom source.
        """
        return pulumi.get(self, "provider_details")

    @provider_details.setter
    def provider_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomLogSourceProviderDetailArgs']]]]):
        pulumi.set(self, "provider_details", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the name for a third-party custom source.
        This must be a Regionally unique value.
        Has a maximum length of 20.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)


class CustomLogSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['CustomLogSourceConfigurationArgs', 'CustomLogSourceConfigurationArgsDict']]] = None,
                 event_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Security Lake Custom Log Source.

        > **NOTE:** The underlying `securitylake.DataLake` must be configured before creating the `securitylake.CustomLogSource`. Use a `depends_on` statement.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.CustomLogSource("example",
            source_name="example-name",
            source_version="1.0",
            event_classes=["FILE_ACTIVITY"],
            configuration={
                "crawler_configuration": {
                    "role_arn": custom_log["arn"],
                },
                "provider_identity": {
                    "external_id": "example-id",
                    "principal": "123456789012",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
        ```

        ## Import

        Using `pulumi import`, import Custom log sources using the source name. For example:

        ```sh
        $ pulumi import aws:securitylake/customLogSource:CustomLogSource example example-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CustomLogSourceConfigurationArgs', 'CustomLogSourceConfigurationArgsDict']] configuration: The configuration for the third-party custom source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] event_classes: The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
        :param pulumi.Input[str] source_name: Specify the name for a third-party custom source.
               This must be a Regionally unique value.
               Has a maximum length of 20.
        :param pulumi.Input[str] source_version: Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomLogSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Security Lake Custom Log Source.

        > **NOTE:** The underlying `securitylake.DataLake` must be configured before creating the `securitylake.CustomLogSource`. Use a `depends_on` statement.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.CustomLogSource("example",
            source_name="example-name",
            source_version="1.0",
            event_classes=["FILE_ACTIVITY"],
            configuration={
                "crawler_configuration": {
                    "role_arn": custom_log["arn"],
                },
                "provider_identity": {
                    "external_id": "example-id",
                    "principal": "123456789012",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
        ```

        ## Import

        Using `pulumi import`, import Custom log sources using the source name. For example:

        ```sh
        $ pulumi import aws:securitylake/customLogSource:CustomLogSource example example-name
        ```

        :param str resource_name: The name of the resource.
        :param CustomLogSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomLogSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['CustomLogSourceConfigurationArgs', 'CustomLogSourceConfigurationArgsDict']]] = None,
                 event_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomLogSourceArgs.__new__(CustomLogSourceArgs)

            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["event_classes"] = event_classes
            if source_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_name'")
            __props__.__dict__["source_name"] = source_name
            __props__.__dict__["source_version"] = source_version
            __props__.__dict__["attributes"] = None
            __props__.__dict__["provider_details"] = None
        super(CustomLogSource, __self__).__init__(
            'aws:securitylake/customLogSource:CustomLogSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomLogSourceAttributeArgs', 'CustomLogSourceAttributeArgsDict']]]]] = None,
            configuration: Optional[pulumi.Input[Union['CustomLogSourceConfigurationArgs', 'CustomLogSourceConfigurationArgsDict']]] = None,
            event_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            provider_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomLogSourceProviderDetailArgs', 'CustomLogSourceProviderDetailArgsDict']]]]] = None,
            source_name: Optional[pulumi.Input[str]] = None,
            source_version: Optional[pulumi.Input[str]] = None) -> 'CustomLogSource':
        """
        Get an existing CustomLogSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomLogSourceAttributeArgs', 'CustomLogSourceAttributeArgsDict']]]] attributes: The attributes of a third-party custom source.
        :param pulumi.Input[Union['CustomLogSourceConfigurationArgs', 'CustomLogSourceConfigurationArgsDict']] configuration: The configuration for the third-party custom source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] event_classes: The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomLogSourceProviderDetailArgs', 'CustomLogSourceProviderDetailArgsDict']]]] provider_details: The details of the log provider for a third-party custom source.
        :param pulumi.Input[str] source_name: Specify the name for a third-party custom source.
               This must be a Regionally unique value.
               Has a maximum length of 20.
        :param pulumi.Input[str] source_version: Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomLogSourceState.__new__(_CustomLogSourceState)

        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["event_classes"] = event_classes
        __props__.__dict__["provider_details"] = provider_details
        __props__.__dict__["source_name"] = source_name
        __props__.__dict__["source_version"] = source_version
        return CustomLogSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Sequence['outputs.CustomLogSourceAttribute']]:
        """
        The attributes of a third-party custom source.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.CustomLogSourceConfiguration']]:
        """
        The configuration for the third-party custom source.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="eventClasses")
    def event_classes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
        """
        return pulumi.get(self, "event_classes")

    @property
    @pulumi.getter(name="providerDetails")
    def provider_details(self) -> pulumi.Output[Sequence['outputs.CustomLogSourceProviderDetail']]:
        """
        The details of the log provider for a third-party custom source.
        """
        return pulumi.get(self, "provider_details")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> pulumi.Output[str]:
        """
        Specify the name for a third-party custom source.
        This must be a Regionally unique value.
        Has a maximum length of 20.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> pulumi.Output[str]:
        """
        Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
        """
        return pulumi.get(self, "source_version")

