# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAppregistryAttributeGroupResult',
    'AwaitableGetAppregistryAttributeGroupResult',
    'get_appregistry_attribute_group',
    'get_appregistry_attribute_group_output',
]

@pulumi.output_type
class GetAppregistryAttributeGroupResult:
    """
    A collection of values returned by getAppregistryAttributeGroup.
    """
    def __init__(__self__, arn=None, attributes=None, description=None, id=None, name=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if attributes and not isinstance(attributes, str):
            raise TypeError("Expected argument 'attributes' to be a str")
        pulumi.set(__self__, "attributes", attributes)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def attributes(self) -> str:
        """
        A JSON string of nested key-value pairs that represents the attributes of the group.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Attribute Group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        A map of tags assigned to the Attribute Group. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAppregistryAttributeGroupResult(GetAppregistryAttributeGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppregistryAttributeGroupResult(
            arn=self.arn,
            attributes=self.attributes,
            description=self.description,
            id=self.id,
            name=self.name,
            tags=self.tags)


def get_appregistry_attribute_group(arn: Optional[str] = None,
                                    id: Optional[str] = None,
                                    name: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppregistryAttributeGroupResult:
    """
    Data source for managing an AWS Service Catalog AppRegistry Attribute Group.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.servicecatalog.get_appregistry_attribute_group(name="example_attribute_group")
    ```


    :param str arn: ARN of the Attribute Group to find.
    :param str id: ID of the Attribute Group to find.
    :param str name: Name of the Attribute Group to find.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:servicecatalog/getAppregistryAttributeGroup:getAppregistryAttributeGroup', __args__, opts=opts, typ=GetAppregistryAttributeGroupResult).value

    return AwaitableGetAppregistryAttributeGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        attributes=pulumi.get(__ret__, 'attributes'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_appregistry_attribute_group_output(arn: Optional[pulumi.Input[Optional[str]]] = None,
                                           id: Optional[pulumi.Input[Optional[str]]] = None,
                                           name: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppregistryAttributeGroupResult]:
    """
    Data source for managing an AWS Service Catalog AppRegistry Attribute Group.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.servicecatalog.get_appregistry_attribute_group(name="example_attribute_group")
    ```


    :param str arn: ARN of the Attribute Group to find.
    :param str id: ID of the Attribute Group to find.
    :param str name: Name of the Attribute Group to find.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:servicecatalog/getAppregistryAttributeGroup:getAppregistryAttributeGroup', __args__, opts=opts, typ=GetAppregistryAttributeGroupResult)
    return __ret__.apply(lambda __response__: GetAppregistryAttributeGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        attributes=pulumi.get(__response__, 'attributes'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags')))
