# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPortfolioResult',
    'AwaitableGetPortfolioResult',
    'get_portfolio',
    'get_portfolio_output',
]

@pulumi.output_type
class GetPortfolioResult:
    """
    A collection of values returned by getPortfolio.
    """
    def __init__(__self__, accept_language=None, arn=None, created_time=None, description=None, id=None, name=None, provider_name=None, tags=None):
        if accept_language and not isinstance(accept_language, str):
            raise TypeError("Expected argument 'accept_language' to be a str")
        pulumi.set(__self__, "accept_language", accept_language)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provider_name and not isinstance(provider_name, str):
            raise TypeError("Expected argument 'provider_name' to be a str")
        pulumi.set(__self__, "provider_name", provider_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[str]:
        return pulumi.get(self, "accept_language")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Portfolio ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Time the portfolio was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the portfolio
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Portfolio name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> str:
        """
        Name of the person or organization who owns the portfolio.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Tags applied to the portfolio.
        """
        return pulumi.get(self, "tags")


class AwaitableGetPortfolioResult(GetPortfolioResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPortfolioResult(
            accept_language=self.accept_language,
            arn=self.arn,
            created_time=self.created_time,
            description=self.description,
            id=self.id,
            name=self.name,
            provider_name=self.provider_name,
            tags=self.tags)


def get_portfolio(accept_language: Optional[str] = None,
                  id: Optional[str] = None,
                  tags: Optional[Mapping[str, str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPortfolioResult:
    """
    Provides information for a Service Catalog Portfolio.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    portfolio = aws.servicecatalog.get_portfolio(id="port-07052002")
    ```


    :param str accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
    :param str id: Portfolio identifier.
           
           The following arguments are optional:
    :param Mapping[str, str] tags: Tags applied to the portfolio.
    """
    __args__ = dict()
    __args__['acceptLanguage'] = accept_language
    __args__['id'] = id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:servicecatalog/getPortfolio:getPortfolio', __args__, opts=opts, typ=GetPortfolioResult).value

    return AwaitableGetPortfolioResult(
        accept_language=pulumi.get(__ret__, 'accept_language'),
        arn=pulumi.get(__ret__, 'arn'),
        created_time=pulumi.get(__ret__, 'created_time'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        provider_name=pulumi.get(__ret__, 'provider_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_portfolio_output(accept_language: Optional[pulumi.Input[Optional[str]]] = None,
                         id: Optional[pulumi.Input[str]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPortfolioResult]:
    """
    Provides information for a Service Catalog Portfolio.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    portfolio = aws.servicecatalog.get_portfolio(id="port-07052002")
    ```


    :param str accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
    :param str id: Portfolio identifier.
           
           The following arguments are optional:
    :param Mapping[str, str] tags: Tags applied to the portfolio.
    """
    __args__ = dict()
    __args__['acceptLanguage'] = accept_language
    __args__['id'] = id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:servicecatalog/getPortfolio:getPortfolio', __args__, opts=opts, typ=GetPortfolioResult)
    return __ret__.apply(lambda __response__: GetPortfolioResult(
        accept_language=pulumi.get(__response__, 'accept_language'),
        arn=pulumi.get(__response__, 'arn'),
        created_time=pulumi.get(__response__, 'created_time'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        provider_name=pulumi.get(__response__, 'provider_name'),
        tags=pulumi.get(__response__, 'tags')))
