# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ActivityEncryptionConfiguration',
    'AliasRoutingConfiguration',
    'StateMachineEncryptionConfiguration',
    'StateMachineLoggingConfiguration',
    'StateMachineTracingConfiguration',
    'GetAliasRoutingConfigurationResult',
]

@pulumi.output_type
class ActivityEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsDataKeyReusePeriodSeconds":
            suggest = "kms_data_key_reuse_period_seconds"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActivityEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActivityEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActivityEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_data_key_reuse_period_seconds: Optional[int] = None,
                 kms_key_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param int kms_data_key_reuse_period_seconds: Maximum duration for which Activities will reuse data keys. When the period expires, Activities will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply to AWS owned KMS key.
        :param str kms_key_id: The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
        :param str type: The encryption option specified for the activity. Valid values: `AWS_KMS_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
        """
        if kms_data_key_reuse_period_seconds is not None:
            pulumi.set(__self__, "kms_data_key_reuse_period_seconds", kms_data_key_reuse_period_seconds)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="kmsDataKeyReusePeriodSeconds")
    def kms_data_key_reuse_period_seconds(self) -> Optional[int]:
        """
        Maximum duration for which Activities will reuse data keys. When the period expires, Activities will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply to AWS owned KMS key.
        """
        return pulumi.get(self, "kms_data_key_reuse_period_seconds")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The encryption option specified for the activity. Valid values: `AWS_KMS_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AliasRoutingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateMachineVersionArn":
            suggest = "state_machine_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasRoutingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasRoutingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasRoutingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state_machine_version_arn: str,
                 weight: int):
        """
        :param str state_machine_version_arn: The Amazon Resource Name (ARN) of the state machine version.
        :param int weight: Percentage of traffic routed to the state machine version.
        """
        pulumi.set(__self__, "state_machine_version_arn", state_machine_version_arn)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="stateMachineVersionArn")
    def state_machine_version_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the state machine version.
        """
        return pulumi.get(self, "state_machine_version_arn")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        Percentage of traffic routed to the state machine version.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class StateMachineEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsDataKeyReusePeriodSeconds":
            suggest = "kms_data_key_reuse_period_seconds"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_data_key_reuse_period_seconds: Optional[int] = None,
                 kms_key_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param int kms_data_key_reuse_period_seconds: Maximum duration for which Step Functions will reuse data keys. When the period expires, Step Functions will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply when `type` is `AWS_OWNED_KEY`.
        :param str kms_key_id: The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
        :param str type: The encryption option specified for the state machine. Valid values: `AWS_OWNED_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
        """
        if kms_data_key_reuse_period_seconds is not None:
            pulumi.set(__self__, "kms_data_key_reuse_period_seconds", kms_data_key_reuse_period_seconds)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="kmsDataKeyReusePeriodSeconds")
    def kms_data_key_reuse_period_seconds(self) -> Optional[int]:
        """
        Maximum duration for which Step Functions will reuse data keys. When the period expires, Step Functions will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply when `type` is `AWS_OWNED_KEY`.
        """
        return pulumi.get(self, "kms_data_key_reuse_period_seconds")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The encryption option specified for the state machine. Valid values: `AWS_OWNED_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StateMachineLoggingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeExecutionData":
            suggest = "include_execution_data"
        elif key == "logDestination":
            suggest = "log_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineLoggingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineLoggingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineLoggingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_execution_data: Optional[bool] = None,
                 level: Optional[str] = None,
                 log_destination: Optional[str] = None):
        """
        :param bool include_execution_data: Determines whether execution data is included in your log. When set to `false`, data is excluded.
        :param str level: Defines which category of execution history events are logged. Valid values: `ALL`, `ERROR`, `FATAL`, `OFF`
        :param str log_destination: Amazon Resource Name (ARN) of a CloudWatch log group. Make sure the State Machine has the correct IAM policies for logging. The ARN must end with `:*`
        """
        if include_execution_data is not None:
            pulumi.set(__self__, "include_execution_data", include_execution_data)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if log_destination is not None:
            pulumi.set(__self__, "log_destination", log_destination)

    @property
    @pulumi.getter(name="includeExecutionData")
    def include_execution_data(self) -> Optional[bool]:
        """
        Determines whether execution data is included in your log. When set to `false`, data is excluded.
        """
        return pulumi.get(self, "include_execution_data")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        Defines which category of execution history events are logged. Valid values: `ALL`, `ERROR`, `FATAL`, `OFF`
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of a CloudWatch log group. Make sure the State Machine has the correct IAM policies for logging. The ARN must end with `:*`
        """
        return pulumi.get(self, "log_destination")


@pulumi.output_type
class StateMachineTracingConfiguration(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: When set to `true`, AWS X-Ray tracing is enabled. Make sure the State Machine has the correct IAM policies for logging. See the [AWS Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/xray-iam.html) for details.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        When set to `true`, AWS X-Ray tracing is enabled. Make sure the State Machine has the correct IAM policies for logging. See the [AWS Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/xray-iam.html) for details.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetAliasRoutingConfigurationResult(dict):
    def __init__(__self__, *,
                 state_machine_version_arn: str,
                 weight: int):
        pulumi.set(__self__, "state_machine_version_arn", state_machine_version_arn)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="stateMachineVersionArn")
    def state_machine_version_arn(self) -> str:
        return pulumi.get(self, "state_machine_version_arn")

    @property
    @pulumi.getter
    def weight(self) -> int:
        return pulumi.get(self, "weight")


