# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetContactsRotationResult',
    'AwaitableGetContactsRotationResult',
    'get_contacts_rotation',
    'get_contacts_rotation_output',
]

@pulumi.output_type
class GetContactsRotationResult:
    """
    A collection of values returned by getContactsRotation.
    """
    def __init__(__self__, arn=None, contact_ids=None, id=None, name=None, recurrences=None, start_time=None, tags=None, time_zone_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if contact_ids and not isinstance(contact_ids, list):
            raise TypeError("Expected argument 'contact_ids' to be a list")
        pulumi.set(__self__, "contact_ids", contact_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recurrences and not isinstance(recurrences, list):
            raise TypeError("Expected argument 'recurrences' to be a list")
        pulumi.set(__self__, "recurrences", recurrences)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if time_zone_id and not isinstance(time_zone_id, str):
            raise TypeError("Expected argument 'time_zone_id' to be a str")
        pulumi.set(__self__, "time_zone_id", time_zone_id)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="contactIds")
    def contact_ids(self) -> Sequence[str]:
        """
        The Amazon Resource Names (ARNs) of the contacts to add to the rotation. The order in which you list the contacts is their shift order in the rotation schedule.
        """
        return pulumi.get(self, "contact_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name for the rotation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def recurrences(self) -> Sequence['outputs.GetContactsRotationRecurrenceResult']:
        """
        Information about when an on-call rotation is in effect and how long the rotation period lasts.
        """
        return pulumi.get(self, "recurrences")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The date and time, in RFC 3339 format, that the rotation goes into effect.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        A map of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> str:
        """
        The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
        """
        return pulumi.get(self, "time_zone_id")


class AwaitableGetContactsRotationResult(GetContactsRotationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContactsRotationResult(
            arn=self.arn,
            contact_ids=self.contact_ids,
            id=self.id,
            name=self.name,
            recurrences=self.recurrences,
            start_time=self.start_time,
            tags=self.tags,
            time_zone_id=self.time_zone_id)


def get_contacts_rotation(arn: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContactsRotationResult:
    """
    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssm.get_contacts_rotation(arn="arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example")
    ```


    :param str arn: The Amazon Resource Name (ARN) of the rotation.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ssm/getContactsRotation:getContactsRotation', __args__, opts=opts, typ=GetContactsRotationResult).value

    return AwaitableGetContactsRotationResult(
        arn=pulumi.get(__ret__, 'arn'),
        contact_ids=pulumi.get(__ret__, 'contact_ids'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        recurrences=pulumi.get(__ret__, 'recurrences'),
        start_time=pulumi.get(__ret__, 'start_time'),
        tags=pulumi.get(__ret__, 'tags'),
        time_zone_id=pulumi.get(__ret__, 'time_zone_id'))
def get_contacts_rotation_output(arn: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContactsRotationResult]:
    """
    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssm.get_contacts_rotation(arn="arn:aws:ssm-contacts:us-east-1:012345678910:rotation/example")
    ```


    :param str arn: The Amazon Resource Name (ARN) of the rotation.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ssm/getContactsRotation:getContactsRotation', __args__, opts=opts, typ=GetContactsRotationResult)
    return __ret__.apply(lambda __response__: GetContactsRotationResult(
        arn=pulumi.get(__response__, 'arn'),
        contact_ids=pulumi.get(__response__, 'contact_ids'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        recurrences=pulumi.get(__response__, 'recurrences'),
        start_time=pulumi.get(__response__, 'start_time'),
        tags=pulumi.get(__response__, 'tags'),
        time_zone_id=pulumi.get(__response__, 'time_zone_id')))
