# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDocumentResult',
    'AwaitableGetDocumentResult',
    'get_document',
    'get_document_output',
]

@pulumi.output_type
class GetDocumentResult:
    """
    A collection of values returned by getDocument.
    """
    def __init__(__self__, arn=None, content=None, document_format=None, document_type=None, document_version=None, id=None, name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if document_format and not isinstance(document_format, str):
            raise TypeError("Expected argument 'document_format' to be a str")
        pulumi.set(__self__, "document_format", document_format)
        if document_type and not isinstance(document_type, str):
            raise TypeError("Expected argument 'document_type' to be a str")
        pulumi.set(__self__, "document_type", document_type)
        if document_version and not isinstance(document_version, str):
            raise TypeError("Expected argument 'document_version' to be a str")
        pulumi.set(__self__, "document_version", document_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the document. If the document is an AWS managed document, this value will be set to the name of the document instead.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The content for the SSM document in JSON or YAML format.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="documentFormat")
    def document_format(self) -> Optional[str]:
        return pulumi.get(self, "document_format")

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> str:
        """
        The type of the document.
        """
        return pulumi.get(self, "document_type")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[str]:
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


class AwaitableGetDocumentResult(GetDocumentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDocumentResult(
            arn=self.arn,
            content=self.content,
            document_format=self.document_format,
            document_type=self.document_type,
            document_version=self.document_version,
            id=self.id,
            name=self.name)


def get_document(document_format: Optional[str] = None,
                 document_version: Optional[str] = None,
                 name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDocumentResult:
    """
    Gets the contents of the specified Systems Manager document.

    ## Example Usage

    To get the contents of the document owned by AWS.

    ```python
    import pulumi
    import pulumi_aws as aws

    foo = aws.ssm.get_document(name="AWS-GatherSoftwareInventory",
        document_format="YAML")
    pulumi.export("content", foo.content)
    ```

    To get the contents of the custom document.

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ssm.get_document(name=test_aws_ssm_document["name"],
        document_format="JSON")
    ```


    :param str document_format: The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
    :param str document_version: The document version.
    :param str name: The name of the document.
    """
    __args__ = dict()
    __args__['documentFormat'] = document_format
    __args__['documentVersion'] = document_version
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ssm/getDocument:getDocument', __args__, opts=opts, typ=GetDocumentResult).value

    return AwaitableGetDocumentResult(
        arn=pulumi.get(__ret__, 'arn'),
        content=pulumi.get(__ret__, 'content'),
        document_format=pulumi.get(__ret__, 'document_format'),
        document_type=pulumi.get(__ret__, 'document_type'),
        document_version=pulumi.get(__ret__, 'document_version'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_document_output(document_format: Optional[pulumi.Input[Optional[str]]] = None,
                        document_version: Optional[pulumi.Input[Optional[str]]] = None,
                        name: Optional[pulumi.Input[str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDocumentResult]:
    """
    Gets the contents of the specified Systems Manager document.

    ## Example Usage

    To get the contents of the document owned by AWS.

    ```python
    import pulumi
    import pulumi_aws as aws

    foo = aws.ssm.get_document(name="AWS-GatherSoftwareInventory",
        document_format="YAML")
    pulumi.export("content", foo.content)
    ```

    To get the contents of the custom document.

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.ssm.get_document(name=test_aws_ssm_document["name"],
        document_format="JSON")
    ```


    :param str document_format: The format of the document. Valid values: `JSON`, `TEXT`, `YAML`.
    :param str document_version: The document version.
    :param str name: The name of the document.
    """
    __args__ = dict()
    __args__['documentFormat'] = document_format
    __args__['documentVersion'] = document_version
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ssm/getDocument:getDocument', __args__, opts=opts, typ=GetDocumentResult)
    return __ret__.apply(lambda __response__: GetDocumentResult(
        arn=pulumi.get(__response__, 'arn'),
        content=pulumi.get(__response__, 'content'),
        document_format=pulumi.get(__response__, 'document_format'),
        document_type=pulumi.get(__response__, 'document_type'),
        document_version=pulumi.get(__response__, 'document_version'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
