# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, arns=None, id=None, identity_store_ids=None):
        if arns and not isinstance(arns, list):
            raise TypeError("Expected argument 'arns' to be a list")
        pulumi.set(__self__, "arns", arns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_store_ids and not isinstance(identity_store_ids, list):
            raise TypeError("Expected argument 'identity_store_ids' to be a list")
        pulumi.set(__self__, "identity_store_ids", identity_store_ids)

    @property
    @pulumi.getter
    def arns(self) -> Sequence[str]:
        """
        Set of Amazon Resource Names (ARNs) of the SSO Instances.
        """
        return pulumi.get(self, "arns")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityStoreIds")
    def identity_store_ids(self) -> Sequence[str]:
        """
        Set of identifiers of the identity stores connected to the SSO Instances.
        """
        return pulumi.get(self, "identity_store_ids")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            arns=self.arns,
            id=self.id,
            identity_store_ids=self.identity_store_ids)


def get_instances(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Use this data source to get ARNs and Identity Store IDs of Single Sign-On (SSO) Instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssoadmin.get_instances()
    pulumi.export("arn", example.arns[0])
    pulumi.export("identityStoreId", example.identity_store_ids[0])
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ssoadmin/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        arns=pulumi.get(__ret__, 'arns'),
        id=pulumi.get(__ret__, 'id'),
        identity_store_ids=pulumi.get(__ret__, 'identity_store_ids'))
def get_instances_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Use this data source to get ARNs and Identity Store IDs of Single Sign-On (SSO) Instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssoadmin.get_instances()
    pulumi.export("arn", example.arns[0])
    pulumi.export("identityStoreId", example.identity_store_ids[0])
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ssoadmin/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        arns=pulumi.get(__response__, 'arns'),
        id=pulumi.get(__response__, 'id'),
        identity_store_ids=pulumi.get(__response__, 'identity_store_ids')))
