# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPermissionSetsResult',
    'AwaitableGetPermissionSetsResult',
    'get_permission_sets',
    'get_permission_sets_output',
]

@pulumi.output_type
class GetPermissionSetsResult:
    """
    A collection of values returned by getPermissionSets.
    """
    def __init__(__self__, arns=None, id=None, instance_arn=None):
        if arns and not isinstance(arns, list):
            raise TypeError("Expected argument 'arns' to be a list")
        pulumi.set(__self__, "arns", arns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_arn and not isinstance(instance_arn, str):
            raise TypeError("Expected argument 'instance_arn' to be a str")
        pulumi.set(__self__, "instance_arn", instance_arn)

    @property
    @pulumi.getter
    def arns(self) -> Sequence[str]:
        """
        Set of string contain the ARN of all Permission Sets.
        """
        return pulumi.get(self, "arns")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> str:
        return pulumi.get(self, "instance_arn")


class AwaitableGetPermissionSetsResult(GetPermissionSetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPermissionSetsResult(
            arns=self.arns,
            id=self.id,
            instance_arn=self.instance_arn)


def get_permission_sets(instance_arn: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPermissionSetsResult:
    """
    Data source returning the ARN of all AWS SSO Admin Permission Sets.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssoadmin.get_instances()
    example_get_permission_sets = aws.ssoadmin.get_permission_sets(instance_arn=example.arns[0])
    ```


    :param str instance_arn: ARN of the SSO Instance associated with the permission set.
    """
    __args__ = dict()
    __args__['instanceArn'] = instance_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ssoadmin/getPermissionSets:getPermissionSets', __args__, opts=opts, typ=GetPermissionSetsResult).value

    return AwaitableGetPermissionSetsResult(
        arns=pulumi.get(__ret__, 'arns'),
        id=pulumi.get(__ret__, 'id'),
        instance_arn=pulumi.get(__ret__, 'instance_arn'))
def get_permission_sets_output(instance_arn: Optional[pulumi.Input[str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPermissionSetsResult]:
    """
    Data source returning the ARN of all AWS SSO Admin Permission Sets.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ssoadmin.get_instances()
    example_get_permission_sets = aws.ssoadmin.get_permission_sets(instance_arn=example.arns[0])
    ```


    :param str instance_arn: ARN of the SSO Instance associated with the permission set.
    """
    __args__ = dict()
    __args__['instanceArn'] = instance_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ssoadmin/getPermissionSets:getPermissionSets', __args__, opts=opts, typ=GetPermissionSetsResult)
    return __ret__.apply(lambda __response__: GetPermissionSetsResult(
        arns=pulumi.get(__response__, 'arns'),
        id=pulumi.get(__response__, 'id'),
        instance_arn=pulumi.get(__response__, 'instance_arn')))
