# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrustedTokenIssuerArgs', 'TrustedTokenIssuer']

@pulumi.input_type
class TrustedTokenIssuerArgs:
    def __init__(__self__, *,
                 instance_arn: pulumi.Input[str],
                 trusted_token_issuer_type: pulumi.Input[str],
                 client_token: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trusted_token_issuer_configuration: Optional[pulumi.Input['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs']] = None):
        """
        The set of arguments for constructing a TrustedTokenIssuer resource.
        :param pulumi.Input[str] instance_arn: ARN of the instance of IAM Identity Center.
        :param pulumi.Input[str] trusted_token_issuer_type: Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`
               
               The following arguments are optional:
        :param pulumi.Input[str] client_token: A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
        :param pulumi.Input[str] name: Name of the trusted token issuer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs'] trusted_token_issuer_configuration: A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
        """
        pulumi.set(__self__, "instance_arn", instance_arn)
        pulumi.set(__self__, "trusted_token_issuer_type", trusted_token_issuer_type)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trusted_token_issuer_configuration is not None:
            pulumi.set(__self__, "trusted_token_issuer_configuration", trusted_token_issuer_configuration)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[str]:
        """
        ARN of the instance of IAM Identity Center.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter(name="trustedTokenIssuerType")
    def trusted_token_issuer_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`

        The following arguments are optional:
        """
        return pulumi.get(self, "trusted_token_issuer_type")

    @trusted_token_issuer_type.setter
    def trusted_token_issuer_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "trusted_token_issuer_type", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[str]]:
        """
        A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the trusted token issuer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trustedTokenIssuerConfiguration")
    def trusted_token_issuer_configuration(self) -> Optional[pulumi.Input['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs']]:
        """
        A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
        """
        return pulumi.get(self, "trusted_token_issuer_configuration")

    @trusted_token_issuer_configuration.setter
    def trusted_token_issuer_configuration(self, value: Optional[pulumi.Input['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs']]):
        pulumi.set(self, "trusted_token_issuer_configuration", value)


@pulumi.input_type
class _TrustedTokenIssuerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trusted_token_issuer_configuration: Optional[pulumi.Input['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs']] = None,
                 trusted_token_issuer_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TrustedTokenIssuer resources.
        :param pulumi.Input[str] arn: ARN of the trusted token issuer.
        :param pulumi.Input[str] client_token: A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
        :param pulumi.Input[str] instance_arn: ARN of the instance of IAM Identity Center.
        :param pulumi.Input[str] name: Name of the trusted token issuer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs'] trusted_token_issuer_configuration: A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
        :param pulumi.Input[str] trusted_token_issuer_type: Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if instance_arn is not None:
            pulumi.set(__self__, "instance_arn", instance_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if trusted_token_issuer_configuration is not None:
            pulumi.set(__self__, "trusted_token_issuer_configuration", trusted_token_issuer_configuration)
        if trusted_token_issuer_type is not None:
            pulumi.set(__self__, "trusted_token_issuer_type", trusted_token_issuer_type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the trusted token issuer.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[str]]:
        """
        A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the instance of IAM Identity Center.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the trusted token issuer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="trustedTokenIssuerConfiguration")
    def trusted_token_issuer_configuration(self) -> Optional[pulumi.Input['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs']]:
        """
        A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
        """
        return pulumi.get(self, "trusted_token_issuer_configuration")

    @trusted_token_issuer_configuration.setter
    def trusted_token_issuer_configuration(self, value: Optional[pulumi.Input['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs']]):
        pulumi.set(self, "trusted_token_issuer_configuration", value)

    @property
    @pulumi.getter(name="trustedTokenIssuerType")
    def trusted_token_issuer_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`

        The following arguments are optional:
        """
        return pulumi.get(self, "trusted_token_issuer_type")

    @trusted_token_issuer_type.setter
    def trusted_token_issuer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trusted_token_issuer_type", value)


class TrustedTokenIssuer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trusted_token_issuer_configuration: Optional[pulumi.Input[Union['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs', 'TrustedTokenIssuerTrustedTokenIssuerConfigurationArgsDict']]] = None,
                 trusted_token_issuer_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS SSO Admin Trusted Token Issuer.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.get_instances()
        example_trusted_token_issuer = aws.ssoadmin.TrustedTokenIssuer("example",
            name="example",
            instance_arn=example.arns[0],
            trusted_token_issuer_type="OIDC_JWT",
            trusted_token_issuer_configuration={
                "oidc_jwt_configuration": {
                    "claim_attribute_path": "email",
                    "identity_store_attribute_path": "emails.value",
                    "issuer_url": "https://example.com",
                    "jwks_retrieval_option": "OPEN_ID_DISCOVERY",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import SSO Admin Trusted Token Issuer using the `id`. For example:

        ```sh
        $ pulumi import aws:ssoadmin/trustedTokenIssuer:TrustedTokenIssuer example arn:aws:sso::123456789012:trustedTokenIssuer/ssoins-lu1ye3gew4mbc7ju/tti-2657c556-9707-11ee-b9d1-0242ac120002
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_token: A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
        :param pulumi.Input[str] instance_arn: ARN of the instance of IAM Identity Center.
        :param pulumi.Input[str] name: Name of the trusted token issuer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs', 'TrustedTokenIssuerTrustedTokenIssuerConfigurationArgsDict']] trusted_token_issuer_configuration: A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
        :param pulumi.Input[str] trusted_token_issuer_type: Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrustedTokenIssuerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS SSO Admin Trusted Token Issuer.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.get_instances()
        example_trusted_token_issuer = aws.ssoadmin.TrustedTokenIssuer("example",
            name="example",
            instance_arn=example.arns[0],
            trusted_token_issuer_type="OIDC_JWT",
            trusted_token_issuer_configuration={
                "oidc_jwt_configuration": {
                    "claim_attribute_path": "email",
                    "identity_store_attribute_path": "emails.value",
                    "issuer_url": "https://example.com",
                    "jwks_retrieval_option": "OPEN_ID_DISCOVERY",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import SSO Admin Trusted Token Issuer using the `id`. For example:

        ```sh
        $ pulumi import aws:ssoadmin/trustedTokenIssuer:TrustedTokenIssuer example arn:aws:sso::123456789012:trustedTokenIssuer/ssoins-lu1ye3gew4mbc7ju/tti-2657c556-9707-11ee-b9d1-0242ac120002
        ```

        :param str resource_name: The name of the resource.
        :param TrustedTokenIssuerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrustedTokenIssuerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trusted_token_issuer_configuration: Optional[pulumi.Input[Union['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs', 'TrustedTokenIssuerTrustedTokenIssuerConfigurationArgsDict']]] = None,
                 trusted_token_issuer_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrustedTokenIssuerArgs.__new__(TrustedTokenIssuerArgs)

            __props__.__dict__["client_token"] = client_token
            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trusted_token_issuer_configuration"] = trusted_token_issuer_configuration
            if trusted_token_issuer_type is None and not opts.urn:
                raise TypeError("Missing required property 'trusted_token_issuer_type'")
            __props__.__dict__["trusted_token_issuer_type"] = trusted_token_issuer_type
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(TrustedTokenIssuer, __self__).__init__(
            'aws:ssoadmin/trustedTokenIssuer:TrustedTokenIssuer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            client_token: Optional[pulumi.Input[str]] = None,
            instance_arn: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            trusted_token_issuer_configuration: Optional[pulumi.Input[Union['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs', 'TrustedTokenIssuerTrustedTokenIssuerConfigurationArgsDict']]] = None,
            trusted_token_issuer_type: Optional[pulumi.Input[str]] = None) -> 'TrustedTokenIssuer':
        """
        Get an existing TrustedTokenIssuer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the trusted token issuer.
        :param pulumi.Input[str] client_token: A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
        :param pulumi.Input[str] instance_arn: ARN of the instance of IAM Identity Center.
        :param pulumi.Input[str] name: Name of the trusted token issuer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs', 'TrustedTokenIssuerTrustedTokenIssuerConfigurationArgsDict']] trusted_token_issuer_configuration: A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
        :param pulumi.Input[str] trusted_token_issuer_type: Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrustedTokenIssuerState.__new__(_TrustedTokenIssuerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["client_token"] = client_token
        __props__.__dict__["instance_arn"] = instance_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["trusted_token_issuer_configuration"] = trusted_token_issuer_configuration
        __props__.__dict__["trusted_token_issuer_type"] = trusted_token_issuer_type
        return TrustedTokenIssuer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the trusted token issuer.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[Optional[str]]:
        """
        A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
        """
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[str]:
        """
        ARN of the instance of IAM Identity Center.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the trusted token issuer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="trustedTokenIssuerConfiguration")
    def trusted_token_issuer_configuration(self) -> pulumi.Output[Optional['outputs.TrustedTokenIssuerTrustedTokenIssuerConfiguration']]:
        """
        A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
        """
        return pulumi.get(self, "trusted_token_issuer_configuration")

    @property
    @pulumi.getter(name="trustedTokenIssuerType")
    def trusted_token_issuer_type(self) -> pulumi.Output[str]:
        """
        Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`

        The following arguments are optional:
        """
        return pulumi.get(self, "trusted_token_issuer_type")

