# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbInstanceArgs', 'DbInstance']

@pulumi.input_type
class DbInstanceArgs:
    def __init__(__self__, *,
                 allocated_storage: pulumi.Input[int],
                 bucket: pulumi.Input[str],
                 db_instance_type: pulumi.Input[str],
                 organization: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 vpc_security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpc_subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 db_parameter_group_identifier: Optional[pulumi.Input[str]] = None,
                 db_storage_type: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 log_delivery_configuration: Optional[pulumi.Input['DbInstanceLogDeliveryConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['DbInstanceTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a DbInstance resource.
        :param pulumi.Input[int] allocated_storage: Amount of storage in GiB (gibibytes). The minimum value is 20, the maximum value is 16384.
        :param pulumi.Input[str] bucket: Name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization. Along with `organization`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[str] db_instance_type: Timestream for InfluxDB DB instance type to run InfluxDB on. Valid options are: `"db.influx.medium"`, `"db.influx.large"`, `"db.influx.xlarge"`, `"db.influx.2xlarge"`, `"db.influx.4xlarge"`, `"db.influx.8xlarge"`, `"db.influx.12xlarge"`, and `"db.influx.16xlarge"`.
        :param pulumi.Input[str] organization: Name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users. Along with `bucket`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[str] password: Password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `username`, and `organization`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[str] username: Username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen or contain two consecutive hyphens. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `organization`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: List of VPC security group IDs to associate with the DB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnet_ids: List of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different availability zones when deploying with a Multi-AZ standby.
               
               The following arguments are optional:
        :param pulumi.Input[str] db_parameter_group_identifier: ID of the DB parameter group assigned to your DB instance. If added to an existing Timestream for InfluxDB instance or given a new value, will cause an in-place update to the instance. However, if an instance already has a value for `db_parameter_group_identifier`, removing `db_parameter_group_identifier` will cause the instance to be destroyed and recreated.
        :param pulumi.Input[str] db_storage_type: Timestream for InfluxDB DB storage type to read and write InfluxDB data. You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads requirements: Influx IO Included 3000 IOPS, Influx IO Included 12000 IOPS, Influx IO Included 16000 IOPS. Valid options are: `"InfluxIOIncludedT1"`, `"InfluxIOIncludedT2"`, and `"InfluxIOIncludedT1"`. If you use `"InfluxIOIncludedT2" or "InfluxIOIncludedT3", the minimum value for `allocated_storage` is 400.
        :param pulumi.Input[str] deployment_type: Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability. Valid options are: `"SINGLE_AZ"`, `"WITH_MULTIAZ_STANDBY"`.
        :param pulumi.Input['DbInstanceLogDeliveryConfigurationArgs'] log_delivery_configuration: Configuration for sending InfluxDB engine logs to a specified S3 bucket.
        :param pulumi.Input[str] name: Name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be unique per customer and per region. The argument must start with a letter, cannot contain consecutive hyphens (`-`) and cannot end with a hyphen.
        :param pulumi.Input[bool] publicly_accessible: Configures the DB instance with a public IP to facilitate access. Other resources, such as a VPC, a subnet, an internet gateway, and a route table with routes, are also required to enabled public access, in addition to this argument. See "Usage with Public Internet Access Enabled" for an example configuration with all required resources for public internet access.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "allocated_storage", allocated_storage)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "db_instance_type", db_instance_type)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)
        pulumi.set(__self__, "vpc_subnet_ids", vpc_subnet_ids)
        if db_parameter_group_identifier is not None:
            pulumi.set(__self__, "db_parameter_group_identifier", db_parameter_group_identifier)
        if db_storage_type is not None:
            pulumi.set(__self__, "db_storage_type", db_storage_type)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if log_delivery_configuration is not None:
            pulumi.set(__self__, "log_delivery_configuration", log_delivery_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Input[int]:
        """
        Amount of storage in GiB (gibibytes). The minimum value is 20, the maximum value is 16384.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: pulumi.Input[int]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization. Along with `organization`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="dbInstanceType")
    def db_instance_type(self) -> pulumi.Input[str]:
        """
        Timestream for InfluxDB DB instance type to run InfluxDB on. Valid options are: `"db.influx.medium"`, `"db.influx.large"`, `"db.influx.xlarge"`, `"db.influx.2xlarge"`, `"db.influx.4xlarge"`, `"db.influx.8xlarge"`, `"db.influx.12xlarge"`, and `"db.influx.16xlarge"`.
        """
        return pulumi.get(self, "db_instance_type")

    @db_instance_type.setter
    def db_instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_instance_type", value)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[str]:
        """
        Name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users. Along with `bucket`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `username`, and `organization`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen or contain two consecutive hyphens. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `organization`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of VPC security group IDs to associate with the DB instance.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vpc_security_group_ids", value)

    @property
    @pulumi.getter(name="vpcSubnetIds")
    def vpc_subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different availability zones when deploying with a Multi-AZ standby.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_subnet_ids")

    @vpc_subnet_ids.setter
    def vpc_subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vpc_subnet_ids", value)

    @property
    @pulumi.getter(name="dbParameterGroupIdentifier")
    def db_parameter_group_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the DB parameter group assigned to your DB instance. If added to an existing Timestream for InfluxDB instance or given a new value, will cause an in-place update to the instance. However, if an instance already has a value for `db_parameter_group_identifier`, removing `db_parameter_group_identifier` will cause the instance to be destroyed and recreated.
        """
        return pulumi.get(self, "db_parameter_group_identifier")

    @db_parameter_group_identifier.setter
    def db_parameter_group_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_parameter_group_identifier", value)

    @property
    @pulumi.getter(name="dbStorageType")
    def db_storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Timestream for InfluxDB DB storage type to read and write InfluxDB data. You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads requirements: Influx IO Included 3000 IOPS, Influx IO Included 12000 IOPS, Influx IO Included 16000 IOPS. Valid options are: `"InfluxIOIncludedT1"`, `"InfluxIOIncludedT2"`, and `"InfluxIOIncludedT1"`. If you use `"InfluxIOIncludedT2" or "InfluxIOIncludedT3", the minimum value for `allocated_storage` is 400.
        """
        return pulumi.get(self, "db_storage_type")

    @db_storage_type.setter
    def db_storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_storage_type", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability. Valid options are: `"SINGLE_AZ"`, `"WITH_MULTIAZ_STANDBY"`.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="logDeliveryConfiguration")
    def log_delivery_configuration(self) -> Optional[pulumi.Input['DbInstanceLogDeliveryConfigurationArgs']]:
        """
        Configuration for sending InfluxDB engine logs to a specified S3 bucket.
        """
        return pulumi.get(self, "log_delivery_configuration")

    @log_delivery_configuration.setter
    def log_delivery_configuration(self, value: Optional[pulumi.Input['DbInstanceLogDeliveryConfigurationArgs']]):
        pulumi.set(self, "log_delivery_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be unique per customer and per region. The argument must start with a letter, cannot contain consecutive hyphens (`-`) and cannot end with a hyphen.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Configures the DB instance with a public IP to facilitate access. Other resources, such as a VPC, a subnet, an internet gateway, and a route table with routes, are also required to enabled public access, in addition to this argument. See "Usage with Public Internet Access Enabled" for an example configuration with all required resources for public internet access.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DbInstanceTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DbInstanceTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _DbInstanceState:
    def __init__(__self__, *,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 db_instance_type: Optional[pulumi.Input[str]] = None,
                 db_parameter_group_identifier: Optional[pulumi.Input[str]] = None,
                 db_storage_type: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 influx_auth_parameters_secret_arn: Optional[pulumi.Input[str]] = None,
                 log_delivery_configuration: Optional[pulumi.Input['DbInstanceLogDeliveryConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 secondary_availability_zone: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['DbInstanceTimeoutsArgs']] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering DbInstance resources.
        :param pulumi.Input[int] allocated_storage: Amount of storage in GiB (gibibytes). The minimum value is 20, the maximum value is 16384.
        :param pulumi.Input[str] arn: ARN of the Timestream for InfluxDB Instance.
        :param pulumi.Input[str] availability_zone: Availability Zone in which the DB instance resides.
        :param pulumi.Input[str] bucket: Name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization. Along with `organization`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[str] db_instance_type: Timestream for InfluxDB DB instance type to run InfluxDB on. Valid options are: `"db.influx.medium"`, `"db.influx.large"`, `"db.influx.xlarge"`, `"db.influx.2xlarge"`, `"db.influx.4xlarge"`, `"db.influx.8xlarge"`, `"db.influx.12xlarge"`, and `"db.influx.16xlarge"`.
        :param pulumi.Input[str] db_parameter_group_identifier: ID of the DB parameter group assigned to your DB instance. If added to an existing Timestream for InfluxDB instance or given a new value, will cause an in-place update to the instance. However, if an instance already has a value for `db_parameter_group_identifier`, removing `db_parameter_group_identifier` will cause the instance to be destroyed and recreated.
        :param pulumi.Input[str] db_storage_type: Timestream for InfluxDB DB storage type to read and write InfluxDB data. You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads requirements: Influx IO Included 3000 IOPS, Influx IO Included 12000 IOPS, Influx IO Included 16000 IOPS. Valid options are: `"InfluxIOIncludedT1"`, `"InfluxIOIncludedT2"`, and `"InfluxIOIncludedT1"`. If you use `"InfluxIOIncludedT2" or "InfluxIOIncludedT3", the minimum value for `allocated_storage` is 400.
        :param pulumi.Input[str] deployment_type: Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability. Valid options are: `"SINGLE_AZ"`, `"WITH_MULTIAZ_STANDBY"`.
        :param pulumi.Input[str] endpoint: Endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
        :param pulumi.Input[str] influx_auth_parameters_secret_arn: ARN of the AWS Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password. This secret will be read by the `timestreaminfluxdb.DbInstance` resource in order to support importing: deleting the secret or secret values can cause errors.
        :param pulumi.Input['DbInstanceLogDeliveryConfigurationArgs'] log_delivery_configuration: Configuration for sending InfluxDB engine logs to a specified S3 bucket.
        :param pulumi.Input[str] name: Name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be unique per customer and per region. The argument must start with a letter, cannot contain consecutive hyphens (`-`) and cannot end with a hyphen.
        :param pulumi.Input[str] organization: Name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users. Along with `bucket`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[str] password: Password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `username`, and `organization`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[bool] publicly_accessible: Configures the DB instance with a public IP to facilitate access. Other resources, such as a VPC, a subnet, an internet gateway, and a route table with routes, are also required to enabled public access, in addition to this argument. See "Usage with Public Internet Access Enabled" for an example configuration with all required resources for public internet access.
        :param pulumi.Input[str] secondary_availability_zone: Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] username: Username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen or contain two consecutive hyphens. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `organization`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: List of VPC security group IDs to associate with the DB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnet_ids: List of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different availability zones when deploying with a Multi-AZ standby.
               
               The following arguments are optional:
        """
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if db_instance_type is not None:
            pulumi.set(__self__, "db_instance_type", db_instance_type)
        if db_parameter_group_identifier is not None:
            pulumi.set(__self__, "db_parameter_group_identifier", db_parameter_group_identifier)
        if db_storage_type is not None:
            pulumi.set(__self__, "db_storage_type", db_storage_type)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if influx_auth_parameters_secret_arn is not None:
            pulumi.set(__self__, "influx_auth_parameters_secret_arn", influx_auth_parameters_secret_arn)
        if log_delivery_configuration is not None:
            pulumi.set(__self__, "log_delivery_configuration", log_delivery_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if secondary_availability_zone is not None:
            pulumi.set(__self__, "secondary_availability_zone", secondary_availability_zone)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)
        if vpc_subnet_ids is not None:
            pulumi.set(__self__, "vpc_subnet_ids", vpc_subnet_ids)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of storage in GiB (gibibytes). The minimum value is 20, the maximum value is 16384.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Timestream for InfluxDB Instance.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability Zone in which the DB instance resides.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization. Along with `organization`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="dbInstanceType")
    def db_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Timestream for InfluxDB DB instance type to run InfluxDB on. Valid options are: `"db.influx.medium"`, `"db.influx.large"`, `"db.influx.xlarge"`, `"db.influx.2xlarge"`, `"db.influx.4xlarge"`, `"db.influx.8xlarge"`, `"db.influx.12xlarge"`, and `"db.influx.16xlarge"`.
        """
        return pulumi.get(self, "db_instance_type")

    @db_instance_type.setter
    def db_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_instance_type", value)

    @property
    @pulumi.getter(name="dbParameterGroupIdentifier")
    def db_parameter_group_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the DB parameter group assigned to your DB instance. If added to an existing Timestream for InfluxDB instance or given a new value, will cause an in-place update to the instance. However, if an instance already has a value for `db_parameter_group_identifier`, removing `db_parameter_group_identifier` will cause the instance to be destroyed and recreated.
        """
        return pulumi.get(self, "db_parameter_group_identifier")

    @db_parameter_group_identifier.setter
    def db_parameter_group_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_parameter_group_identifier", value)

    @property
    @pulumi.getter(name="dbStorageType")
    def db_storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Timestream for InfluxDB DB storage type to read and write InfluxDB data. You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads requirements: Influx IO Included 3000 IOPS, Influx IO Included 12000 IOPS, Influx IO Included 16000 IOPS. Valid options are: `"InfluxIOIncludedT1"`, `"InfluxIOIncludedT2"`, and `"InfluxIOIncludedT1"`. If you use `"InfluxIOIncludedT2" or "InfluxIOIncludedT3", the minimum value for `allocated_storage` is 400.
        """
        return pulumi.get(self, "db_storage_type")

    @db_storage_type.setter
    def db_storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_storage_type", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability. Valid options are: `"SINGLE_AZ"`, `"WITH_MULTIAZ_STANDBY"`.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="influxAuthParametersSecretArn")
    def influx_auth_parameters_secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the AWS Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password. This secret will be read by the `timestreaminfluxdb.DbInstance` resource in order to support importing: deleting the secret or secret values can cause errors.
        """
        return pulumi.get(self, "influx_auth_parameters_secret_arn")

    @influx_auth_parameters_secret_arn.setter
    def influx_auth_parameters_secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "influx_auth_parameters_secret_arn", value)

    @property
    @pulumi.getter(name="logDeliveryConfiguration")
    def log_delivery_configuration(self) -> Optional[pulumi.Input['DbInstanceLogDeliveryConfigurationArgs']]:
        """
        Configuration for sending InfluxDB engine logs to a specified S3 bucket.
        """
        return pulumi.get(self, "log_delivery_configuration")

    @log_delivery_configuration.setter
    def log_delivery_configuration(self, value: Optional[pulumi.Input['DbInstanceLogDeliveryConfigurationArgs']]):
        pulumi.set(self, "log_delivery_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be unique per customer and per region. The argument must start with a letter, cannot contain consecutive hyphens (`-`) and cannot end with a hyphen.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users. Along with `bucket`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `username`, and `organization`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Configures the DB instance with a public IP to facilitate access. Other resources, such as a VPC, a subnet, an internet gateway, and a route table with routes, are also required to enabled public access, in addition to this argument. See "Usage with Public Internet Access Enabled" for an example configuration with all required resources for public internet access.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="secondaryAvailabilityZone")
    def secondary_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.
        """
        return pulumi.get(self, "secondary_availability_zone")

    @secondary_availability_zone.setter
    def secondary_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_availability_zone", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DbInstanceTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DbInstanceTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen or contain two consecutive hyphens. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `organization`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPC security group IDs to associate with the DB instance.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)

    @property
    @pulumi.getter(name="vpcSubnetIds")
    def vpc_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different availability zones when deploying with a Multi-AZ standby.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_subnet_ids")

    @vpc_subnet_ids.setter
    def vpc_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_subnet_ids", value)


class DbInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 db_instance_type: Optional[pulumi.Input[str]] = None,
                 db_parameter_group_identifier: Optional[pulumi.Input[str]] = None,
                 db_storage_type: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 log_delivery_configuration: Optional[pulumi.Input[Union['DbInstanceLogDeliveryConfigurationArgs', 'DbInstanceLogDeliveryConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['DbInstanceTimeoutsArgs', 'DbInstanceTimeoutsArgsDict']]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon Timestream for InfluxDB database instance.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.timestreaminfluxdb.DbInstance("example",
            allocated_storage=20,
            bucket="example-bucket-name",
            db_instance_type="db.influx.medium",
            username="admin",
            password="example-password",
            organization="organization",
            vpc_subnet_ids=[exampleid],
            vpc_security_group_ids=[example_aws_security_group["id"]],
            name="example-db-instance")
        ```

        ### Usage with Prerequisite Resources

        All Timestream for InfluxDB instances require a VPC, subnet, and security group. The following example shows how these prerequisite resources can be created and used with `timestreaminfluxdb.DbInstance`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
        example_subnet = aws.ec2.Subnet("example",
            vpc_id=example.id,
            cidr_block="10.0.1.0/24")
        example_security_group = aws.ec2.SecurityGroup("example",
            name="example",
            vpc_id=example.id)
        example_db_instance = aws.timestreaminfluxdb.DbInstance("example",
            allocated_storage=20,
            bucket="example-bucket-name",
            db_instance_type="db.influx.medium",
            username="admin",
            password="example-password",
            organization="organization",
            vpc_subnet_ids=[example_subnet.id],
            vpc_security_group_ids=[example_security_group.id],
            name="example-db-instance")
        ```

        ### Usage with S3 Log Delivery Enabled

        You can use an S3 bucket to store logs generated by your Timestream for InfluxDB instance. The following example shows what resources and arguments are required to configure an S3 bucket for logging, including the IAM policy that needs to be set in order to allow Timestream for InfluxDB to place logs in your S3 bucket. The configuration of the required VPC, security group, and subnet have been left out of the example for brevity.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket_v2 = aws.s3.BucketV2("example", bucket="example-s3-bucket")
        example = aws.iam.get_policy_document_output(statements=[{
            "actions": ["s3:PutObject"],
            "principals": [{
                "type": "Service",
                "identifiers": ["timestream-influxdb.amazonaws.com"],
            }],
            "resources": [example_bucket_v2.arn.apply(lambda arn: f"{arn}/*")],
        }])
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example_bucket_v2.id,
            policy=example.json)
        example_db_instance = aws.timestreaminfluxdb.DbInstance("example",
            allocated_storage=20,
            bucket="example-bucket-name",
            db_instance_type="db.influx.medium",
            username="admin",
            password="example-password",
            organization="organization",
            vpc_subnet_ids=[example_aws_subnet["id"]],
            vpc_security_group_ids=[example_aws_security_group["id"]],
            name="example-db-instance",
            log_delivery_configuration={
                "s3_configuration": {
                    "bucket_name": example_bucket_v2.name,
                    "enabled": True,
                },
            })
        ```

        ### Usage with MultiAZ Deployment

        To use multi-region availability, at least two subnets must be created in different availability zones and used with your Timestream for InfluxDB instance.

        ```python
        import pulumi
        import pulumi_aws as aws

        example1 = aws.ec2.Subnet("example_1",
            vpc_id=example_aws_vpc["id"],
            cidr_block="10.0.1.0/24",
            availability_zone="us-west-2a")
        example2 = aws.ec2.Subnet("example_2",
            vpc_id=example_aws_vpc["id"],
            cidr_block="10.0.2.0/24",
            availability_zone="us-west-2b")
        example = aws.timestreaminfluxdb.DbInstance("example",
            allocated_storage=20,
            bucket="example-bucket-name",
            db_instance_type="db.influx.medium",
            deployment_type="WITH_MULTIAZ_STANDBY",
            username="admin",
            password="example-password",
            organization="organization",
            vpc_subnet_ids=[
                example1.id,
                example2.id,
            ],
            vpc_security_group_ids=[example_aws_security_group["id"]],
            name="example-db-instance")
        ```

        ## Import

        Using `pulumi import`, import Timestream for InfluxDB Db Instance using its identifier. For example:

        ```sh
        $ pulumi import aws:timestreaminfluxdb/dbInstance:DbInstance example 12345abcde
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] allocated_storage: Amount of storage in GiB (gibibytes). The minimum value is 20, the maximum value is 16384.
        :param pulumi.Input[str] bucket: Name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization. Along with `organization`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[str] db_instance_type: Timestream for InfluxDB DB instance type to run InfluxDB on. Valid options are: `"db.influx.medium"`, `"db.influx.large"`, `"db.influx.xlarge"`, `"db.influx.2xlarge"`, `"db.influx.4xlarge"`, `"db.influx.8xlarge"`, `"db.influx.12xlarge"`, and `"db.influx.16xlarge"`.
        :param pulumi.Input[str] db_parameter_group_identifier: ID of the DB parameter group assigned to your DB instance. If added to an existing Timestream for InfluxDB instance or given a new value, will cause an in-place update to the instance. However, if an instance already has a value for `db_parameter_group_identifier`, removing `db_parameter_group_identifier` will cause the instance to be destroyed and recreated.
        :param pulumi.Input[str] db_storage_type: Timestream for InfluxDB DB storage type to read and write InfluxDB data. You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads requirements: Influx IO Included 3000 IOPS, Influx IO Included 12000 IOPS, Influx IO Included 16000 IOPS. Valid options are: `"InfluxIOIncludedT1"`, `"InfluxIOIncludedT2"`, and `"InfluxIOIncludedT1"`. If you use `"InfluxIOIncludedT2" or "InfluxIOIncludedT3", the minimum value for `allocated_storage` is 400.
        :param pulumi.Input[str] deployment_type: Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability. Valid options are: `"SINGLE_AZ"`, `"WITH_MULTIAZ_STANDBY"`.
        :param pulumi.Input[Union['DbInstanceLogDeliveryConfigurationArgs', 'DbInstanceLogDeliveryConfigurationArgsDict']] log_delivery_configuration: Configuration for sending InfluxDB engine logs to a specified S3 bucket.
        :param pulumi.Input[str] name: Name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be unique per customer and per region. The argument must start with a letter, cannot contain consecutive hyphens (`-`) and cannot end with a hyphen.
        :param pulumi.Input[str] organization: Name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users. Along with `bucket`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[str] password: Password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `username`, and `organization`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[bool] publicly_accessible: Configures the DB instance with a public IP to facilitate access. Other resources, such as a VPC, a subnet, an internet gateway, and a route table with routes, are also required to enabled public access, in addition to this argument. See "Usage with Public Internet Access Enabled" for an example configuration with all required resources for public internet access.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] username: Username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen or contain two consecutive hyphens. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `organization`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: List of VPC security group IDs to associate with the DB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnet_ids: List of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different availability zones when deploying with a Multi-AZ standby.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon Timestream for InfluxDB database instance.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.timestreaminfluxdb.DbInstance("example",
            allocated_storage=20,
            bucket="example-bucket-name",
            db_instance_type="db.influx.medium",
            username="admin",
            password="example-password",
            organization="organization",
            vpc_subnet_ids=[exampleid],
            vpc_security_group_ids=[example_aws_security_group["id"]],
            name="example-db-instance")
        ```

        ### Usage with Prerequisite Resources

        All Timestream for InfluxDB instances require a VPC, subnet, and security group. The following example shows how these prerequisite resources can be created and used with `timestreaminfluxdb.DbInstance`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
        example_subnet = aws.ec2.Subnet("example",
            vpc_id=example.id,
            cidr_block="10.0.1.0/24")
        example_security_group = aws.ec2.SecurityGroup("example",
            name="example",
            vpc_id=example.id)
        example_db_instance = aws.timestreaminfluxdb.DbInstance("example",
            allocated_storage=20,
            bucket="example-bucket-name",
            db_instance_type="db.influx.medium",
            username="admin",
            password="example-password",
            organization="organization",
            vpc_subnet_ids=[example_subnet.id],
            vpc_security_group_ids=[example_security_group.id],
            name="example-db-instance")
        ```

        ### Usage with S3 Log Delivery Enabled

        You can use an S3 bucket to store logs generated by your Timestream for InfluxDB instance. The following example shows what resources and arguments are required to configure an S3 bucket for logging, including the IAM policy that needs to be set in order to allow Timestream for InfluxDB to place logs in your S3 bucket. The configuration of the required VPC, security group, and subnet have been left out of the example for brevity.

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket_v2 = aws.s3.BucketV2("example", bucket="example-s3-bucket")
        example = aws.iam.get_policy_document_output(statements=[{
            "actions": ["s3:PutObject"],
            "principals": [{
                "type": "Service",
                "identifiers": ["timestream-influxdb.amazonaws.com"],
            }],
            "resources": [example_bucket_v2.arn.apply(lambda arn: f"{arn}/*")],
        }])
        example_bucket_policy = aws.s3.BucketPolicy("example",
            bucket=example_bucket_v2.id,
            policy=example.json)
        example_db_instance = aws.timestreaminfluxdb.DbInstance("example",
            allocated_storage=20,
            bucket="example-bucket-name",
            db_instance_type="db.influx.medium",
            username="admin",
            password="example-password",
            organization="organization",
            vpc_subnet_ids=[example_aws_subnet["id"]],
            vpc_security_group_ids=[example_aws_security_group["id"]],
            name="example-db-instance",
            log_delivery_configuration={
                "s3_configuration": {
                    "bucket_name": example_bucket_v2.name,
                    "enabled": True,
                },
            })
        ```

        ### Usage with MultiAZ Deployment

        To use multi-region availability, at least two subnets must be created in different availability zones and used with your Timestream for InfluxDB instance.

        ```python
        import pulumi
        import pulumi_aws as aws

        example1 = aws.ec2.Subnet("example_1",
            vpc_id=example_aws_vpc["id"],
            cidr_block="10.0.1.0/24",
            availability_zone="us-west-2a")
        example2 = aws.ec2.Subnet("example_2",
            vpc_id=example_aws_vpc["id"],
            cidr_block="10.0.2.0/24",
            availability_zone="us-west-2b")
        example = aws.timestreaminfluxdb.DbInstance("example",
            allocated_storage=20,
            bucket="example-bucket-name",
            db_instance_type="db.influx.medium",
            deployment_type="WITH_MULTIAZ_STANDBY",
            username="admin",
            password="example-password",
            organization="organization",
            vpc_subnet_ids=[
                example1.id,
                example2.id,
            ],
            vpc_security_group_ids=[example_aws_security_group["id"]],
            name="example-db-instance")
        ```

        ## Import

        Using `pulumi import`, import Timestream for InfluxDB Db Instance using its identifier. For example:

        ```sh
        $ pulumi import aws:timestreaminfluxdb/dbInstance:DbInstance example 12345abcde
        ```

        :param str resource_name: The name of the resource.
        :param DbInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 db_instance_type: Optional[pulumi.Input[str]] = None,
                 db_parameter_group_identifier: Optional[pulumi.Input[str]] = None,
                 db_storage_type: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 log_delivery_configuration: Optional[pulumi.Input[Union['DbInstanceLogDeliveryConfigurationArgs', 'DbInstanceLogDeliveryConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['DbInstanceTimeoutsArgs', 'DbInstanceTimeoutsArgsDict']]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbInstanceArgs.__new__(DbInstanceArgs)

            if allocated_storage is None and not opts.urn:
                raise TypeError("Missing required property 'allocated_storage'")
            __props__.__dict__["allocated_storage"] = allocated_storage
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if db_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_type'")
            __props__.__dict__["db_instance_type"] = db_instance_type
            __props__.__dict__["db_parameter_group_identifier"] = db_parameter_group_identifier
            __props__.__dict__["db_storage_type"] = db_storage_type
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["log_delivery_configuration"] = log_delivery_configuration
            __props__.__dict__["name"] = name
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            if vpc_security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_security_group_ids'")
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            if vpc_subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_subnet_ids'")
            __props__.__dict__["vpc_subnet_ids"] = vpc_subnet_ids
            __props__.__dict__["arn"] = None
            __props__.__dict__["availability_zone"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["influx_auth_parameters_secret_arn"] = None
            __props__.__dict__["secondary_availability_zone"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DbInstance, __self__).__init__(
            'aws:timestreaminfluxdb/dbInstance:DbInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocated_storage: Optional[pulumi.Input[int]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            db_instance_type: Optional[pulumi.Input[str]] = None,
            db_parameter_group_identifier: Optional[pulumi.Input[str]] = None,
            db_storage_type: Optional[pulumi.Input[str]] = None,
            deployment_type: Optional[pulumi.Input[str]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            influx_auth_parameters_secret_arn: Optional[pulumi.Input[str]] = None,
            log_delivery_configuration: Optional[pulumi.Input[Union['DbInstanceLogDeliveryConfigurationArgs', 'DbInstanceLogDeliveryConfigurationArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            publicly_accessible: Optional[pulumi.Input[bool]] = None,
            secondary_availability_zone: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['DbInstanceTimeoutsArgs', 'DbInstanceTimeoutsArgsDict']]] = None,
            username: Optional[pulumi.Input[str]] = None,
            vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vpc_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'DbInstance':
        """
        Get an existing DbInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] allocated_storage: Amount of storage in GiB (gibibytes). The minimum value is 20, the maximum value is 16384.
        :param pulumi.Input[str] arn: ARN of the Timestream for InfluxDB Instance.
        :param pulumi.Input[str] availability_zone: Availability Zone in which the DB instance resides.
        :param pulumi.Input[str] bucket: Name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization. Along with `organization`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[str] db_instance_type: Timestream for InfluxDB DB instance type to run InfluxDB on. Valid options are: `"db.influx.medium"`, `"db.influx.large"`, `"db.influx.xlarge"`, `"db.influx.2xlarge"`, `"db.influx.4xlarge"`, `"db.influx.8xlarge"`, `"db.influx.12xlarge"`, and `"db.influx.16xlarge"`.
        :param pulumi.Input[str] db_parameter_group_identifier: ID of the DB parameter group assigned to your DB instance. If added to an existing Timestream for InfluxDB instance or given a new value, will cause an in-place update to the instance. However, if an instance already has a value for `db_parameter_group_identifier`, removing `db_parameter_group_identifier` will cause the instance to be destroyed and recreated.
        :param pulumi.Input[str] db_storage_type: Timestream for InfluxDB DB storage type to read and write InfluxDB data. You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads requirements: Influx IO Included 3000 IOPS, Influx IO Included 12000 IOPS, Influx IO Included 16000 IOPS. Valid options are: `"InfluxIOIncludedT1"`, `"InfluxIOIncludedT2"`, and `"InfluxIOIncludedT1"`. If you use `"InfluxIOIncludedT2" or "InfluxIOIncludedT3", the minimum value for `allocated_storage` is 400.
        :param pulumi.Input[str] deployment_type: Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability. Valid options are: `"SINGLE_AZ"`, `"WITH_MULTIAZ_STANDBY"`.
        :param pulumi.Input[str] endpoint: Endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
        :param pulumi.Input[str] influx_auth_parameters_secret_arn: ARN of the AWS Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password. This secret will be read by the `timestreaminfluxdb.DbInstance` resource in order to support importing: deleting the secret or secret values can cause errors.
        :param pulumi.Input[Union['DbInstanceLogDeliveryConfigurationArgs', 'DbInstanceLogDeliveryConfigurationArgsDict']] log_delivery_configuration: Configuration for sending InfluxDB engine logs to a specified S3 bucket.
        :param pulumi.Input[str] name: Name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be unique per customer and per region. The argument must start with a letter, cannot contain consecutive hyphens (`-`) and cannot end with a hyphen.
        :param pulumi.Input[str] organization: Name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users. Along with `bucket`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[str] password: Password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `username`, and `organization`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[bool] publicly_accessible: Configures the DB instance with a public IP to facilitate access. Other resources, such as a VPC, a subnet, an internet gateway, and a route table with routes, are also required to enabled public access, in addition to this argument. See "Usage with Public Internet Access Enabled" for an example configuration with all required resources for public internet access.
        :param pulumi.Input[str] secondary_availability_zone: Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] username: Username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen or contain two consecutive hyphens. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `organization`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: List of VPC security group IDs to associate with the DB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnet_ids: List of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different availability zones when deploying with a Multi-AZ standby.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbInstanceState.__new__(_DbInstanceState)

        __props__.__dict__["allocated_storage"] = allocated_storage
        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["db_instance_type"] = db_instance_type
        __props__.__dict__["db_parameter_group_identifier"] = db_parameter_group_identifier
        __props__.__dict__["db_storage_type"] = db_storage_type
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["influx_auth_parameters_secret_arn"] = influx_auth_parameters_secret_arn
        __props__.__dict__["log_delivery_configuration"] = log_delivery_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["organization"] = organization
        __props__.__dict__["password"] = password
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["secondary_availability_zone"] = secondary_availability_zone
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["username"] = username
        __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
        __props__.__dict__["vpc_subnet_ids"] = vpc_subnet_ids
        return DbInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Output[int]:
        """
        Amount of storage in GiB (gibibytes). The minimum value is 20, the maximum value is 16384.
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Timestream for InfluxDB Instance.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Availability Zone in which the DB instance resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        Name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization. Along with `organization`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="dbInstanceType")
    def db_instance_type(self) -> pulumi.Output[str]:
        """
        Timestream for InfluxDB DB instance type to run InfluxDB on. Valid options are: `"db.influx.medium"`, `"db.influx.large"`, `"db.influx.xlarge"`, `"db.influx.2xlarge"`, `"db.influx.4xlarge"`, `"db.influx.8xlarge"`, `"db.influx.12xlarge"`, and `"db.influx.16xlarge"`.
        """
        return pulumi.get(self, "db_instance_type")

    @property
    @pulumi.getter(name="dbParameterGroupIdentifier")
    def db_parameter_group_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the DB parameter group assigned to your DB instance. If added to an existing Timestream for InfluxDB instance or given a new value, will cause an in-place update to the instance. However, if an instance already has a value for `db_parameter_group_identifier`, removing `db_parameter_group_identifier` will cause the instance to be destroyed and recreated.
        """
        return pulumi.get(self, "db_parameter_group_identifier")

    @property
    @pulumi.getter(name="dbStorageType")
    def db_storage_type(self) -> pulumi.Output[str]:
        """
        Timestream for InfluxDB DB storage type to read and write InfluxDB data. You can choose between 3 different types of provisioned Influx IOPS included storage according to your workloads requirements: Influx IO Included 3000 IOPS, Influx IO Included 12000 IOPS, Influx IO Included 16000 IOPS. Valid options are: `"InfluxIOIncludedT1"`, `"InfluxIOIncludedT2"`, and `"InfluxIOIncludedT1"`. If you use `"InfluxIOIncludedT2" or "InfluxIOIncludedT3", the minimum value for `allocated_storage` is 400.
        """
        return pulumi.get(self, "db_storage_type")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[str]:
        """
        Specifies whether the DB instance will be deployed as a standalone instance or with a Multi-AZ standby for high availability. Valid options are: `"SINGLE_AZ"`, `"WITH_MULTIAZ_STANDBY"`.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        Endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="influxAuthParametersSecretArn")
    def influx_auth_parameters_secret_arn(self) -> pulumi.Output[str]:
        """
        ARN of the AWS Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password. This secret will be read by the `timestreaminfluxdb.DbInstance` resource in order to support importing: deleting the secret or secret values can cause errors.
        """
        return pulumi.get(self, "influx_auth_parameters_secret_arn")

    @property
    @pulumi.getter(name="logDeliveryConfiguration")
    def log_delivery_configuration(self) -> pulumi.Output[Optional['outputs.DbInstanceLogDeliveryConfiguration']]:
        """
        Configuration for sending InfluxDB engine logs to a specified S3 bucket.
        """
        return pulumi.get(self, "log_delivery_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name that uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB instance names must be unique per customer and per region. The argument must start with a letter, cannot contain consecutive hyphens (`-`) and cannot end with a hyphen.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[str]:
        """
        Name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users. Along with `bucket`, `username`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `username`, and `organization`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[bool]:
        """
        Configures the DB instance with a public IP to facilitate access. Other resources, such as a VPC, a subnet, an internet gateway, and a route table with routes, are also required to enabled public access, in addition to this argument. See "Usage with Public Internet Access Enabled" for an example configuration with all required resources for public internet access.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="secondaryAvailabilityZone")
    def secondary_availability_zone(self) -> pulumi.Output[str]:
        """
        Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.
        """
        return pulumi.get(self, "secondary_availability_zone")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DbInstanceTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen or contain two consecutive hyphens. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. Along with `bucket`, `organization`, and `password`, this argument will be stored in the secret referred to by the `influx_auth_parameters_secret_arn` attribute.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of VPC security group IDs to associate with the DB instance.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @property
    @pulumi.getter(name="vpcSubnetIds")
    def vpc_subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of VPC subnet IDs to associate with the DB instance. Provide at least two VPC subnet IDs in different availability zones when deploying with a Multi-AZ standby.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_subnet_ids")

