# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTableResult',
    'AwaitableGetTableResult',
    'get_table',
    'get_table_output',
]

@pulumi.output_type
class GetTableResult:
    """
    A collection of values returned by getTable.
    """
    def __init__(__self__, arn=None, creation_time=None, database_name=None, id=None, last_updated_time=None, magnetic_store_write_properties=None, name=None, retention_properties=None, schemas=None, table_status=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if magnetic_store_write_properties and not isinstance(magnetic_store_write_properties, list):
            raise TypeError("Expected argument 'magnetic_store_write_properties' to be a list")
        pulumi.set(__self__, "magnetic_store_write_properties", magnetic_store_write_properties)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if retention_properties and not isinstance(retention_properties, list):
            raise TypeError("Expected argument 'retention_properties' to be a list")
        pulumi.set(__self__, "retention_properties", retention_properties)
        if schemas and not isinstance(schemas, list):
            raise TypeError("Expected argument 'schemas' to be a list")
        pulumi.set(__self__, "schemas", schemas)
        if table_status and not isinstance(table_status, str):
            raise TypeError("Expected argument 'table_status' to be a str")
        pulumi.set(__self__, "table_status", table_status)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN that uniquely identifies the table.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Time that table was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Name of database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> str:
        """
        Last time table was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="magneticStoreWriteProperties")
    def magnetic_store_write_properties(self) -> Sequence['outputs.GetTableMagneticStoreWritePropertyResult']:
        """
        Object containing the following attributes to desribe magnetic store writes.
        """
        return pulumi.get(self, "magnetic_store_write_properties")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retentionProperties")
    def retention_properties(self) -> Sequence['outputs.GetTableRetentionPropertyResult']:
        """
        Object containing the following attributes to describe the retention duration for the memory and magnetic stores.
        """
        return pulumi.get(self, "retention_properties")

    @property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.GetTableSchemaResult']:
        """
        Object containing the following attributes to describe the schema of the table.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="tableStatus")
    def table_status(self) -> str:
        """
        Current state of table.
        """
        return pulumi.get(self, "table_status")


class AwaitableGetTableResult(GetTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableResult(
            arn=self.arn,
            creation_time=self.creation_time,
            database_name=self.database_name,
            id=self.id,
            last_updated_time=self.last_updated_time,
            magnetic_store_write_properties=self.magnetic_store_write_properties,
            name=self.name,
            retention_properties=self.retention_properties,
            schemas=self.schemas,
            table_status=self.table_status)


def get_table(database_name: Optional[str] = None,
              name: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableResult:
    """
    Data source for managing an AWS Timestream Write Table.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.timestreamwrite.get_table(database_name=test_aws_timestreamwrite_database["databaseName"],
        name=test_aws_timestreamwrite_table["tableName"])
    ```


    :param str database_name: Name of the Timestream database.
    :param str name: Name of the Timestream table.
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:timestreamwrite/getTable:getTable', __args__, opts=opts, typ=GetTableResult).value

    return AwaitableGetTableResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        database_name=pulumi.get(__ret__, 'database_name'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        magnetic_store_write_properties=pulumi.get(__ret__, 'magnetic_store_write_properties'),
        name=pulumi.get(__ret__, 'name'),
        retention_properties=pulumi.get(__ret__, 'retention_properties'),
        schemas=pulumi.get(__ret__, 'schemas'),
        table_status=pulumi.get(__ret__, 'table_status'))
def get_table_output(database_name: Optional[pulumi.Input[str]] = None,
                     name: Optional[pulumi.Input[str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTableResult]:
    """
    Data source for managing an AWS Timestream Write Table.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.timestreamwrite.get_table(database_name=test_aws_timestreamwrite_database["databaseName"],
        name=test_aws_timestreamwrite_table["tableName"])
    ```


    :param str database_name: Name of the Timestream database.
    :param str name: Name of the Timestream table.
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:timestreamwrite/getTable:getTable', __args__, opts=opts, typ=GetTableResult)
    return __ret__.apply(lambda __response__: GetTableResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        database_name=pulumi.get(__response__, 'database_name'),
        id=pulumi.get(__response__, 'id'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        magnetic_store_write_properties=pulumi.get(__response__, 'magnetic_store_write_properties'),
        name=pulumi.get(__response__, 'name'),
        retention_properties=pulumi.get(__response__, 'retention_properties'),
        schemas=pulumi.get(__response__, 'schemas'),
        table_status=pulumi.get(__response__, 'table_status')))
