# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessHomeDirectoryMapping',
    'AccessPosixProfile',
    'ConnectorAs2Config',
    'ConnectorSftpConfig',
    'ServerEndpointDetails',
    'ServerProtocolDetails',
    'ServerS3StorageOptions',
    'ServerWorkflowDetails',
    'ServerWorkflowDetailsOnPartialUpload',
    'ServerWorkflowDetailsOnUpload',
    'UserHomeDirectoryMapping',
    'UserPosixProfile',
    'WorkflowOnExceptionStep',
    'WorkflowOnExceptionStepCopyStepDetails',
    'WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocation',
    'WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocation',
    'WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocation',
    'WorkflowOnExceptionStepCustomStepDetails',
    'WorkflowOnExceptionStepDecryptStepDetails',
    'WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocation',
    'WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocation',
    'WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocation',
    'WorkflowOnExceptionStepDeleteStepDetails',
    'WorkflowOnExceptionStepTagStepDetails',
    'WorkflowOnExceptionStepTagStepDetailsTag',
    'WorkflowStep',
    'WorkflowStepCopyStepDetails',
    'WorkflowStepCopyStepDetailsDestinationFileLocation',
    'WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocation',
    'WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocation',
    'WorkflowStepCustomStepDetails',
    'WorkflowStepDecryptStepDetails',
    'WorkflowStepDecryptStepDetailsDestinationFileLocation',
    'WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocation',
    'WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocation',
    'WorkflowStepDeleteStepDetails',
    'WorkflowStepTagStepDetails',
    'WorkflowStepTagStepDetailsTag',
    'GetConnectorAs2ConfigResult',
    'GetConnectorSftpConfigResult',
]

@pulumi.output_type
class AccessHomeDirectoryMapping(dict):
    def __init__(__self__, *,
                 entry: str,
                 target: str):
        """
        :param str entry: Represents an entry and a target.
        :param str target: Represents the map target.
        """
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def entry(self) -> str:
        """
        Represents an entry and a target.
        """
        return pulumi.get(self, "entry")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Represents the map target.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class AccessPosixProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secondaryGids":
            suggest = "secondary_gids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPosixProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPosixProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPosixProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: int,
                 uid: int,
                 secondary_gids: Optional[Sequence[int]] = None):
        """
        :param int gid: The POSIX group ID used for all EFS operations by this user.
        :param int uid: The POSIX user ID used for all EFS operations by this user.
        :param Sequence[int] secondary_gids: The secondary POSIX group IDs used for all EFS operations by this user.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if secondary_gids is not None:
            pulumi.set(__self__, "secondary_gids", secondary_gids)

    @property
    @pulumi.getter
    def gid(self) -> int:
        """
        The POSIX group ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def uid(self) -> int:
        """
        The POSIX user ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Optional[Sequence[int]]:
        """
        The secondary POSIX group IDs used for all EFS operations by this user.
        """
        return pulumi.get(self, "secondary_gids")


@pulumi.output_type
class ConnectorAs2Config(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"
        elif key == "localProfileId":
            suggest = "local_profile_id"
        elif key == "mdnResponse":
            suggest = "mdn_response"
        elif key == "partnerProfileId":
            suggest = "partner_profile_id"
        elif key == "signingAlgorithm":
            suggest = "signing_algorithm"
        elif key == "mdnSigningAlgorithm":
            suggest = "mdn_signing_algorithm"
        elif key == "messageSubject":
            suggest = "message_subject"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorAs2Config. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorAs2Config.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorAs2Config.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compression: str,
                 encryption_algorithm: str,
                 local_profile_id: str,
                 mdn_response: str,
                 partner_profile_id: str,
                 signing_algorithm: str,
                 mdn_signing_algorithm: Optional[str] = None,
                 message_subject: Optional[str] = None):
        """
        :param str compression: Specifies weather AS2 file is compressed. The valud values are ZLIB and  DISABLED.
        :param str encryption_algorithm: The algorithm that is used to encrypt the file. The valid values are AES128_CBC | AES192_CBC | AES256_CBC | NONE.
        :param str local_profile_id: The unique identifier for the AS2 local profile.
        :param str mdn_response: Used for outbound requests to determine if a partner response for transfers is synchronous or asynchronous. The valid values are SYNC and NONE.
        :param str partner_profile_id: The unique identifier for the AS2 partner profile.
        :param str signing_algorithm: The algorithm that is used to sign AS2 messages sent with the connector. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE .
        :param str mdn_signing_algorithm: The signing algorithm for the Mdn response. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE | DEFAULT.
        :param str message_subject: Used as the subject HTTP header attribute in AS2 messages that are being sent with the connector.
        """
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "local_profile_id", local_profile_id)
        pulumi.set(__self__, "mdn_response", mdn_response)
        pulumi.set(__self__, "partner_profile_id", partner_profile_id)
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        if mdn_signing_algorithm is not None:
            pulumi.set(__self__, "mdn_signing_algorithm", mdn_signing_algorithm)
        if message_subject is not None:
            pulumi.set(__self__, "message_subject", message_subject)

    @property
    @pulumi.getter
    def compression(self) -> str:
        """
        Specifies weather AS2 file is compressed. The valud values are ZLIB and  DISABLED.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> str:
        """
        The algorithm that is used to encrypt the file. The valid values are AES128_CBC | AES192_CBC | AES256_CBC | NONE.
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="localProfileId")
    def local_profile_id(self) -> str:
        """
        The unique identifier for the AS2 local profile.
        """
        return pulumi.get(self, "local_profile_id")

    @property
    @pulumi.getter(name="mdnResponse")
    def mdn_response(self) -> str:
        """
        Used for outbound requests to determine if a partner response for transfers is synchronous or asynchronous. The valid values are SYNC and NONE.
        """
        return pulumi.get(self, "mdn_response")

    @property
    @pulumi.getter(name="partnerProfileId")
    def partner_profile_id(self) -> str:
        """
        The unique identifier for the AS2 partner profile.
        """
        return pulumi.get(self, "partner_profile_id")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> str:
        """
        The algorithm that is used to sign AS2 messages sent with the connector. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE .
        """
        return pulumi.get(self, "signing_algorithm")

    @property
    @pulumi.getter(name="mdnSigningAlgorithm")
    def mdn_signing_algorithm(self) -> Optional[str]:
        """
        The signing algorithm for the Mdn response. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE | DEFAULT.
        """
        return pulumi.get(self, "mdn_signing_algorithm")

    @property
    @pulumi.getter(name="messageSubject")
    def message_subject(self) -> Optional[str]:
        """
        Used as the subject HTTP header attribute in AS2 messages that are being sent with the connector.
        """
        return pulumi.get(self, "message_subject")


@pulumi.output_type
class ConnectorSftpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustedHostKeys":
            suggest = "trusted_host_keys"
        elif key == "userSecretId":
            suggest = "user_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorSftpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorSftpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorSftpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trusted_host_keys: Optional[Sequence[str]] = None,
                 user_secret_id: Optional[str] = None):
        """
        :param Sequence[str] trusted_host_keys: A list of public portion of the host key, or keys, that are used to authenticate the user to the external server to which you are connecting.(https://docs.aws.amazon.com/transfer/latest/userguide/API_SftpConnectorConfig.html)
        :param str user_secret_id: The identifier for the secret (in AWS Secrets Manager) that contains the SFTP user's private key, password, or both. The identifier can be either the Amazon Resource Name (ARN) or the name of the secret.
        """
        if trusted_host_keys is not None:
            pulumi.set(__self__, "trusted_host_keys", trusted_host_keys)
        if user_secret_id is not None:
            pulumi.set(__self__, "user_secret_id", user_secret_id)

    @property
    @pulumi.getter(name="trustedHostKeys")
    def trusted_host_keys(self) -> Optional[Sequence[str]]:
        """
        A list of public portion of the host key, or keys, that are used to authenticate the user to the external server to which you are connecting.(https://docs.aws.amazon.com/transfer/latest/userguide/API_SftpConnectorConfig.html)
        """
        return pulumi.get(self, "trusted_host_keys")

    @property
    @pulumi.getter(name="userSecretId")
    def user_secret_id(self) -> Optional[str]:
        """
        The identifier for the secret (in AWS Secrets Manager) that contains the SFTP user's private key, password, or both. The identifier can be either the Amazon Resource Name (ARN) or the name of the secret.
        """
        return pulumi.get(self, "user_secret_id")


@pulumi.output_type
class ServerEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressAllocationIds":
            suggest = "address_allocation_ids"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcEndpointId":
            suggest = "vpc_endpoint_id"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_allocation_ids: Optional[Sequence[str]] = None,
                 security_group_ids: Optional[Sequence[str]] = None,
                 subnet_ids: Optional[Sequence[str]] = None,
                 vpc_endpoint_id: Optional[str] = None,
                 vpc_id: Optional[str] = None):
        """
        :param Sequence[str] address_allocation_ids: A list of address allocation IDs that are required to attach an Elastic IP address to your SFTP server's endpoint. This property can only be used when `endpoint_type` is set to `VPC`.
        :param Sequence[str] security_group_ids: A list of security groups IDs that are available to attach to your server's endpoint. If no security groups are specified, the VPC's default security groups are automatically assigned to your endpoint. This property can only be used when `endpoint_type` is set to `VPC`.
        :param Sequence[str] subnet_ids: A list of subnet IDs that are required to host your SFTP server endpoint in your VPC. This property can only be used when `endpoint_type` is set to `VPC`.
        :param str vpc_endpoint_id: The ID of the VPC endpoint. This property can only be used when `endpoint_type` is set to `VPC_ENDPOINT`
        :param str vpc_id: The VPC ID of the virtual private cloud in which the SFTP server's endpoint will be hosted. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        if address_allocation_ids is not None:
            pulumi.set(__self__, "address_allocation_ids", address_allocation_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="addressAllocationIds")
    def address_allocation_ids(self) -> Optional[Sequence[str]]:
        """
        A list of address allocation IDs that are required to attach an Elastic IP address to your SFTP server's endpoint. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        return pulumi.get(self, "address_allocation_ids")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        A list of security groups IDs that are available to attach to your server's endpoint. If no security groups are specified, the VPC's default security groups are automatically assigned to your endpoint. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[str]]:
        """
        A list of subnet IDs that are required to host your SFTP server endpoint in your VPC. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[str]:
        """
        The ID of the VPC endpoint. This property can only be used when `endpoint_type` is set to `VPC_ENDPOINT`
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The VPC ID of the virtual private cloud in which the SFTP server's endpoint will be hosted. This property can only be used when `endpoint_type` is set to `VPC`.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class ServerProtocolDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "as2Transports":
            suggest = "as2_transports"
        elif key == "passiveIp":
            suggest = "passive_ip"
        elif key == "setStatOption":
            suggest = "set_stat_option"
        elif key == "tlsSessionResumptionMode":
            suggest = "tls_session_resumption_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerProtocolDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerProtocolDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerProtocolDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 as2_transports: Optional[Sequence[str]] = None,
                 passive_ip: Optional[str] = None,
                 set_stat_option: Optional[str] = None,
                 tls_session_resumption_mode: Optional[str] = None):
        """
        :param Sequence[str] as2_transports: Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
        :param str passive_ip: Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
        :param str set_stat_option: Use to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket. Valid values: `DEFAULT`, `ENABLE_NO_OP`.
        :param str tls_session_resumption_mode: A property used with Transfer Family servers that use the FTPS protocol. Provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. Valid values: `DISABLED`, `ENABLED`, `ENFORCED`.
        """
        if as2_transports is not None:
            pulumi.set(__self__, "as2_transports", as2_transports)
        if passive_ip is not None:
            pulumi.set(__self__, "passive_ip", passive_ip)
        if set_stat_option is not None:
            pulumi.set(__self__, "set_stat_option", set_stat_option)
        if tls_session_resumption_mode is not None:
            pulumi.set(__self__, "tls_session_resumption_mode", tls_session_resumption_mode)

    @property
    @pulumi.getter(name="as2Transports")
    def as2_transports(self) -> Optional[Sequence[str]]:
        """
        Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
        """
        return pulumi.get(self, "as2_transports")

    @property
    @pulumi.getter(name="passiveIp")
    def passive_ip(self) -> Optional[str]:
        """
        Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
        """
        return pulumi.get(self, "passive_ip")

    @property
    @pulumi.getter(name="setStatOption")
    def set_stat_option(self) -> Optional[str]:
        """
        Use to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket. Valid values: `DEFAULT`, `ENABLE_NO_OP`.
        """
        return pulumi.get(self, "set_stat_option")

    @property
    @pulumi.getter(name="tlsSessionResumptionMode")
    def tls_session_resumption_mode(self) -> Optional[str]:
        """
        A property used with Transfer Family servers that use the FTPS protocol. Provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. Valid values: `DISABLED`, `ENABLED`, `ENFORCED`.
        """
        return pulumi.get(self, "tls_session_resumption_mode")


@pulumi.output_type
class ServerS3StorageOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryListingOptimization":
            suggest = "directory_listing_optimization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerS3StorageOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerS3StorageOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerS3StorageOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_listing_optimization: Optional[str] = None):
        """
        :param str directory_listing_optimization: Specifies whether or not performance for your Amazon S3 directories is optimized. Valid values are `DISABLED`, `ENABLED`.
               
               By default, home directory mappings have a `TYPE` of `DIRECTORY`. If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` Type to `FILE` if you want a mapping to have a file target. See [Using logical directories to simplify your Transfer Family directory structures](https://docs.aws.amazon.com/transfer/latest/userguide/logical-dir-mappings.html) for details.
        """
        if directory_listing_optimization is not None:
            pulumi.set(__self__, "directory_listing_optimization", directory_listing_optimization)

    @property
    @pulumi.getter(name="directoryListingOptimization")
    def directory_listing_optimization(self) -> Optional[str]:
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. Valid values are `DISABLED`, `ENABLED`.

        By default, home directory mappings have a `TYPE` of `DIRECTORY`. If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` Type to `FILE` if you want a mapping to have a file target. See [Using logical directories to simplify your Transfer Family directory structures](https://docs.aws.amazon.com/transfer/latest/userguide/logical-dir-mappings.html) for details.
        """
        return pulumi.get(self, "directory_listing_optimization")


@pulumi.output_type
class ServerWorkflowDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onPartialUpload":
            suggest = "on_partial_upload"
        elif key == "onUpload":
            suggest = "on_upload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerWorkflowDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerWorkflowDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerWorkflowDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_partial_upload: Optional['outputs.ServerWorkflowDetailsOnPartialUpload'] = None,
                 on_upload: Optional['outputs.ServerWorkflowDetailsOnUpload'] = None):
        """
        :param 'ServerWorkflowDetailsOnPartialUploadArgs' on_partial_upload: A trigger that starts a workflow if a file is only partially uploaded. See Workflow Detail below. See `on_partial_upload` Block below for details.
        :param 'ServerWorkflowDetailsOnUploadArgs' on_upload: A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. See `on_upload` Block below for details.
        """
        if on_partial_upload is not None:
            pulumi.set(__self__, "on_partial_upload", on_partial_upload)
        if on_upload is not None:
            pulumi.set(__self__, "on_upload", on_upload)

    @property
    @pulumi.getter(name="onPartialUpload")
    def on_partial_upload(self) -> Optional['outputs.ServerWorkflowDetailsOnPartialUpload']:
        """
        A trigger that starts a workflow if a file is only partially uploaded. See Workflow Detail below. See `on_partial_upload` Block below for details.
        """
        return pulumi.get(self, "on_partial_upload")

    @property
    @pulumi.getter(name="onUpload")
    def on_upload(self) -> Optional['outputs.ServerWorkflowDetailsOnUpload']:
        """
        A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. See `on_upload` Block below for details.
        """
        return pulumi.get(self, "on_upload")


@pulumi.output_type
class ServerWorkflowDetailsOnPartialUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "workflowId":
            suggest = "workflow_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerWorkflowDetailsOnPartialUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerWorkflowDetailsOnPartialUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerWorkflowDetailsOnPartialUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: str,
                 workflow_id: str):
        """
        :param str execution_role: Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
        :param str workflow_id: A unique identifier for the workflow.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        pulumi.set(__self__, "workflow_id", workflow_id)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> str:
        """
        Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> str:
        """
        A unique identifier for the workflow.
        """
        return pulumi.get(self, "workflow_id")


@pulumi.output_type
class ServerWorkflowDetailsOnUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "workflowId":
            suggest = "workflow_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerWorkflowDetailsOnUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerWorkflowDetailsOnUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerWorkflowDetailsOnUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: str,
                 workflow_id: str):
        """
        :param str execution_role: Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
        :param str workflow_id: A unique identifier for the workflow.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        pulumi.set(__self__, "workflow_id", workflow_id)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> str:
        """
        Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> str:
        """
        A unique identifier for the workflow.
        """
        return pulumi.get(self, "workflow_id")


@pulumi.output_type
class UserHomeDirectoryMapping(dict):
    def __init__(__self__, *,
                 entry: str,
                 target: str):
        """
        :param str entry: Represents an entry and a target.
        :param str target: Represents the map target.
               
               The `Restricted` option is achieved using the following mapping:
               
               ```
               home_directory_mappings {
               entry  = "/"
               target = "/${aws_s3_bucket.foo.id}/$${Transfer:UserName}"
               }
               ```
        """
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def entry(self) -> str:
        """
        Represents an entry and a target.
        """
        return pulumi.get(self, "entry")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Represents the map target.

        The `Restricted` option is achieved using the following mapping:

        ```
        home_directory_mappings {
        entry  = "/"
        target = "/${aws_s3_bucket.foo.id}/$${Transfer:UserName}"
        }
        ```
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class UserPosixProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secondaryGids":
            suggest = "secondary_gids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPosixProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPosixProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPosixProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: int,
                 uid: int,
                 secondary_gids: Optional[Sequence[int]] = None):
        """
        :param int gid: The POSIX group ID used for all EFS operations by this user.
        :param int uid: The POSIX user ID used for all EFS operations by this user.
        :param Sequence[int] secondary_gids: The secondary POSIX group IDs used for all EFS operations by this user.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if secondary_gids is not None:
            pulumi.set(__self__, "secondary_gids", secondary_gids)

    @property
    @pulumi.getter
    def gid(self) -> int:
        """
        The POSIX group ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def uid(self) -> int:
        """
        The POSIX user ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Optional[Sequence[int]]:
        """
        The secondary POSIX group IDs used for all EFS operations by this user.
        """
        return pulumi.get(self, "secondary_gids")


@pulumi.output_type
class WorkflowOnExceptionStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyStepDetails":
            suggest = "copy_step_details"
        elif key == "customStepDetails":
            suggest = "custom_step_details"
        elif key == "decryptStepDetails":
            suggest = "decrypt_step_details"
        elif key == "deleteStepDetails":
            suggest = "delete_step_details"
        elif key == "tagStepDetails":
            suggest = "tag_step_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 copy_step_details: Optional['outputs.WorkflowOnExceptionStepCopyStepDetails'] = None,
                 custom_step_details: Optional['outputs.WorkflowOnExceptionStepCustomStepDetails'] = None,
                 decrypt_step_details: Optional['outputs.WorkflowOnExceptionStepDecryptStepDetails'] = None,
                 delete_step_details: Optional['outputs.WorkflowOnExceptionStepDeleteStepDetails'] = None,
                 tag_step_details: Optional['outputs.WorkflowOnExceptionStepTagStepDetails'] = None):
        """
        :param 'WorkflowOnExceptionStepCopyStepDetailsArgs' copy_step_details: Details for a step that performs a file copy. See Copy Step Details below.
        :param 'WorkflowOnExceptionStepCustomStepDetailsArgs' custom_step_details: Details for a step that invokes a lambda function.
        :param 'WorkflowOnExceptionStepDecryptStepDetailsArgs' decrypt_step_details: Details for a step that decrypts the file.
        :param 'WorkflowOnExceptionStepDeleteStepDetailsArgs' delete_step_details: Details for a step that deletes the file.
        :param 'WorkflowOnExceptionStepTagStepDetailsArgs' tag_step_details: Details for a step that creates one or more tags.
        """
        pulumi.set(__self__, "type", type)
        if copy_step_details is not None:
            pulumi.set(__self__, "copy_step_details", copy_step_details)
        if custom_step_details is not None:
            pulumi.set(__self__, "custom_step_details", custom_step_details)
        if decrypt_step_details is not None:
            pulumi.set(__self__, "decrypt_step_details", decrypt_step_details)
        if delete_step_details is not None:
            pulumi.set(__self__, "delete_step_details", delete_step_details)
        if tag_step_details is not None:
            pulumi.set(__self__, "tag_step_details", tag_step_details)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="copyStepDetails")
    def copy_step_details(self) -> Optional['outputs.WorkflowOnExceptionStepCopyStepDetails']:
        """
        Details for a step that performs a file copy. See Copy Step Details below.
        """
        return pulumi.get(self, "copy_step_details")

    @property
    @pulumi.getter(name="customStepDetails")
    def custom_step_details(self) -> Optional['outputs.WorkflowOnExceptionStepCustomStepDetails']:
        """
        Details for a step that invokes a lambda function.
        """
        return pulumi.get(self, "custom_step_details")

    @property
    @pulumi.getter(name="decryptStepDetails")
    def decrypt_step_details(self) -> Optional['outputs.WorkflowOnExceptionStepDecryptStepDetails']:
        """
        Details for a step that decrypts the file.
        """
        return pulumi.get(self, "decrypt_step_details")

    @property
    @pulumi.getter(name="deleteStepDetails")
    def delete_step_details(self) -> Optional['outputs.WorkflowOnExceptionStepDeleteStepDetails']:
        """
        Details for a step that deletes the file.
        """
        return pulumi.get(self, "delete_step_details")

    @property
    @pulumi.getter(name="tagStepDetails")
    def tag_step_details(self) -> Optional['outputs.WorkflowOnExceptionStepTagStepDetails']:
        """
        Details for a step that creates one or more tags.
        """
        return pulumi.get(self, "tag_step_details")


@pulumi.output_type
class WorkflowOnExceptionStepCopyStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationFileLocation":
            suggest = "destination_file_location"
        elif key == "overwriteExisting":
            suggest = "overwrite_existing"
        elif key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStepCopyStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStepCopyStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStepCopyStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_file_location: Optional['outputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocation'] = None,
                 name: Optional[str] = None,
                 overwrite_existing: Optional[str] = None,
                 source_file_location: Optional[str] = None):
        """
        :param 'WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs' destination_file_location: Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        :param str name: The name of the step, used as an identifier.
        :param str overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional['outputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocation']:
        """
        Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        """
        return pulumi.get(self, "destination_file_location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[str]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        """
        return pulumi.get(self, "overwrite_existing")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsFileLocation":
            suggest = "efs_file_location"
        elif key == "s3FileLocation":
            suggest = "s3_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_file_location: Optional['outputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocation'] = None,
                 s3_file_location: Optional['outputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocation'] = None):
        """
        :param 'WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs' efs_file_location: Specifies the details for the EFS file being copied.
        :param 'WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs' s3_file_location: Specifies the details for the S3 file being copied.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional['outputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocation']:
        """
        Specifies the details for the EFS file being copied.
        """
        return pulumi.get(self, "efs_file_location")

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional['outputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocation']:
        """
        Specifies the details for the S3 file being copied.
        """
        return pulumi.get(self, "s3_file_location")


@pulumi.output_type
class WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str file_system_id: The ID of the file system, assigned by Amazon EFS.
        :param str path: The pathname for the folder being used by a workflow.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        """
        The ID of the file system, assigned by Amazon EFS.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The pathname for the folder being used by a workflow.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 key: Optional[str] = None):
        """
        :param str bucket: Specifies the S3 bucket for the customer input file.
        :param str key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Specifies the S3 bucket for the customer input file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class WorkflowOnExceptionStepCustomStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStepCustomStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStepCustomStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStepCustomStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 source_file_location: Optional[str] = None,
                 target: Optional[str] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param str name: The name of the step, used as an identifier.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        :param str target: The ARN for the lambda function that is being called.
        :param int timeout_seconds: Timeout, in seconds, for the step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The ARN for the lambda function that is being called.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Timeout, in seconds, for the step.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class WorkflowOnExceptionStepDecryptStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationFileLocation":
            suggest = "destination_file_location"
        elif key == "overwriteExisting":
            suggest = "overwrite_existing"
        elif key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStepDecryptStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStepDecryptStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStepDecryptStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 destination_file_location: Optional['outputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocation'] = None,
                 name: Optional[str] = None,
                 overwrite_existing: Optional[str] = None,
                 source_file_location: Optional[str] = None):
        """
        :param str type: The type of encryption used. Currently, this value must be `"PGP"`.
        :param 'WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs' destination_file_location: Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        :param str name: The name of the step, used as an identifier.
        :param str overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        pulumi.set(__self__, "type", type)
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of encryption used. Currently, this value must be `"PGP"`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional['outputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocation']:
        """
        Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        """
        return pulumi.get(self, "destination_file_location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[str]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        """
        return pulumi.get(self, "overwrite_existing")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsFileLocation":
            suggest = "efs_file_location"
        elif key == "s3FileLocation":
            suggest = "s3_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_file_location: Optional['outputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocation'] = None,
                 s3_file_location: Optional['outputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocation'] = None):
        """
        :param 'WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs' efs_file_location: Specifies the details for the EFS file being copied.
        :param 'WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs' s3_file_location: Specifies the details for the S3 file being copied.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional['outputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocation']:
        """
        Specifies the details for the EFS file being copied.
        """
        return pulumi.get(self, "efs_file_location")

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional['outputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocation']:
        """
        Specifies the details for the S3 file being copied.
        """
        return pulumi.get(self, "s3_file_location")


@pulumi.output_type
class WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str file_system_id: The ID of the file system, assigned by Amazon EFS.
        :param str path: The pathname for the folder being used by a workflow.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        """
        The ID of the file system, assigned by Amazon EFS.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The pathname for the folder being used by a workflow.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 key: Optional[str] = None):
        """
        :param str bucket: Specifies the S3 bucket for the customer input file.
        :param str key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Specifies the S3 bucket for the customer input file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class WorkflowOnExceptionStepDeleteStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStepDeleteStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStepDeleteStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStepDeleteStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 source_file_location: Optional[str] = None):
        """
        :param str name: The name of the step, used as an identifier.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowOnExceptionStepTagStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowOnExceptionStepTagStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowOnExceptionStepTagStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowOnExceptionStepTagStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 source_file_location: Optional[str] = None,
                 tags: Optional[Sequence['outputs.WorkflowOnExceptionStepTagStepDetailsTag']] = None):
        """
        :param str name: The name of the step, used as an identifier.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        :param Sequence['WorkflowOnExceptionStepTagStepDetailsTagArgs'] tags: Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.WorkflowOnExceptionStepTagStepDetailsTag']]:
        """
        Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class WorkflowOnExceptionStepTagStepDetailsTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str value: The value that corresponds to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value that corresponds to the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WorkflowStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyStepDetails":
            suggest = "copy_step_details"
        elif key == "customStepDetails":
            suggest = "custom_step_details"
        elif key == "decryptStepDetails":
            suggest = "decrypt_step_details"
        elif key == "deleteStepDetails":
            suggest = "delete_step_details"
        elif key == "tagStepDetails":
            suggest = "tag_step_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 copy_step_details: Optional['outputs.WorkflowStepCopyStepDetails'] = None,
                 custom_step_details: Optional['outputs.WorkflowStepCustomStepDetails'] = None,
                 decrypt_step_details: Optional['outputs.WorkflowStepDecryptStepDetails'] = None,
                 delete_step_details: Optional['outputs.WorkflowStepDeleteStepDetails'] = None,
                 tag_step_details: Optional['outputs.WorkflowStepTagStepDetails'] = None):
        """
        :param 'WorkflowStepCopyStepDetailsArgs' copy_step_details: Details for a step that performs a file copy. See Copy Step Details below.
        :param 'WorkflowStepCustomStepDetailsArgs' custom_step_details: Details for a step that invokes a lambda function.
        :param 'WorkflowStepDecryptStepDetailsArgs' decrypt_step_details: Details for a step that decrypts the file.
        :param 'WorkflowStepDeleteStepDetailsArgs' delete_step_details: Details for a step that deletes the file.
        :param 'WorkflowStepTagStepDetailsArgs' tag_step_details: Details for a step that creates one or more tags.
        """
        pulumi.set(__self__, "type", type)
        if copy_step_details is not None:
            pulumi.set(__self__, "copy_step_details", copy_step_details)
        if custom_step_details is not None:
            pulumi.set(__self__, "custom_step_details", custom_step_details)
        if decrypt_step_details is not None:
            pulumi.set(__self__, "decrypt_step_details", decrypt_step_details)
        if delete_step_details is not None:
            pulumi.set(__self__, "delete_step_details", delete_step_details)
        if tag_step_details is not None:
            pulumi.set(__self__, "tag_step_details", tag_step_details)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="copyStepDetails")
    def copy_step_details(self) -> Optional['outputs.WorkflowStepCopyStepDetails']:
        """
        Details for a step that performs a file copy. See Copy Step Details below.
        """
        return pulumi.get(self, "copy_step_details")

    @property
    @pulumi.getter(name="customStepDetails")
    def custom_step_details(self) -> Optional['outputs.WorkflowStepCustomStepDetails']:
        """
        Details for a step that invokes a lambda function.
        """
        return pulumi.get(self, "custom_step_details")

    @property
    @pulumi.getter(name="decryptStepDetails")
    def decrypt_step_details(self) -> Optional['outputs.WorkflowStepDecryptStepDetails']:
        """
        Details for a step that decrypts the file.
        """
        return pulumi.get(self, "decrypt_step_details")

    @property
    @pulumi.getter(name="deleteStepDetails")
    def delete_step_details(self) -> Optional['outputs.WorkflowStepDeleteStepDetails']:
        """
        Details for a step that deletes the file.
        """
        return pulumi.get(self, "delete_step_details")

    @property
    @pulumi.getter(name="tagStepDetails")
    def tag_step_details(self) -> Optional['outputs.WorkflowStepTagStepDetails']:
        """
        Details for a step that creates one or more tags.
        """
        return pulumi.get(self, "tag_step_details")


@pulumi.output_type
class WorkflowStepCopyStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationFileLocation":
            suggest = "destination_file_location"
        elif key == "overwriteExisting":
            suggest = "overwrite_existing"
        elif key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepCopyStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepCopyStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepCopyStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_file_location: Optional['outputs.WorkflowStepCopyStepDetailsDestinationFileLocation'] = None,
                 name: Optional[str] = None,
                 overwrite_existing: Optional[str] = None,
                 source_file_location: Optional[str] = None):
        """
        :param 'WorkflowStepCopyStepDetailsDestinationFileLocationArgs' destination_file_location: Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        :param str name: The name of the step, used as an identifier.
        :param str overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional['outputs.WorkflowStepCopyStepDetailsDestinationFileLocation']:
        """
        Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        """
        return pulumi.get(self, "destination_file_location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[str]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        """
        return pulumi.get(self, "overwrite_existing")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowStepCopyStepDetailsDestinationFileLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsFileLocation":
            suggest = "efs_file_location"
        elif key == "s3FileLocation":
            suggest = "s3_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepCopyStepDetailsDestinationFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepCopyStepDetailsDestinationFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepCopyStepDetailsDestinationFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_file_location: Optional['outputs.WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocation'] = None,
                 s3_file_location: Optional['outputs.WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocation'] = None):
        """
        :param 'WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs' efs_file_location: Specifies the details for the EFS file being copied.
        :param 'WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs' s3_file_location: Specifies the details for the S3 file being copied.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional['outputs.WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocation']:
        """
        Specifies the details for the EFS file being copied.
        """
        return pulumi.get(self, "efs_file_location")

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional['outputs.WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocation']:
        """
        Specifies the details for the S3 file being copied.
        """
        return pulumi.get(self, "s3_file_location")


@pulumi.output_type
class WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepCopyStepDetailsDestinationFileLocationEfsFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str file_system_id: The ID of the file system, assigned by Amazon EFS.
        :param str path: The pathname for the folder being used by a workflow.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        """
        The ID of the file system, assigned by Amazon EFS.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The pathname for the folder being used by a workflow.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class WorkflowStepCopyStepDetailsDestinationFileLocationS3FileLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 key: Optional[str] = None):
        """
        :param str bucket: Specifies the S3 bucket for the customer input file.
        :param str key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Specifies the S3 bucket for the customer input file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class WorkflowStepCustomStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepCustomStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepCustomStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepCustomStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 source_file_location: Optional[str] = None,
                 target: Optional[str] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param str name: The name of the step, used as an identifier.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        :param str target: The ARN for the lambda function that is being called.
        :param int timeout_seconds: Timeout, in seconds, for the step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The ARN for the lambda function that is being called.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Timeout, in seconds, for the step.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class WorkflowStepDecryptStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationFileLocation":
            suggest = "destination_file_location"
        elif key == "overwriteExisting":
            suggest = "overwrite_existing"
        elif key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepDecryptStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepDecryptStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepDecryptStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 destination_file_location: Optional['outputs.WorkflowStepDecryptStepDetailsDestinationFileLocation'] = None,
                 name: Optional[str] = None,
                 overwrite_existing: Optional[str] = None,
                 source_file_location: Optional[str] = None):
        """
        :param str type: The type of encryption used. Currently, this value must be `"PGP"`.
        :param 'WorkflowStepDecryptStepDetailsDestinationFileLocationArgs' destination_file_location: Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        :param str name: The name of the step, used as an identifier.
        :param str overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        pulumi.set(__self__, "type", type)
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of encryption used. Currently, this value must be `"PGP"`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional['outputs.WorkflowStepDecryptStepDetailsDestinationFileLocation']:
        """
        Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
        """
        return pulumi.get(self, "destination_file_location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[str]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
        """
        return pulumi.get(self, "overwrite_existing")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowStepDecryptStepDetailsDestinationFileLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsFileLocation":
            suggest = "efs_file_location"
        elif key == "s3FileLocation":
            suggest = "s3_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepDecryptStepDetailsDestinationFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepDecryptStepDetailsDestinationFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepDecryptStepDetailsDestinationFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_file_location: Optional['outputs.WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocation'] = None,
                 s3_file_location: Optional['outputs.WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocation'] = None):
        """
        :param 'WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs' efs_file_location: Specifies the details for the EFS file being copied.
        :param 'WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs' s3_file_location: Specifies the details for the S3 file being copied.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional['outputs.WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocation']:
        """
        Specifies the details for the EFS file being copied.
        """
        return pulumi.get(self, "efs_file_location")

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional['outputs.WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocation']:
        """
        Specifies the details for the S3 file being copied.
        """
        return pulumi.get(self, "s3_file_location")


@pulumi.output_type
class WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str file_system_id: The ID of the file system, assigned by Amazon EFS.
        :param str path: The pathname for the folder being used by a workflow.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        """
        The ID of the file system, assigned by Amazon EFS.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The pathname for the folder being used by a workflow.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 key: Optional[str] = None):
        """
        :param str bucket: Specifies the S3 bucket for the customer input file.
        :param str key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Specifies the S3 bucket for the customer input file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class WorkflowStepDeleteStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepDeleteStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepDeleteStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepDeleteStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 source_file_location: Optional[str] = None):
        """
        :param str name: The name of the step, used as an identifier.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowStepTagStepDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepTagStepDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepTagStepDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepTagStepDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 source_file_location: Optional[str] = None,
                 tags: Optional[Sequence['outputs.WorkflowStepTagStepDetailsTag']] = None):
        """
        :param str name: The name of the step, used as an identifier.
        :param str source_file_location: Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        :param Sequence['WorkflowStepTagStepDetailsTagArgs'] tags: Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
        """
        return pulumi.get(self, "source_file_location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.WorkflowStepTagStepDetailsTag']]:
        """
        Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class WorkflowStepTagStepDetailsTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str value: The value that corresponds to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value that corresponds to the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetConnectorAs2ConfigResult(dict):
    def __init__(__self__, *,
                 basic_auth_secret_id: str,
                 compression: str,
                 encryption_algorithm: str,
                 local_profile_id: str,
                 mdn_response: str,
                 mdn_signing_algorithm: str,
                 message_subject: str,
                 partner_profile_id: str,
                 singing_algorithm: str):
        """
        :param str basic_auth_secret_id: Basic authentication for AS2 connector API. Returns a null value if not set.
        :param str compression: Specifies whether AS2 file is compressed. Will be ZLIB or DISABLED
        :param str encryption_algorithm: Algorithm used to encrypt file. Will be AES128_CBC or AES192_CBC or AES256_CBC or DES_EDE3_CBC or NONE.
        :param str local_profile_id: Unique identifier for AS2 local profile.
        :param str mdn_response: Used for outbound requests to tell if response is asynchronous or not. Will be either SYNC or NONE.
        :param str mdn_signing_algorithm: Signing algorithm for MDN response. Will be SHA256 or SHA384 or SHA512 or SHA1 or NONE or DEFAULT.
        :param str message_subject: Subject HTTP header attribute in outbound AS2 messages to the connector.
        :param str partner_profile_id: Unique identifier used by connector for partner profile.
        """
        pulumi.set(__self__, "basic_auth_secret_id", basic_auth_secret_id)
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "local_profile_id", local_profile_id)
        pulumi.set(__self__, "mdn_response", mdn_response)
        pulumi.set(__self__, "mdn_signing_algorithm", mdn_signing_algorithm)
        pulumi.set(__self__, "message_subject", message_subject)
        pulumi.set(__self__, "partner_profile_id", partner_profile_id)
        pulumi.set(__self__, "singing_algorithm", singing_algorithm)

    @property
    @pulumi.getter(name="basicAuthSecretId")
    def basic_auth_secret_id(self) -> str:
        """
        Basic authentication for AS2 connector API. Returns a null value if not set.
        """
        return pulumi.get(self, "basic_auth_secret_id")

    @property
    @pulumi.getter
    def compression(self) -> str:
        """
        Specifies whether AS2 file is compressed. Will be ZLIB or DISABLED
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> str:
        """
        Algorithm used to encrypt file. Will be AES128_CBC or AES192_CBC or AES256_CBC or DES_EDE3_CBC or NONE.
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="localProfileId")
    def local_profile_id(self) -> str:
        """
        Unique identifier for AS2 local profile.
        """
        return pulumi.get(self, "local_profile_id")

    @property
    @pulumi.getter(name="mdnResponse")
    def mdn_response(self) -> str:
        """
        Used for outbound requests to tell if response is asynchronous or not. Will be either SYNC or NONE.
        """
        return pulumi.get(self, "mdn_response")

    @property
    @pulumi.getter(name="mdnSigningAlgorithm")
    def mdn_signing_algorithm(self) -> str:
        """
        Signing algorithm for MDN response. Will be SHA256 or SHA384 or SHA512 or SHA1 or NONE or DEFAULT.
        """
        return pulumi.get(self, "mdn_signing_algorithm")

    @property
    @pulumi.getter(name="messageSubject")
    def message_subject(self) -> str:
        """
        Subject HTTP header attribute in outbound AS2 messages to the connector.
        """
        return pulumi.get(self, "message_subject")

    @property
    @pulumi.getter(name="partnerProfileId")
    def partner_profile_id(self) -> str:
        """
        Unique identifier used by connector for partner profile.
        """
        return pulumi.get(self, "partner_profile_id")

    @property
    @pulumi.getter(name="singingAlgorithm")
    def singing_algorithm(self) -> str:
        return pulumi.get(self, "singing_algorithm")


@pulumi.output_type
class GetConnectorSftpConfigResult(dict):
    def __init__(__self__, *,
                 trusted_host_keys: Sequence[str],
                 user_secret_id: str):
        """
        :param Sequence[str] trusted_host_keys: List of the public portions of the host keys that are used to identify the servers the connector is connected to.
        :param str user_secret_id: Identifer for the secret in AWS Secrets Manager that contains the SFTP user's private key, and/or password.
        """
        pulumi.set(__self__, "trusted_host_keys", trusted_host_keys)
        pulumi.set(__self__, "user_secret_id", user_secret_id)

    @property
    @pulumi.getter(name="trustedHostKeys")
    def trusted_host_keys(self) -> Sequence[str]:
        """
        List of the public portions of the host keys that are used to identify the servers the connector is connected to.
        """
        return pulumi.get(self, "trusted_host_keys")

    @property
    @pulumi.getter(name="userSecretId")
    def user_secret_id(self) -> str:
        """
        Identifer for the secret in AWS Secrets Manager that contains the SFTP user's private key, and/or password.
        """
        return pulumi.get(self, "user_secret_id")


