# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FastHttpAppArgs', 'FastHttpApp']

@pulumi.input_type
class FastHttpAppArgs:
    def __init__(__self__, *,
                 application: pulumi.Input[_builtins.str],
                 tenant: pulumi.Input[_builtins.str],
                 endpoint_ltm_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 existing_monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_snat_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_waf_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 fallback_persistence: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor: Optional[pulumi.Input['FastHttpAppMonitorArgs']] = None,
                 persistence_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_members: Optional[pulumi.Input[Sequence[pulumi.Input['FastHttpAppPoolMemberArgs']]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 slow_ramp_time: Optional[pulumi.Input[_builtins.int]] = None,
                 snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 virtual_server: Optional[pulumi.Input['FastHttpAppVirtualServerArgs']] = None,
                 waf_security_policy: Optional[pulumi.Input['FastHttpAppWafSecurityPolicyArgs']] = None):
        """
        The set of arguments for constructing a FastHttpApp resource.
        :param pulumi.Input[_builtins.str] application: Name of the FAST HTTPS application.
        :param pulumi.Input[_builtins.str] tenant: Name of the FAST HTTPS application tenant.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_ltm_policies: List of LTM Policies to be applied FAST HTTP Application.
        :param pulumi.Input[_builtins.str] existing_monitor: Name of an existing BIG-IP HTTPS pool monitor. Monitors are used to determine the health of the application on each server.
        :param pulumi.Input[_builtins.str] existing_pool: Select an existing BIG-IP Pool
        :param pulumi.Input[_builtins.str] existing_snat_pool: Name of an existing BIG-IP SNAT pool.
        :param pulumi.Input[_builtins.str] existing_waf_security_policy: Name of an existing WAF Security policy.
        :param pulumi.Input[_builtins.str] fallback_persistence: Type of fallback persistence record to be created for each new client connection.
        :param pulumi.Input[_builtins.str] load_balancing_mode: A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        :param pulumi.Input['FastHttpAppMonitorArgs'] monitor: `monitor` block takes input for FAST-Generated Pool Monitor.
               See Pool Monitor below for more details.
        :param pulumi.Input[_builtins.str] persistence_profile: Name of an existing BIG-IP persistence profile to be used.
        :param pulumi.Input[_builtins.str] persistence_type: Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        :param pulumi.Input[Sequence[pulumi.Input['FastHttpAppPoolMemberArgs']]] pool_members: `pool_members` block takes input for FAST-Generated Pool.
               See Pool Members below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_log_profiles: List of security log profiles to be used for FAST application
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_discoveries: List of different cloud service discovery config provided as string, provided `service_discovery` block to Automatically Discover Pool Members with Service Discovery on different clouds.
        :param pulumi.Input[_builtins.int] slow_ramp_time: Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snat_pool_addresses: List of address to be used for FAST-Generated SNAT Pool.
        :param pulumi.Input['FastHttpAppVirtualServerArgs'] virtual_server: `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
               See virtual server below for more details.
        :param pulumi.Input['FastHttpAppWafSecurityPolicyArgs'] waf_security_policy: `waf_security_policy` block takes input for FAST-Generated WAF Security Policy.
               See WAF Security Policy below for more details.
        """
        pulumi.set(__self__, "application", application)
        pulumi.set(__self__, "tenant", tenant)
        if endpoint_ltm_policies is not None:
            pulumi.set(__self__, "endpoint_ltm_policies", endpoint_ltm_policies)
        if existing_monitor is not None:
            pulumi.set(__self__, "existing_monitor", existing_monitor)
        if existing_pool is not None:
            pulumi.set(__self__, "existing_pool", existing_pool)
        if existing_snat_pool is not None:
            pulumi.set(__self__, "existing_snat_pool", existing_snat_pool)
        if existing_waf_security_policy is not None:
            pulumi.set(__self__, "existing_waf_security_policy", existing_waf_security_policy)
        if fallback_persistence is not None:
            pulumi.set(__self__, "fallback_persistence", fallback_persistence)
        if load_balancing_mode is not None:
            pulumi.set(__self__, "load_balancing_mode", load_balancing_mode)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if persistence_profile is not None:
            pulumi.set(__self__, "persistence_profile", persistence_profile)
        if persistence_type is not None:
            pulumi.set(__self__, "persistence_type", persistence_type)
        if pool_members is not None:
            pulumi.set(__self__, "pool_members", pool_members)
        if security_log_profiles is not None:
            pulumi.set(__self__, "security_log_profiles", security_log_profiles)
        if service_discoveries is not None:
            pulumi.set(__self__, "service_discoveries", service_discoveries)
        if slow_ramp_time is not None:
            pulumi.set(__self__, "slow_ramp_time", slow_ramp_time)
        if snat_pool_addresses is not None:
            pulumi.set(__self__, "snat_pool_addresses", snat_pool_addresses)
        if virtual_server is not None:
            pulumi.set(__self__, "virtual_server", virtual_server)
        if waf_security_policy is not None:
            pulumi.set(__self__, "waf_security_policy", waf_security_policy)

    @_builtins.property
    @pulumi.getter
    def application(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the FAST HTTPS application.
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the FAST HTTPS application tenant.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="endpointLtmPolicies")
    def endpoint_ltm_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of LTM Policies to be applied FAST HTTP Application.
        """
        return pulumi.get(self, "endpoint_ltm_policies")

    @endpoint_ltm_policies.setter
    def endpoint_ltm_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_ltm_policies", value)

    @_builtins.property
    @pulumi.getter(name="existingMonitor")
    def existing_monitor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an existing BIG-IP HTTPS pool monitor. Monitors are used to determine the health of the application on each server.
        """
        return pulumi.get(self, "existing_monitor")

    @existing_monitor.setter
    def existing_monitor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_monitor", value)

    @_builtins.property
    @pulumi.getter(name="existingPool")
    def existing_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select an existing BIG-IP Pool
        """
        return pulumi.get(self, "existing_pool")

    @existing_pool.setter
    def existing_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_pool", value)

    @_builtins.property
    @pulumi.getter(name="existingSnatPool")
    def existing_snat_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an existing BIG-IP SNAT pool.
        """
        return pulumi.get(self, "existing_snat_pool")

    @existing_snat_pool.setter
    def existing_snat_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_snat_pool", value)

    @_builtins.property
    @pulumi.getter(name="existingWafSecurityPolicy")
    def existing_waf_security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an existing WAF Security policy.
        """
        return pulumi.get(self, "existing_waf_security_policy")

    @existing_waf_security_policy.setter
    def existing_waf_security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_waf_security_policy", value)

    @_builtins.property
    @pulumi.getter(name="fallbackPersistence")
    def fallback_persistence(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of fallback persistence record to be created for each new client connection.
        """
        return pulumi.get(self, "fallback_persistence")

    @fallback_persistence.setter
    def fallback_persistence(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fallback_persistence", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingMode")
    def load_balancing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        """
        return pulumi.get(self, "load_balancing_mode")

    @load_balancing_mode.setter
    def load_balancing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_mode", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['FastHttpAppMonitorArgs']]:
        """
        `monitor` block takes input for FAST-Generated Pool Monitor.
        See Pool Monitor below for more details.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['FastHttpAppMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter(name="persistenceProfile")
    def persistence_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an existing BIG-IP persistence profile to be used.
        """
        return pulumi.get(self, "persistence_profile")

    @persistence_profile.setter
    def persistence_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "persistence_profile", value)

    @_builtins.property
    @pulumi.getter(name="persistenceType")
    def persistence_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        """
        return pulumi.get(self, "persistence_type")

    @persistence_type.setter
    def persistence_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "persistence_type", value)

    @_builtins.property
    @pulumi.getter(name="poolMembers")
    def pool_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FastHttpAppPoolMemberArgs']]]]:
        """
        `pool_members` block takes input for FAST-Generated Pool.
        See Pool Members below for more details.
        """
        return pulumi.get(self, "pool_members")

    @pool_members.setter
    def pool_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FastHttpAppPoolMemberArgs']]]]):
        pulumi.set(self, "pool_members", value)

    @_builtins.property
    @pulumi.getter(name="securityLogProfiles")
    def security_log_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of security log profiles to be used for FAST application
        """
        return pulumi.get(self, "security_log_profiles")

    @security_log_profiles.setter
    def security_log_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_log_profiles", value)

    @_builtins.property
    @pulumi.getter(name="serviceDiscoveries")
    def service_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of different cloud service discovery config provided as string, provided `service_discovery` block to Automatically Discover Pool Members with Service Discovery on different clouds.
        """
        return pulumi.get(self, "service_discoveries")

    @service_discoveries.setter
    def service_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_discoveries", value)

    @_builtins.property
    @pulumi.getter(name="slowRampTime")
    def slow_ramp_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        """
        return pulumi.get(self, "slow_ramp_time")

    @slow_ramp_time.setter
    def slow_ramp_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slow_ramp_time", value)

    @_builtins.property
    @pulumi.getter(name="snatPoolAddresses")
    def snat_pool_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of address to be used for FAST-Generated SNAT Pool.
        """
        return pulumi.get(self, "snat_pool_addresses")

    @snat_pool_addresses.setter
    def snat_pool_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "snat_pool_addresses", value)

    @_builtins.property
    @pulumi.getter(name="virtualServer")
    def virtual_server(self) -> Optional[pulumi.Input['FastHttpAppVirtualServerArgs']]:
        """
        `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
        See virtual server below for more details.
        """
        return pulumi.get(self, "virtual_server")

    @virtual_server.setter
    def virtual_server(self, value: Optional[pulumi.Input['FastHttpAppVirtualServerArgs']]):
        pulumi.set(self, "virtual_server", value)

    @_builtins.property
    @pulumi.getter(name="wafSecurityPolicy")
    def waf_security_policy(self) -> Optional[pulumi.Input['FastHttpAppWafSecurityPolicyArgs']]:
        """
        `waf_security_policy` block takes input for FAST-Generated WAF Security Policy.
        See WAF Security Policy below for more details.
        """
        return pulumi.get(self, "waf_security_policy")

    @waf_security_policy.setter
    def waf_security_policy(self, value: Optional[pulumi.Input['FastHttpAppWafSecurityPolicyArgs']]):
        pulumi.set(self, "waf_security_policy", value)


@pulumi.input_type
class _FastHttpAppState:
    def __init__(__self__, *,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_ltm_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 existing_monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_snat_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_waf_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 fallback_persistence: Optional[pulumi.Input[_builtins.str]] = None,
                 fast_http_json: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor: Optional[pulumi.Input['FastHttpAppMonitorArgs']] = None,
                 persistence_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_members: Optional[pulumi.Input[Sequence[pulumi.Input['FastHttpAppPoolMemberArgs']]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 slow_ramp_time: Optional[pulumi.Input[_builtins.int]] = None,
                 snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_server: Optional[pulumi.Input['FastHttpAppVirtualServerArgs']] = None,
                 waf_security_policy: Optional[pulumi.Input['FastHttpAppWafSecurityPolicyArgs']] = None):
        """
        Input properties used for looking up and filtering FastHttpApp resources.
        :param pulumi.Input[_builtins.str] application: Name of the FAST HTTPS application.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_ltm_policies: List of LTM Policies to be applied FAST HTTP Application.
        :param pulumi.Input[_builtins.str] existing_monitor: Name of an existing BIG-IP HTTPS pool monitor. Monitors are used to determine the health of the application on each server.
        :param pulumi.Input[_builtins.str] existing_pool: Select an existing BIG-IP Pool
        :param pulumi.Input[_builtins.str] existing_snat_pool: Name of an existing BIG-IP SNAT pool.
        :param pulumi.Input[_builtins.str] existing_waf_security_policy: Name of an existing WAF Security policy.
        :param pulumi.Input[_builtins.str] fallback_persistence: Type of fallback persistence record to be created for each new client connection.
        :param pulumi.Input[_builtins.str] fast_http_json: Json payload for FAST HTTP application.
        :param pulumi.Input[_builtins.str] load_balancing_mode: A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        :param pulumi.Input['FastHttpAppMonitorArgs'] monitor: `monitor` block takes input for FAST-Generated Pool Monitor.
               See Pool Monitor below for more details.
        :param pulumi.Input[_builtins.str] persistence_profile: Name of an existing BIG-IP persistence profile to be used.
        :param pulumi.Input[_builtins.str] persistence_type: Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        :param pulumi.Input[Sequence[pulumi.Input['FastHttpAppPoolMemberArgs']]] pool_members: `pool_members` block takes input for FAST-Generated Pool.
               See Pool Members below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_log_profiles: List of security log profiles to be used for FAST application
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_discoveries: List of different cloud service discovery config provided as string, provided `service_discovery` block to Automatically Discover Pool Members with Service Discovery on different clouds.
        :param pulumi.Input[_builtins.int] slow_ramp_time: Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snat_pool_addresses: List of address to be used for FAST-Generated SNAT Pool.
        :param pulumi.Input[_builtins.str] tenant: Name of the FAST HTTPS application tenant.
        :param pulumi.Input['FastHttpAppVirtualServerArgs'] virtual_server: `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
               See virtual server below for more details.
        :param pulumi.Input['FastHttpAppWafSecurityPolicyArgs'] waf_security_policy: `waf_security_policy` block takes input for FAST-Generated WAF Security Policy.
               See WAF Security Policy below for more details.
        """
        if application is not None:
            pulumi.set(__self__, "application", application)
        if endpoint_ltm_policies is not None:
            pulumi.set(__self__, "endpoint_ltm_policies", endpoint_ltm_policies)
        if existing_monitor is not None:
            pulumi.set(__self__, "existing_monitor", existing_monitor)
        if existing_pool is not None:
            pulumi.set(__self__, "existing_pool", existing_pool)
        if existing_snat_pool is not None:
            pulumi.set(__self__, "existing_snat_pool", existing_snat_pool)
        if existing_waf_security_policy is not None:
            pulumi.set(__self__, "existing_waf_security_policy", existing_waf_security_policy)
        if fallback_persistence is not None:
            pulumi.set(__self__, "fallback_persistence", fallback_persistence)
        if fast_http_json is not None:
            pulumi.set(__self__, "fast_http_json", fast_http_json)
        if load_balancing_mode is not None:
            pulumi.set(__self__, "load_balancing_mode", load_balancing_mode)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if persistence_profile is not None:
            pulumi.set(__self__, "persistence_profile", persistence_profile)
        if persistence_type is not None:
            pulumi.set(__self__, "persistence_type", persistence_type)
        if pool_members is not None:
            pulumi.set(__self__, "pool_members", pool_members)
        if security_log_profiles is not None:
            pulumi.set(__self__, "security_log_profiles", security_log_profiles)
        if service_discoveries is not None:
            pulumi.set(__self__, "service_discoveries", service_discoveries)
        if slow_ramp_time is not None:
            pulumi.set(__self__, "slow_ramp_time", slow_ramp_time)
        if snat_pool_addresses is not None:
            pulumi.set(__self__, "snat_pool_addresses", snat_pool_addresses)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if virtual_server is not None:
            pulumi.set(__self__, "virtual_server", virtual_server)
        if waf_security_policy is not None:
            pulumi.set(__self__, "waf_security_policy", waf_security_policy)

    @_builtins.property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the FAST HTTPS application.
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application", value)

    @_builtins.property
    @pulumi.getter(name="endpointLtmPolicies")
    def endpoint_ltm_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of LTM Policies to be applied FAST HTTP Application.
        """
        return pulumi.get(self, "endpoint_ltm_policies")

    @endpoint_ltm_policies.setter
    def endpoint_ltm_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_ltm_policies", value)

    @_builtins.property
    @pulumi.getter(name="existingMonitor")
    def existing_monitor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an existing BIG-IP HTTPS pool monitor. Monitors are used to determine the health of the application on each server.
        """
        return pulumi.get(self, "existing_monitor")

    @existing_monitor.setter
    def existing_monitor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_monitor", value)

    @_builtins.property
    @pulumi.getter(name="existingPool")
    def existing_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select an existing BIG-IP Pool
        """
        return pulumi.get(self, "existing_pool")

    @existing_pool.setter
    def existing_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_pool", value)

    @_builtins.property
    @pulumi.getter(name="existingSnatPool")
    def existing_snat_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an existing BIG-IP SNAT pool.
        """
        return pulumi.get(self, "existing_snat_pool")

    @existing_snat_pool.setter
    def existing_snat_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_snat_pool", value)

    @_builtins.property
    @pulumi.getter(name="existingWafSecurityPolicy")
    def existing_waf_security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an existing WAF Security policy.
        """
        return pulumi.get(self, "existing_waf_security_policy")

    @existing_waf_security_policy.setter
    def existing_waf_security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_waf_security_policy", value)

    @_builtins.property
    @pulumi.getter(name="fallbackPersistence")
    def fallback_persistence(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of fallback persistence record to be created for each new client connection.
        """
        return pulumi.get(self, "fallback_persistence")

    @fallback_persistence.setter
    def fallback_persistence(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fallback_persistence", value)

    @_builtins.property
    @pulumi.getter(name="fastHttpJson")
    def fast_http_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Json payload for FAST HTTP application.
        """
        return pulumi.get(self, "fast_http_json")

    @fast_http_json.setter
    def fast_http_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fast_http_json", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingMode")
    def load_balancing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        """
        return pulumi.get(self, "load_balancing_mode")

    @load_balancing_mode.setter
    def load_balancing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_mode", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['FastHttpAppMonitorArgs']]:
        """
        `monitor` block takes input for FAST-Generated Pool Monitor.
        See Pool Monitor below for more details.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['FastHttpAppMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter(name="persistenceProfile")
    def persistence_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an existing BIG-IP persistence profile to be used.
        """
        return pulumi.get(self, "persistence_profile")

    @persistence_profile.setter
    def persistence_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "persistence_profile", value)

    @_builtins.property
    @pulumi.getter(name="persistenceType")
    def persistence_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        """
        return pulumi.get(self, "persistence_type")

    @persistence_type.setter
    def persistence_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "persistence_type", value)

    @_builtins.property
    @pulumi.getter(name="poolMembers")
    def pool_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FastHttpAppPoolMemberArgs']]]]:
        """
        `pool_members` block takes input for FAST-Generated Pool.
        See Pool Members below for more details.
        """
        return pulumi.get(self, "pool_members")

    @pool_members.setter
    def pool_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FastHttpAppPoolMemberArgs']]]]):
        pulumi.set(self, "pool_members", value)

    @_builtins.property
    @pulumi.getter(name="securityLogProfiles")
    def security_log_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of security log profiles to be used for FAST application
        """
        return pulumi.get(self, "security_log_profiles")

    @security_log_profiles.setter
    def security_log_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_log_profiles", value)

    @_builtins.property
    @pulumi.getter(name="serviceDiscoveries")
    def service_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of different cloud service discovery config provided as string, provided `service_discovery` block to Automatically Discover Pool Members with Service Discovery on different clouds.
        """
        return pulumi.get(self, "service_discoveries")

    @service_discoveries.setter
    def service_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_discoveries", value)

    @_builtins.property
    @pulumi.getter(name="slowRampTime")
    def slow_ramp_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        """
        return pulumi.get(self, "slow_ramp_time")

    @slow_ramp_time.setter
    def slow_ramp_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slow_ramp_time", value)

    @_builtins.property
    @pulumi.getter(name="snatPoolAddresses")
    def snat_pool_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of address to be used for FAST-Generated SNAT Pool.
        """
        return pulumi.get(self, "snat_pool_addresses")

    @snat_pool_addresses.setter
    def snat_pool_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "snat_pool_addresses", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the FAST HTTPS application tenant.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="virtualServer")
    def virtual_server(self) -> Optional[pulumi.Input['FastHttpAppVirtualServerArgs']]:
        """
        `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
        See virtual server below for more details.
        """
        return pulumi.get(self, "virtual_server")

    @virtual_server.setter
    def virtual_server(self, value: Optional[pulumi.Input['FastHttpAppVirtualServerArgs']]):
        pulumi.set(self, "virtual_server", value)

    @_builtins.property
    @pulumi.getter(name="wafSecurityPolicy")
    def waf_security_policy(self) -> Optional[pulumi.Input['FastHttpAppWafSecurityPolicyArgs']]:
        """
        `waf_security_policy` block takes input for FAST-Generated WAF Security Policy.
        See WAF Security Policy below for more details.
        """
        return pulumi.get(self, "waf_security_policy")

    @waf_security_policy.setter
    def waf_security_policy(self, value: Optional[pulumi.Input['FastHttpAppWafSecurityPolicyArgs']]):
        pulumi.set(self, "waf_security_policy", value)


@pulumi.type_token("f5bigip:index/fastHttpApp:FastHttpApp")
class FastHttpApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_ltm_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 existing_monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_snat_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_waf_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 fallback_persistence: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor: Optional[pulumi.Input[Union['FastHttpAppMonitorArgs', 'FastHttpAppMonitorArgsDict']]] = None,
                 persistence_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FastHttpAppPoolMemberArgs', 'FastHttpAppPoolMemberArgsDict']]]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 slow_ramp_time: Optional[pulumi.Input[_builtins.int]] = None,
                 snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_server: Optional[pulumi.Input[Union['FastHttpAppVirtualServerArgs', 'FastHttpAppVirtualServerArgsDict']]] = None,
                 waf_security_policy: Optional[pulumi.Input[Union['FastHttpAppWafSecurityPolicyArgs', 'FastHttpAppWafSecurityPolicyArgsDict']]] = None,
                 __props__=None):
        """
        `FastHttpApp` This resource will create and manage FAST HTTP applications on BIG-IP

        [FAST documentation](https://clouddocs.f5.com/products/extensions/f5-appsvcs-templates/latest/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        fast_http_app = f5bigip.FastHttpApp("fast_http_app",
            tenant="fasthttptenant",
            application="fasthttpapp",
            virtual_server={
                "ip": "10.30.30.44",
                "port": 443,
            })
        ```

        ### With Service Discovery

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        tc3 = f5bigip.fast.get_azure_service_discovery(resource_group="testazurerg",
            subscription_id="testazuresid",
            tag_key="testazuretag",
            tag_value="testazurevalue")
        tc3_get_gce_service_discovery = f5bigip.fast.get_gce_service_discovery(tag_key="testgcetag",
            tag_value="testgcevalue",
            region="testgceregion")
        fast_https_app = f5bigip.FastHttpApp("fast_https_app",
            tenant="fasthttptenant",
            application="fasthttpapp",
            virtual_server={
                "ip": "10.30.40.44",
                "port": 443,
            },
            pool_members=[{
                "addresses": [
                    "10.11.40.120",
                    "10.11.30.121",
                    "10.11.30.122",
                ],
                "port": 80,
            }],
            service_discoveries=[
                tc3_get_gce_service_discovery.gce_sd_json,
                tc3.azure_sd_json,
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application: Name of the FAST HTTPS application.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_ltm_policies: List of LTM Policies to be applied FAST HTTP Application.
        :param pulumi.Input[_builtins.str] existing_monitor: Name of an existing BIG-IP HTTPS pool monitor. Monitors are used to determine the health of the application on each server.
        :param pulumi.Input[_builtins.str] existing_pool: Select an existing BIG-IP Pool
        :param pulumi.Input[_builtins.str] existing_snat_pool: Name of an existing BIG-IP SNAT pool.
        :param pulumi.Input[_builtins.str] existing_waf_security_policy: Name of an existing WAF Security policy.
        :param pulumi.Input[_builtins.str] fallback_persistence: Type of fallback persistence record to be created for each new client connection.
        :param pulumi.Input[_builtins.str] load_balancing_mode: A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        :param pulumi.Input[Union['FastHttpAppMonitorArgs', 'FastHttpAppMonitorArgsDict']] monitor: `monitor` block takes input for FAST-Generated Pool Monitor.
               See Pool Monitor below for more details.
        :param pulumi.Input[_builtins.str] persistence_profile: Name of an existing BIG-IP persistence profile to be used.
        :param pulumi.Input[_builtins.str] persistence_type: Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FastHttpAppPoolMemberArgs', 'FastHttpAppPoolMemberArgsDict']]]] pool_members: `pool_members` block takes input for FAST-Generated Pool.
               See Pool Members below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_log_profiles: List of security log profiles to be used for FAST application
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_discoveries: List of different cloud service discovery config provided as string, provided `service_discovery` block to Automatically Discover Pool Members with Service Discovery on different clouds.
        :param pulumi.Input[_builtins.int] slow_ramp_time: Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snat_pool_addresses: List of address to be used for FAST-Generated SNAT Pool.
        :param pulumi.Input[_builtins.str] tenant: Name of the FAST HTTPS application tenant.
        :param pulumi.Input[Union['FastHttpAppVirtualServerArgs', 'FastHttpAppVirtualServerArgsDict']] virtual_server: `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
               See virtual server below for more details.
        :param pulumi.Input[Union['FastHttpAppWafSecurityPolicyArgs', 'FastHttpAppWafSecurityPolicyArgsDict']] waf_security_policy: `waf_security_policy` block takes input for FAST-Generated WAF Security Policy.
               See WAF Security Policy below for more details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FastHttpAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `FastHttpApp` This resource will create and manage FAST HTTP applications on BIG-IP

        [FAST documentation](https://clouddocs.f5.com/products/extensions/f5-appsvcs-templates/latest/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        fast_http_app = f5bigip.FastHttpApp("fast_http_app",
            tenant="fasthttptenant",
            application="fasthttpapp",
            virtual_server={
                "ip": "10.30.30.44",
                "port": 443,
            })
        ```

        ### With Service Discovery

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        tc3 = f5bigip.fast.get_azure_service_discovery(resource_group="testazurerg",
            subscription_id="testazuresid",
            tag_key="testazuretag",
            tag_value="testazurevalue")
        tc3_get_gce_service_discovery = f5bigip.fast.get_gce_service_discovery(tag_key="testgcetag",
            tag_value="testgcevalue",
            region="testgceregion")
        fast_https_app = f5bigip.FastHttpApp("fast_https_app",
            tenant="fasthttptenant",
            application="fasthttpapp",
            virtual_server={
                "ip": "10.30.40.44",
                "port": 443,
            },
            pool_members=[{
                "addresses": [
                    "10.11.40.120",
                    "10.11.30.121",
                    "10.11.30.122",
                ],
                "port": 80,
            }],
            service_discoveries=[
                tc3_get_gce_service_discovery.gce_sd_json,
                tc3.azure_sd_json,
            ])
        ```

        :param str resource_name: The name of the resource.
        :param FastHttpAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FastHttpAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_ltm_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 existing_monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_snat_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_waf_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 fallback_persistence: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor: Optional[pulumi.Input[Union['FastHttpAppMonitorArgs', 'FastHttpAppMonitorArgsDict']]] = None,
                 persistence_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FastHttpAppPoolMemberArgs', 'FastHttpAppPoolMemberArgsDict']]]]] = None,
                 security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 slow_ramp_time: Optional[pulumi.Input[_builtins.int]] = None,
                 snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_server: Optional[pulumi.Input[Union['FastHttpAppVirtualServerArgs', 'FastHttpAppVirtualServerArgsDict']]] = None,
                 waf_security_policy: Optional[pulumi.Input[Union['FastHttpAppWafSecurityPolicyArgs', 'FastHttpAppWafSecurityPolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FastHttpAppArgs.__new__(FastHttpAppArgs)

            if application is None and not opts.urn:
                raise TypeError("Missing required property 'application'")
            __props__.__dict__["application"] = application
            __props__.__dict__["endpoint_ltm_policies"] = endpoint_ltm_policies
            __props__.__dict__["existing_monitor"] = existing_monitor
            __props__.__dict__["existing_pool"] = existing_pool
            __props__.__dict__["existing_snat_pool"] = existing_snat_pool
            __props__.__dict__["existing_waf_security_policy"] = existing_waf_security_policy
            __props__.__dict__["fallback_persistence"] = fallback_persistence
            __props__.__dict__["load_balancing_mode"] = load_balancing_mode
            __props__.__dict__["monitor"] = monitor
            __props__.__dict__["persistence_profile"] = persistence_profile
            __props__.__dict__["persistence_type"] = persistence_type
            __props__.__dict__["pool_members"] = pool_members
            __props__.__dict__["security_log_profiles"] = security_log_profiles
            __props__.__dict__["service_discoveries"] = service_discoveries
            __props__.__dict__["slow_ramp_time"] = slow_ramp_time
            __props__.__dict__["snat_pool_addresses"] = snat_pool_addresses
            if tenant is None and not opts.urn:
                raise TypeError("Missing required property 'tenant'")
            __props__.__dict__["tenant"] = tenant
            __props__.__dict__["virtual_server"] = virtual_server
            __props__.__dict__["waf_security_policy"] = waf_security_policy
            __props__.__dict__["fast_http_json"] = None
        super(FastHttpApp, __self__).__init__(
            'f5bigip:index/fastHttpApp:FastHttpApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_ltm_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            existing_monitor: Optional[pulumi.Input[_builtins.str]] = None,
            existing_pool: Optional[pulumi.Input[_builtins.str]] = None,
            existing_snat_pool: Optional[pulumi.Input[_builtins.str]] = None,
            existing_waf_security_policy: Optional[pulumi.Input[_builtins.str]] = None,
            fallback_persistence: Optional[pulumi.Input[_builtins.str]] = None,
            fast_http_json: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
            monitor: Optional[pulumi.Input[Union['FastHttpAppMonitorArgs', 'FastHttpAppMonitorArgsDict']]] = None,
            persistence_profile: Optional[pulumi.Input[_builtins.str]] = None,
            persistence_type: Optional[pulumi.Input[_builtins.str]] = None,
            pool_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FastHttpAppPoolMemberArgs', 'FastHttpAppPoolMemberArgsDict']]]]] = None,
            security_log_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            slow_ramp_time: Optional[pulumi.Input[_builtins.int]] = None,
            snat_pool_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tenant: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_server: Optional[pulumi.Input[Union['FastHttpAppVirtualServerArgs', 'FastHttpAppVirtualServerArgsDict']]] = None,
            waf_security_policy: Optional[pulumi.Input[Union['FastHttpAppWafSecurityPolicyArgs', 'FastHttpAppWafSecurityPolicyArgsDict']]] = None) -> 'FastHttpApp':
        """
        Get an existing FastHttpApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application: Name of the FAST HTTPS application.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_ltm_policies: List of LTM Policies to be applied FAST HTTP Application.
        :param pulumi.Input[_builtins.str] existing_monitor: Name of an existing BIG-IP HTTPS pool monitor. Monitors are used to determine the health of the application on each server.
        :param pulumi.Input[_builtins.str] existing_pool: Select an existing BIG-IP Pool
        :param pulumi.Input[_builtins.str] existing_snat_pool: Name of an existing BIG-IP SNAT pool.
        :param pulumi.Input[_builtins.str] existing_waf_security_policy: Name of an existing WAF Security policy.
        :param pulumi.Input[_builtins.str] fallback_persistence: Type of fallback persistence record to be created for each new client connection.
        :param pulumi.Input[_builtins.str] fast_http_json: Json payload for FAST HTTP application.
        :param pulumi.Input[_builtins.str] load_balancing_mode: A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        :param pulumi.Input[Union['FastHttpAppMonitorArgs', 'FastHttpAppMonitorArgsDict']] monitor: `monitor` block takes input for FAST-Generated Pool Monitor.
               See Pool Monitor below for more details.
        :param pulumi.Input[_builtins.str] persistence_profile: Name of an existing BIG-IP persistence profile to be used.
        :param pulumi.Input[_builtins.str] persistence_type: Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FastHttpAppPoolMemberArgs', 'FastHttpAppPoolMemberArgsDict']]]] pool_members: `pool_members` block takes input for FAST-Generated Pool.
               See Pool Members below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_log_profiles: List of security log profiles to be used for FAST application
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_discoveries: List of different cloud service discovery config provided as string, provided `service_discovery` block to Automatically Discover Pool Members with Service Discovery on different clouds.
        :param pulumi.Input[_builtins.int] slow_ramp_time: Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] snat_pool_addresses: List of address to be used for FAST-Generated SNAT Pool.
        :param pulumi.Input[_builtins.str] tenant: Name of the FAST HTTPS application tenant.
        :param pulumi.Input[Union['FastHttpAppVirtualServerArgs', 'FastHttpAppVirtualServerArgsDict']] virtual_server: `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
               See virtual server below for more details.
        :param pulumi.Input[Union['FastHttpAppWafSecurityPolicyArgs', 'FastHttpAppWafSecurityPolicyArgsDict']] waf_security_policy: `waf_security_policy` block takes input for FAST-Generated WAF Security Policy.
               See WAF Security Policy below for more details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FastHttpAppState.__new__(_FastHttpAppState)

        __props__.__dict__["application"] = application
        __props__.__dict__["endpoint_ltm_policies"] = endpoint_ltm_policies
        __props__.__dict__["existing_monitor"] = existing_monitor
        __props__.__dict__["existing_pool"] = existing_pool
        __props__.__dict__["existing_snat_pool"] = existing_snat_pool
        __props__.__dict__["existing_waf_security_policy"] = existing_waf_security_policy
        __props__.__dict__["fallback_persistence"] = fallback_persistence
        __props__.__dict__["fast_http_json"] = fast_http_json
        __props__.__dict__["load_balancing_mode"] = load_balancing_mode
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["persistence_profile"] = persistence_profile
        __props__.__dict__["persistence_type"] = persistence_type
        __props__.__dict__["pool_members"] = pool_members
        __props__.__dict__["security_log_profiles"] = security_log_profiles
        __props__.__dict__["service_discoveries"] = service_discoveries
        __props__.__dict__["slow_ramp_time"] = slow_ramp_time
        __props__.__dict__["snat_pool_addresses"] = snat_pool_addresses
        __props__.__dict__["tenant"] = tenant
        __props__.__dict__["virtual_server"] = virtual_server
        __props__.__dict__["waf_security_policy"] = waf_security_policy
        return FastHttpApp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def application(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the FAST HTTPS application.
        """
        return pulumi.get(self, "application")

    @_builtins.property
    @pulumi.getter(name="endpointLtmPolicies")
    def endpoint_ltm_policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of LTM Policies to be applied FAST HTTP Application.
        """
        return pulumi.get(self, "endpoint_ltm_policies")

    @_builtins.property
    @pulumi.getter(name="existingMonitor")
    def existing_monitor(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of an existing BIG-IP HTTPS pool monitor. Monitors are used to determine the health of the application on each server.
        """
        return pulumi.get(self, "existing_monitor")

    @_builtins.property
    @pulumi.getter(name="existingPool")
    def existing_pool(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Select an existing BIG-IP Pool
        """
        return pulumi.get(self, "existing_pool")

    @_builtins.property
    @pulumi.getter(name="existingSnatPool")
    def existing_snat_pool(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of an existing BIG-IP SNAT pool.
        """
        return pulumi.get(self, "existing_snat_pool")

    @_builtins.property
    @pulumi.getter(name="existingWafSecurityPolicy")
    def existing_waf_security_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of an existing WAF Security policy.
        """
        return pulumi.get(self, "existing_waf_security_policy")

    @_builtins.property
    @pulumi.getter(name="fallbackPersistence")
    def fallback_persistence(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of fallback persistence record to be created for each new client connection.
        """
        return pulumi.get(self, "fallback_persistence")

    @_builtins.property
    @pulumi.getter(name="fastHttpJson")
    def fast_http_json(self) -> pulumi.Output[_builtins.str]:
        """
        Json payload for FAST HTTP application.
        """
        return pulumi.get(self, "fast_http_json")

    @_builtins.property
    @pulumi.getter(name="loadBalancingMode")
    def load_balancing_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A `load balancing method` is an algorithm that the BIG-IP system uses to select a pool member for processing a request. F5 recommends the Least Connections load balancing method
        """
        return pulumi.get(self, "load_balancing_mode")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional['outputs.FastHttpAppMonitor']]:
        """
        `monitor` block takes input for FAST-Generated Pool Monitor.
        See Pool Monitor below for more details.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter(name="persistenceProfile")
    def persistence_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of an existing BIG-IP persistence profile to be used.
        """
        return pulumi.get(self, "persistence_profile")

    @_builtins.property
    @pulumi.getter(name="persistenceType")
    def persistence_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of persistence profile to be created. Using this option will enable use of FAST generated persistence profiles.
        """
        return pulumi.get(self, "persistence_type")

    @_builtins.property
    @pulumi.getter(name="poolMembers")
    def pool_members(self) -> pulumi.Output[Sequence['outputs.FastHttpAppPoolMember']]:
        """
        `pool_members` block takes input for FAST-Generated Pool.
        See Pool Members below for more details.
        """
        return pulumi.get(self, "pool_members")

    @_builtins.property
    @pulumi.getter(name="securityLogProfiles")
    def security_log_profiles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of security log profiles to be used for FAST application
        """
        return pulumi.get(self, "security_log_profiles")

    @_builtins.property
    @pulumi.getter(name="serviceDiscoveries")
    def service_discoveries(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of different cloud service discovery config provided as string, provided `service_discovery` block to Automatically Discover Pool Members with Service Discovery on different clouds.
        """
        return pulumi.get(self, "service_discoveries")

    @_builtins.property
    @pulumi.getter(name="slowRampTime")
    def slow_ramp_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Slow ramp temporarily throttles the number of connections to a new pool member. The recommended value is 300 seconds
        """
        return pulumi.get(self, "slow_ramp_time")

    @_builtins.property
    @pulumi.getter(name="snatPoolAddresses")
    def snat_pool_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of address to be used for FAST-Generated SNAT Pool.
        """
        return pulumi.get(self, "snat_pool_addresses")

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the FAST HTTPS application tenant.
        """
        return pulumi.get(self, "tenant")

    @_builtins.property
    @pulumi.getter(name="virtualServer")
    def virtual_server(self) -> pulumi.Output[Optional['outputs.FastHttpAppVirtualServer']]:
        """
        `virtual_server` block will provide `ip` and `port` options to be used for virtual server.
        See virtual server below for more details.
        """
        return pulumi.get(self, "virtual_server")

    @_builtins.property
    @pulumi.getter(name="wafSecurityPolicy")
    def waf_security_policy(self) -> pulumi.Output[Optional['outputs.FastHttpAppWafSecurityPolicy']]:
        """
        `waf_security_policy` block takes input for FAST-Generated WAF Security Policy.
        See WAF Security Policy below for more details.
        """
        return pulumi.get(self, "waf_security_policy")

