# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetIruleResult',
    'AwaitableGetIruleResult',
    'get_irule',
    'get_irule_output',
]

@pulumi.output_type
class GetIruleResult:
    """
    A collection of values returned by getIrule.
    """
    def __init__(__self__, id=None, irule=None, name=None, partition=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if irule and not isinstance(irule, str):
            raise TypeError("Expected argument 'irule' to be a str")
        pulumi.set(__self__, "irule", irule)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def irule(self) -> Optional[_builtins.str]:
        """
        Irule configured on bigip
        """
        return pulumi.get(self, "irule")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of irule configured on bigip with full path
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> _builtins.str:
        """
        Bigip partition in which rule is configured
        """
        return pulumi.get(self, "partition")


class AwaitableGetIruleResult(GetIruleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIruleResult(
            id=self.id,
            irule=self.irule,
            name=self.name,
            partition=self.partition)


def get_irule(irule: Optional[_builtins.str] = None,
              name: Optional[_builtins.str] = None,
              partition: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIruleResult:
    """
    Use this data source (`ltm.IRule`) to get the ltm irule details available on BIG-IP

    ## Example Usage

    ```python
    import pulumi
    import pulumi_f5bigip as f5bigip

    test = f5bigip.ltm.get_irule(name="terraform_irule",
        partition="Common")
    pulumi.export("bigipIrule", test.irule)
    ```


    :param _builtins.str irule: Irule configured on bigip
    :param _builtins.str name: Name of the irule
    :param _builtins.str partition: partition of the ltm irule
    """
    __args__ = dict()
    __args__['irule'] = irule
    __args__['name'] = name
    __args__['partition'] = partition
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('f5bigip:ltm/getIrule:getIrule', __args__, opts=opts, typ=GetIruleResult).value

    return AwaitableGetIruleResult(
        id=pulumi.get(__ret__, 'id'),
        irule=pulumi.get(__ret__, 'irule'),
        name=pulumi.get(__ret__, 'name'),
        partition=pulumi.get(__ret__, 'partition'))
def get_irule_output(irule: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name: Optional[pulumi.Input[_builtins.str]] = None,
                     partition: Optional[pulumi.Input[_builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIruleResult]:
    """
    Use this data source (`ltm.IRule`) to get the ltm irule details available on BIG-IP

    ## Example Usage

    ```python
    import pulumi
    import pulumi_f5bigip as f5bigip

    test = f5bigip.ltm.get_irule(name="terraform_irule",
        partition="Common")
    pulumi.export("bigipIrule", test.irule)
    ```


    :param _builtins.str irule: Irule configured on bigip
    :param _builtins.str name: Name of the irule
    :param _builtins.str partition: partition of the ltm irule
    """
    __args__ = dict()
    __args__['irule'] = irule
    __args__['name'] = name
    __args__['partition'] = partition
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('f5bigip:ltm/getIrule:getIrule', __args__, opts=opts, typ=GetIruleResult)
    return __ret__.apply(lambda __response__: GetIruleResult(
        id=pulumi.get(__response__, 'id'),
        irule=pulumi.get(__response__, 'irule'),
        name=pulumi.get(__response__, 'name'),
        partition=pulumi.get(__response__, 'partition')))
