# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProfileBotDefenseArgs', 'ProfileBotDefense']

@pulumi.input_type
class ProfileBotDefenseArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProfileBotDefense resource.
        :param pulumi.Input[_builtins.str] name: Name of the Bot Defense profile
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log`
               profile
        :param pulumi.Input[_builtins.str] description: User defined description for Bot Defense profile
        :param pulumi.Input[_builtins.str] enforcement_mode: Select the enforcement mode, possible values are `transparent` and `blocking`.
        :param pulumi.Input[_builtins.str] template: Profile templates specify Mitigation and Verification Settings default values. possible ptions `balanced`,`relaxed` and
               `strict`
        """
        pulumi.set(__self__, "name", name)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforcement_mode is not None:
            pulumi.set(__self__, "enforcement_mode", enforcement_mode)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Bot Defense profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log`
        profile
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User defined description for Bot Defense profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enforcementMode")
    def enforcement_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select the enforcement mode, possible values are `transparent` and `blocking`.
        """
        return pulumi.get(self, "enforcement_mode")

    @enforcement_mode.setter
    def enforcement_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforcement_mode", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Profile templates specify Mitigation and Verification Settings default values. possible ptions `balanced`,`relaxed` and
        `strict`
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class _ProfileBotDefenseState:
    def __init__(__self__, *,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProfileBotDefense resources.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log`
               profile
        :param pulumi.Input[_builtins.str] description: User defined description for Bot Defense profile
        :param pulumi.Input[_builtins.str] enforcement_mode: Select the enforcement mode, possible values are `transparent` and `blocking`.
        :param pulumi.Input[_builtins.str] name: Name of the Bot Defense profile
        :param pulumi.Input[_builtins.str] template: Profile templates specify Mitigation and Verification Settings default values. possible ptions `balanced`,`relaxed` and
               `strict`
        """
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforcement_mode is not None:
            pulumi.set(__self__, "enforcement_mode", enforcement_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log`
        profile
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User defined description for Bot Defense profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enforcementMode")
    def enforcement_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select the enforcement mode, possible values are `transparent` and `blocking`.
        """
        return pulumi.get(self, "enforcement_mode")

    @enforcement_mode.setter
    def enforcement_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforcement_mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Bot Defense profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Profile templates specify Mitigation and Verification Settings default values. possible ptions `balanced`,`relaxed` and
        `strict`
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template", value)


@pulumi.type_token("f5bigip:ltm/profileBotDefense:ProfileBotDefense")
class ProfileBotDefense(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ProfileBotDefense resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log`
               profile
        :param pulumi.Input[_builtins.str] description: User defined description for Bot Defense profile
        :param pulumi.Input[_builtins.str] enforcement_mode: Select the enforcement mode, possible values are `transparent` and `blocking`.
        :param pulumi.Input[_builtins.str] name: Name of the Bot Defense profile
        :param pulumi.Input[_builtins.str] template: Profile templates specify Mitigation and Verification Settings default values. possible ptions `balanced`,`relaxed` and
               `strict`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileBotDefenseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ProfileBotDefense resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProfileBotDefenseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileBotDefenseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforcement_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileBotDefenseArgs.__new__(ProfileBotDefenseArgs)

            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["description"] = description
            __props__.__dict__["enforcement_mode"] = enforcement_mode
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["template"] = template
        super(ProfileBotDefense, __self__).__init__(
            'f5bigip:ltm/profileBotDefense:ProfileBotDefense',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enforcement_mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            template: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProfileBotDefense':
        """
        Get an existing ProfileBotDefense resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log`
               profile
        :param pulumi.Input[_builtins.str] description: User defined description for Bot Defense profile
        :param pulumi.Input[_builtins.str] enforcement_mode: Select the enforcement mode, possible values are `transparent` and `blocking`.
        :param pulumi.Input[_builtins.str] name: Name of the Bot Defense profile
        :param pulumi.Input[_builtins.str] template: Profile templates specify Mitigation and Verification Settings default values. possible ptions `balanced`,`relaxed` and
               `strict`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileBotDefenseState.__new__(_ProfileBotDefenseState)

        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["description"] = description
        __props__.__dict__["enforcement_mode"] = enforcement_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["template"] = template
        return ProfileBotDefense(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log`
        profile
        """
        return pulumi.get(self, "defaults_from")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        User defined description for Bot Defense profile
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enforcementMode")
    def enforcement_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Select the enforcement mode, possible values are `transparent` and `blocking`.
        """
        return pulumi.get(self, "enforcement_mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Bot Defense profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Output[_builtins.str]:
        """
        Profile templates specify Mitigation and Verification Settings default values. possible ptions `balanced`,`relaxed` and
        `strict`
        """
        return pulumi.get(self, "template")

