# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProfileFtpArgs', 'ProfileFtp']

@pulumi.input_type
class ProfileFtpArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 allow_active_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_ftps: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce_tlssession_reuse: Optional[pulumi.Input[_builtins.str]] = None,
                 ftps_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_parent_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_vlan_list: Optional[pulumi.Input[_builtins.str]] = None,
                 log_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 log_publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 translate_extended: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProfileFtp resource.
        :param pulumi.Input[_builtins.str] name: Name of the profile_ftp
        :param pulumi.Input[_builtins.str] allow_active_mode: Specifies, when selected (enabled), that the system allows FTP Active Transfer mode. The default value is enabled.
        :param pulumi.Input[_builtins.str] allow_ftps: Allows explicit FTPS negotiation
        :param pulumi.Input[_builtins.str] app_service: The application service to which the object belongs.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] description: User defined description
        :param pulumi.Input[_builtins.str] enforce_tlssession_reuse: Specifies, when selected (enabled), that the system enforces the data connection to reuse a TLS session. The default
               value is unchecked (disabled).
        :param pulumi.Input[_builtins.str] ftps_mode: Allows explicit FTPS negotiation
        :param pulumi.Input[_builtins.str] inherit_parent_profile: Enables the FTP data channel to inherit the TCP profile used by the control channel.If disabled,the data channel uses
               FastL4 only.
        :param pulumi.Input[_builtins.str] inherit_vlan_list: inherent vlan list
        :param pulumi.Input[_builtins.str] log_profile: Configures the ALG log profile that controls logging
        :param pulumi.Input[_builtins.str] log_publisher: Configures the log publisher that handles events logging for this profile
        :param pulumi.Input[_builtins.str] partition: Displays the administrative partition within which this profile resides
        :param pulumi.Input[_builtins.int] port: Specifies a service for the data channel port used for this FTP profile. The default port is ftp-data.
        :param pulumi.Input[_builtins.str] security: Enables secure FTP traffic for the BIG-IP Application Security Manager. You can set the security option only if the
               system is licensed for the BIG-IP Application Security Manager. The default value is disabled.
        :param pulumi.Input[_builtins.str] translate_extended: This setting is enabled by default, and thus, automatically translates RFC 2428 extended requests EPSV and EPRT to PASV
               and PORT when communicating with IPv4 servers.
        """
        pulumi.set(__self__, "name", name)
        if allow_active_mode is not None:
            pulumi.set(__self__, "allow_active_mode", allow_active_mode)
        if allow_ftps is not None:
            pulumi.set(__self__, "allow_ftps", allow_ftps)
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforce_tlssession_reuse is not None:
            pulumi.set(__self__, "enforce_tlssession_reuse", enforce_tlssession_reuse)
        if ftps_mode is not None:
            pulumi.set(__self__, "ftps_mode", ftps_mode)
        if inherit_parent_profile is not None:
            pulumi.set(__self__, "inherit_parent_profile", inherit_parent_profile)
        if inherit_vlan_list is not None:
            pulumi.set(__self__, "inherit_vlan_list", inherit_vlan_list)
        if log_profile is not None:
            pulumi.set(__self__, "log_profile", log_profile)
        if log_publisher is not None:
            pulumi.set(__self__, "log_publisher", log_publisher)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if translate_extended is not None:
            pulumi.set(__self__, "translate_extended", translate_extended)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the profile_ftp
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="allowActiveMode")
    def allow_active_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies, when selected (enabled), that the system allows FTP Active Transfer mode. The default value is enabled.
        """
        return pulumi.get(self, "allow_active_mode")

    @allow_active_mode.setter
    def allow_active_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allow_active_mode", value)

    @_builtins.property
    @pulumi.getter(name="allowFtps")
    def allow_ftps(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allows explicit FTPS negotiation
        """
        return pulumi.get(self, "allow_ftps")

    @allow_ftps.setter
    def allow_ftps(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allow_ftps", value)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application service to which the object belongs.
        """
        return pulumi.get(self, "app_service")

    @app_service.setter
    def app_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User defined description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enforceTlssessionReuse")
    def enforce_tlssession_reuse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies, when selected (enabled), that the system enforces the data connection to reuse a TLS session. The default
        value is unchecked (disabled).
        """
        return pulumi.get(self, "enforce_tlssession_reuse")

    @enforce_tlssession_reuse.setter
    def enforce_tlssession_reuse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforce_tlssession_reuse", value)

    @_builtins.property
    @pulumi.getter(name="ftpsMode")
    def ftps_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allows explicit FTPS negotiation
        """
        return pulumi.get(self, "ftps_mode")

    @ftps_mode.setter
    def ftps_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ftps_mode", value)

    @_builtins.property
    @pulumi.getter(name="inheritParentProfile")
    def inherit_parent_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables the FTP data channel to inherit the TCP profile used by the control channel.If disabled,the data channel uses
        FastL4 only.
        """
        return pulumi.get(self, "inherit_parent_profile")

    @inherit_parent_profile.setter
    def inherit_parent_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inherit_parent_profile", value)

    @_builtins.property
    @pulumi.getter(name="inheritVlanList")
    def inherit_vlan_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        inherent vlan list
        """
        return pulumi.get(self, "inherit_vlan_list")

    @inherit_vlan_list.setter
    def inherit_vlan_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inherit_vlan_list", value)

    @_builtins.property
    @pulumi.getter(name="logProfile")
    def log_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configures the ALG log profile that controls logging
        """
        return pulumi.get(self, "log_profile")

    @log_profile.setter
    def log_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_profile", value)

    @_builtins.property
    @pulumi.getter(name="logPublisher")
    def log_publisher(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configures the log publisher that handles events logging for this profile
        """
        return pulumi.get(self, "log_publisher")

    @log_publisher.setter
    def log_publisher(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_publisher", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays the administrative partition within which this profile resides
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies a service for the data channel port used for this FTP profile. The default port is ftp-data.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables secure FTP traffic for the BIG-IP Application Security Manager. You can set the security option only if the
        system is licensed for the BIG-IP Application Security Manager. The default value is disabled.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter(name="translateExtended")
    def translate_extended(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This setting is enabled by default, and thus, automatically translates RFC 2428 extended requests EPSV and EPRT to PASV
        and PORT when communicating with IPv4 servers.
        """
        return pulumi.get(self, "translate_extended")

    @translate_extended.setter
    def translate_extended(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "translate_extended", value)


@pulumi.input_type
class _ProfileFtpState:
    def __init__(__self__, *,
                 allow_active_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_ftps: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce_tlssession_reuse: Optional[pulumi.Input[_builtins.str]] = None,
                 ftps_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_parent_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_vlan_list: Optional[pulumi.Input[_builtins.str]] = None,
                 log_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 log_publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 translate_extended: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProfileFtp resources.
        :param pulumi.Input[_builtins.str] allow_active_mode: Specifies, when selected (enabled), that the system allows FTP Active Transfer mode. The default value is enabled.
        :param pulumi.Input[_builtins.str] allow_ftps: Allows explicit FTPS negotiation
        :param pulumi.Input[_builtins.str] app_service: The application service to which the object belongs.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] description: User defined description
        :param pulumi.Input[_builtins.str] enforce_tlssession_reuse: Specifies, when selected (enabled), that the system enforces the data connection to reuse a TLS session. The default
               value is unchecked (disabled).
        :param pulumi.Input[_builtins.str] ftps_mode: Allows explicit FTPS negotiation
        :param pulumi.Input[_builtins.str] inherit_parent_profile: Enables the FTP data channel to inherit the TCP profile used by the control channel.If disabled,the data channel uses
               FastL4 only.
        :param pulumi.Input[_builtins.str] inherit_vlan_list: inherent vlan list
        :param pulumi.Input[_builtins.str] log_profile: Configures the ALG log profile that controls logging
        :param pulumi.Input[_builtins.str] log_publisher: Configures the log publisher that handles events logging for this profile
        :param pulumi.Input[_builtins.str] name: Name of the profile_ftp
        :param pulumi.Input[_builtins.str] partition: Displays the administrative partition within which this profile resides
        :param pulumi.Input[_builtins.int] port: Specifies a service for the data channel port used for this FTP profile. The default port is ftp-data.
        :param pulumi.Input[_builtins.str] security: Enables secure FTP traffic for the BIG-IP Application Security Manager. You can set the security option only if the
               system is licensed for the BIG-IP Application Security Manager. The default value is disabled.
        :param pulumi.Input[_builtins.str] translate_extended: This setting is enabled by default, and thus, automatically translates RFC 2428 extended requests EPSV and EPRT to PASV
               and PORT when communicating with IPv4 servers.
        """
        if allow_active_mode is not None:
            pulumi.set(__self__, "allow_active_mode", allow_active_mode)
        if allow_ftps is not None:
            pulumi.set(__self__, "allow_ftps", allow_ftps)
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enforce_tlssession_reuse is not None:
            pulumi.set(__self__, "enforce_tlssession_reuse", enforce_tlssession_reuse)
        if ftps_mode is not None:
            pulumi.set(__self__, "ftps_mode", ftps_mode)
        if inherit_parent_profile is not None:
            pulumi.set(__self__, "inherit_parent_profile", inherit_parent_profile)
        if inherit_vlan_list is not None:
            pulumi.set(__self__, "inherit_vlan_list", inherit_vlan_list)
        if log_profile is not None:
            pulumi.set(__self__, "log_profile", log_profile)
        if log_publisher is not None:
            pulumi.set(__self__, "log_publisher", log_publisher)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if translate_extended is not None:
            pulumi.set(__self__, "translate_extended", translate_extended)

    @_builtins.property
    @pulumi.getter(name="allowActiveMode")
    def allow_active_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies, when selected (enabled), that the system allows FTP Active Transfer mode. The default value is enabled.
        """
        return pulumi.get(self, "allow_active_mode")

    @allow_active_mode.setter
    def allow_active_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allow_active_mode", value)

    @_builtins.property
    @pulumi.getter(name="allowFtps")
    def allow_ftps(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allows explicit FTPS negotiation
        """
        return pulumi.get(self, "allow_ftps")

    @allow_ftps.setter
    def allow_ftps(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allow_ftps", value)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application service to which the object belongs.
        """
        return pulumi.get(self, "app_service")

    @app_service.setter
    def app_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User defined description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enforceTlssessionReuse")
    def enforce_tlssession_reuse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies, when selected (enabled), that the system enforces the data connection to reuse a TLS session. The default
        value is unchecked (disabled).
        """
        return pulumi.get(self, "enforce_tlssession_reuse")

    @enforce_tlssession_reuse.setter
    def enforce_tlssession_reuse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforce_tlssession_reuse", value)

    @_builtins.property
    @pulumi.getter(name="ftpsMode")
    def ftps_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allows explicit FTPS negotiation
        """
        return pulumi.get(self, "ftps_mode")

    @ftps_mode.setter
    def ftps_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ftps_mode", value)

    @_builtins.property
    @pulumi.getter(name="inheritParentProfile")
    def inherit_parent_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables the FTP data channel to inherit the TCP profile used by the control channel.If disabled,the data channel uses
        FastL4 only.
        """
        return pulumi.get(self, "inherit_parent_profile")

    @inherit_parent_profile.setter
    def inherit_parent_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inherit_parent_profile", value)

    @_builtins.property
    @pulumi.getter(name="inheritVlanList")
    def inherit_vlan_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        inherent vlan list
        """
        return pulumi.get(self, "inherit_vlan_list")

    @inherit_vlan_list.setter
    def inherit_vlan_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inherit_vlan_list", value)

    @_builtins.property
    @pulumi.getter(name="logProfile")
    def log_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configures the ALG log profile that controls logging
        """
        return pulumi.get(self, "log_profile")

    @log_profile.setter
    def log_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_profile", value)

    @_builtins.property
    @pulumi.getter(name="logPublisher")
    def log_publisher(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configures the log publisher that handles events logging for this profile
        """
        return pulumi.get(self, "log_publisher")

    @log_publisher.setter
    def log_publisher(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_publisher", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the profile_ftp
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays the administrative partition within which this profile resides
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies a service for the data channel port used for this FTP profile. The default port is ftp-data.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables secure FTP traffic for the BIG-IP Application Security Manager. You can set the security option only if the
        system is licensed for the BIG-IP Application Security Manager. The default value is disabled.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter(name="translateExtended")
    def translate_extended(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This setting is enabled by default, and thus, automatically translates RFC 2428 extended requests EPSV and EPRT to PASV
        and PORT when communicating with IPv4 servers.
        """
        return pulumi.get(self, "translate_extended")

    @translate_extended.setter
    def translate_extended(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "translate_extended", value)


@pulumi.type_token("f5bigip:ltm/profileFtp:ProfileFtp")
class ProfileFtp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_active_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_ftps: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce_tlssession_reuse: Optional[pulumi.Input[_builtins.str]] = None,
                 ftps_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_parent_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_vlan_list: Optional[pulumi.Input[_builtins.str]] = None,
                 log_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 log_publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 translate_extended: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `ltm.ProfileFtp` Configures a custom profile_ftp.

        Resources should be named with their "full path". The full path is the combination of the partition + name (example: /Common/my-pool ) or  partition + directory + name of the resource  (example: /Common/test/my-pool )

        ## Example Usage

        ### For Bigip versions (14.x - 16.x)

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sanjose_ftp_profile = f5bigip.ltm.ProfileFtp("sanjose-ftp-profile",
            name="/Common/sanjose-ftp-profile",
            defaults_from="/Common/ftp",
            port=2020,
            description="test-tftp-profile",
            ftps_mode="allow",
            enforce_tlssession_reuse="enabled",
            allow_active_mode="enabled")
        ```

        ### For Bigip versions (12.x - 13.x)

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sanjose_ftp_profile = f5bigip.ltm.ProfileFtp("sanjose-ftp-profile",
            name="/Common/sanjose-ftp-profile",
            defaults_from="/Common/ftp",
            port=2020,
            description="test-tftp-profile",
            allow_ftps="enabled",
            translate_extended="enabled")
        ```

        ## Common Arguments for all versions

        * `security` - (Optional)Specifies, when checked (enabled), that the system inspects FTP traffic for security vulnerabilities using an FTP security profile. This option is available only on systems licensed for BIG-IP ASM.

        * `port` - (Optional)Allows you to configure the FTP service to run on an alternate port. The default is 20.

        * `log_profile` - (Optional)Configures the ALG log profile that controls logging

        * `log_publisher` - (Optional)Configures the log publisher that handles events logging for this profile

        *  `inherit_parent_profile` - (Optional)Enables the FTP data channel to inherit the TCP profile used by the control channel.If disabled,the data channel uses FastL4 only.

        * `description` - (Optional)User defined description for FTP profile

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] allow_active_mode: Specifies, when selected (enabled), that the system allows FTP Active Transfer mode. The default value is enabled.
        :param pulumi.Input[_builtins.str] allow_ftps: Allows explicit FTPS negotiation
        :param pulumi.Input[_builtins.str] app_service: The application service to which the object belongs.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] description: User defined description
        :param pulumi.Input[_builtins.str] enforce_tlssession_reuse: Specifies, when selected (enabled), that the system enforces the data connection to reuse a TLS session. The default
               value is unchecked (disabled).
        :param pulumi.Input[_builtins.str] ftps_mode: Allows explicit FTPS negotiation
        :param pulumi.Input[_builtins.str] inherit_parent_profile: Enables the FTP data channel to inherit the TCP profile used by the control channel.If disabled,the data channel uses
               FastL4 only.
        :param pulumi.Input[_builtins.str] inherit_vlan_list: inherent vlan list
        :param pulumi.Input[_builtins.str] log_profile: Configures the ALG log profile that controls logging
        :param pulumi.Input[_builtins.str] log_publisher: Configures the log publisher that handles events logging for this profile
        :param pulumi.Input[_builtins.str] name: Name of the profile_ftp
        :param pulumi.Input[_builtins.str] partition: Displays the administrative partition within which this profile resides
        :param pulumi.Input[_builtins.int] port: Specifies a service for the data channel port used for this FTP profile. The default port is ftp-data.
        :param pulumi.Input[_builtins.str] security: Enables secure FTP traffic for the BIG-IP Application Security Manager. You can set the security option only if the
               system is licensed for the BIG-IP Application Security Manager. The default value is disabled.
        :param pulumi.Input[_builtins.str] translate_extended: This setting is enabled by default, and thus, automatically translates RFC 2428 extended requests EPSV and EPRT to PASV
               and PORT when communicating with IPv4 servers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileFtpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.ProfileFtp` Configures a custom profile_ftp.

        Resources should be named with their "full path". The full path is the combination of the partition + name (example: /Common/my-pool ) or  partition + directory + name of the resource  (example: /Common/test/my-pool )

        ## Example Usage

        ### For Bigip versions (14.x - 16.x)

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sanjose_ftp_profile = f5bigip.ltm.ProfileFtp("sanjose-ftp-profile",
            name="/Common/sanjose-ftp-profile",
            defaults_from="/Common/ftp",
            port=2020,
            description="test-tftp-profile",
            ftps_mode="allow",
            enforce_tlssession_reuse="enabled",
            allow_active_mode="enabled")
        ```

        ### For Bigip versions (12.x - 13.x)

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sanjose_ftp_profile = f5bigip.ltm.ProfileFtp("sanjose-ftp-profile",
            name="/Common/sanjose-ftp-profile",
            defaults_from="/Common/ftp",
            port=2020,
            description="test-tftp-profile",
            allow_ftps="enabled",
            translate_extended="enabled")
        ```

        ## Common Arguments for all versions

        * `security` - (Optional)Specifies, when checked (enabled), that the system inspects FTP traffic for security vulnerabilities using an FTP security profile. This option is available only on systems licensed for BIG-IP ASM.

        * `port` - (Optional)Allows you to configure the FTP service to run on an alternate port. The default is 20.

        * `log_profile` - (Optional)Configures the ALG log profile that controls logging

        * `log_publisher` - (Optional)Configures the log publisher that handles events logging for this profile

        *  `inherit_parent_profile` - (Optional)Enables the FTP data channel to inherit the TCP profile used by the control channel.If disabled,the data channel uses FastL4 only.

        * `description` - (Optional)User defined description for FTP profile

        :param str resource_name: The name of the resource.
        :param ProfileFtpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileFtpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_active_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_ftps: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce_tlssession_reuse: Optional[pulumi.Input[_builtins.str]] = None,
                 ftps_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_parent_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_vlan_list: Optional[pulumi.Input[_builtins.str]] = None,
                 log_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 log_publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 translate_extended: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileFtpArgs.__new__(ProfileFtpArgs)

            __props__.__dict__["allow_active_mode"] = allow_active_mode
            __props__.__dict__["allow_ftps"] = allow_ftps
            __props__.__dict__["app_service"] = app_service
            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["description"] = description
            __props__.__dict__["enforce_tlssession_reuse"] = enforce_tlssession_reuse
            __props__.__dict__["ftps_mode"] = ftps_mode
            __props__.__dict__["inherit_parent_profile"] = inherit_parent_profile
            __props__.__dict__["inherit_vlan_list"] = inherit_vlan_list
            __props__.__dict__["log_profile"] = log_profile
            __props__.__dict__["log_publisher"] = log_publisher
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["partition"] = partition
            __props__.__dict__["port"] = port
            __props__.__dict__["security"] = security
            __props__.__dict__["translate_extended"] = translate_extended
        super(ProfileFtp, __self__).__init__(
            'f5bigip:ltm/profileFtp:ProfileFtp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_active_mode: Optional[pulumi.Input[_builtins.str]] = None,
            allow_ftps: Optional[pulumi.Input[_builtins.str]] = None,
            app_service: Optional[pulumi.Input[_builtins.str]] = None,
            defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enforce_tlssession_reuse: Optional[pulumi.Input[_builtins.str]] = None,
            ftps_mode: Optional[pulumi.Input[_builtins.str]] = None,
            inherit_parent_profile: Optional[pulumi.Input[_builtins.str]] = None,
            inherit_vlan_list: Optional[pulumi.Input[_builtins.str]] = None,
            log_profile: Optional[pulumi.Input[_builtins.str]] = None,
            log_publisher: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            security: Optional[pulumi.Input[_builtins.str]] = None,
            translate_extended: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProfileFtp':
        """
        Get an existing ProfileFtp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] allow_active_mode: Specifies, when selected (enabled), that the system allows FTP Active Transfer mode. The default value is enabled.
        :param pulumi.Input[_builtins.str] allow_ftps: Allows explicit FTPS negotiation
        :param pulumi.Input[_builtins.str] app_service: The application service to which the object belongs.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] description: User defined description
        :param pulumi.Input[_builtins.str] enforce_tlssession_reuse: Specifies, when selected (enabled), that the system enforces the data connection to reuse a TLS session. The default
               value is unchecked (disabled).
        :param pulumi.Input[_builtins.str] ftps_mode: Allows explicit FTPS negotiation
        :param pulumi.Input[_builtins.str] inherit_parent_profile: Enables the FTP data channel to inherit the TCP profile used by the control channel.If disabled,the data channel uses
               FastL4 only.
        :param pulumi.Input[_builtins.str] inherit_vlan_list: inherent vlan list
        :param pulumi.Input[_builtins.str] log_profile: Configures the ALG log profile that controls logging
        :param pulumi.Input[_builtins.str] log_publisher: Configures the log publisher that handles events logging for this profile
        :param pulumi.Input[_builtins.str] name: Name of the profile_ftp
        :param pulumi.Input[_builtins.str] partition: Displays the administrative partition within which this profile resides
        :param pulumi.Input[_builtins.int] port: Specifies a service for the data channel port used for this FTP profile. The default port is ftp-data.
        :param pulumi.Input[_builtins.str] security: Enables secure FTP traffic for the BIG-IP Application Security Manager. You can set the security option only if the
               system is licensed for the BIG-IP Application Security Manager. The default value is disabled.
        :param pulumi.Input[_builtins.str] translate_extended: This setting is enabled by default, and thus, automatically translates RFC 2428 extended requests EPSV and EPRT to PASV
               and PORT when communicating with IPv4 servers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileFtpState.__new__(_ProfileFtpState)

        __props__.__dict__["allow_active_mode"] = allow_active_mode
        __props__.__dict__["allow_ftps"] = allow_ftps
        __props__.__dict__["app_service"] = app_service
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["description"] = description
        __props__.__dict__["enforce_tlssession_reuse"] = enforce_tlssession_reuse
        __props__.__dict__["ftps_mode"] = ftps_mode
        __props__.__dict__["inherit_parent_profile"] = inherit_parent_profile
        __props__.__dict__["inherit_vlan_list"] = inherit_vlan_list
        __props__.__dict__["log_profile"] = log_profile
        __props__.__dict__["log_publisher"] = log_publisher
        __props__.__dict__["name"] = name
        __props__.__dict__["partition"] = partition
        __props__.__dict__["port"] = port
        __props__.__dict__["security"] = security
        __props__.__dict__["translate_extended"] = translate_extended
        return ProfileFtp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowActiveMode")
    def allow_active_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies, when selected (enabled), that the system allows FTP Active Transfer mode. The default value is enabled.
        """
        return pulumi.get(self, "allow_active_mode")

    @_builtins.property
    @pulumi.getter(name="allowFtps")
    def allow_ftps(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Allows explicit FTPS negotiation
        """
        return pulumi.get(self, "allow_ftps")

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The application service to which the object belongs.
        """
        return pulumi.get(self, "app_service")

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User defined description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enforceTlssessionReuse")
    def enforce_tlssession_reuse(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies, when selected (enabled), that the system enforces the data connection to reuse a TLS session. The default
        value is unchecked (disabled).
        """
        return pulumi.get(self, "enforce_tlssession_reuse")

    @_builtins.property
    @pulumi.getter(name="ftpsMode")
    def ftps_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Allows explicit FTPS negotiation
        """
        return pulumi.get(self, "ftps_mode")

    @_builtins.property
    @pulumi.getter(name="inheritParentProfile")
    def inherit_parent_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enables the FTP data channel to inherit the TCP profile used by the control channel.If disabled,the data channel uses
        FastL4 only.
        """
        return pulumi.get(self, "inherit_parent_profile")

    @_builtins.property
    @pulumi.getter(name="inheritVlanList")
    def inherit_vlan_list(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        inherent vlan list
        """
        return pulumi.get(self, "inherit_vlan_list")

    @_builtins.property
    @pulumi.getter(name="logProfile")
    def log_profile(self) -> pulumi.Output[_builtins.str]:
        """
        Configures the ALG log profile that controls logging
        """
        return pulumi.get(self, "log_profile")

    @_builtins.property
    @pulumi.getter(name="logPublisher")
    def log_publisher(self) -> pulumi.Output[_builtins.str]:
        """
        Configures the log publisher that handles events logging for this profile
        """
        return pulumi.get(self, "log_publisher")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the profile_ftp
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[_builtins.str]:
        """
        Displays the administrative partition within which this profile resides
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies a service for the data channel port used for this FTP profile. The default port is ftp-data.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def security(self) -> pulumi.Output[_builtins.str]:
        """
        Enables secure FTP traffic for the BIG-IP Application Security Manager. You can set the security option only if the
        system is licensed for the BIG-IP Application Security Manager. The default value is disabled.
        """
        return pulumi.get(self, "security")

    @_builtins.property
    @pulumi.getter(name="translateExtended")
    def translate_extended(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This setting is enabled by default, and thus, automatically translates RFC 2428 extended requests EPSV and EPRT to PASV
        and PORT when communicating with IPv4 servers.
        """
        return pulumi.get(self, "translate_extended")

