# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProfileHttpArgs', 'ProfileHttp']

@pulumi.input_type
class ProfileHttpArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 accept_xff: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 basic_auth_realm: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cookie_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cookies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enforcements: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpEnforcementArgs']]]] = None,
                 fallback_host: Optional[pulumi.Input[_builtins.str]] = None,
                 fallback_status_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 head_erase: Optional[pulumi.Input[_builtins.str]] = None,
                 head_insert: Optional[pulumi.Input[_builtins.str]] = None,
                 http_strict_transport_securities: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpHttpStrictTransportSecurityArgs']]]] = None,
                 insert_xforwarded_for: Optional[pulumi.Input[_builtins.str]] = None,
                 lws_separator: Optional[pulumi.Input[_builtins.str]] = None,
                 lws_width: Optional[pulumi.Input[_builtins.int]] = None,
                 oneconnect_transformations: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_rewrite: Optional[pulumi.Input[_builtins.str]] = None,
                 request_chunking: Optional[pulumi.Input[_builtins.str]] = None,
                 response_chunking: Optional[pulumi.Input[_builtins.str]] = None,
                 response_headers_permitteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_agent_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tm_partition: Optional[pulumi.Input[_builtins.str]] = None,
                 via_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 via_request: Optional[pulumi.Input[_builtins.str]] = None,
                 via_response: Optional[pulumi.Input[_builtins.str]] = None,
                 xff_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ProfileHttp resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the http profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/test-http-profile`.
        :param pulumi.Input[_builtins.str] accept_xff: Enables or disables trusting the client IP address, and statistics from the client IP address, based on the request's XFF (X-forwarded-for) headers, if they exist.
        :param pulumi.Input[_builtins.str] app_service: The application service to which the object belongs.
        :param pulumi.Input[_builtins.str] basic_auth_realm: Specifies a quoted string for the basic authentication realm. The system sends this string to a client whenever authorization fails. The default value is `none`
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] description: Specifies user-defined description.
        :param pulumi.Input[_builtins.str] encrypt_cookie_secret: Type a passphrase for cookie encryption. Note: Since it's a sensitive entity idempotency will fail for it in the update call.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] encrypt_cookies: Type the cookie names for the system to encrypt.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileHttpEnforcementArgs']]] enforcements: See Enforcement below for more details.
        :param pulumi.Input[_builtins.str] fallback_host: Specifies an HTTP fallback host. HTTP redirection allows you to redirect HTTP traffic to another protocol identifier, host name, port number
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fallback_status_codes: Specifies one or more three-digit status codes that can be returned by an HTTP server,that should trigger a redirection to the fallback host.
        :param pulumi.Input[_builtins.str] head_erase: Specifies the header string that you want to erase from an HTTP request. Default is `none`.
        :param pulumi.Input[_builtins.str] head_insert: Specifies a quoted header string that you want to insert into an HTTP request.Default is `none`.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileHttpHttpStrictTransportSecurityArgs']]] http_strict_transport_securities: See Http_Strict_Transport_Security below for more details.
        :param pulumi.Input[_builtins.str] insert_xforwarded_for: Specifies, when enabled, that the system inserts an X-Forwarded-For header in an HTTP request with the client IP address, to use with connection pooling. The default is `Disabled`.
        :param pulumi.Input[_builtins.str] lws_separator: Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you
               specify in the LWS Maximum Columns setting.
        :param pulumi.Input[_builtins.int] lws_width: Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you specify in the LWS Maximum Columns setting.
        :param pulumi.Input[_builtins.str] oneconnect_transformations: Enables the system to perform HTTP header transformations for the purpose of  keeping server-side connections open. This feature requires configuration of a OneConnect profile
        :param pulumi.Input[_builtins.str] proxy_type: Specifies the proxy mode for this profile: reverse, explicit, or transparent. The default is `reverse`.
        :param pulumi.Input[_builtins.str] redirect_rewrite: Specifies whether the system rewrites the URIs that are part of HTTP redirect (3XX) responses. The default is `none`.
        :param pulumi.Input[_builtins.str] request_chunking: Specifies how the system handles HTTP content that is chunked by a client. The default is `preserve`.
        :param pulumi.Input[_builtins.str] response_chunking: Specifies how the system handles HTTP content that is chunked by a server. The default is `selective`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] response_headers_permitteds: Specifies headers that the BIG-IP system allows in an HTTP response.If you are specifying more than one header, separate the headers with a blank space.
        :param pulumi.Input[_builtins.str] server_agent_name: Specifies the value of the Server header in responses that the BIG-IP itself generates. The default is BigIP. In order to remove it, "none" string is to be passed. If server_agent_name is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "BigIP" explicitly.
        :param pulumi.Input[_builtins.str] tm_partition: Displays the administrative partition within which this profile resides.
        :param pulumi.Input[_builtins.str] via_host_name: Specifies the hostname to include into Via header
        :param pulumi.Input[_builtins.str] via_request: Specifies whether to append, remove, or preserve a Via header in an HTTP request
        :param pulumi.Input[_builtins.str] via_response: Specifies whether to append, remove, or preserve a Via header in an HTTP request
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] xff_alternative_names: Specifies alternative XFF headers instead of the default X-forwarded-for header.
        """
        pulumi.set(__self__, "name", name)
        if accept_xff is not None:
            pulumi.set(__self__, "accept_xff", accept_xff)
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if basic_auth_realm is not None:
            pulumi.set(__self__, "basic_auth_realm", basic_auth_realm)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypt_cookie_secret is not None:
            pulumi.set(__self__, "encrypt_cookie_secret", encrypt_cookie_secret)
        if encrypt_cookies is not None:
            pulumi.set(__self__, "encrypt_cookies", encrypt_cookies)
        if enforcements is not None:
            pulumi.set(__self__, "enforcements", enforcements)
        if fallback_host is not None:
            pulumi.set(__self__, "fallback_host", fallback_host)
        if fallback_status_codes is not None:
            pulumi.set(__self__, "fallback_status_codes", fallback_status_codes)
        if head_erase is not None:
            pulumi.set(__self__, "head_erase", head_erase)
        if head_insert is not None:
            pulumi.set(__self__, "head_insert", head_insert)
        if http_strict_transport_securities is not None:
            pulumi.set(__self__, "http_strict_transport_securities", http_strict_transport_securities)
        if insert_xforwarded_for is not None:
            pulumi.set(__self__, "insert_xforwarded_for", insert_xforwarded_for)
        if lws_separator is not None:
            pulumi.set(__self__, "lws_separator", lws_separator)
        if lws_width is not None:
            pulumi.set(__self__, "lws_width", lws_width)
        if oneconnect_transformations is not None:
            pulumi.set(__self__, "oneconnect_transformations", oneconnect_transformations)
        if proxy_type is not None:
            pulumi.set(__self__, "proxy_type", proxy_type)
        if redirect_rewrite is not None:
            pulumi.set(__self__, "redirect_rewrite", redirect_rewrite)
        if request_chunking is not None:
            pulumi.set(__self__, "request_chunking", request_chunking)
        if response_chunking is not None:
            pulumi.set(__self__, "response_chunking", response_chunking)
        if response_headers_permitteds is not None:
            pulumi.set(__self__, "response_headers_permitteds", response_headers_permitteds)
        if server_agent_name is not None:
            pulumi.set(__self__, "server_agent_name", server_agent_name)
        if tm_partition is not None:
            pulumi.set(__self__, "tm_partition", tm_partition)
        if via_host_name is not None:
            pulumi.set(__self__, "via_host_name", via_host_name)
        if via_request is not None:
            pulumi.set(__self__, "via_request", via_request)
        if via_response is not None:
            pulumi.set(__self__, "via_response", via_response)
        if xff_alternative_names is not None:
            pulumi.set(__self__, "xff_alternative_names", xff_alternative_names)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the http profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/test-http-profile`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="acceptXff")
    def accept_xff(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables trusting the client IP address, and statistics from the client IP address, based on the request's XFF (X-forwarded-for) headers, if they exist.
        """
        return pulumi.get(self, "accept_xff")

    @accept_xff.setter
    def accept_xff(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accept_xff", value)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application service to which the object belongs.
        """
        return pulumi.get(self, "app_service")

    @app_service.setter
    def app_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service", value)

    @_builtins.property
    @pulumi.getter(name="basicAuthRealm")
    def basic_auth_realm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a quoted string for the basic authentication realm. The system sends this string to a client whenever authorization fails. The default value is `none`
        """
        return pulumi.get(self, "basic_auth_realm")

    @basic_auth_realm.setter
    def basic_auth_realm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "basic_auth_realm", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies user-defined description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptCookieSecret")
    def encrypt_cookie_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type a passphrase for cookie encryption. Note: Since it's a sensitive entity idempotency will fail for it in the update call.
        """
        return pulumi.get(self, "encrypt_cookie_secret")

    @encrypt_cookie_secret.setter
    def encrypt_cookie_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_cookie_secret", value)

    @_builtins.property
    @pulumi.getter(name="encryptCookies")
    def encrypt_cookies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Type the cookie names for the system to encrypt.
        """
        return pulumi.get(self, "encrypt_cookies")

    @encrypt_cookies.setter
    def encrypt_cookies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encrypt_cookies", value)

    @_builtins.property
    @pulumi.getter
    def enforcements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpEnforcementArgs']]]]:
        """
        See Enforcement below for more details.
        """
        return pulumi.get(self, "enforcements")

    @enforcements.setter
    def enforcements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpEnforcementArgs']]]]):
        pulumi.set(self, "enforcements", value)

    @_builtins.property
    @pulumi.getter(name="fallbackHost")
    def fallback_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an HTTP fallback host. HTTP redirection allows you to redirect HTTP traffic to another protocol identifier, host name, port number
        """
        return pulumi.get(self, "fallback_host")

    @fallback_host.setter
    def fallback_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fallback_host", value)

    @_builtins.property
    @pulumi.getter(name="fallbackStatusCodes")
    def fallback_status_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies one or more three-digit status codes that can be returned by an HTTP server,that should trigger a redirection to the fallback host.
        """
        return pulumi.get(self, "fallback_status_codes")

    @fallback_status_codes.setter
    def fallback_status_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fallback_status_codes", value)

    @_builtins.property
    @pulumi.getter(name="headErase")
    def head_erase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the header string that you want to erase from an HTTP request. Default is `none`.
        """
        return pulumi.get(self, "head_erase")

    @head_erase.setter
    def head_erase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "head_erase", value)

    @_builtins.property
    @pulumi.getter(name="headInsert")
    def head_insert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a quoted header string that you want to insert into an HTTP request.Default is `none`.
        """
        return pulumi.get(self, "head_insert")

    @head_insert.setter
    def head_insert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "head_insert", value)

    @_builtins.property
    @pulumi.getter(name="httpStrictTransportSecurities")
    def http_strict_transport_securities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpHttpStrictTransportSecurityArgs']]]]:
        """
        See Http_Strict_Transport_Security below for more details.
        """
        return pulumi.get(self, "http_strict_transport_securities")

    @http_strict_transport_securities.setter
    def http_strict_transport_securities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpHttpStrictTransportSecurityArgs']]]]):
        pulumi.set(self, "http_strict_transport_securities", value)

    @_builtins.property
    @pulumi.getter(name="insertXforwardedFor")
    def insert_xforwarded_for(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies, when enabled, that the system inserts an X-Forwarded-For header in an HTTP request with the client IP address, to use with connection pooling. The default is `Disabled`.
        """
        return pulumi.get(self, "insert_xforwarded_for")

    @insert_xforwarded_for.setter
    def insert_xforwarded_for(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "insert_xforwarded_for", value)

    @_builtins.property
    @pulumi.getter(name="lwsSeparator")
    def lws_separator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you
        specify in the LWS Maximum Columns setting.
        """
        return pulumi.get(self, "lws_separator")

    @lws_separator.setter
    def lws_separator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lws_separator", value)

    @_builtins.property
    @pulumi.getter(name="lwsWidth")
    def lws_width(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you specify in the LWS Maximum Columns setting.
        """
        return pulumi.get(self, "lws_width")

    @lws_width.setter
    def lws_width(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lws_width", value)

    @_builtins.property
    @pulumi.getter(name="oneconnectTransformations")
    def oneconnect_transformations(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables the system to perform HTTP header transformations for the purpose of  keeping server-side connections open. This feature requires configuration of a OneConnect profile
        """
        return pulumi.get(self, "oneconnect_transformations")

    @oneconnect_transformations.setter
    def oneconnect_transformations(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oneconnect_transformations", value)

    @_builtins.property
    @pulumi.getter(name="proxyType")
    def proxy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the proxy mode for this profile: reverse, explicit, or transparent. The default is `reverse`.
        """
        return pulumi.get(self, "proxy_type")

    @proxy_type.setter
    def proxy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_type", value)

    @_builtins.property
    @pulumi.getter(name="redirectRewrite")
    def redirect_rewrite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the system rewrites the URIs that are part of HTTP redirect (3XX) responses. The default is `none`.
        """
        return pulumi.get(self, "redirect_rewrite")

    @redirect_rewrite.setter
    def redirect_rewrite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_rewrite", value)

    @_builtins.property
    @pulumi.getter(name="requestChunking")
    def request_chunking(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the system handles HTTP content that is chunked by a client. The default is `preserve`.
        """
        return pulumi.get(self, "request_chunking")

    @request_chunking.setter
    def request_chunking(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_chunking", value)

    @_builtins.property
    @pulumi.getter(name="responseChunking")
    def response_chunking(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the system handles HTTP content that is chunked by a server. The default is `selective`.
        """
        return pulumi.get(self, "response_chunking")

    @response_chunking.setter
    def response_chunking(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_chunking", value)

    @_builtins.property
    @pulumi.getter(name="responseHeadersPermitteds")
    def response_headers_permitteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies headers that the BIG-IP system allows in an HTTP response.If you are specifying more than one header, separate the headers with a blank space.
        """
        return pulumi.get(self, "response_headers_permitteds")

    @response_headers_permitteds.setter
    def response_headers_permitteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "response_headers_permitteds", value)

    @_builtins.property
    @pulumi.getter(name="serverAgentName")
    def server_agent_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the value of the Server header in responses that the BIG-IP itself generates. The default is BigIP. In order to remove it, "none" string is to be passed. If server_agent_name is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "BigIP" explicitly.
        """
        return pulumi.get(self, "server_agent_name")

    @server_agent_name.setter
    def server_agent_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_agent_name", value)

    @_builtins.property
    @pulumi.getter(name="tmPartition")
    def tm_partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays the administrative partition within which this profile resides.
        """
        return pulumi.get(self, "tm_partition")

    @tm_partition.setter
    def tm_partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tm_partition", value)

    @_builtins.property
    @pulumi.getter(name="viaHostName")
    def via_host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the hostname to include into Via header
        """
        return pulumi.get(self, "via_host_name")

    @via_host_name.setter
    def via_host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "via_host_name", value)

    @_builtins.property
    @pulumi.getter(name="viaRequest")
    def via_request(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to append, remove, or preserve a Via header in an HTTP request
        """
        return pulumi.get(self, "via_request")

    @via_request.setter
    def via_request(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "via_request", value)

    @_builtins.property
    @pulumi.getter(name="viaResponse")
    def via_response(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to append, remove, or preserve a Via header in an HTTP request
        """
        return pulumi.get(self, "via_response")

    @via_response.setter
    def via_response(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "via_response", value)

    @_builtins.property
    @pulumi.getter(name="xffAlternativeNames")
    def xff_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies alternative XFF headers instead of the default X-forwarded-for header.
        """
        return pulumi.get(self, "xff_alternative_names")

    @xff_alternative_names.setter
    def xff_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "xff_alternative_names", value)


@pulumi.input_type
class _ProfileHttpState:
    def __init__(__self__, *,
                 accept_xff: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 basic_auth_realm: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cookie_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cookies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enforcements: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpEnforcementArgs']]]] = None,
                 fallback_host: Optional[pulumi.Input[_builtins.str]] = None,
                 fallback_status_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 head_erase: Optional[pulumi.Input[_builtins.str]] = None,
                 head_insert: Optional[pulumi.Input[_builtins.str]] = None,
                 http_strict_transport_securities: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpHttpStrictTransportSecurityArgs']]]] = None,
                 insert_xforwarded_for: Optional[pulumi.Input[_builtins.str]] = None,
                 lws_separator: Optional[pulumi.Input[_builtins.str]] = None,
                 lws_width: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oneconnect_transformations: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_rewrite: Optional[pulumi.Input[_builtins.str]] = None,
                 request_chunking: Optional[pulumi.Input[_builtins.str]] = None,
                 response_chunking: Optional[pulumi.Input[_builtins.str]] = None,
                 response_headers_permitteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_agent_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tm_partition: Optional[pulumi.Input[_builtins.str]] = None,
                 via_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 via_request: Optional[pulumi.Input[_builtins.str]] = None,
                 via_response: Optional[pulumi.Input[_builtins.str]] = None,
                 xff_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ProfileHttp resources.
        :param pulumi.Input[_builtins.str] accept_xff: Enables or disables trusting the client IP address, and statistics from the client IP address, based on the request's XFF (X-forwarded-for) headers, if they exist.
        :param pulumi.Input[_builtins.str] app_service: The application service to which the object belongs.
        :param pulumi.Input[_builtins.str] basic_auth_realm: Specifies a quoted string for the basic authentication realm. The system sends this string to a client whenever authorization fails. The default value is `none`
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] description: Specifies user-defined description.
        :param pulumi.Input[_builtins.str] encrypt_cookie_secret: Type a passphrase for cookie encryption. Note: Since it's a sensitive entity idempotency will fail for it in the update call.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] encrypt_cookies: Type the cookie names for the system to encrypt.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileHttpEnforcementArgs']]] enforcements: See Enforcement below for more details.
        :param pulumi.Input[_builtins.str] fallback_host: Specifies an HTTP fallback host. HTTP redirection allows you to redirect HTTP traffic to another protocol identifier, host name, port number
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fallback_status_codes: Specifies one or more three-digit status codes that can be returned by an HTTP server,that should trigger a redirection to the fallback host.
        :param pulumi.Input[_builtins.str] head_erase: Specifies the header string that you want to erase from an HTTP request. Default is `none`.
        :param pulumi.Input[_builtins.str] head_insert: Specifies a quoted header string that you want to insert into an HTTP request.Default is `none`.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileHttpHttpStrictTransportSecurityArgs']]] http_strict_transport_securities: See Http_Strict_Transport_Security below for more details.
        :param pulumi.Input[_builtins.str] insert_xforwarded_for: Specifies, when enabled, that the system inserts an X-Forwarded-For header in an HTTP request with the client IP address, to use with connection pooling. The default is `Disabled`.
        :param pulumi.Input[_builtins.str] lws_separator: Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you
               specify in the LWS Maximum Columns setting.
        :param pulumi.Input[_builtins.int] lws_width: Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you specify in the LWS Maximum Columns setting.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the http profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/test-http-profile`.
        :param pulumi.Input[_builtins.str] oneconnect_transformations: Enables the system to perform HTTP header transformations for the purpose of  keeping server-side connections open. This feature requires configuration of a OneConnect profile
        :param pulumi.Input[_builtins.str] proxy_type: Specifies the proxy mode for this profile: reverse, explicit, or transparent. The default is `reverse`.
        :param pulumi.Input[_builtins.str] redirect_rewrite: Specifies whether the system rewrites the URIs that are part of HTTP redirect (3XX) responses. The default is `none`.
        :param pulumi.Input[_builtins.str] request_chunking: Specifies how the system handles HTTP content that is chunked by a client. The default is `preserve`.
        :param pulumi.Input[_builtins.str] response_chunking: Specifies how the system handles HTTP content that is chunked by a server. The default is `selective`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] response_headers_permitteds: Specifies headers that the BIG-IP system allows in an HTTP response.If you are specifying more than one header, separate the headers with a blank space.
        :param pulumi.Input[_builtins.str] server_agent_name: Specifies the value of the Server header in responses that the BIG-IP itself generates. The default is BigIP. In order to remove it, "none" string is to be passed. If server_agent_name is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "BigIP" explicitly.
        :param pulumi.Input[_builtins.str] tm_partition: Displays the administrative partition within which this profile resides.
        :param pulumi.Input[_builtins.str] via_host_name: Specifies the hostname to include into Via header
        :param pulumi.Input[_builtins.str] via_request: Specifies whether to append, remove, or preserve a Via header in an HTTP request
        :param pulumi.Input[_builtins.str] via_response: Specifies whether to append, remove, or preserve a Via header in an HTTP request
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] xff_alternative_names: Specifies alternative XFF headers instead of the default X-forwarded-for header.
        """
        if accept_xff is not None:
            pulumi.set(__self__, "accept_xff", accept_xff)
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if basic_auth_realm is not None:
            pulumi.set(__self__, "basic_auth_realm", basic_auth_realm)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypt_cookie_secret is not None:
            pulumi.set(__self__, "encrypt_cookie_secret", encrypt_cookie_secret)
        if encrypt_cookies is not None:
            pulumi.set(__self__, "encrypt_cookies", encrypt_cookies)
        if enforcements is not None:
            pulumi.set(__self__, "enforcements", enforcements)
        if fallback_host is not None:
            pulumi.set(__self__, "fallback_host", fallback_host)
        if fallback_status_codes is not None:
            pulumi.set(__self__, "fallback_status_codes", fallback_status_codes)
        if head_erase is not None:
            pulumi.set(__self__, "head_erase", head_erase)
        if head_insert is not None:
            pulumi.set(__self__, "head_insert", head_insert)
        if http_strict_transport_securities is not None:
            pulumi.set(__self__, "http_strict_transport_securities", http_strict_transport_securities)
        if insert_xforwarded_for is not None:
            pulumi.set(__self__, "insert_xforwarded_for", insert_xforwarded_for)
        if lws_separator is not None:
            pulumi.set(__self__, "lws_separator", lws_separator)
        if lws_width is not None:
            pulumi.set(__self__, "lws_width", lws_width)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oneconnect_transformations is not None:
            pulumi.set(__self__, "oneconnect_transformations", oneconnect_transformations)
        if proxy_type is not None:
            pulumi.set(__self__, "proxy_type", proxy_type)
        if redirect_rewrite is not None:
            pulumi.set(__self__, "redirect_rewrite", redirect_rewrite)
        if request_chunking is not None:
            pulumi.set(__self__, "request_chunking", request_chunking)
        if response_chunking is not None:
            pulumi.set(__self__, "response_chunking", response_chunking)
        if response_headers_permitteds is not None:
            pulumi.set(__self__, "response_headers_permitteds", response_headers_permitteds)
        if server_agent_name is not None:
            pulumi.set(__self__, "server_agent_name", server_agent_name)
        if tm_partition is not None:
            pulumi.set(__self__, "tm_partition", tm_partition)
        if via_host_name is not None:
            pulumi.set(__self__, "via_host_name", via_host_name)
        if via_request is not None:
            pulumi.set(__self__, "via_request", via_request)
        if via_response is not None:
            pulumi.set(__self__, "via_response", via_response)
        if xff_alternative_names is not None:
            pulumi.set(__self__, "xff_alternative_names", xff_alternative_names)

    @_builtins.property
    @pulumi.getter(name="acceptXff")
    def accept_xff(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables trusting the client IP address, and statistics from the client IP address, based on the request's XFF (X-forwarded-for) headers, if they exist.
        """
        return pulumi.get(self, "accept_xff")

    @accept_xff.setter
    def accept_xff(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accept_xff", value)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application service to which the object belongs.
        """
        return pulumi.get(self, "app_service")

    @app_service.setter
    def app_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service", value)

    @_builtins.property
    @pulumi.getter(name="basicAuthRealm")
    def basic_auth_realm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a quoted string for the basic authentication realm. The system sends this string to a client whenever authorization fails. The default value is `none`
        """
        return pulumi.get(self, "basic_auth_realm")

    @basic_auth_realm.setter
    def basic_auth_realm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "basic_auth_realm", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies user-defined description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptCookieSecret")
    def encrypt_cookie_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type a passphrase for cookie encryption. Note: Since it's a sensitive entity idempotency will fail for it in the update call.
        """
        return pulumi.get(self, "encrypt_cookie_secret")

    @encrypt_cookie_secret.setter
    def encrypt_cookie_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_cookie_secret", value)

    @_builtins.property
    @pulumi.getter(name="encryptCookies")
    def encrypt_cookies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Type the cookie names for the system to encrypt.
        """
        return pulumi.get(self, "encrypt_cookies")

    @encrypt_cookies.setter
    def encrypt_cookies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encrypt_cookies", value)

    @_builtins.property
    @pulumi.getter
    def enforcements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpEnforcementArgs']]]]:
        """
        See Enforcement below for more details.
        """
        return pulumi.get(self, "enforcements")

    @enforcements.setter
    def enforcements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpEnforcementArgs']]]]):
        pulumi.set(self, "enforcements", value)

    @_builtins.property
    @pulumi.getter(name="fallbackHost")
    def fallback_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an HTTP fallback host. HTTP redirection allows you to redirect HTTP traffic to another protocol identifier, host name, port number
        """
        return pulumi.get(self, "fallback_host")

    @fallback_host.setter
    def fallback_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fallback_host", value)

    @_builtins.property
    @pulumi.getter(name="fallbackStatusCodes")
    def fallback_status_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies one or more three-digit status codes that can be returned by an HTTP server,that should trigger a redirection to the fallback host.
        """
        return pulumi.get(self, "fallback_status_codes")

    @fallback_status_codes.setter
    def fallback_status_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fallback_status_codes", value)

    @_builtins.property
    @pulumi.getter(name="headErase")
    def head_erase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the header string that you want to erase from an HTTP request. Default is `none`.
        """
        return pulumi.get(self, "head_erase")

    @head_erase.setter
    def head_erase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "head_erase", value)

    @_builtins.property
    @pulumi.getter(name="headInsert")
    def head_insert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a quoted header string that you want to insert into an HTTP request.Default is `none`.
        """
        return pulumi.get(self, "head_insert")

    @head_insert.setter
    def head_insert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "head_insert", value)

    @_builtins.property
    @pulumi.getter(name="httpStrictTransportSecurities")
    def http_strict_transport_securities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpHttpStrictTransportSecurityArgs']]]]:
        """
        See Http_Strict_Transport_Security below for more details.
        """
        return pulumi.get(self, "http_strict_transport_securities")

    @http_strict_transport_securities.setter
    def http_strict_transport_securities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileHttpHttpStrictTransportSecurityArgs']]]]):
        pulumi.set(self, "http_strict_transport_securities", value)

    @_builtins.property
    @pulumi.getter(name="insertXforwardedFor")
    def insert_xforwarded_for(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies, when enabled, that the system inserts an X-Forwarded-For header in an HTTP request with the client IP address, to use with connection pooling. The default is `Disabled`.
        """
        return pulumi.get(self, "insert_xforwarded_for")

    @insert_xforwarded_for.setter
    def insert_xforwarded_for(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "insert_xforwarded_for", value)

    @_builtins.property
    @pulumi.getter(name="lwsSeparator")
    def lws_separator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you
        specify in the LWS Maximum Columns setting.
        """
        return pulumi.get(self, "lws_separator")

    @lws_separator.setter
    def lws_separator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lws_separator", value)

    @_builtins.property
    @pulumi.getter(name="lwsWidth")
    def lws_width(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you specify in the LWS Maximum Columns setting.
        """
        return pulumi.get(self, "lws_width")

    @lws_width.setter
    def lws_width(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lws_width", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the http profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/test-http-profile`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oneconnectTransformations")
    def oneconnect_transformations(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables the system to perform HTTP header transformations for the purpose of  keeping server-side connections open. This feature requires configuration of a OneConnect profile
        """
        return pulumi.get(self, "oneconnect_transformations")

    @oneconnect_transformations.setter
    def oneconnect_transformations(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oneconnect_transformations", value)

    @_builtins.property
    @pulumi.getter(name="proxyType")
    def proxy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the proxy mode for this profile: reverse, explicit, or transparent. The default is `reverse`.
        """
        return pulumi.get(self, "proxy_type")

    @proxy_type.setter
    def proxy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_type", value)

    @_builtins.property
    @pulumi.getter(name="redirectRewrite")
    def redirect_rewrite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the system rewrites the URIs that are part of HTTP redirect (3XX) responses. The default is `none`.
        """
        return pulumi.get(self, "redirect_rewrite")

    @redirect_rewrite.setter
    def redirect_rewrite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_rewrite", value)

    @_builtins.property
    @pulumi.getter(name="requestChunking")
    def request_chunking(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the system handles HTTP content that is chunked by a client. The default is `preserve`.
        """
        return pulumi.get(self, "request_chunking")

    @request_chunking.setter
    def request_chunking(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_chunking", value)

    @_builtins.property
    @pulumi.getter(name="responseChunking")
    def response_chunking(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the system handles HTTP content that is chunked by a server. The default is `selective`.
        """
        return pulumi.get(self, "response_chunking")

    @response_chunking.setter
    def response_chunking(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_chunking", value)

    @_builtins.property
    @pulumi.getter(name="responseHeadersPermitteds")
    def response_headers_permitteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies headers that the BIG-IP system allows in an HTTP response.If you are specifying more than one header, separate the headers with a blank space.
        """
        return pulumi.get(self, "response_headers_permitteds")

    @response_headers_permitteds.setter
    def response_headers_permitteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "response_headers_permitteds", value)

    @_builtins.property
    @pulumi.getter(name="serverAgentName")
    def server_agent_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the value of the Server header in responses that the BIG-IP itself generates. The default is BigIP. In order to remove it, "none" string is to be passed. If server_agent_name is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "BigIP" explicitly.
        """
        return pulumi.get(self, "server_agent_name")

    @server_agent_name.setter
    def server_agent_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_agent_name", value)

    @_builtins.property
    @pulumi.getter(name="tmPartition")
    def tm_partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays the administrative partition within which this profile resides.
        """
        return pulumi.get(self, "tm_partition")

    @tm_partition.setter
    def tm_partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tm_partition", value)

    @_builtins.property
    @pulumi.getter(name="viaHostName")
    def via_host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the hostname to include into Via header
        """
        return pulumi.get(self, "via_host_name")

    @via_host_name.setter
    def via_host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "via_host_name", value)

    @_builtins.property
    @pulumi.getter(name="viaRequest")
    def via_request(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to append, remove, or preserve a Via header in an HTTP request
        """
        return pulumi.get(self, "via_request")

    @via_request.setter
    def via_request(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "via_request", value)

    @_builtins.property
    @pulumi.getter(name="viaResponse")
    def via_response(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to append, remove, or preserve a Via header in an HTTP request
        """
        return pulumi.get(self, "via_response")

    @via_response.setter
    def via_response(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "via_response", value)

    @_builtins.property
    @pulumi.getter(name="xffAlternativeNames")
    def xff_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies alternative XFF headers instead of the default X-forwarded-for header.
        """
        return pulumi.get(self, "xff_alternative_names")

    @xff_alternative_names.setter
    def xff_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "xff_alternative_names", value)


@pulumi.type_token("f5bigip:ltm/profileHttp:ProfileHttp")
class ProfileHttp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_xff: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 basic_auth_realm: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cookie_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cookies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enforcements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpEnforcementArgs', 'ProfileHttpEnforcementArgsDict']]]]] = None,
                 fallback_host: Optional[pulumi.Input[_builtins.str]] = None,
                 fallback_status_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 head_erase: Optional[pulumi.Input[_builtins.str]] = None,
                 head_insert: Optional[pulumi.Input[_builtins.str]] = None,
                 http_strict_transport_securities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpHttpStrictTransportSecurityArgs', 'ProfileHttpHttpStrictTransportSecurityArgsDict']]]]] = None,
                 insert_xforwarded_for: Optional[pulumi.Input[_builtins.str]] = None,
                 lws_separator: Optional[pulumi.Input[_builtins.str]] = None,
                 lws_width: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oneconnect_transformations: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_rewrite: Optional[pulumi.Input[_builtins.str]] = None,
                 request_chunking: Optional[pulumi.Input[_builtins.str]] = None,
                 response_chunking: Optional[pulumi.Input[_builtins.str]] = None,
                 response_headers_permitteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_agent_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tm_partition: Optional[pulumi.Input[_builtins.str]] = None,
                 via_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 via_request: Optional[pulumi.Input[_builtins.str]] = None,
                 via_response: Optional[pulumi.Input[_builtins.str]] = None,
                 xff_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        `ltm.ProfileHttp` Configures a custom profile_http for use by health checks.

        For resources should be named with their "full path". The full path is the combination of the partition + name of the resource. For example /Common/my-pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sanjose_http = f5bigip.ltm.ProfileHttp("sanjose-http",
            name="/Common/sanjose-http",
            defaults_from="/Common/http",
            fallback_host="titanic",
            fallback_status_codes=[
                "400",
                "500",
                "300",
            ])
        ```

        ## Import

        BIG-IP LTM http profiles can be imported using the `name`, e.g.

        bash

        ```sh
        $ pulumi import f5bigip:ltm/profileHttp:ProfileHttp test-http /Common/test-http
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accept_xff: Enables or disables trusting the client IP address, and statistics from the client IP address, based on the request's XFF (X-forwarded-for) headers, if they exist.
        :param pulumi.Input[_builtins.str] app_service: The application service to which the object belongs.
        :param pulumi.Input[_builtins.str] basic_auth_realm: Specifies a quoted string for the basic authentication realm. The system sends this string to a client whenever authorization fails. The default value is `none`
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] description: Specifies user-defined description.
        :param pulumi.Input[_builtins.str] encrypt_cookie_secret: Type a passphrase for cookie encryption. Note: Since it's a sensitive entity idempotency will fail for it in the update call.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] encrypt_cookies: Type the cookie names for the system to encrypt.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpEnforcementArgs', 'ProfileHttpEnforcementArgsDict']]]] enforcements: See Enforcement below for more details.
        :param pulumi.Input[_builtins.str] fallback_host: Specifies an HTTP fallback host. HTTP redirection allows you to redirect HTTP traffic to another protocol identifier, host name, port number
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fallback_status_codes: Specifies one or more three-digit status codes that can be returned by an HTTP server,that should trigger a redirection to the fallback host.
        :param pulumi.Input[_builtins.str] head_erase: Specifies the header string that you want to erase from an HTTP request. Default is `none`.
        :param pulumi.Input[_builtins.str] head_insert: Specifies a quoted header string that you want to insert into an HTTP request.Default is `none`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpHttpStrictTransportSecurityArgs', 'ProfileHttpHttpStrictTransportSecurityArgsDict']]]] http_strict_transport_securities: See Http_Strict_Transport_Security below for more details.
        :param pulumi.Input[_builtins.str] insert_xforwarded_for: Specifies, when enabled, that the system inserts an X-Forwarded-For header in an HTTP request with the client IP address, to use with connection pooling. The default is `Disabled`.
        :param pulumi.Input[_builtins.str] lws_separator: Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you
               specify in the LWS Maximum Columns setting.
        :param pulumi.Input[_builtins.int] lws_width: Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you specify in the LWS Maximum Columns setting.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the http profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/test-http-profile`.
        :param pulumi.Input[_builtins.str] oneconnect_transformations: Enables the system to perform HTTP header transformations for the purpose of  keeping server-side connections open. This feature requires configuration of a OneConnect profile
        :param pulumi.Input[_builtins.str] proxy_type: Specifies the proxy mode for this profile: reverse, explicit, or transparent. The default is `reverse`.
        :param pulumi.Input[_builtins.str] redirect_rewrite: Specifies whether the system rewrites the URIs that are part of HTTP redirect (3XX) responses. The default is `none`.
        :param pulumi.Input[_builtins.str] request_chunking: Specifies how the system handles HTTP content that is chunked by a client. The default is `preserve`.
        :param pulumi.Input[_builtins.str] response_chunking: Specifies how the system handles HTTP content that is chunked by a server. The default is `selective`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] response_headers_permitteds: Specifies headers that the BIG-IP system allows in an HTTP response.If you are specifying more than one header, separate the headers with a blank space.
        :param pulumi.Input[_builtins.str] server_agent_name: Specifies the value of the Server header in responses that the BIG-IP itself generates. The default is BigIP. In order to remove it, "none" string is to be passed. If server_agent_name is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "BigIP" explicitly.
        :param pulumi.Input[_builtins.str] tm_partition: Displays the administrative partition within which this profile resides.
        :param pulumi.Input[_builtins.str] via_host_name: Specifies the hostname to include into Via header
        :param pulumi.Input[_builtins.str] via_request: Specifies whether to append, remove, or preserve a Via header in an HTTP request
        :param pulumi.Input[_builtins.str] via_response: Specifies whether to append, remove, or preserve a Via header in an HTTP request
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] xff_alternative_names: Specifies alternative XFF headers instead of the default X-forwarded-for header.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileHttpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.ProfileHttp` Configures a custom profile_http for use by health checks.

        For resources should be named with their "full path". The full path is the combination of the partition + name of the resource. For example /Common/my-pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sanjose_http = f5bigip.ltm.ProfileHttp("sanjose-http",
            name="/Common/sanjose-http",
            defaults_from="/Common/http",
            fallback_host="titanic",
            fallback_status_codes=[
                "400",
                "500",
                "300",
            ])
        ```

        ## Import

        BIG-IP LTM http profiles can be imported using the `name`, e.g.

        bash

        ```sh
        $ pulumi import f5bigip:ltm/profileHttp:ProfileHttp test-http /Common/test-http
        ```

        :param str resource_name: The name of the resource.
        :param ProfileHttpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileHttpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_xff: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 basic_auth_realm: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cookie_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_cookies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enforcements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpEnforcementArgs', 'ProfileHttpEnforcementArgsDict']]]]] = None,
                 fallback_host: Optional[pulumi.Input[_builtins.str]] = None,
                 fallback_status_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 head_erase: Optional[pulumi.Input[_builtins.str]] = None,
                 head_insert: Optional[pulumi.Input[_builtins.str]] = None,
                 http_strict_transport_securities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpHttpStrictTransportSecurityArgs', 'ProfileHttpHttpStrictTransportSecurityArgsDict']]]]] = None,
                 insert_xforwarded_for: Optional[pulumi.Input[_builtins.str]] = None,
                 lws_separator: Optional[pulumi.Input[_builtins.str]] = None,
                 lws_width: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oneconnect_transformations: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_rewrite: Optional[pulumi.Input[_builtins.str]] = None,
                 request_chunking: Optional[pulumi.Input[_builtins.str]] = None,
                 response_chunking: Optional[pulumi.Input[_builtins.str]] = None,
                 response_headers_permitteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_agent_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tm_partition: Optional[pulumi.Input[_builtins.str]] = None,
                 via_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 via_request: Optional[pulumi.Input[_builtins.str]] = None,
                 via_response: Optional[pulumi.Input[_builtins.str]] = None,
                 xff_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileHttpArgs.__new__(ProfileHttpArgs)

            __props__.__dict__["accept_xff"] = accept_xff
            __props__.__dict__["app_service"] = app_service
            __props__.__dict__["basic_auth_realm"] = basic_auth_realm
            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["description"] = description
            __props__.__dict__["encrypt_cookie_secret"] = encrypt_cookie_secret
            __props__.__dict__["encrypt_cookies"] = encrypt_cookies
            __props__.__dict__["enforcements"] = enforcements
            __props__.__dict__["fallback_host"] = fallback_host
            __props__.__dict__["fallback_status_codes"] = fallback_status_codes
            __props__.__dict__["head_erase"] = head_erase
            __props__.__dict__["head_insert"] = head_insert
            __props__.__dict__["http_strict_transport_securities"] = http_strict_transport_securities
            __props__.__dict__["insert_xforwarded_for"] = insert_xforwarded_for
            __props__.__dict__["lws_separator"] = lws_separator
            __props__.__dict__["lws_width"] = lws_width
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["oneconnect_transformations"] = oneconnect_transformations
            __props__.__dict__["proxy_type"] = proxy_type
            __props__.__dict__["redirect_rewrite"] = redirect_rewrite
            __props__.__dict__["request_chunking"] = request_chunking
            __props__.__dict__["response_chunking"] = response_chunking
            __props__.__dict__["response_headers_permitteds"] = response_headers_permitteds
            __props__.__dict__["server_agent_name"] = server_agent_name
            __props__.__dict__["tm_partition"] = tm_partition
            __props__.__dict__["via_host_name"] = via_host_name
            __props__.__dict__["via_request"] = via_request
            __props__.__dict__["via_response"] = via_response
            __props__.__dict__["xff_alternative_names"] = xff_alternative_names
        super(ProfileHttp, __self__).__init__(
            'f5bigip:ltm/profileHttp:ProfileHttp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept_xff: Optional[pulumi.Input[_builtins.str]] = None,
            app_service: Optional[pulumi.Input[_builtins.str]] = None,
            basic_auth_realm: Optional[pulumi.Input[_builtins.str]] = None,
            defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt_cookie_secret: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt_cookies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enforcements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpEnforcementArgs', 'ProfileHttpEnforcementArgsDict']]]]] = None,
            fallback_host: Optional[pulumi.Input[_builtins.str]] = None,
            fallback_status_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            head_erase: Optional[pulumi.Input[_builtins.str]] = None,
            head_insert: Optional[pulumi.Input[_builtins.str]] = None,
            http_strict_transport_securities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpHttpStrictTransportSecurityArgs', 'ProfileHttpHttpStrictTransportSecurityArgsDict']]]]] = None,
            insert_xforwarded_for: Optional[pulumi.Input[_builtins.str]] = None,
            lws_separator: Optional[pulumi.Input[_builtins.str]] = None,
            lws_width: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oneconnect_transformations: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_type: Optional[pulumi.Input[_builtins.str]] = None,
            redirect_rewrite: Optional[pulumi.Input[_builtins.str]] = None,
            request_chunking: Optional[pulumi.Input[_builtins.str]] = None,
            response_chunking: Optional[pulumi.Input[_builtins.str]] = None,
            response_headers_permitteds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            server_agent_name: Optional[pulumi.Input[_builtins.str]] = None,
            tm_partition: Optional[pulumi.Input[_builtins.str]] = None,
            via_host_name: Optional[pulumi.Input[_builtins.str]] = None,
            via_request: Optional[pulumi.Input[_builtins.str]] = None,
            via_response: Optional[pulumi.Input[_builtins.str]] = None,
            xff_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ProfileHttp':
        """
        Get an existing ProfileHttp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accept_xff: Enables or disables trusting the client IP address, and statistics from the client IP address, based on the request's XFF (X-forwarded-for) headers, if they exist.
        :param pulumi.Input[_builtins.str] app_service: The application service to which the object belongs.
        :param pulumi.Input[_builtins.str] basic_auth_realm: Specifies a quoted string for the basic authentication realm. The system sends this string to a client whenever authorization fails. The default value is `none`
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] description: Specifies user-defined description.
        :param pulumi.Input[_builtins.str] encrypt_cookie_secret: Type a passphrase for cookie encryption. Note: Since it's a sensitive entity idempotency will fail for it in the update call.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] encrypt_cookies: Type the cookie names for the system to encrypt.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpEnforcementArgs', 'ProfileHttpEnforcementArgsDict']]]] enforcements: See Enforcement below for more details.
        :param pulumi.Input[_builtins.str] fallback_host: Specifies an HTTP fallback host. HTTP redirection allows you to redirect HTTP traffic to another protocol identifier, host name, port number
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fallback_status_codes: Specifies one or more three-digit status codes that can be returned by an HTTP server,that should trigger a redirection to the fallback host.
        :param pulumi.Input[_builtins.str] head_erase: Specifies the header string that you want to erase from an HTTP request. Default is `none`.
        :param pulumi.Input[_builtins.str] head_insert: Specifies a quoted header string that you want to insert into an HTTP request.Default is `none`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProfileHttpHttpStrictTransportSecurityArgs', 'ProfileHttpHttpStrictTransportSecurityArgsDict']]]] http_strict_transport_securities: See Http_Strict_Transport_Security below for more details.
        :param pulumi.Input[_builtins.str] insert_xforwarded_for: Specifies, when enabled, that the system inserts an X-Forwarded-For header in an HTTP request with the client IP address, to use with connection pooling. The default is `Disabled`.
        :param pulumi.Input[_builtins.str] lws_separator: Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you
               specify in the LWS Maximum Columns setting.
        :param pulumi.Input[_builtins.int] lws_width: Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you specify in the LWS Maximum Columns setting.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the http profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/test-http-profile`.
        :param pulumi.Input[_builtins.str] oneconnect_transformations: Enables the system to perform HTTP header transformations for the purpose of  keeping server-side connections open. This feature requires configuration of a OneConnect profile
        :param pulumi.Input[_builtins.str] proxy_type: Specifies the proxy mode for this profile: reverse, explicit, or transparent. The default is `reverse`.
        :param pulumi.Input[_builtins.str] redirect_rewrite: Specifies whether the system rewrites the URIs that are part of HTTP redirect (3XX) responses. The default is `none`.
        :param pulumi.Input[_builtins.str] request_chunking: Specifies how the system handles HTTP content that is chunked by a client. The default is `preserve`.
        :param pulumi.Input[_builtins.str] response_chunking: Specifies how the system handles HTTP content that is chunked by a server. The default is `selective`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] response_headers_permitteds: Specifies headers that the BIG-IP system allows in an HTTP response.If you are specifying more than one header, separate the headers with a blank space.
        :param pulumi.Input[_builtins.str] server_agent_name: Specifies the value of the Server header in responses that the BIG-IP itself generates. The default is BigIP. In order to remove it, "none" string is to be passed. If server_agent_name is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "BigIP" explicitly.
        :param pulumi.Input[_builtins.str] tm_partition: Displays the administrative partition within which this profile resides.
        :param pulumi.Input[_builtins.str] via_host_name: Specifies the hostname to include into Via header
        :param pulumi.Input[_builtins.str] via_request: Specifies whether to append, remove, or preserve a Via header in an HTTP request
        :param pulumi.Input[_builtins.str] via_response: Specifies whether to append, remove, or preserve a Via header in an HTTP request
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] xff_alternative_names: Specifies alternative XFF headers instead of the default X-forwarded-for header.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileHttpState.__new__(_ProfileHttpState)

        __props__.__dict__["accept_xff"] = accept_xff
        __props__.__dict__["app_service"] = app_service
        __props__.__dict__["basic_auth_realm"] = basic_auth_realm
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["description"] = description
        __props__.__dict__["encrypt_cookie_secret"] = encrypt_cookie_secret
        __props__.__dict__["encrypt_cookies"] = encrypt_cookies
        __props__.__dict__["enforcements"] = enforcements
        __props__.__dict__["fallback_host"] = fallback_host
        __props__.__dict__["fallback_status_codes"] = fallback_status_codes
        __props__.__dict__["head_erase"] = head_erase
        __props__.__dict__["head_insert"] = head_insert
        __props__.__dict__["http_strict_transport_securities"] = http_strict_transport_securities
        __props__.__dict__["insert_xforwarded_for"] = insert_xforwarded_for
        __props__.__dict__["lws_separator"] = lws_separator
        __props__.__dict__["lws_width"] = lws_width
        __props__.__dict__["name"] = name
        __props__.__dict__["oneconnect_transformations"] = oneconnect_transformations
        __props__.__dict__["proxy_type"] = proxy_type
        __props__.__dict__["redirect_rewrite"] = redirect_rewrite
        __props__.__dict__["request_chunking"] = request_chunking
        __props__.__dict__["response_chunking"] = response_chunking
        __props__.__dict__["response_headers_permitteds"] = response_headers_permitteds
        __props__.__dict__["server_agent_name"] = server_agent_name
        __props__.__dict__["tm_partition"] = tm_partition
        __props__.__dict__["via_host_name"] = via_host_name
        __props__.__dict__["via_request"] = via_request
        __props__.__dict__["via_response"] = via_response
        __props__.__dict__["xff_alternative_names"] = xff_alternative_names
        return ProfileHttp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceptXff")
    def accept_xff(self) -> pulumi.Output[_builtins.str]:
        """
        Enables or disables trusting the client IP address, and statistics from the client IP address, based on the request's XFF (X-forwarded-for) headers, if they exist.
        """
        return pulumi.get(self, "accept_xff")

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The application service to which the object belongs.
        """
        return pulumi.get(self, "app_service")

    @_builtins.property
    @pulumi.getter(name="basicAuthRealm")
    def basic_auth_realm(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a quoted string for the basic authentication realm. The system sends this string to a client whenever authorization fails. The default value is `none`
        """
        return pulumi.get(self, "basic_auth_realm")

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies user-defined description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptCookieSecret")
    def encrypt_cookie_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type a passphrase for cookie encryption. Note: Since it's a sensitive entity idempotency will fail for it in the update call.
        """
        return pulumi.get(self, "encrypt_cookie_secret")

    @_builtins.property
    @pulumi.getter(name="encryptCookies")
    def encrypt_cookies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Type the cookie names for the system to encrypt.
        """
        return pulumi.get(self, "encrypt_cookies")

    @_builtins.property
    @pulumi.getter
    def enforcements(self) -> pulumi.Output[Sequence['outputs.ProfileHttpEnforcement']]:
        """
        See Enforcement below for more details.
        """
        return pulumi.get(self, "enforcements")

    @_builtins.property
    @pulumi.getter(name="fallbackHost")
    def fallback_host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies an HTTP fallback host. HTTP redirection allows you to redirect HTTP traffic to another protocol identifier, host name, port number
        """
        return pulumi.get(self, "fallback_host")

    @_builtins.property
    @pulumi.getter(name="fallbackStatusCodes")
    def fallback_status_codes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies one or more three-digit status codes that can be returned by an HTTP server,that should trigger a redirection to the fallback host.
        """
        return pulumi.get(self, "fallback_status_codes")

    @_builtins.property
    @pulumi.getter(name="headErase")
    def head_erase(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the header string that you want to erase from an HTTP request. Default is `none`.
        """
        return pulumi.get(self, "head_erase")

    @_builtins.property
    @pulumi.getter(name="headInsert")
    def head_insert(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a quoted header string that you want to insert into an HTTP request.Default is `none`.
        """
        return pulumi.get(self, "head_insert")

    @_builtins.property
    @pulumi.getter(name="httpStrictTransportSecurities")
    def http_strict_transport_securities(self) -> pulumi.Output[Sequence['outputs.ProfileHttpHttpStrictTransportSecurity']]:
        """
        See Http_Strict_Transport_Security below for more details.
        """
        return pulumi.get(self, "http_strict_transport_securities")

    @_builtins.property
    @pulumi.getter(name="insertXforwardedFor")
    def insert_xforwarded_for(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies, when enabled, that the system inserts an X-Forwarded-For header in an HTTP request with the client IP address, to use with connection pooling. The default is `Disabled`.
        """
        return pulumi.get(self, "insert_xforwarded_for")

    @_builtins.property
    @pulumi.getter(name="lwsSeparator")
    def lws_separator(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you
        specify in the LWS Maximum Columns setting.
        """
        return pulumi.get(self, "lws_separator")

    @_builtins.property
    @pulumi.getter(name="lwsWidth")
    def lws_width(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the linear white space (LWS) separator that the system inserts when a header exceeds the maximum width you specify in the LWS Maximum Columns setting.
        """
        return pulumi.get(self, "lws_width")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the http profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/test-http-profile`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oneconnectTransformations")
    def oneconnect_transformations(self) -> pulumi.Output[_builtins.str]:
        """
        Enables the system to perform HTTP header transformations for the purpose of  keeping server-side connections open. This feature requires configuration of a OneConnect profile
        """
        return pulumi.get(self, "oneconnect_transformations")

    @_builtins.property
    @pulumi.getter(name="proxyType")
    def proxy_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the proxy mode for this profile: reverse, explicit, or transparent. The default is `reverse`.
        """
        return pulumi.get(self, "proxy_type")

    @_builtins.property
    @pulumi.getter(name="redirectRewrite")
    def redirect_rewrite(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether the system rewrites the URIs that are part of HTTP redirect (3XX) responses. The default is `none`.
        """
        return pulumi.get(self, "redirect_rewrite")

    @_builtins.property
    @pulumi.getter(name="requestChunking")
    def request_chunking(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies how the system handles HTTP content that is chunked by a client. The default is `preserve`.
        """
        return pulumi.get(self, "request_chunking")

    @_builtins.property
    @pulumi.getter(name="responseChunking")
    def response_chunking(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies how the system handles HTTP content that is chunked by a server. The default is `selective`.
        """
        return pulumi.get(self, "response_chunking")

    @_builtins.property
    @pulumi.getter(name="responseHeadersPermitteds")
    def response_headers_permitteds(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies headers that the BIG-IP system allows in an HTTP response.If you are specifying more than one header, separate the headers with a blank space.
        """
        return pulumi.get(self, "response_headers_permitteds")

    @_builtins.property
    @pulumi.getter(name="serverAgentName")
    def server_agent_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the value of the Server header in responses that the BIG-IP itself generates. The default is BigIP. In order to remove it, "none" string is to be passed. If server_agent_name is commented (or not passed) during the update call, then no changes would be applied and previous value will persist. In order to put default value, we need to pass "BigIP" explicitly.
        """
        return pulumi.get(self, "server_agent_name")

    @_builtins.property
    @pulumi.getter(name="tmPartition")
    def tm_partition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Displays the administrative partition within which this profile resides.
        """
        return pulumi.get(self, "tm_partition")

    @_builtins.property
    @pulumi.getter(name="viaHostName")
    def via_host_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the hostname to include into Via header
        """
        return pulumi.get(self, "via_host_name")

    @_builtins.property
    @pulumi.getter(name="viaRequest")
    def via_request(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to append, remove, or preserve a Via header in an HTTP request
        """
        return pulumi.get(self, "via_request")

    @_builtins.property
    @pulumi.getter(name="viaResponse")
    def via_response(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to append, remove, or preserve a Via header in an HTTP request
        """
        return pulumi.get(self, "via_response")

    @_builtins.property
    @pulumi.getter(name="xffAlternativeNames")
    def xff_alternative_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies alternative XFF headers instead of the default X-forwarded-for header.
        """
        return pulumi.get(self, "xff_alternative_names")

