# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProfileWebAccelerationArgs', 'ProfileWebAcceleration']

@pulumi.input_type
class ProfileWebAccelerationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 cache_aging_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_client_cache_control_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_insert_age_header: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_max_entries: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_object_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_object_min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_include_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_pinneds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProfileWebAcceleration resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the web acceleration profile service ,name of Profile should be full path. Full path is the combination of the `partition + web acceleration profile name`,For example `/Common/sample-resource`.
        :param pulumi.Input[_builtins.int] cache_aging_rate: Specifies how quickly the system ages a cache entry. The aging rate ranges from 0 (slowest aging) to 10 (fastest aging). The default value is `9`.
        :param pulumi.Input[_builtins.str] cache_client_cache_control_mode: Specifies which cache disabling headers sent by clients the system ignores. The default value is `all`.
        :param pulumi.Input[_builtins.str] cache_insert_age_header: Inserts Age and Date headers in the response. The default value is `enabled`.
        :param pulumi.Input[_builtins.int] cache_max_age: Specifies how long the system considers the cached content to be valid. The default value is `3600 seconds`.
        :param pulumi.Input[_builtins.int] cache_max_entries: Specifies the maximum number of entries that can be in the cache. The default value is `0` (zero), which means that the system does not limit the maximum entries.
        :param pulumi.Input[_builtins.int] cache_object_max_size: Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        :param pulumi.Input[_builtins.int] cache_object_min_size: Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        :param pulumi.Input[_builtins.int] cache_size: Specifies the maximum size for the cache. When the cache reaches the maximum size, the system starts removing the oldest entries. The default value is `100 megabytes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_excludes: Configures a list of URIs to exclude from the cache. The default value of `none` specifies no URIs are excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_include_overrides: Configures a list of URIs to include in the cache even if they would normally be excluded due to factors like object size or HTTP request type. The default value of none specifies no URIs are to be forced into the cache.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_includes: Configures a list of URIs to include in the cache. The default value of `.*` specifies that all URIs are cacheable.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_pinneds: Configures a list of URIs to keep in the cache. The pinning process keeps URIs in cache when they would normally be evicted to make room for more active URIs.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        pulumi.set(__self__, "name", name)
        if cache_aging_rate is not None:
            pulumi.set(__self__, "cache_aging_rate", cache_aging_rate)
        if cache_client_cache_control_mode is not None:
            pulumi.set(__self__, "cache_client_cache_control_mode", cache_client_cache_control_mode)
        if cache_insert_age_header is not None:
            pulumi.set(__self__, "cache_insert_age_header", cache_insert_age_header)
        if cache_max_age is not None:
            pulumi.set(__self__, "cache_max_age", cache_max_age)
        if cache_max_entries is not None:
            pulumi.set(__self__, "cache_max_entries", cache_max_entries)
        if cache_object_max_size is not None:
            pulumi.set(__self__, "cache_object_max_size", cache_object_max_size)
        if cache_object_min_size is not None:
            pulumi.set(__self__, "cache_object_min_size", cache_object_min_size)
        if cache_size is not None:
            pulumi.set(__self__, "cache_size", cache_size)
        if cache_uri_excludes is not None:
            pulumi.set(__self__, "cache_uri_excludes", cache_uri_excludes)
        if cache_uri_include_overrides is not None:
            pulumi.set(__self__, "cache_uri_include_overrides", cache_uri_include_overrides)
        if cache_uri_includes is not None:
            pulumi.set(__self__, "cache_uri_includes", cache_uri_includes)
        if cache_uri_pinneds is not None:
            pulumi.set(__self__, "cache_uri_pinneds", cache_uri_pinneds)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the web acceleration profile service ,name of Profile should be full path. Full path is the combination of the `partition + web acceleration profile name`,For example `/Common/sample-resource`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="cacheAgingRate")
    def cache_aging_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how quickly the system ages a cache entry. The aging rate ranges from 0 (slowest aging) to 10 (fastest aging). The default value is `9`.
        """
        return pulumi.get(self, "cache_aging_rate")

    @cache_aging_rate.setter
    def cache_aging_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_aging_rate", value)

    @_builtins.property
    @pulumi.getter(name="cacheClientCacheControlMode")
    def cache_client_cache_control_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which cache disabling headers sent by clients the system ignores. The default value is `all`.
        """
        return pulumi.get(self, "cache_client_cache_control_mode")

    @cache_client_cache_control_mode.setter
    def cache_client_cache_control_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_client_cache_control_mode", value)

    @_builtins.property
    @pulumi.getter(name="cacheInsertAgeHeader")
    def cache_insert_age_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Inserts Age and Date headers in the response. The default value is `enabled`.
        """
        return pulumi.get(self, "cache_insert_age_header")

    @cache_insert_age_header.setter
    def cache_insert_age_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_insert_age_header", value)

    @_builtins.property
    @pulumi.getter(name="cacheMaxAge")
    def cache_max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how long the system considers the cached content to be valid. The default value is `3600 seconds`.
        """
        return pulumi.get(self, "cache_max_age")

    @cache_max_age.setter
    def cache_max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_max_age", value)

    @_builtins.property
    @pulumi.getter(name="cacheMaxEntries")
    def cache_max_entries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of entries that can be in the cache. The default value is `0` (zero), which means that the system does not limit the maximum entries.
        """
        return pulumi.get(self, "cache_max_entries")

    @cache_max_entries.setter
    def cache_max_entries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_max_entries", value)

    @_builtins.property
    @pulumi.getter(name="cacheObjectMaxSize")
    def cache_object_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        """
        return pulumi.get(self, "cache_object_max_size")

    @cache_object_max_size.setter
    def cache_object_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_object_max_size", value)

    @_builtins.property
    @pulumi.getter(name="cacheObjectMinSize")
    def cache_object_min_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        """
        return pulumi.get(self, "cache_object_min_size")

    @cache_object_min_size.setter
    def cache_object_min_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_object_min_size", value)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum size for the cache. When the cache reaches the maximum size, the system starts removing the oldest entries. The default value is `100 megabytes`.
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_size", value)

    @_builtins.property
    @pulumi.getter(name="cacheUriExcludes")
    def cache_uri_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configures a list of URIs to exclude from the cache. The default value of `none` specifies no URIs are excluded.
        """
        return pulumi.get(self, "cache_uri_excludes")

    @cache_uri_excludes.setter
    def cache_uri_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_uri_excludes", value)

    @_builtins.property
    @pulumi.getter(name="cacheUriIncludeOverrides")
    def cache_uri_include_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configures a list of URIs to include in the cache even if they would normally be excluded due to factors like object size or HTTP request type. The default value of none specifies no URIs are to be forced into the cache.
        """
        return pulumi.get(self, "cache_uri_include_overrides")

    @cache_uri_include_overrides.setter
    def cache_uri_include_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_uri_include_overrides", value)

    @_builtins.property
    @pulumi.getter(name="cacheUriIncludes")
    def cache_uri_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configures a list of URIs to include in the cache. The default value of `.*` specifies that all URIs are cacheable.
        """
        return pulumi.get(self, "cache_uri_includes")

    @cache_uri_includes.setter
    def cache_uri_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_uri_includes", value)

    @_builtins.property
    @pulumi.getter(name="cacheUriPinneds")
    def cache_uri_pinneds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configures a list of URIs to keep in the cache. The pinning process keeps URIs in cache when they would normally be evicted to make room for more active URIs.
        """
        return pulumi.get(self, "cache_uri_pinneds")

    @cache_uri_pinneds.setter
    def cache_uri_pinneds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_uri_pinneds", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)


@pulumi.input_type
class _ProfileWebAccelerationState:
    def __init__(__self__, *,
                 cache_aging_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_client_cache_control_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_insert_age_header: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_max_entries: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_object_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_object_min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_include_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_pinneds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProfileWebAcceleration resources.
        :param pulumi.Input[_builtins.int] cache_aging_rate: Specifies how quickly the system ages a cache entry. The aging rate ranges from 0 (slowest aging) to 10 (fastest aging). The default value is `9`.
        :param pulumi.Input[_builtins.str] cache_client_cache_control_mode: Specifies which cache disabling headers sent by clients the system ignores. The default value is `all`.
        :param pulumi.Input[_builtins.str] cache_insert_age_header: Inserts Age and Date headers in the response. The default value is `enabled`.
        :param pulumi.Input[_builtins.int] cache_max_age: Specifies how long the system considers the cached content to be valid. The default value is `3600 seconds`.
        :param pulumi.Input[_builtins.int] cache_max_entries: Specifies the maximum number of entries that can be in the cache. The default value is `0` (zero), which means that the system does not limit the maximum entries.
        :param pulumi.Input[_builtins.int] cache_object_max_size: Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        :param pulumi.Input[_builtins.int] cache_object_min_size: Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        :param pulumi.Input[_builtins.int] cache_size: Specifies the maximum size for the cache. When the cache reaches the maximum size, the system starts removing the oldest entries. The default value is `100 megabytes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_excludes: Configures a list of URIs to exclude from the cache. The default value of `none` specifies no URIs are excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_include_overrides: Configures a list of URIs to include in the cache even if they would normally be excluded due to factors like object size or HTTP request type. The default value of none specifies no URIs are to be forced into the cache.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_includes: Configures a list of URIs to include in the cache. The default value of `.*` specifies that all URIs are cacheable.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_pinneds: Configures a list of URIs to keep in the cache. The pinning process keeps URIs in cache when they would normally be evicted to make room for more active URIs.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the web acceleration profile service ,name of Profile should be full path. Full path is the combination of the `partition + web acceleration profile name`,For example `/Common/sample-resource`.
        """
        if cache_aging_rate is not None:
            pulumi.set(__self__, "cache_aging_rate", cache_aging_rate)
        if cache_client_cache_control_mode is not None:
            pulumi.set(__self__, "cache_client_cache_control_mode", cache_client_cache_control_mode)
        if cache_insert_age_header is not None:
            pulumi.set(__self__, "cache_insert_age_header", cache_insert_age_header)
        if cache_max_age is not None:
            pulumi.set(__self__, "cache_max_age", cache_max_age)
        if cache_max_entries is not None:
            pulumi.set(__self__, "cache_max_entries", cache_max_entries)
        if cache_object_max_size is not None:
            pulumi.set(__self__, "cache_object_max_size", cache_object_max_size)
        if cache_object_min_size is not None:
            pulumi.set(__self__, "cache_object_min_size", cache_object_min_size)
        if cache_size is not None:
            pulumi.set(__self__, "cache_size", cache_size)
        if cache_uri_excludes is not None:
            pulumi.set(__self__, "cache_uri_excludes", cache_uri_excludes)
        if cache_uri_include_overrides is not None:
            pulumi.set(__self__, "cache_uri_include_overrides", cache_uri_include_overrides)
        if cache_uri_includes is not None:
            pulumi.set(__self__, "cache_uri_includes", cache_uri_includes)
        if cache_uri_pinneds is not None:
            pulumi.set(__self__, "cache_uri_pinneds", cache_uri_pinneds)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="cacheAgingRate")
    def cache_aging_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how quickly the system ages a cache entry. The aging rate ranges from 0 (slowest aging) to 10 (fastest aging). The default value is `9`.
        """
        return pulumi.get(self, "cache_aging_rate")

    @cache_aging_rate.setter
    def cache_aging_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_aging_rate", value)

    @_builtins.property
    @pulumi.getter(name="cacheClientCacheControlMode")
    def cache_client_cache_control_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which cache disabling headers sent by clients the system ignores. The default value is `all`.
        """
        return pulumi.get(self, "cache_client_cache_control_mode")

    @cache_client_cache_control_mode.setter
    def cache_client_cache_control_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_client_cache_control_mode", value)

    @_builtins.property
    @pulumi.getter(name="cacheInsertAgeHeader")
    def cache_insert_age_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Inserts Age and Date headers in the response. The default value is `enabled`.
        """
        return pulumi.get(self, "cache_insert_age_header")

    @cache_insert_age_header.setter
    def cache_insert_age_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_insert_age_header", value)

    @_builtins.property
    @pulumi.getter(name="cacheMaxAge")
    def cache_max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how long the system considers the cached content to be valid. The default value is `3600 seconds`.
        """
        return pulumi.get(self, "cache_max_age")

    @cache_max_age.setter
    def cache_max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_max_age", value)

    @_builtins.property
    @pulumi.getter(name="cacheMaxEntries")
    def cache_max_entries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of entries that can be in the cache. The default value is `0` (zero), which means that the system does not limit the maximum entries.
        """
        return pulumi.get(self, "cache_max_entries")

    @cache_max_entries.setter
    def cache_max_entries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_max_entries", value)

    @_builtins.property
    @pulumi.getter(name="cacheObjectMaxSize")
    def cache_object_max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        """
        return pulumi.get(self, "cache_object_max_size")

    @cache_object_max_size.setter
    def cache_object_max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_object_max_size", value)

    @_builtins.property
    @pulumi.getter(name="cacheObjectMinSize")
    def cache_object_min_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        """
        return pulumi.get(self, "cache_object_min_size")

    @cache_object_min_size.setter
    def cache_object_min_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_object_min_size", value)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum size for the cache. When the cache reaches the maximum size, the system starts removing the oldest entries. The default value is `100 megabytes`.
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_size", value)

    @_builtins.property
    @pulumi.getter(name="cacheUriExcludes")
    def cache_uri_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configures a list of URIs to exclude from the cache. The default value of `none` specifies no URIs are excluded.
        """
        return pulumi.get(self, "cache_uri_excludes")

    @cache_uri_excludes.setter
    def cache_uri_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_uri_excludes", value)

    @_builtins.property
    @pulumi.getter(name="cacheUriIncludeOverrides")
    def cache_uri_include_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configures a list of URIs to include in the cache even if they would normally be excluded due to factors like object size or HTTP request type. The default value of none specifies no URIs are to be forced into the cache.
        """
        return pulumi.get(self, "cache_uri_include_overrides")

    @cache_uri_include_overrides.setter
    def cache_uri_include_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_uri_include_overrides", value)

    @_builtins.property
    @pulumi.getter(name="cacheUriIncludes")
    def cache_uri_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configures a list of URIs to include in the cache. The default value of `.*` specifies that all URIs are cacheable.
        """
        return pulumi.get(self, "cache_uri_includes")

    @cache_uri_includes.setter
    def cache_uri_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_uri_includes", value)

    @_builtins.property
    @pulumi.getter(name="cacheUriPinneds")
    def cache_uri_pinneds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configures a list of URIs to keep in the cache. The pinning process keeps URIs in cache when they would normally be evicted to make room for more active URIs.
        """
        return pulumi.get(self, "cache_uri_pinneds")

    @cache_uri_pinneds.setter
    def cache_uri_pinneds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_uri_pinneds", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the web acceleration profile service ,name of Profile should be full path. Full path is the combination of the `partition + web acceleration profile name`,For example `/Common/sample-resource`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("f5bigip:ltm/profileWebAcceleration:ProfileWebAcceleration")
class ProfileWebAcceleration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_aging_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_client_cache_control_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_insert_age_header: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_max_entries: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_object_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_object_min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_include_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_pinneds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `ltm.ProfileWebAcceleration` Configures a custom web-acceleration profile for use.

        For resources should be named with their "full path". The full path is the combination of the partition + name of the resource. For example /Common/sample-resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sample_resource = f5bigip.ltm.ProfileWebAcceleration("sample-resource",
            name="/Common/sample-resource",
            defaults_from="/Common/test2",
            cache_size=101,
            cache_max_entries=201)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cache_aging_rate: Specifies how quickly the system ages a cache entry. The aging rate ranges from 0 (slowest aging) to 10 (fastest aging). The default value is `9`.
        :param pulumi.Input[_builtins.str] cache_client_cache_control_mode: Specifies which cache disabling headers sent by clients the system ignores. The default value is `all`.
        :param pulumi.Input[_builtins.str] cache_insert_age_header: Inserts Age and Date headers in the response. The default value is `enabled`.
        :param pulumi.Input[_builtins.int] cache_max_age: Specifies how long the system considers the cached content to be valid. The default value is `3600 seconds`.
        :param pulumi.Input[_builtins.int] cache_max_entries: Specifies the maximum number of entries that can be in the cache. The default value is `0` (zero), which means that the system does not limit the maximum entries.
        :param pulumi.Input[_builtins.int] cache_object_max_size: Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        :param pulumi.Input[_builtins.int] cache_object_min_size: Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        :param pulumi.Input[_builtins.int] cache_size: Specifies the maximum size for the cache. When the cache reaches the maximum size, the system starts removing the oldest entries. The default value is `100 megabytes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_excludes: Configures a list of URIs to exclude from the cache. The default value of `none` specifies no URIs are excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_include_overrides: Configures a list of URIs to include in the cache even if they would normally be excluded due to factors like object size or HTTP request type. The default value of none specifies no URIs are to be forced into the cache.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_includes: Configures a list of URIs to include in the cache. The default value of `.*` specifies that all URIs are cacheable.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_pinneds: Configures a list of URIs to keep in the cache. The pinning process keeps URIs in cache when they would normally be evicted to make room for more active URIs.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the web acceleration profile service ,name of Profile should be full path. Full path is the combination of the `partition + web acceleration profile name`,For example `/Common/sample-resource`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileWebAccelerationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.ProfileWebAcceleration` Configures a custom web-acceleration profile for use.

        For resources should be named with their "full path". The full path is the combination of the partition + name of the resource. For example /Common/sample-resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        sample_resource = f5bigip.ltm.ProfileWebAcceleration("sample-resource",
            name="/Common/sample-resource",
            defaults_from="/Common/test2",
            cache_size=101,
            cache_max_entries=201)
        ```

        :param str resource_name: The name of the resource.
        :param ProfileWebAccelerationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileWebAccelerationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_aging_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_client_cache_control_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_insert_age_header: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_max_entries: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_object_max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_object_min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_include_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_uri_pinneds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileWebAccelerationArgs.__new__(ProfileWebAccelerationArgs)

            __props__.__dict__["cache_aging_rate"] = cache_aging_rate
            __props__.__dict__["cache_client_cache_control_mode"] = cache_client_cache_control_mode
            __props__.__dict__["cache_insert_age_header"] = cache_insert_age_header
            __props__.__dict__["cache_max_age"] = cache_max_age
            __props__.__dict__["cache_max_entries"] = cache_max_entries
            __props__.__dict__["cache_object_max_size"] = cache_object_max_size
            __props__.__dict__["cache_object_min_size"] = cache_object_min_size
            __props__.__dict__["cache_size"] = cache_size
            __props__.__dict__["cache_uri_excludes"] = cache_uri_excludes
            __props__.__dict__["cache_uri_include_overrides"] = cache_uri_include_overrides
            __props__.__dict__["cache_uri_includes"] = cache_uri_includes
            __props__.__dict__["cache_uri_pinneds"] = cache_uri_pinneds
            __props__.__dict__["defaults_from"] = defaults_from
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(ProfileWebAcceleration, __self__).__init__(
            'f5bigip:ltm/profileWebAcceleration:ProfileWebAcceleration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_aging_rate: Optional[pulumi.Input[_builtins.int]] = None,
            cache_client_cache_control_mode: Optional[pulumi.Input[_builtins.str]] = None,
            cache_insert_age_header: Optional[pulumi.Input[_builtins.str]] = None,
            cache_max_age: Optional[pulumi.Input[_builtins.int]] = None,
            cache_max_entries: Optional[pulumi.Input[_builtins.int]] = None,
            cache_object_max_size: Optional[pulumi.Input[_builtins.int]] = None,
            cache_object_min_size: Optional[pulumi.Input[_builtins.int]] = None,
            cache_size: Optional[pulumi.Input[_builtins.int]] = None,
            cache_uri_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cache_uri_include_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cache_uri_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cache_uri_pinneds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProfileWebAcceleration':
        """
        Get an existing ProfileWebAcceleration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cache_aging_rate: Specifies how quickly the system ages a cache entry. The aging rate ranges from 0 (slowest aging) to 10 (fastest aging). The default value is `9`.
        :param pulumi.Input[_builtins.str] cache_client_cache_control_mode: Specifies which cache disabling headers sent by clients the system ignores. The default value is `all`.
        :param pulumi.Input[_builtins.str] cache_insert_age_header: Inserts Age and Date headers in the response. The default value is `enabled`.
        :param pulumi.Input[_builtins.int] cache_max_age: Specifies how long the system considers the cached content to be valid. The default value is `3600 seconds`.
        :param pulumi.Input[_builtins.int] cache_max_entries: Specifies the maximum number of entries that can be in the cache. The default value is `0` (zero), which means that the system does not limit the maximum entries.
        :param pulumi.Input[_builtins.int] cache_object_max_size: Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        :param pulumi.Input[_builtins.int] cache_object_min_size: Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        :param pulumi.Input[_builtins.int] cache_size: Specifies the maximum size for the cache. When the cache reaches the maximum size, the system starts removing the oldest entries. The default value is `100 megabytes`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_excludes: Configures a list of URIs to exclude from the cache. The default value of `none` specifies no URIs are excluded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_include_overrides: Configures a list of URIs to include in the cache even if they would normally be excluded due to factors like object size or HTTP request type. The default value of none specifies no URIs are to be forced into the cache.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_includes: Configures a list of URIs to include in the cache. The default value of `.*` specifies that all URIs are cacheable.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_uri_pinneds: Configures a list of URIs to keep in the cache. The pinning process keeps URIs in cache when they would normally be evicted to make room for more active URIs.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the web acceleration profile service ,name of Profile should be full path. Full path is the combination of the `partition + web acceleration profile name`,For example `/Common/sample-resource`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileWebAccelerationState.__new__(_ProfileWebAccelerationState)

        __props__.__dict__["cache_aging_rate"] = cache_aging_rate
        __props__.__dict__["cache_client_cache_control_mode"] = cache_client_cache_control_mode
        __props__.__dict__["cache_insert_age_header"] = cache_insert_age_header
        __props__.__dict__["cache_max_age"] = cache_max_age
        __props__.__dict__["cache_max_entries"] = cache_max_entries
        __props__.__dict__["cache_object_max_size"] = cache_object_max_size
        __props__.__dict__["cache_object_min_size"] = cache_object_min_size
        __props__.__dict__["cache_size"] = cache_size
        __props__.__dict__["cache_uri_excludes"] = cache_uri_excludes
        __props__.__dict__["cache_uri_include_overrides"] = cache_uri_include_overrides
        __props__.__dict__["cache_uri_includes"] = cache_uri_includes
        __props__.__dict__["cache_uri_pinneds"] = cache_uri_pinneds
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["name"] = name
        return ProfileWebAcceleration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cacheAgingRate")
    def cache_aging_rate(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies how quickly the system ages a cache entry. The aging rate ranges from 0 (slowest aging) to 10 (fastest aging). The default value is `9`.
        """
        return pulumi.get(self, "cache_aging_rate")

    @_builtins.property
    @pulumi.getter(name="cacheClientCacheControlMode")
    def cache_client_cache_control_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies which cache disabling headers sent by clients the system ignores. The default value is `all`.
        """
        return pulumi.get(self, "cache_client_cache_control_mode")

    @_builtins.property
    @pulumi.getter(name="cacheInsertAgeHeader")
    def cache_insert_age_header(self) -> pulumi.Output[_builtins.str]:
        """
        Inserts Age and Date headers in the response. The default value is `enabled`.
        """
        return pulumi.get(self, "cache_insert_age_header")

    @_builtins.property
    @pulumi.getter(name="cacheMaxAge")
    def cache_max_age(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies how long the system considers the cached content to be valid. The default value is `3600 seconds`.
        """
        return pulumi.get(self, "cache_max_age")

    @_builtins.property
    @pulumi.getter(name="cacheMaxEntries")
    def cache_max_entries(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum number of entries that can be in the cache. The default value is `0` (zero), which means that the system does not limit the maximum entries.
        """
        return pulumi.get(self, "cache_max_entries")

    @_builtins.property
    @pulumi.getter(name="cacheObjectMaxSize")
    def cache_object_max_size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        """
        return pulumi.get(self, "cache_object_max_size")

    @_builtins.property
    @pulumi.getter(name="cacheObjectMinSize")
    def cache_object_min_size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the smallest object that the system considers eligible for caching. The default value is `500 bytes`.
        """
        return pulumi.get(self, "cache_object_min_size")

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum size for the cache. When the cache reaches the maximum size, the system starts removing the oldest entries. The default value is `100 megabytes`.
        """
        return pulumi.get(self, "cache_size")

    @_builtins.property
    @pulumi.getter(name="cacheUriExcludes")
    def cache_uri_excludes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Configures a list of URIs to exclude from the cache. The default value of `none` specifies no URIs are excluded.
        """
        return pulumi.get(self, "cache_uri_excludes")

    @_builtins.property
    @pulumi.getter(name="cacheUriIncludeOverrides")
    def cache_uri_include_overrides(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Configures a list of URIs to include in the cache even if they would normally be excluded due to factors like object size or HTTP request type. The default value of none specifies no URIs are to be forced into the cache.
        """
        return pulumi.get(self, "cache_uri_include_overrides")

    @_builtins.property
    @pulumi.getter(name="cacheUriIncludes")
    def cache_uri_includes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Configures a list of URIs to include in the cache. The default value of `.*` specifies that all URIs are cacheable.
        """
        return pulumi.get(self, "cache_uri_includes")

    @_builtins.property
    @pulumi.getter(name="cacheUriPinneds")
    def cache_uri_pinneds(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Configures a list of URIs to keep in the cache. The pinning process keeps URIs in cache when they would normally be evicted to make room for more active URIs.
        """
        return pulumi.get(self, "cache_uri_pinneds")

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the profile that you want to use as the parent profile. Your new profile inherits all settings and values from the parent profile specified.
        """
        return pulumi.get(self, "defaults_from")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the web acceleration profile service ,name of Profile should be full path. Full path is the combination of the `partition + web acceleration profile name`,For example `/Common/sample-resource`.
        """
        return pulumi.get(self, "name")

