# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RequestLogProfileArgs', 'RequestLogProfile']

@pulumi.input_type
class RequestLogProfileArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_response: Optional[pulumi.Input[_builtins.str]] = None,
                 proxyclose_on_error: Optional[pulumi.Input[_builtins.str]] = None,
                 proxyrespond_on_loggingerror: Optional[pulumi.Input[_builtins.str]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_template: Optional[pulumi.Input[_builtins.str]] = None,
                 response_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RequestLogProfile resource.
        :param pulumi.Input[_builtins.str] name: Name of the Request Logging profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/request-log-profile-tc1`.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log` profile.
        :param pulumi.Input[_builtins.str] description: Specifies user-defined description.
        :param pulumi.Input[_builtins.str] proxy_response: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] proxyclose_on_error: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] proxyrespond_on_loggingerror: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] request_logging: Enables or disables request logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        :param pulumi.Input[_builtins.str] requestlog_error_pool: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] requestlog_error_protocol: Specifies the protocol to be used for high-speed logging of request errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] requestlog_error_template: Specifies the directives and entries to be logged for request errors.
        :param pulumi.Input[_builtins.str] requestlog_pool: Defines the pool to send logs to. Typically, the pool will contain one or more syslog servers. It is recommended that you create a pool specifically for logging requests. The default is `none`.
        :param pulumi.Input[_builtins.str] requestlog_protocol: Specifies the protocol to be used for high-speed logging of requests. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] requestlog_template: Specifies the directives and entries to be logged. More infor on requestlog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        :param pulumi.Input[_builtins.str] response_logging: Enables or disables response logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        :param pulumi.Input[_builtins.str] responselog_error_pool: Defines the pool associated with logging response errors. The default is `none`.
        :param pulumi.Input[_builtins.str] responselog_error_protocol: Specifies the protocol to be used for high-speed logging of response errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] responselog_error_template: Specifies the directives and entries to be logged for request errors.
        :param pulumi.Input[_builtins.str] responselog_pool: Defines the pool to send logs to. Typically, the pool contains one or more syslog servers. It is recommended that you create a pool specifically for logging responses. The default is `none`.
        :param pulumi.Input[_builtins.str] responselog_protocol: Specifies the protocol to be used for high-speed logging of responses. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] responselog_template: Specifies the directives and entries to be logged. More infor on responselog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        pulumi.set(__self__, "name", name)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if proxy_response is not None:
            pulumi.set(__self__, "proxy_response", proxy_response)
        if proxyclose_on_error is not None:
            pulumi.set(__self__, "proxyclose_on_error", proxyclose_on_error)
        if proxyrespond_on_loggingerror is not None:
            pulumi.set(__self__, "proxyrespond_on_loggingerror", proxyrespond_on_loggingerror)
        if request_logging is not None:
            pulumi.set(__self__, "request_logging", request_logging)
        if requestlog_error_pool is not None:
            pulumi.set(__self__, "requestlog_error_pool", requestlog_error_pool)
        if requestlog_error_protocol is not None:
            pulumi.set(__self__, "requestlog_error_protocol", requestlog_error_protocol)
        if requestlog_error_template is not None:
            pulumi.set(__self__, "requestlog_error_template", requestlog_error_template)
        if requestlog_pool is not None:
            pulumi.set(__self__, "requestlog_pool", requestlog_pool)
        if requestlog_protocol is not None:
            pulumi.set(__self__, "requestlog_protocol", requestlog_protocol)
        if requestlog_template is not None:
            pulumi.set(__self__, "requestlog_template", requestlog_template)
        if response_logging is not None:
            pulumi.set(__self__, "response_logging", response_logging)
        if responselog_error_pool is not None:
            pulumi.set(__self__, "responselog_error_pool", responselog_error_pool)
        if responselog_error_protocol is not None:
            pulumi.set(__self__, "responselog_error_protocol", responselog_error_protocol)
        if responselog_error_template is not None:
            pulumi.set(__self__, "responselog_error_template", responselog_error_template)
        if responselog_pool is not None:
            pulumi.set(__self__, "responselog_pool", responselog_pool)
        if responselog_protocol is not None:
            pulumi.set(__self__, "responselog_protocol", responselog_protocol)
        if responselog_template is not None:
            pulumi.set(__self__, "responselog_template", responselog_template)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Request Logging profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/request-log-profile-tc1`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log` profile.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies user-defined description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="proxyResponse")
    def proxy_response(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "proxy_response")

    @proxy_response.setter
    def proxy_response(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_response", value)

    @_builtins.property
    @pulumi.getter(name="proxycloseOnError")
    def proxyclose_on_error(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "proxyclose_on_error")

    @proxyclose_on_error.setter
    def proxyclose_on_error(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxyclose_on_error", value)

    @_builtins.property
    @pulumi.getter(name="proxyrespondOnLoggingerror")
    def proxyrespond_on_loggingerror(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "proxyrespond_on_loggingerror")

    @proxyrespond_on_loggingerror.setter
    def proxyrespond_on_loggingerror(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxyrespond_on_loggingerror", value)

    @_builtins.property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables request logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "request_logging")

    @request_logging.setter
    def request_logging(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_logging", value)

    @_builtins.property
    @pulumi.getter(name="requestlogErrorPool")
    def requestlog_error_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "requestlog_error_pool")

    @requestlog_error_pool.setter
    def requestlog_error_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_error_pool", value)

    @_builtins.property
    @pulumi.getter(name="requestlogErrorProtocol")
    def requestlog_error_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of request errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "requestlog_error_protocol")

    @requestlog_error_protocol.setter
    def requestlog_error_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_error_protocol", value)

    @_builtins.property
    @pulumi.getter(name="requestlogErrorTemplate")
    def requestlog_error_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directives and entries to be logged for request errors.
        """
        return pulumi.get(self, "requestlog_error_template")

    @requestlog_error_template.setter
    def requestlog_error_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_error_template", value)

    @_builtins.property
    @pulumi.getter(name="requestlogPool")
    def requestlog_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool to send logs to. Typically, the pool will contain one or more syslog servers. It is recommended that you create a pool specifically for logging requests. The default is `none`.
        """
        return pulumi.get(self, "requestlog_pool")

    @requestlog_pool.setter
    def requestlog_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_pool", value)

    @_builtins.property
    @pulumi.getter(name="requestlogProtocol")
    def requestlog_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of requests. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "requestlog_protocol")

    @requestlog_protocol.setter
    def requestlog_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_protocol", value)

    @_builtins.property
    @pulumi.getter(name="requestlogTemplate")
    def requestlog_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directives and entries to be logged. More infor on requestlog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        return pulumi.get(self, "requestlog_template")

    @requestlog_template.setter
    def requestlog_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_template", value)

    @_builtins.property
    @pulumi.getter(name="responseLogging")
    def response_logging(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables response logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "response_logging")

    @response_logging.setter
    def response_logging(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_logging", value)

    @_builtins.property
    @pulumi.getter(name="responselogErrorPool")
    def responselog_error_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging response errors. The default is `none`.
        """
        return pulumi.get(self, "responselog_error_pool")

    @responselog_error_pool.setter
    def responselog_error_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_error_pool", value)

    @_builtins.property
    @pulumi.getter(name="responselogErrorProtocol")
    def responselog_error_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of response errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "responselog_error_protocol")

    @responselog_error_protocol.setter
    def responselog_error_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_error_protocol", value)

    @_builtins.property
    @pulumi.getter(name="responselogErrorTemplate")
    def responselog_error_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directives and entries to be logged for request errors.
        """
        return pulumi.get(self, "responselog_error_template")

    @responselog_error_template.setter
    def responselog_error_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_error_template", value)

    @_builtins.property
    @pulumi.getter(name="responselogPool")
    def responselog_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool to send logs to. Typically, the pool contains one or more syslog servers. It is recommended that you create a pool specifically for logging responses. The default is `none`.
        """
        return pulumi.get(self, "responselog_pool")

    @responselog_pool.setter
    def responselog_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_pool", value)

    @_builtins.property
    @pulumi.getter(name="responselogProtocol")
    def responselog_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of responses. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "responselog_protocol")

    @responselog_protocol.setter
    def responselog_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_protocol", value)

    @_builtins.property
    @pulumi.getter(name="responselogTemplate")
    def responselog_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directives and entries to be logged. More infor on responselog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        return pulumi.get(self, "responselog_template")

    @responselog_template.setter
    def responselog_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_template", value)


@pulumi.input_type
class _RequestLogProfileState:
    def __init__(__self__, *,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_response: Optional[pulumi.Input[_builtins.str]] = None,
                 proxyclose_on_error: Optional[pulumi.Input[_builtins.str]] = None,
                 proxyrespond_on_loggingerror: Optional[pulumi.Input[_builtins.str]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_template: Optional[pulumi.Input[_builtins.str]] = None,
                 response_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RequestLogProfile resources.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log` profile.
        :param pulumi.Input[_builtins.str] description: Specifies user-defined description.
        :param pulumi.Input[_builtins.str] name: Name of the Request Logging profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/request-log-profile-tc1`.
        :param pulumi.Input[_builtins.str] proxy_response: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] proxyclose_on_error: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] proxyrespond_on_loggingerror: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] request_logging: Enables or disables request logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        :param pulumi.Input[_builtins.str] requestlog_error_pool: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] requestlog_error_protocol: Specifies the protocol to be used for high-speed logging of request errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] requestlog_error_template: Specifies the directives and entries to be logged for request errors.
        :param pulumi.Input[_builtins.str] requestlog_pool: Defines the pool to send logs to. Typically, the pool will contain one or more syslog servers. It is recommended that you create a pool specifically for logging requests. The default is `none`.
        :param pulumi.Input[_builtins.str] requestlog_protocol: Specifies the protocol to be used for high-speed logging of requests. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] requestlog_template: Specifies the directives and entries to be logged. More infor on requestlog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        :param pulumi.Input[_builtins.str] response_logging: Enables or disables response logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        :param pulumi.Input[_builtins.str] responselog_error_pool: Defines the pool associated with logging response errors. The default is `none`.
        :param pulumi.Input[_builtins.str] responselog_error_protocol: Specifies the protocol to be used for high-speed logging of response errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] responselog_error_template: Specifies the directives and entries to be logged for request errors.
        :param pulumi.Input[_builtins.str] responselog_pool: Defines the pool to send logs to. Typically, the pool contains one or more syslog servers. It is recommended that you create a pool specifically for logging responses. The default is `none`.
        :param pulumi.Input[_builtins.str] responselog_protocol: Specifies the protocol to be used for high-speed logging of responses. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] responselog_template: Specifies the directives and entries to be logged. More infor on responselog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if proxy_response is not None:
            pulumi.set(__self__, "proxy_response", proxy_response)
        if proxyclose_on_error is not None:
            pulumi.set(__self__, "proxyclose_on_error", proxyclose_on_error)
        if proxyrespond_on_loggingerror is not None:
            pulumi.set(__self__, "proxyrespond_on_loggingerror", proxyrespond_on_loggingerror)
        if request_logging is not None:
            pulumi.set(__self__, "request_logging", request_logging)
        if requestlog_error_pool is not None:
            pulumi.set(__self__, "requestlog_error_pool", requestlog_error_pool)
        if requestlog_error_protocol is not None:
            pulumi.set(__self__, "requestlog_error_protocol", requestlog_error_protocol)
        if requestlog_error_template is not None:
            pulumi.set(__self__, "requestlog_error_template", requestlog_error_template)
        if requestlog_pool is not None:
            pulumi.set(__self__, "requestlog_pool", requestlog_pool)
        if requestlog_protocol is not None:
            pulumi.set(__self__, "requestlog_protocol", requestlog_protocol)
        if requestlog_template is not None:
            pulumi.set(__self__, "requestlog_template", requestlog_template)
        if response_logging is not None:
            pulumi.set(__self__, "response_logging", response_logging)
        if responselog_error_pool is not None:
            pulumi.set(__self__, "responselog_error_pool", responselog_error_pool)
        if responselog_error_protocol is not None:
            pulumi.set(__self__, "responselog_error_protocol", responselog_error_protocol)
        if responselog_error_template is not None:
            pulumi.set(__self__, "responselog_error_template", responselog_error_template)
        if responselog_pool is not None:
            pulumi.set(__self__, "responselog_pool", responselog_pool)
        if responselog_protocol is not None:
            pulumi.set(__self__, "responselog_protocol", responselog_protocol)
        if responselog_template is not None:
            pulumi.set(__self__, "responselog_template", responselog_template)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log` profile.
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies user-defined description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Request Logging profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/request-log-profile-tc1`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="proxyResponse")
    def proxy_response(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "proxy_response")

    @proxy_response.setter
    def proxy_response(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_response", value)

    @_builtins.property
    @pulumi.getter(name="proxycloseOnError")
    def proxyclose_on_error(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "proxyclose_on_error")

    @proxyclose_on_error.setter
    def proxyclose_on_error(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxyclose_on_error", value)

    @_builtins.property
    @pulumi.getter(name="proxyrespondOnLoggingerror")
    def proxyrespond_on_loggingerror(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "proxyrespond_on_loggingerror")

    @proxyrespond_on_loggingerror.setter
    def proxyrespond_on_loggingerror(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxyrespond_on_loggingerror", value)

    @_builtins.property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables request logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "request_logging")

    @request_logging.setter
    def request_logging(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_logging", value)

    @_builtins.property
    @pulumi.getter(name="requestlogErrorPool")
    def requestlog_error_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "requestlog_error_pool")

    @requestlog_error_pool.setter
    def requestlog_error_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_error_pool", value)

    @_builtins.property
    @pulumi.getter(name="requestlogErrorProtocol")
    def requestlog_error_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of request errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "requestlog_error_protocol")

    @requestlog_error_protocol.setter
    def requestlog_error_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_error_protocol", value)

    @_builtins.property
    @pulumi.getter(name="requestlogErrorTemplate")
    def requestlog_error_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directives and entries to be logged for request errors.
        """
        return pulumi.get(self, "requestlog_error_template")

    @requestlog_error_template.setter
    def requestlog_error_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_error_template", value)

    @_builtins.property
    @pulumi.getter(name="requestlogPool")
    def requestlog_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool to send logs to. Typically, the pool will contain one or more syslog servers. It is recommended that you create a pool specifically for logging requests. The default is `none`.
        """
        return pulumi.get(self, "requestlog_pool")

    @requestlog_pool.setter
    def requestlog_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_pool", value)

    @_builtins.property
    @pulumi.getter(name="requestlogProtocol")
    def requestlog_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of requests. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "requestlog_protocol")

    @requestlog_protocol.setter
    def requestlog_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_protocol", value)

    @_builtins.property
    @pulumi.getter(name="requestlogTemplate")
    def requestlog_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directives and entries to be logged. More infor on requestlog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        return pulumi.get(self, "requestlog_template")

    @requestlog_template.setter
    def requestlog_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requestlog_template", value)

    @_builtins.property
    @pulumi.getter(name="responseLogging")
    def response_logging(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables or disables response logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "response_logging")

    @response_logging.setter
    def response_logging(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_logging", value)

    @_builtins.property
    @pulumi.getter(name="responselogErrorPool")
    def responselog_error_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool associated with logging response errors. The default is `none`.
        """
        return pulumi.get(self, "responselog_error_pool")

    @responselog_error_pool.setter
    def responselog_error_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_error_pool", value)

    @_builtins.property
    @pulumi.getter(name="responselogErrorProtocol")
    def responselog_error_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of response errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "responselog_error_protocol")

    @responselog_error_protocol.setter
    def responselog_error_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_error_protocol", value)

    @_builtins.property
    @pulumi.getter(name="responselogErrorTemplate")
    def responselog_error_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directives and entries to be logged for request errors.
        """
        return pulumi.get(self, "responselog_error_template")

    @responselog_error_template.setter
    def responselog_error_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_error_template", value)

    @_builtins.property
    @pulumi.getter(name="responselogPool")
    def responselog_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the pool to send logs to. Typically, the pool contains one or more syslog servers. It is recommended that you create a pool specifically for logging responses. The default is `none`.
        """
        return pulumi.get(self, "responselog_pool")

    @responselog_pool.setter
    def responselog_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_pool", value)

    @_builtins.property
    @pulumi.getter(name="responselogProtocol")
    def responselog_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of responses. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "responselog_protocol")

    @responselog_protocol.setter
    def responselog_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_protocol", value)

    @_builtins.property
    @pulumi.getter(name="responselogTemplate")
    def responselog_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directives and entries to be logged. More infor on responselog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        return pulumi.get(self, "responselog_template")

    @responselog_template.setter
    def responselog_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "responselog_template", value)


@pulumi.type_token("f5bigip:ltm/requestLogProfile:RequestLogProfile")
class RequestLogProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_response: Optional[pulumi.Input[_builtins.str]] = None,
                 proxyclose_on_error: Optional[pulumi.Input[_builtins.str]] = None,
                 proxyrespond_on_loggingerror: Optional[pulumi.Input[_builtins.str]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_template: Optional[pulumi.Input[_builtins.str]] = None,
                 response_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `ltm.RequestLogProfile` Resource used for Configures request logging using the Request Logging profile

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        request_log_profile_tc1_child = f5bigip.ltm.RequestLogProfile("request-log-profile-tc1-child",
            name="/Common/request-log-profile-tc1-child",
            defaults_from=request_log_profile_tc1["name"],
            request_logging="disabled",
            requestlog_pool="/Common/pool2",
            requestlog_error_pool="/Common/pool1",
            requestlog_protocol="mds-tcp",
            requestlog_error_protocol="mds-tcp",
            responselog_protocol="mds-tcp",
            responselog_error_protocol="mds-tcp")
        ```

        ## Import

        BIG-IP LTM Request Log profiles can be imported using the `name`, e.g.

        bash

        ```sh
        $ pulumi import f5bigip:ltm/requestLogProfile:RequestLogProfile test-request-log /Common/test-request-log
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log` profile.
        :param pulumi.Input[_builtins.str] description: Specifies user-defined description.
        :param pulumi.Input[_builtins.str] name: Name of the Request Logging profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/request-log-profile-tc1`.
        :param pulumi.Input[_builtins.str] proxy_response: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] proxyclose_on_error: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] proxyrespond_on_loggingerror: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] request_logging: Enables or disables request logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        :param pulumi.Input[_builtins.str] requestlog_error_pool: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] requestlog_error_protocol: Specifies the protocol to be used for high-speed logging of request errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] requestlog_error_template: Specifies the directives and entries to be logged for request errors.
        :param pulumi.Input[_builtins.str] requestlog_pool: Defines the pool to send logs to. Typically, the pool will contain one or more syslog servers. It is recommended that you create a pool specifically for logging requests. The default is `none`.
        :param pulumi.Input[_builtins.str] requestlog_protocol: Specifies the protocol to be used for high-speed logging of requests. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] requestlog_template: Specifies the directives and entries to be logged. More infor on requestlog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        :param pulumi.Input[_builtins.str] response_logging: Enables or disables response logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        :param pulumi.Input[_builtins.str] responselog_error_pool: Defines the pool associated with logging response errors. The default is `none`.
        :param pulumi.Input[_builtins.str] responselog_error_protocol: Specifies the protocol to be used for high-speed logging of response errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] responselog_error_template: Specifies the directives and entries to be logged for request errors.
        :param pulumi.Input[_builtins.str] responselog_pool: Defines the pool to send logs to. Typically, the pool contains one or more syslog servers. It is recommended that you create a pool specifically for logging responses. The default is `none`.
        :param pulumi.Input[_builtins.str] responselog_protocol: Specifies the protocol to be used for high-speed logging of responses. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] responselog_template: Specifies the directives and entries to be logged. More infor on responselog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RequestLogProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `ltm.RequestLogProfile` Resource used for Configures request logging using the Request Logging profile

        ## Example Usage

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        request_log_profile_tc1_child = f5bigip.ltm.RequestLogProfile("request-log-profile-tc1-child",
            name="/Common/request-log-profile-tc1-child",
            defaults_from=request_log_profile_tc1["name"],
            request_logging="disabled",
            requestlog_pool="/Common/pool2",
            requestlog_error_pool="/Common/pool1",
            requestlog_protocol="mds-tcp",
            requestlog_error_protocol="mds-tcp",
            responselog_protocol="mds-tcp",
            responselog_error_protocol="mds-tcp")
        ```

        ## Import

        BIG-IP LTM Request Log profiles can be imported using the `name`, e.g.

        bash

        ```sh
        $ pulumi import f5bigip:ltm/requestLogProfile:RequestLogProfile test-request-log /Common/test-request-log
        ```

        :param str resource_name: The name of the resource.
        :param RequestLogProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RequestLogProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_response: Optional[pulumi.Input[_builtins.str]] = None,
                 proxyclose_on_error: Optional[pulumi.Input[_builtins.str]] = None,
                 proxyrespond_on_loggingerror: Optional[pulumi.Input[_builtins.str]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 requestlog_template: Optional[pulumi.Input[_builtins.str]] = None,
                 response_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 responselog_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RequestLogProfileArgs.__new__(RequestLogProfileArgs)

            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["description"] = description
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["proxy_response"] = proxy_response
            __props__.__dict__["proxyclose_on_error"] = proxyclose_on_error
            __props__.__dict__["proxyrespond_on_loggingerror"] = proxyrespond_on_loggingerror
            __props__.__dict__["request_logging"] = request_logging
            __props__.__dict__["requestlog_error_pool"] = requestlog_error_pool
            __props__.__dict__["requestlog_error_protocol"] = requestlog_error_protocol
            __props__.__dict__["requestlog_error_template"] = requestlog_error_template
            __props__.__dict__["requestlog_pool"] = requestlog_pool
            __props__.__dict__["requestlog_protocol"] = requestlog_protocol
            __props__.__dict__["requestlog_template"] = requestlog_template
            __props__.__dict__["response_logging"] = response_logging
            __props__.__dict__["responselog_error_pool"] = responselog_error_pool
            __props__.__dict__["responselog_error_protocol"] = responselog_error_protocol
            __props__.__dict__["responselog_error_template"] = responselog_error_template
            __props__.__dict__["responselog_pool"] = responselog_pool
            __props__.__dict__["responselog_protocol"] = responselog_protocol
            __props__.__dict__["responselog_template"] = responselog_template
        super(RequestLogProfile, __self__).__init__(
            'f5bigip:ltm/requestLogProfile:RequestLogProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_response: Optional[pulumi.Input[_builtins.str]] = None,
            proxyclose_on_error: Optional[pulumi.Input[_builtins.str]] = None,
            proxyrespond_on_loggingerror: Optional[pulumi.Input[_builtins.str]] = None,
            request_logging: Optional[pulumi.Input[_builtins.str]] = None,
            requestlog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
            requestlog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            requestlog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
            requestlog_pool: Optional[pulumi.Input[_builtins.str]] = None,
            requestlog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            requestlog_template: Optional[pulumi.Input[_builtins.str]] = None,
            response_logging: Optional[pulumi.Input[_builtins.str]] = None,
            responselog_error_pool: Optional[pulumi.Input[_builtins.str]] = None,
            responselog_error_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            responselog_error_template: Optional[pulumi.Input[_builtins.str]] = None,
            responselog_pool: Optional[pulumi.Input[_builtins.str]] = None,
            responselog_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            responselog_template: Optional[pulumi.Input[_builtins.str]] = None) -> 'RequestLogProfile':
        """
        Get an existing RequestLogProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] defaults_from: Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log` profile.
        :param pulumi.Input[_builtins.str] description: Specifies user-defined description.
        :param pulumi.Input[_builtins.str] name: Name of the Request Logging profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/request-log-profile-tc1`.
        :param pulumi.Input[_builtins.str] proxy_response: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] proxyclose_on_error: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] proxyrespond_on_loggingerror: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] request_logging: Enables or disables request logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        :param pulumi.Input[_builtins.str] requestlog_error_pool: Defines the pool associated with logging request errors. The default is None.
        :param pulumi.Input[_builtins.str] requestlog_error_protocol: Specifies the protocol to be used for high-speed logging of request errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] requestlog_error_template: Specifies the directives and entries to be logged for request errors.
        :param pulumi.Input[_builtins.str] requestlog_pool: Defines the pool to send logs to. Typically, the pool will contain one or more syslog servers. It is recommended that you create a pool specifically for logging requests. The default is `none`.
        :param pulumi.Input[_builtins.str] requestlog_protocol: Specifies the protocol to be used for high-speed logging of requests. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] requestlog_template: Specifies the directives and entries to be logged. More infor on requestlog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        :param pulumi.Input[_builtins.str] response_logging: Enables or disables response logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        :param pulumi.Input[_builtins.str] responselog_error_pool: Defines the pool associated with logging response errors. The default is `none`.
        :param pulumi.Input[_builtins.str] responselog_error_protocol: Specifies the protocol to be used for high-speed logging of response errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] responselog_error_template: Specifies the directives and entries to be logged for request errors.
        :param pulumi.Input[_builtins.str] responselog_pool: Defines the pool to send logs to. Typically, the pool contains one or more syslog servers. It is recommended that you create a pool specifically for logging responses. The default is `none`.
        :param pulumi.Input[_builtins.str] responselog_protocol: Specifies the protocol to be used for high-speed logging of responses. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        :param pulumi.Input[_builtins.str] responselog_template: Specifies the directives and entries to be logged. More infor on responselog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RequestLogProfileState.__new__(_RequestLogProfileState)

        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["proxy_response"] = proxy_response
        __props__.__dict__["proxyclose_on_error"] = proxyclose_on_error
        __props__.__dict__["proxyrespond_on_loggingerror"] = proxyrespond_on_loggingerror
        __props__.__dict__["request_logging"] = request_logging
        __props__.__dict__["requestlog_error_pool"] = requestlog_error_pool
        __props__.__dict__["requestlog_error_protocol"] = requestlog_error_protocol
        __props__.__dict__["requestlog_error_template"] = requestlog_error_template
        __props__.__dict__["requestlog_pool"] = requestlog_pool
        __props__.__dict__["requestlog_protocol"] = requestlog_protocol
        __props__.__dict__["requestlog_template"] = requestlog_template
        __props__.__dict__["response_logging"] = response_logging
        __props__.__dict__["responselog_error_pool"] = responselog_error_pool
        __props__.__dict__["responselog_error_protocol"] = responselog_error_protocol
        __props__.__dict__["responselog_error_template"] = responselog_error_template
        __props__.__dict__["responselog_pool"] = responselog_pool
        __props__.__dict__["responselog_protocol"] = responselog_protocol
        __props__.__dict__["responselog_template"] = responselog_template
        return RequestLogProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the profile from which this profile inherits settings. The default is the system-supplied `request-log` profile.
        """
        return pulumi.get(self, "defaults_from")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies user-defined description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Request Logging profile,name of Profile should be full path. Full path is the combination of the `partition + profile name`,For example `/Common/request-log-profile-tc1`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="proxyResponse")
    def proxy_response(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "proxy_response")

    @_builtins.property
    @pulumi.getter(name="proxycloseOnError")
    def proxyclose_on_error(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "proxyclose_on_error")

    @_builtins.property
    @pulumi.getter(name="proxyrespondOnLoggingerror")
    def proxyrespond_on_loggingerror(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "proxyrespond_on_loggingerror")

    @_builtins.property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> pulumi.Output[_builtins.str]:
        """
        Enables or disables request logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "request_logging")

    @_builtins.property
    @pulumi.getter(name="requestlogErrorPool")
    def requestlog_error_pool(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the pool associated with logging request errors. The default is None.
        """
        return pulumi.get(self, "requestlog_error_pool")

    @_builtins.property
    @pulumi.getter(name="requestlogErrorProtocol")
    def requestlog_error_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of request errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "requestlog_error_protocol")

    @_builtins.property
    @pulumi.getter(name="requestlogErrorTemplate")
    def requestlog_error_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the directives and entries to be logged for request errors.
        """
        return pulumi.get(self, "requestlog_error_template")

    @_builtins.property
    @pulumi.getter(name="requestlogPool")
    def requestlog_pool(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the pool to send logs to. Typically, the pool will contain one or more syslog servers. It is recommended that you create a pool specifically for logging requests. The default is `none`.
        """
        return pulumi.get(self, "requestlog_pool")

    @_builtins.property
    @pulumi.getter(name="requestlogProtocol")
    def requestlog_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of requests. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "requestlog_protocol")

    @_builtins.property
    @pulumi.getter(name="requestlogTemplate")
    def requestlog_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the directives and entries to be logged. More infor on requestlog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        return pulumi.get(self, "requestlog_template")

    @_builtins.property
    @pulumi.getter(name="responseLogging")
    def response_logging(self) -> pulumi.Output[_builtins.str]:
        """
        Enables or disables response logging. The default is `disabled`, possible values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "response_logging")

    @_builtins.property
    @pulumi.getter(name="responselogErrorPool")
    def responselog_error_pool(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the pool associated with logging response errors. The default is `none`.
        """
        return pulumi.get(self, "responselog_error_pool")

    @_builtins.property
    @pulumi.getter(name="responselogErrorProtocol")
    def responselog_error_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of response errors. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "responselog_error_protocol")

    @_builtins.property
    @pulumi.getter(name="responselogErrorTemplate")
    def responselog_error_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the directives and entries to be logged for request errors.
        """
        return pulumi.get(self, "responselog_error_template")

    @_builtins.property
    @pulumi.getter(name="responselogPool")
    def responselog_pool(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the pool to send logs to. Typically, the pool contains one or more syslog servers. It is recommended that you create a pool specifically for logging responses. The default is `none`.
        """
        return pulumi.get(self, "responselog_pool")

    @_builtins.property
    @pulumi.getter(name="responselogProtocol")
    def responselog_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the protocol to be used for high-speed logging of responses. The default is `mds-udp`,possible values are `mds-udp` and `mds-tcp`.
        """
        return pulumi.get(self, "responselog_protocol")

    @_builtins.property
    @pulumi.getter(name="responselogTemplate")
    def responselog_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the directives and entries to be logged. More infor on responselog_template can be found [here](https://techdocs.f5.com/en-us/bigip-15-0-0/external-monitoring-of-big-ip-systems-implementations/configuring-request-logging.html). how to use can be find [here](https://my.f5.com/manage/s/article/K00847516).
        """
        return pulumi.get(self, "responselog_template")

