""" Copyright Xplainable Pty Ltd, 2023

This logo is not to be copied, changed, or distributed without the express
permission of Xplainable Pty Ltd.
"""

import drawsvg as draw

def generate_xplainable_logo(size):
        logo = draw.Drawing(200, 200)
        circles = [
            (100, 100, 14, "#E14067"),
            (124, 124, 11, "#0080EA"),
            (146, 146, 9.6, "#E14067"),
            (165, 165, 7, "#0080EA"),
            (184, 184, 4, "#E14067"),
            (76, 76, 11, "#0080EA"),
            (54, 54, 9.6, "#E14067"),
            (35, 35, 7, "#0080EA"),
            (16, 16, 4, "#E14067"),
            (124, 76, 11, "#0080EA"),
            (146, 54, 9.6, "#E14067"),
            (165, 35, 7, "#0080EA"),
            (184, 16, 4, "#E14067"),
            (76, 124, 11, "#0080EA"),
            (54, 146, 9.6, "#E14067"),
            (35, 165, 7, "#0080EA"),
            (16, 184, 4, "#E14067"),
            (100, 138, 9, "#E14067"),
            (138, 100, 9, "#E14067"),
            (100, 62, 9, "#E14067"),
            (62, 100, 9, "#E14067"),
            (162, 126, 7, "#E14067"),
            (178, 146, 5, "#E14067"),
            (188, 166, 4, "#E14067"),
            (38, 74, 7, "#E14067"),
            (22, 54, 5, "#E14067"),
            (12, 34, 4, "#E14067"),
            (162, 74, 7, "#E14067"),
            (178, 54, 5, "#E14067"),
            (188, 34, 4, "#E14067"),
            (38, 126, 7, "#E14067"),
            (22, 146, 5, "#E14067"),
            (12, 166, 4, "#E14067"),
            (74, 38, 7, "#E14067"),
            (54, 22, 5, "#E14067"),
            (34, 12, 4, "#E14067"),
            (126, 162, 7, "#E14067"),
            (146, 178, 5, "#E14067"),
            (166, 188, 4, "#E14067"),
            (126, 38, 7, "#E14067"),
            (146, 22, 5, "#E14067"),
            (166, 12, 4, "#E14067"),
            (74, 162, 7, "#E14067"),
            (54, 178, 5, "#E14067"),
            (34, 188, 4, "#E14067"),
        ]

        for cx, cy, r, fill in circles:
            logo.append(draw.Circle(cx, cy, r, fill=fill))

        logo.set_render_size(size)
        
        return logo.as_html()


docs_svg = """
<svg height="35px" width="35px" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 
        viewBox="0 0 512.001 512.001" xml:space="preserve">
    <path style="fill:#0080EA;" d="M439.652,512H72.348c-9.217,0-16.696-7.479-16.696-16.696V16.696C55.652,7.479,63.131,0,72.348,0
    h233.739c4.424,0,8.674,1.761,11.804,4.892l133.565,133.565c3.131,3.13,4.892,7.379,4.892,11.804v345.043
    C456.348,504.521,448.869,512,439.652,512z"/>
<path style="fill:#2860CC;" d="M317.891,4.892C314.761,1.761,310.511,0,306.087,0H256v512h183.652
    c9.217,0,16.696-7.479,16.696-16.696V150.261c0-4.424-1.761-8.674-4.892-11.804L317.891,4.892z"/>
<path style="fill:#0080EA;" d="M451.459,138.459L317.891,4.892C314.76,1.76,310.511,0,306.082,0h-16.691l0.001,150.261
    c0,9.22,7.475,16.696,16.696,16.696h150.26v-16.696C456.348,145.834,454.589,141.589,451.459,138.459z"/>
<path style="fill:#FFFFFF;" d="M272.696,411.826H139.13c-9.217,0-16.696-7.479-16.696-16.696c0-9.217,7.479-16.696,16.696-16.696
    h133.565c9.217,0,16.696,7.479,16.696,16.696C289.391,404.348,281.913,411.826,272.696,411.826z"/>
<path style="fill:#E6F3FF;" d="M272.696,378.435H256v33.391h16.696c9.217,0,16.696-7.479,16.696-16.696
    C289.391,385.913,281.913,378.435,272.696,378.435z"/>
<path style="fill:#FFFFFF;" d="M372.87,345.043H139.13c-9.217,0-16.696-7.479-16.696-16.696c0-9.217,7.479-16.696,16.696-16.696
    H372.87c9.217,0,16.696,7.479,16.696,16.696C389.565,337.565,382.087,345.043,372.87,345.043z"/>
<path style="fill:#E6F3FF;" d="M372.87,311.652H256v33.391h116.87c9.217,0,16.696-7.479,16.696-16.696
    C389.565,319.131,382.087,311.652,372.87,311.652z"/>
<path style="fill:#FFFFFF;" d="M372.87,278.261H139.13c-9.217,0-16.696-7.479-16.696-16.696c0-9.217,7.479-16.696,16.696-16.696
    H372.87c9.217,0,16.696,7.479,16.696,16.696C389.565,270.782,382.087,278.261,372.87,278.261z"/>
<path style="fill:#E6F3FF;" d="M372.87,244.87H256v33.391h116.87c9.217,0,16.696-7.479,16.696-16.696
    C389.565,252.348,382.087,244.87,372.87,244.87z"/>
</svg>
"""

offline_svg = """
<svg width="35px" height="35px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M24 14a5 5 0 0 1-5 5h-1v-1h1a3.99 3.99 0 0 0 .623-7.934l-.79-.124-.052-.798a5.293 5.293 0 0 0-10.214-1.57L8.17 8.59l-.977-.483A2.277 2.277 0 0 0 6.19 7.87a2.18 2.18 0 0 0-1.167.339 2.205 2.205 0 0 0-.98 1.395l-.113.505-.476.2A4 4 0 0 0 5 18h6v1H5a5 5 0 0 1-1.934-9.611 3.21 3.21 0 0 1 1.422-2.024A3.17 3.17 0 0 1 6.19 6.87a3.268 3.268 0 0 1 1.446.34 6.293 6.293 0 0 1 12.143 1.867A4.988 4.988 0 0 1 24 14zm-8.793 4.5l3.146-3.146-.707-.707-3.146 3.146-3.146-3.146-.707.707 3.146 3.146-3.146 3.146.707.707 3.146-3.146 3.146 3.146.707-.707z"/><path fill="none" d="M0 0h24v24H0z"/></svg>
"""