# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, Union, Optional
from datetime import datetime
from typing_extensions import Literal

import httpx

from .. import _legacy_response
from ..types import (
    ledger_account_list_params,
    ledger_account_create_params,
    ledger_account_update_params,
    ledger_account_retrieve_params,
)
from .._types import Body, Omit, Query, Headers, NotGiven, SequenceNotStr, omit, not_given
from .._utils import maybe_transform, async_maybe_transform
from .._compat import cached_property
from .._resource import SyncAPIResource, AsyncAPIResource
from .._response import to_streamed_response_wrapper, async_to_streamed_response_wrapper
from ..pagination import SyncPage, AsyncPage
from .._base_client import AsyncPaginator, make_request_options
from ..types.ledger_account import LedgerAccount
from ..types.shared.transaction_direction import TransactionDirection

__all__ = ["LedgerAccounts", "AsyncLedgerAccounts"]


class LedgerAccounts(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> LedgerAccountsWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#accessing-raw-response-data-eg-headers
        """
        return LedgerAccountsWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> LedgerAccountsWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#with_streaming_response
        """
        return LedgerAccountsWithStreamingResponse(self)

    def create(
        self,
        *,
        currency: str,
        ledger_id: str,
        name: str,
        normal_balance: TransactionDirection,
        currency_exponent: Optional[int] | Omit = omit,
        description: Optional[str] | Omit = omit,
        ledger_account_category_ids: SequenceNotStr[str] | Omit = omit,
        ledgerable_id: str | Omit = omit,
        ledgerable_type: Literal["counterparty", "external_account", "internal_account", "virtual_account"]
        | Omit = omit,
        metadata: Dict[str, str] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> LedgerAccount:
        """
        Create a ledger account.

        Args:
          currency: The currency of the ledger account.

          ledger_id: The id of the ledger that this account belongs to.

          name: The name of the ledger account.

          normal_balance: The normal balance of the ledger account.

          currency_exponent: The currency exponent of the ledger account.

          description: The description of the ledger account.

          ledger_account_category_ids: The array of ledger account category ids that this ledger account should be a
              child of.

          ledgerable_id: If the ledger account links to another object in Modern Treasury, the id will be
              populated here, otherwise null.

          ledgerable_type: If the ledger account links to another object in Modern Treasury, the type will
              be populated here, otherwise null. The value is one of internal_account or
              external_account.

          metadata: Additional data represented as key-value pairs. Both the key and value must be
              strings.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        return self._post(
            "/api/ledger_accounts",
            body=maybe_transform(
                {
                    "currency": currency,
                    "ledger_id": ledger_id,
                    "name": name,
                    "normal_balance": normal_balance,
                    "currency_exponent": currency_exponent,
                    "description": description,
                    "ledger_account_category_ids": ledger_account_category_ids,
                    "ledgerable_id": ledgerable_id,
                    "ledgerable_type": ledgerable_type,
                    "metadata": metadata,
                },
                ledger_account_create_params.LedgerAccountCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=LedgerAccount,
        )

    def retrieve(
        self,
        id: str,
        *,
        balances: ledger_account_retrieve_params.Balances | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> LedgerAccount:
        """
        Get details on a single ledger account.

        Args:
          balances: Use `balances[effective_at_lower_bound]` and
              `balances[effective_at_upper_bound]` to get the balances change between the two
              timestamps. The lower bound is inclusive while the upper bound is exclusive of
              the provided timestamps. If no value is supplied the balances will be retrieved
              not including that bound. Use `balances[as_of_lock_version]` to retrieve a
              balance as of a specific Ledger Account `lock_version`.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return self._get(
            f"/api/ledger_accounts/{id}",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {"balances": balances}, ledger_account_retrieve_params.LedgerAccountRetrieveParams
                ),
            ),
            cast_to=LedgerAccount,
        )

    def update(
        self,
        id: str,
        *,
        description: Optional[str] | Omit = omit,
        metadata: Dict[str, str] | Omit = omit,
        name: str | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> LedgerAccount:
        """
        Update the details of a ledger account.

        Args:
          description: The description of the ledger account.

          metadata: Additional data represented as key-value pairs. Both the key and value must be
              strings.

          name: The name of the ledger account.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return self._patch(
            f"/api/ledger_accounts/{id}",
            body=maybe_transform(
                {
                    "description": description,
                    "metadata": metadata,
                    "name": name,
                },
                ledger_account_update_params.LedgerAccountUpdateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=LedgerAccount,
        )

    def list(
        self,
        *,
        id: SequenceNotStr[str] | Omit = omit,
        after_cursor: Optional[str] | Omit = omit,
        available_balance_amount: ledger_account_list_params.AvailableBalanceAmount | Omit = omit,
        balances: ledger_account_list_params.Balances | Omit = omit,
        created_at: Dict[str, Union[str, datetime]] | Omit = omit,
        currency: str | Omit = omit,
        external_id: str | Omit = omit,
        ledger_account_category_id: str | Omit = omit,
        ledger_id: str | Omit = omit,
        metadata: Dict[str, str] | Omit = omit,
        name: SequenceNotStr[str] | Omit = omit,
        normal_balance: TransactionDirection | Omit = omit,
        pending_balance_amount: ledger_account_list_params.PendingBalanceAmount | Omit = omit,
        per_page: int | Omit = omit,
        posted_balance_amount: ledger_account_list_params.PostedBalanceAmount | Omit = omit,
        updated_at: Dict[str, Union[str, datetime]] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> SyncPage[LedgerAccount]:
        """
        Get a list of ledger accounts.

        Args:
          id: If you have specific IDs to retrieve in bulk, you can pass them as query
              parameters delimited with `id[]=`, for example `?id[]=123&id[]=abc`.

          available_balance_amount: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), `eq` (=), or `not_eq` (!=) to
              filter by balance amount.

          balances: Use `balances[effective_at_lower_bound]` and
              `balances[effective_at_upper_bound]` to get the balances change between the two
              timestamps. The lower bound is inclusive while the upper bound is exclusive of
              the provided timestamps. If no value is supplied the balances will be retrieved
              not including that bound.

          created_at: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), or `eq` (=) to filter by the
              created at timestamp. For example, for all times after Jan 1 2000 12:00 UTC, use
              created_at%5Bgt%5D=2000-01-01T12:00:00Z.

          metadata: For example, if you want to query for records with metadata key `Type` and value
              `Loan`, the query would be `metadata%5BType%5D=Loan`. This encodes the query
              parameters.

          name: If you have specific names to retrieve in bulk, you can pass them as query
              parameters delimited with `name[]=`, for example `?name[]=123&name[]=abc`.

          pending_balance_amount: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), `eq` (=), or `not_eq` (!=) to
              filter by balance amount.

          posted_balance_amount: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), `eq` (=), or `not_eq` (!=) to
              filter by balance amount.

          updated_at: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), or `eq` (=) to filter by the
              updated at timestamp. For example, for all times after Jan 1 2000 12:00 UTC, use
              updated_at%5Bgt%5D=2000-01-01T12:00:00Z.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/api/ledger_accounts",
            page=SyncPage[LedgerAccount],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "id": id,
                        "after_cursor": after_cursor,
                        "available_balance_amount": available_balance_amount,
                        "balances": balances,
                        "created_at": created_at,
                        "currency": currency,
                        "external_id": external_id,
                        "ledger_account_category_id": ledger_account_category_id,
                        "ledger_id": ledger_id,
                        "metadata": metadata,
                        "name": name,
                        "normal_balance": normal_balance,
                        "pending_balance_amount": pending_balance_amount,
                        "per_page": per_page,
                        "posted_balance_amount": posted_balance_amount,
                        "updated_at": updated_at,
                    },
                    ledger_account_list_params.LedgerAccountListParams,
                ),
            ),
            model=LedgerAccount,
        )

    def delete(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> LedgerAccount:
        """
        Delete a ledger account.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return self._delete(
            f"/api/ledger_accounts/{id}",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=LedgerAccount,
        )


class AsyncLedgerAccounts(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncLedgerAccountsWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#accessing-raw-response-data-eg-headers
        """
        return AsyncLedgerAccountsWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncLedgerAccountsWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#with_streaming_response
        """
        return AsyncLedgerAccountsWithStreamingResponse(self)

    async def create(
        self,
        *,
        currency: str,
        ledger_id: str,
        name: str,
        normal_balance: TransactionDirection,
        currency_exponent: Optional[int] | Omit = omit,
        description: Optional[str] | Omit = omit,
        ledger_account_category_ids: SequenceNotStr[str] | Omit = omit,
        ledgerable_id: str | Omit = omit,
        ledgerable_type: Literal["counterparty", "external_account", "internal_account", "virtual_account"]
        | Omit = omit,
        metadata: Dict[str, str] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> LedgerAccount:
        """
        Create a ledger account.

        Args:
          currency: The currency of the ledger account.

          ledger_id: The id of the ledger that this account belongs to.

          name: The name of the ledger account.

          normal_balance: The normal balance of the ledger account.

          currency_exponent: The currency exponent of the ledger account.

          description: The description of the ledger account.

          ledger_account_category_ids: The array of ledger account category ids that this ledger account should be a
              child of.

          ledgerable_id: If the ledger account links to another object in Modern Treasury, the id will be
              populated here, otherwise null.

          ledgerable_type: If the ledger account links to another object in Modern Treasury, the type will
              be populated here, otherwise null. The value is one of internal_account or
              external_account.

          metadata: Additional data represented as key-value pairs. Both the key and value must be
              strings.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        return await self._post(
            "/api/ledger_accounts",
            body=await async_maybe_transform(
                {
                    "currency": currency,
                    "ledger_id": ledger_id,
                    "name": name,
                    "normal_balance": normal_balance,
                    "currency_exponent": currency_exponent,
                    "description": description,
                    "ledger_account_category_ids": ledger_account_category_ids,
                    "ledgerable_id": ledgerable_id,
                    "ledgerable_type": ledgerable_type,
                    "metadata": metadata,
                },
                ledger_account_create_params.LedgerAccountCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=LedgerAccount,
        )

    async def retrieve(
        self,
        id: str,
        *,
        balances: ledger_account_retrieve_params.Balances | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> LedgerAccount:
        """
        Get details on a single ledger account.

        Args:
          balances: Use `balances[effective_at_lower_bound]` and
              `balances[effective_at_upper_bound]` to get the balances change between the two
              timestamps. The lower bound is inclusive while the upper bound is exclusive of
              the provided timestamps. If no value is supplied the balances will be retrieved
              not including that bound. Use `balances[as_of_lock_version]` to retrieve a
              balance as of a specific Ledger Account `lock_version`.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return await self._get(
            f"/api/ledger_accounts/{id}",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=await async_maybe_transform(
                    {"balances": balances}, ledger_account_retrieve_params.LedgerAccountRetrieveParams
                ),
            ),
            cast_to=LedgerAccount,
        )

    async def update(
        self,
        id: str,
        *,
        description: Optional[str] | Omit = omit,
        metadata: Dict[str, str] | Omit = omit,
        name: str | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> LedgerAccount:
        """
        Update the details of a ledger account.

        Args:
          description: The description of the ledger account.

          metadata: Additional data represented as key-value pairs. Both the key and value must be
              strings.

          name: The name of the ledger account.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return await self._patch(
            f"/api/ledger_accounts/{id}",
            body=await async_maybe_transform(
                {
                    "description": description,
                    "metadata": metadata,
                    "name": name,
                },
                ledger_account_update_params.LedgerAccountUpdateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=LedgerAccount,
        )

    def list(
        self,
        *,
        id: SequenceNotStr[str] | Omit = omit,
        after_cursor: Optional[str] | Omit = omit,
        available_balance_amount: ledger_account_list_params.AvailableBalanceAmount | Omit = omit,
        balances: ledger_account_list_params.Balances | Omit = omit,
        created_at: Dict[str, Union[str, datetime]] | Omit = omit,
        currency: str | Omit = omit,
        external_id: str | Omit = omit,
        ledger_account_category_id: str | Omit = omit,
        ledger_id: str | Omit = omit,
        metadata: Dict[str, str] | Omit = omit,
        name: SequenceNotStr[str] | Omit = omit,
        normal_balance: TransactionDirection | Omit = omit,
        pending_balance_amount: ledger_account_list_params.PendingBalanceAmount | Omit = omit,
        per_page: int | Omit = omit,
        posted_balance_amount: ledger_account_list_params.PostedBalanceAmount | Omit = omit,
        updated_at: Dict[str, Union[str, datetime]] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AsyncPaginator[LedgerAccount, AsyncPage[LedgerAccount]]:
        """
        Get a list of ledger accounts.

        Args:
          id: If you have specific IDs to retrieve in bulk, you can pass them as query
              parameters delimited with `id[]=`, for example `?id[]=123&id[]=abc`.

          available_balance_amount: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), `eq` (=), or `not_eq` (!=) to
              filter by balance amount.

          balances: Use `balances[effective_at_lower_bound]` and
              `balances[effective_at_upper_bound]` to get the balances change between the two
              timestamps. The lower bound is inclusive while the upper bound is exclusive of
              the provided timestamps. If no value is supplied the balances will be retrieved
              not including that bound.

          created_at: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), or `eq` (=) to filter by the
              created at timestamp. For example, for all times after Jan 1 2000 12:00 UTC, use
              created_at%5Bgt%5D=2000-01-01T12:00:00Z.

          metadata: For example, if you want to query for records with metadata key `Type` and value
              `Loan`, the query would be `metadata%5BType%5D=Loan`. This encodes the query
              parameters.

          name: If you have specific names to retrieve in bulk, you can pass them as query
              parameters delimited with `name[]=`, for example `?name[]=123&name[]=abc`.

          pending_balance_amount: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), `eq` (=), or `not_eq` (!=) to
              filter by balance amount.

          posted_balance_amount: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), `eq` (=), or `not_eq` (!=) to
              filter by balance amount.

          updated_at: Use `gt` (>), `gte` (>=), `lt` (<), `lte` (<=), or `eq` (=) to filter by the
              updated at timestamp. For example, for all times after Jan 1 2000 12:00 UTC, use
              updated_at%5Bgt%5D=2000-01-01T12:00:00Z.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/api/ledger_accounts",
            page=AsyncPage[LedgerAccount],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "id": id,
                        "after_cursor": after_cursor,
                        "available_balance_amount": available_balance_amount,
                        "balances": balances,
                        "created_at": created_at,
                        "currency": currency,
                        "external_id": external_id,
                        "ledger_account_category_id": ledger_account_category_id,
                        "ledger_id": ledger_id,
                        "metadata": metadata,
                        "name": name,
                        "normal_balance": normal_balance,
                        "pending_balance_amount": pending_balance_amount,
                        "per_page": per_page,
                        "posted_balance_amount": posted_balance_amount,
                        "updated_at": updated_at,
                    },
                    ledger_account_list_params.LedgerAccountListParams,
                ),
            ),
            model=LedgerAccount,
        )

    async def delete(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> LedgerAccount:
        """
        Delete a ledger account.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return await self._delete(
            f"/api/ledger_accounts/{id}",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=LedgerAccount,
        )


class LedgerAccountsWithRawResponse:
    def __init__(self, ledger_accounts: LedgerAccounts) -> None:
        self._ledger_accounts = ledger_accounts

        self.create = _legacy_response.to_raw_response_wrapper(
            ledger_accounts.create,
        )
        self.retrieve = _legacy_response.to_raw_response_wrapper(
            ledger_accounts.retrieve,
        )
        self.update = _legacy_response.to_raw_response_wrapper(
            ledger_accounts.update,
        )
        self.list = _legacy_response.to_raw_response_wrapper(
            ledger_accounts.list,
        )
        self.delete = _legacy_response.to_raw_response_wrapper(
            ledger_accounts.delete,
        )


class AsyncLedgerAccountsWithRawResponse:
    def __init__(self, ledger_accounts: AsyncLedgerAccounts) -> None:
        self._ledger_accounts = ledger_accounts

        self.create = _legacy_response.async_to_raw_response_wrapper(
            ledger_accounts.create,
        )
        self.retrieve = _legacy_response.async_to_raw_response_wrapper(
            ledger_accounts.retrieve,
        )
        self.update = _legacy_response.async_to_raw_response_wrapper(
            ledger_accounts.update,
        )
        self.list = _legacy_response.async_to_raw_response_wrapper(
            ledger_accounts.list,
        )
        self.delete = _legacy_response.async_to_raw_response_wrapper(
            ledger_accounts.delete,
        )


class LedgerAccountsWithStreamingResponse:
    def __init__(self, ledger_accounts: LedgerAccounts) -> None:
        self._ledger_accounts = ledger_accounts

        self.create = to_streamed_response_wrapper(
            ledger_accounts.create,
        )
        self.retrieve = to_streamed_response_wrapper(
            ledger_accounts.retrieve,
        )
        self.update = to_streamed_response_wrapper(
            ledger_accounts.update,
        )
        self.list = to_streamed_response_wrapper(
            ledger_accounts.list,
        )
        self.delete = to_streamed_response_wrapper(
            ledger_accounts.delete,
        )


class AsyncLedgerAccountsWithStreamingResponse:
    def __init__(self, ledger_accounts: AsyncLedgerAccounts) -> None:
        self._ledger_accounts = ledger_accounts

        self.create = async_to_streamed_response_wrapper(
            ledger_accounts.create,
        )
        self.retrieve = async_to_streamed_response_wrapper(
            ledger_accounts.retrieve,
        )
        self.update = async_to_streamed_response_wrapper(
            ledger_accounts.update,
        )
        self.list = async_to_streamed_response_wrapper(
            ledger_accounts.list,
        )
        self.delete = async_to_streamed_response_wrapper(
            ledger_accounts.delete,
        )
