---
name: Bug report
about: Create a report to help us improve
title: ''
labels: bug, help wanted
assignees: ''
---

## 🐛 Bug

<!-- A clear and concise description of what the bug is. -->

### To Reproduce

Attach a [Lightning Studio](https://lightning.ai/studios) which is fully reproducible (code, dependencies, environment, etc...) to reproduce this:   

1. Create a [Studio](https://lightning.ai/studios).    
2. Reproduce the issue in the Studio.    
3. [Publish the Studio](https://lightning.ai/docs/overview/studios/publishing#how-to-publish).
4. Paste the Studio link here.    

<!-- If you have a code sample, error messages, stack traces, please provide it here as well -->

#### Code sample

<!-- Ideally attach a minimal code sample to reproduce the decried issue.
Minimal means having the shortest code but still preserving the bug. -->

### Expected behavior

<!-- A clear and concise description of what you expected to happen. -->

### Environment
If you published a Studio with your bug report, we can automatically get this information. Otherwise, please describe:   

- PyTorch/Jax/Tensorflow Version (e.g., 1.0):
- OS (e.g., Linux):
- How you installed PyTorch (`conda`, `pip`, source):
- Build command you used (if compiling from source):
- Python version:
- CUDA/cuDNN version:
- GPU models and configuration:
- Any other relevant information:

### Additional context

<!-- Add any other context about the problem here. -->
