# Copyright The Lightning AI team.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from litserve import test_examples
from litserve.__about__ import *  # noqa: F403
from litserve.api import LitAPI
from litserve.callbacks import Callback
from litserve.loggers import Logger
from litserve.server import LitServer, Request, Response
from litserve.specs import OpenAIEmbeddingSpec, OpenAISpec
from litserve.utils import configure_logging, set_trace, set_trace_if_debug

configure_logging()

__all__ = [
    "Callback",
    "LitAPI",
    "LitServer",
    "Logger",
    "OpenAISpec",
    "OpenAIEmbeddingSpec",
    "Request",
    "Response",
    "set_trace",
    "set_trace_if_debug",
    "test_examples",
]
