# Harvester SDK PyPI Package Contents

Total files: 221

## Python Files (96 files)

- ai_assistant.py
- batch_code.py
- batch_status.py
- batch_submit.py
- batch_vertex_processor.py
- conductor.py
- converter.py
- core/batch_processor.py
- core/collector.py
- core/csv_scanner.py
- core/divine_arbiter.py
- core/document_loader.py
- core/function_calling.py
- core/__init__.py
- core/json_template_processor.py
- core/post_processor.py
- core/result_templater.py
- core/rqp_templater.py
- core/scanner.py
- core/structured_output.py
- core/synthesizer.py
- core/templater.py
- csv_processor.py
- deepseek_chat.py
- deepseek_provider.py
- grok_chat.py
- grok_search.py
- harvester.py
- harvester_sdk/__init__.py
- harvester_sdk/licensing.py
- harvester_sdk/output_manager.py
- harvester_sdk/sdk.py
- image_cli.py
- __init__.py
- json_processor.py
- license_guardian.py
- mothership.py
- process_dir.py
- processors/batch_submitter.py
- processors/galactic_federation.py
- processors/gemini_batch_submitter.py
- processors/__init__.py
- processors/multi_provider_parallel.py
- processors/parallel_monarchy.py
- processors/parallel.py
- processors/xai_async_processor.py
- processors/xai_deferred_submitter.py
- providers/anthropic_provider.py
- providers/base_provider.py
- providers/dalle3_provider.py
- providers/deepseek_provider.py
- providers/gemini_exp_provider.py
- providers/gemini_provider.py
- providers/genai_embeddings_provider.py
- providers/genai_functions_provider.py
- providers/genai_imagen_provider.py
- providers/genai_lyria_provider.py
- providers/genai_provider.py
- providers/genai_tts_provider.py
- providers/genai_veo3_provider.py
- providers/generic_provider.py
- providers/google_provider.py
- providers/gpt_image_provider.py
- providers/__init__.py
- providers/openai_image_provider.py
- providers/openai_provider.py
- providers/provider_factory.py
- providers/rqp_adapter.py
- providers/vertex_image_provider.py
- providers/vertex_provider.py
- providers/xai_async.py
- providers/xai_batch_provider.py
- providers/xai_functions.py
- providers/xai_provider_advanced.py
- providers/xai_provider.py
- providers/xai_streaming.py
- secure_license.py
- setup.py
- test_all_endpoints.py
- test_all_providers.py
- test_divine_arbiter.py
- test_function_calling.py
- test_gpt5_batch.py
- test_installation.py
- test_multi_provider.py
- test_parallel_architecture.py
- test_structured_output.py
- test_xai_deepseek.py
- utils/file_handlers.py
- utils/__init__.py
- utils/json_csv_converter.py
- utils/output_manager.py
- utils/output_paths.py
- utils/progress_tracker.py
- utils/rate_limiter.py
- version.py

## Configuration Files (10 YAML files)

- config/google_cloud_setup.yaml
- config/harvest_profiles.yaml
- config/legacy-config/providers.yaml
- config/providers/genai_embeddings.yaml
- config/providers/genai_imagen.yaml
- config/providers/genai_lyria.yaml
- config/providers/genai_veo3.yaml
- config/providers.yaml
- config/rqp_presets.yaml
- config/templates.yaml

## JSON Files (34 files)

- templates/cinematic_templates.json
- templates/consciousness_templates.json
- templates/construction_image_templates.json
- templates/dalle3/advanced_features.json
- templates/dalle3/creative_styles.json
- templates/digital_art_templates.json
- templates/embeddings/content_similarity.json
- templates/embeddings/rag_system.json
- templates/embeddings/semantic_search.json
- templates/fantasy_expanded_templates.json
- templates/fashion_image_templates.json
- templates/food_image_templates.json
- templates/gpt_image/api_workflows.json
- templates/gpt_image/multi_turn_editing.json
- templates/imagen/batch_generation.json
- templates/imagen/genai_cosmic_duck.json
- templates/image/styles/artistic_styles.json
- templates/json_order_templates.json
- templates/lyria/electronic_journey.json
- templates/lyria/jazz_lounge.json
- templates/lyria/world_fusion.json
- templates/music_style_templates.json
- templates/nature_cosmic_templates.json
- templates/photography_templates.json
- templates/retro_nostalgia_templates.json
- templates/surreal_creative_templates.json
- templates/tech_dystopian_templates.json
- templates/tech_harmonious_templates.json
- templates/technology_image_templates.json
- templates/template_index.json
- templates/themed_templates.json
- templates/veo3/animate_image.json
- templates/veo3/cinematic_scene.json
- templates/video_style_templates.json

## Template Files (27 Jinja2 templates)

- templates/agnostic_purity.j2
- templates/architectural_review.j2
- templates/basic_image_generation.j2
- templates/batch_styling_upgrades.j2
- templates/butcher_the_code.j2
- templates/code_forge_exact.j2
- templates/code_forge.j2
- templates/creative_art_generation.j2
- templates/documentation.j2
- templates/document_improved.j2
- templates/enhanced_image_prompt.j2
- templates/generate_schema.j2
- templates/lux_transmutation.j2
- templates/MASTER-TEMPLATE.j2
- templates/metatron_guardian.j2
- templates/pattern_extraction.j2
- templates/performance_optimization.j2
- templates/process_dir/code_quality/test_generation.j2
- templates/process_dir/documentation/comprehensive_docs.j2
- templates/process_dir/refactoring/clean_code.j2
- templates/process_dir/transformation/modernize_code.j2
- templates/product_photography.j2
- templates/prompt_enhancement.j2
- templates/prompt_improver_general.j2
- templates/prompt_improver_program.j2
- templates/quality_guardian.j2
- templates/quantum_ui_upgrade.j2

## Documentation (10 Markdown files)

- CLI_REFERENCE.md
- google-rebuttal.md
- INSTALL.md
- PACKAGING_SUMMARY.md
- PROCESSING_DOMINION.md
- README.md
- SECURITY_FIX.md
- SOVEREIGN_ARSENAL.md
- SOVEREIGN_ARSENAL_SLIDES.md
- SUMMON_RENAME_OPTIONS.md

## Data Files (4 CSV files)

- templates/csv/image_batch_multiapi.csv
- templates/image_batch_blog.csv
- templates/image_batch_product.csv
- templates/image_batch_universal.csv

## Diagrams (6 SVG files)

- diagrams/chimera-gpu-architecture.svg
- diagrams/harvester-sdk-platform.svg
- diagrams/lockfree-queue-investor-enhanced.svg
- diagrams/lockfree-queue-investor.svg
- diagrams/performance-metrics-proof.svg
- diagrams/performance-metrics-truth.svg

## ✅ Security Check

**No sensitive files found!** The package is clean of:
- Environment files (.env)
- Private keys or certificates
- API keys or tokens
- Git history or cache files
- Python cache files (__pycache__, .pyc, .pyo)

## 📦 Package Summary

**Total Files:** 221
- **Python Code:** 96 files (all core SDK functionality)
- **Templates:** 27 Jinja2 + 34 JSON templates
- **Configuration:** 10 YAML files
- **Documentation:** 10 Markdown files
- **Sample Data:** 4 CSV files
- **Diagrams:** 6 SVG architecture diagrams
- **Other:** Requirements, LICENSE, setup files

## ⚠️ Files to Consider Removing (Optional)

These test files are included but could be excluded from production:
- `test_*.py` files (10 test scripts)
- `deepseek_chat.py`, `grok_chat.py`, `grok_search.py` (standalone test scripts)
- `google-rebuttal.md` (internal document)
