# Summon.py Rename Options

## Current Capabilities Analysis
- 19+ AI task templates (math, physics, code review, advice, criticism, etc.)
- Universal model orchestration (single, group, AI Council)
- Multi-format output (text, JSON, markdown, HTML)
- Template categories: academic, development, advisory, creative, technical, research
- Enterprise-tier tool requiring maximum license

## Rename Options (Ranked by Clarity)

### 1. **`ai-assistant`** ⭐ RECOMMENDED
- **Pros**: Immediately clear purpose, familiar to users
- **Cons**: Generic but accurate
- **Usage**: `ai-assistant maths "prove pythagorean theorem"`

### 2. **`ai-orchestrator`**
- **Pros**: Emphasizes coordination of multiple AI models
- **Cons**: Technical term, might confuse non-tech users
- **Usage**: `ai-orchestrator code_review "review this function"`

### 3. **`universal-ai`**
- **Pros**: Conveys the "does everything" nature
- **Cons**: Might sound too broad
- **Usage**: `universal-ai advice "should I start a company?"`

### 4. **`ai-hub`**
- **Pros**: Short, implies central control point
- **Cons**: Might suggest a web interface
- **Usage**: `ai-hub brainstorm "new product ideas"`

### 5. **`ai-maestro`**
- **Pros**: Creative, implies orchestration mastery
- **Cons**: Not immediately clear to all users
- **Usage**: `ai-maestro architecture "design microservices"`

### 6. **`ai-council`**
- **Pros**: Emphasizes multi-model consensus feature
- **Cons**: Doesn't cover single-model usage
- **Usage**: `ai-council criticism "review my startup idea"`

### 7. **`task-ai`**
- **Pros**: Clear that it handles various tasks
- **Cons**: Too generic
- **Usage**: `task-ai debug "fix this error"`

### 8. **`multi-ai`**
- **Pros**: Emphasizes multiple AI models
- **Cons**: Doesn't convey task variety
- **Usage**: `multi-ai research "quantum computing trends"`

## Recommendation: `ai-assistant`

Most intuitive for non-technical users while accurately describing the tool's purpose as a comprehensive AI assistant that can handle any task with any model configuration.