"""Setup configuration for Harvester SDK."""

from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="harvester-sdk",
    version="2.0.0",
    author="Quantum Encoding",
    author_email="support@quantumencoding.io",
    description="Multi-provider AI SDK with parallel processing and enterprise features",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/quantum-encoding/harvester-sdk",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.8",
    install_requires=[
        "aiohttp>=3.8.0",
        "aiofiles>=23.0.0",
        "anthropic>=0.39.0",
        "openai>=1.54.0",
        "google-generativeai>=0.8.3",
        "groq>=0.11.0",
        "boto3>=1.35.0",
        "mistralai>=1.2.3",
        "cohere>=5.11.0",
        "ollama>=0.4.4",
        "tavily-python>=0.5.0",
        "duckduckgo-search>=6.3.0",
        "together>=1.3.0",
        "voyageai>=0.3.0",
        "jsonschema>=4.0.0",
        "pydantic>=2.0.0",
        "python-dotenv>=1.0.0",
        "rich>=13.0.0",
        "tiktoken>=0.5.0",
        "beautifulsoup4>=4.12.0",
        "lxml>=4.9.0",
        "chardet>=5.2.0",
        "PyPDF2>=3.0.0",
        "python-docx>=1.0.0",
        "python-pptx>=0.6.0",
        "openpyxl>=3.1.0",
        "pandas>=2.0.0",
        "Pillow>=10.0.0",
        "moviepy>=1.0.0",
        "speechrecognition>=3.10.0",
        "pydub>=0.25.0",
        "yt-dlp>=2024.0.0",
        "ffmpeg-python>=0.2.0",
        "python-magic>=0.4.0",
        "textstat>=0.7.0",
        "pypandoc>=1.13",
        "ebooklib>=0.18",
        "python-multipart>=0.0.6",
    ],
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "pytest-asyncio>=0.21.0",
            "pytest-cov>=4.0.0",
            "black>=23.0.0",
            "flake8>=6.0.0",
            "mypy>=1.0.0",
            "pre-commit>=3.0.0",
        ],
        "full": [
            "streamlit>=1.38.0",
            "gradio>=4.0.0",
            "fastapi>=0.115.0",
            "uvicorn>=0.31.0",
            "chainlit>=1.2.0",
        ]
    },
    entry_points={
        "console_scripts": [
            "harvester=harvester:main",
            "hsdk=harvester:main",
        ],
    },
    include_package_data=True,
    package_data={
        "": ["*.json", "*.yaml", "*.yml", "*.txt", "*.md"],
    },
    zip_safe=False,
    keywords=[
        "ai", "llm", "gpt", "claude", "gemini", "mistral", "groq", 
        "anthropic", "openai", "google", "bedrock", "together",
        "multimodal", "parallel-processing", "batch-processing",
        "structured-output", "function-calling", "tool-use",
        "enterprise", "sdk", "api", "quantum-encoding"
    ],
    project_urls={
        "Documentation": "https://docs.quantumencoding.io/harvester",
        "Source": "https://github.com/quantum-encoding/harvester-sdk",
        "Tracker": "https://github.com/quantum-encoding/harvester-sdk/issues",
        "Premium": "https://quantumencoding.io/premium",
    },
)