<a id="mypy-boto3-elasticache"></a>

# mypy-boto3-elasticache

[![PyPI - mypy-boto3-elasticache](https://img.shields.io/pypi/v/mypy-boto3-elasticache.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticache)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elasticache.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticache)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-elasticache?color=blue)](https://pypistats.org/packages/mypy-boto3-elasticache)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ElastiCache 1.17.101](https://boto3.amazonaws.com/v1/documentation/api/1.17.101/reference/services/elasticache.html#ElastiCache)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.20.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-elasticache docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elasticache/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-elasticache](#mypy-boto3-elasticache)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `ElastiCache` service.

```bash
python -m pip install boto3-stubs[elasticache]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[elasticache]` in your environment:
  `python -m pip install 'boto3-stubs[elasticache]'`

Both type checking and auto-complete should work for `ElastiCache` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[elasticache]` in your environment:
  `python -m pip install 'boto3-stubs[elasticache]'`

Both type checking and auto-complete should work for `ElastiCache` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[elasticache]` in your environment:
  `python -m pip install 'boto3-stubs[elasticache]'`
- Run `mypy` as usual

Type checking should work for `ElastiCache` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[elasticache]` in your environment:
  `python -m pip install 'boto3-stubs[elasticache]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElastiCache` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`ElastiCacheClient` provides annotations for `boto3.client("elasticache")`.

```python
import boto3

from mypy_boto3_elasticache import ElastiCacheClient

client: ElastiCacheClient = boto3.client("elasticache")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElastiCacheClient = session.client("elasticache")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_elasticache.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_elasticache import ElastiCacheClient
from mypy_boto3_elasticache.paginator import (
    DescribeCacheClustersPaginator,
    DescribeCacheEngineVersionsPaginator,
    DescribeCacheParameterGroupsPaginator,
    DescribeCacheParametersPaginator,
    DescribeCacheSecurityGroupsPaginator,
    DescribeCacheSubnetGroupsPaginator,
    DescribeEngineDefaultParametersPaginator,
    DescribeEventsPaginator,
    DescribeGlobalReplicationGroupsPaginator,
    DescribeReplicationGroupsPaginator,
    DescribeReservedCacheNodesPaginator,
    DescribeReservedCacheNodesOfferingsPaginator,
    DescribeServiceUpdatesPaginator,
    DescribeSnapshotsPaginator,
    DescribeUpdateActionsPaginator,
    DescribeUserGroupsPaginator,
    DescribeUsersPaginator,
)

client: ElastiCacheClient = boto3.client("elasticache")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_cache_clusters_paginator: DescribeCacheClustersPaginator = client.get_paginator("describe_cache_clusters")
describe_cache_engine_versions_paginator: DescribeCacheEngineVersionsPaginator = client.get_paginator("describe_cache_engine_versions")
describe_cache_parameter_groups_paginator: DescribeCacheParameterGroupsPaginator = client.get_paginator("describe_cache_parameter_groups")
describe_cache_parameters_paginator: DescribeCacheParametersPaginator = client.get_paginator("describe_cache_parameters")
describe_cache_security_groups_paginator: DescribeCacheSecurityGroupsPaginator = client.get_paginator("describe_cache_security_groups")
describe_cache_subnet_groups_paginator: DescribeCacheSubnetGroupsPaginator = client.get_paginator("describe_cache_subnet_groups")
describe_engine_default_parameters_paginator: DescribeEngineDefaultParametersPaginator = client.get_paginator("describe_engine_default_parameters")
describe_events_paginator: DescribeEventsPaginator = client.get_paginator("describe_events")
describe_global_replication_groups_paginator: DescribeGlobalReplicationGroupsPaginator = client.get_paginator("describe_global_replication_groups")
describe_replication_groups_paginator: DescribeReplicationGroupsPaginator = client.get_paginator("describe_replication_groups")
describe_reserved_cache_nodes_paginator: DescribeReservedCacheNodesPaginator = client.get_paginator("describe_reserved_cache_nodes")
describe_reserved_cache_nodes_offerings_paginator: DescribeReservedCacheNodesOfferingsPaginator = client.get_paginator("describe_reserved_cache_nodes_offerings")
describe_service_updates_paginator: DescribeServiceUpdatesPaginator = client.get_paginator("describe_service_updates")
describe_snapshots_paginator: DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_update_actions_paginator: DescribeUpdateActionsPaginator = client.get_paginator("describe_update_actions")
describe_user_groups_paginator: DescribeUserGroupsPaginator = client.get_paginator("describe_user_groups")
describe_users_paginator: DescribeUsersPaginator = client.get_paginator("describe_users")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_elasticache.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_elasticache import ElastiCacheClient
from mypy_boto3_elasticache.waiter import (
    CacheClusterAvailableWaiter,
    CacheClusterDeletedWaiter,
    ReplicationGroupAvailableWaiter,
    ReplicationGroupDeletedWaiter,
)

client: ElastiCacheClient = boto3.client("elasticache")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
cache_cluster_available_waiter: CacheClusterAvailableWaiter = client.get_waiter("cache_cluster_available")
cache_cluster_deleted_waiter: CacheClusterDeletedWaiter = client.get_waiter("cache_cluster_deleted")
replication_group_available_waiter: ReplicationGroupAvailableWaiter = client.get_waiter("replication_group_available")
replication_group_deleted_waiter: ReplicationGroupDeletedWaiter = client.get_waiter("replication_group_deleted")
```

<a id="literals"></a>

### Literals

`mypy_boto3_elasticache.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_elasticache.literals import (
    AZModeType,
    AuthTokenUpdateStatusType,
    AuthTokenUpdateStrategyTypeType,
    AuthenticationTypeType,
    AutomaticFailoverStatusType,
    CacheClusterAvailableWaiterName,
    CacheClusterDeletedWaiterName,
    ChangeTypeType,
    DescribeCacheClustersPaginatorName,
    DescribeCacheEngineVersionsPaginatorName,
    DescribeCacheParameterGroupsPaginatorName,
    DescribeCacheParametersPaginatorName,
    DescribeCacheSecurityGroupsPaginatorName,
    DescribeCacheSubnetGroupsPaginatorName,
    DescribeEngineDefaultParametersPaginatorName,
    DescribeEventsPaginatorName,
    DescribeGlobalReplicationGroupsPaginatorName,
    DescribeReplicationGroupsPaginatorName,
    DescribeReservedCacheNodesOfferingsPaginatorName,
    DescribeReservedCacheNodesPaginatorName,
    DescribeServiceUpdatesPaginatorName,
    DescribeSnapshotsPaginatorName,
    DescribeUpdateActionsPaginatorName,
    DescribeUserGroupsPaginatorName,
    DescribeUsersPaginatorName,
    DestinationTypeType,
    LogDeliveryConfigurationStatusType,
    LogFormatType,
    LogTypeType,
    MultiAZStatusType,
    NodeUpdateInitiatedByType,
    NodeUpdateStatusType,
    OutpostModeType,
    PendingAutomaticFailoverStatusType,
    ReplicationGroupAvailableWaiterName,
    ReplicationGroupDeletedWaiterName,
    ServiceUpdateSeverityType,
    ServiceUpdateStatusType,
    ServiceUpdateTypeType,
    SlaMetType,
    SourceTypeType,
    UpdateActionStatusType,
)

def check_value(value: AZModeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_elasticache.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_elasticache.type_defs import (
    AddTagsToResourceMessageTypeDef,
    AllowedNodeTypeModificationsMessageResponseTypeDef,
    AuthenticationTypeDef,
    AuthorizeCacheSecurityGroupIngressMessageTypeDef,
    AuthorizeCacheSecurityGroupIngressResultResponseTypeDef,
    AvailabilityZoneTypeDef,
    BatchApplyUpdateActionMessageTypeDef,
    BatchStopUpdateActionMessageTypeDef,
    CacheClusterMessageResponseTypeDef,
    CacheClusterTypeDef,
    CacheEngineVersionMessageResponseTypeDef,
    CacheEngineVersionTypeDef,
    CacheNodeTypeDef,
    CacheNodeTypeSpecificParameterTypeDef,
    CacheNodeTypeSpecificValueTypeDef,
    CacheNodeUpdateStatusTypeDef,
    CacheParameterGroupDetailsResponseTypeDef,
    CacheParameterGroupNameMessageResponseTypeDef,
    CacheParameterGroupStatusTypeDef,
    CacheParameterGroupTypeDef,
    CacheParameterGroupsMessageResponseTypeDef,
    CacheSecurityGroupMembershipTypeDef,
    CacheSecurityGroupMessageResponseTypeDef,
    CacheSecurityGroupTypeDef,
    CacheSubnetGroupMessageResponseTypeDef,
    CacheSubnetGroupTypeDef,
    CloudWatchLogsDestinationDetailsTypeDef,
    CompleteMigrationMessageTypeDef,
    CompleteMigrationResponseResponseTypeDef,
    ConfigureShardTypeDef,
    CopySnapshotMessageTypeDef,
    CopySnapshotResultResponseTypeDef,
    CreateCacheClusterMessageTypeDef,
    CreateCacheClusterResultResponseTypeDef,
    CreateCacheParameterGroupMessageTypeDef,
    CreateCacheParameterGroupResultResponseTypeDef,
    CreateCacheSecurityGroupMessageTypeDef,
    CreateCacheSecurityGroupResultResponseTypeDef,
    CreateCacheSubnetGroupMessageTypeDef,
    CreateCacheSubnetGroupResultResponseTypeDef,
    CreateGlobalReplicationGroupMessageTypeDef,
    CreateGlobalReplicationGroupResultResponseTypeDef,
    CreateReplicationGroupMessageTypeDef,
    CreateReplicationGroupResultResponseTypeDef,
    CreateSnapshotMessageTypeDef,
    CreateSnapshotResultResponseTypeDef,
    CreateUserGroupMessageTypeDef,
    CreateUserMessageTypeDef,
    CustomerNodeEndpointTypeDef,
    DecreaseNodeGroupsInGlobalReplicationGroupMessageTypeDef,
    DecreaseNodeGroupsInGlobalReplicationGroupResultResponseTypeDef,
    DecreaseReplicaCountMessageTypeDef,
    DecreaseReplicaCountResultResponseTypeDef,
    DeleteCacheClusterMessageTypeDef,
    DeleteCacheClusterResultResponseTypeDef,
    DeleteCacheParameterGroupMessageTypeDef,
    DeleteCacheSecurityGroupMessageTypeDef,
    DeleteCacheSubnetGroupMessageTypeDef,
    DeleteGlobalReplicationGroupMessageTypeDef,
    DeleteGlobalReplicationGroupResultResponseTypeDef,
    DeleteReplicationGroupMessageTypeDef,
    DeleteReplicationGroupResultResponseTypeDef,
    DeleteSnapshotMessageTypeDef,
    DeleteSnapshotResultResponseTypeDef,
    DeleteUserGroupMessageTypeDef,
    DeleteUserMessageTypeDef,
    DescribeCacheClustersMessageTypeDef,
    DescribeCacheEngineVersionsMessageTypeDef,
    DescribeCacheParameterGroupsMessageTypeDef,
    DescribeCacheParametersMessageTypeDef,
    DescribeCacheSecurityGroupsMessageTypeDef,
    DescribeCacheSubnetGroupsMessageTypeDef,
    DescribeEngineDefaultParametersMessageTypeDef,
    DescribeEngineDefaultParametersResultResponseTypeDef,
    DescribeEventsMessageTypeDef,
    DescribeGlobalReplicationGroupsMessageTypeDef,
    DescribeGlobalReplicationGroupsResultResponseTypeDef,
    DescribeReplicationGroupsMessageTypeDef,
    DescribeReservedCacheNodesMessageTypeDef,
    DescribeReservedCacheNodesOfferingsMessageTypeDef,
    DescribeServiceUpdatesMessageTypeDef,
    DescribeSnapshotsListMessageResponseTypeDef,
    DescribeSnapshotsMessageTypeDef,
    DescribeUpdateActionsMessageTypeDef,
    DescribeUserGroupsMessageTypeDef,
    DescribeUserGroupsResultResponseTypeDef,
    DescribeUsersMessageTypeDef,
    DescribeUsersResultResponseTypeDef,
    DestinationDetailsTypeDef,
    DisassociateGlobalReplicationGroupMessageTypeDef,
    DisassociateGlobalReplicationGroupResultResponseTypeDef,
    EC2SecurityGroupTypeDef,
    EndpointTypeDef,
    EngineDefaultsTypeDef,
    EventTypeDef,
    EventsMessageResponseTypeDef,
    FailoverGlobalReplicationGroupMessageTypeDef,
    FailoverGlobalReplicationGroupResultResponseTypeDef,
    FilterTypeDef,
    GlobalNodeGroupTypeDef,
    GlobalReplicationGroupInfoTypeDef,
    GlobalReplicationGroupMemberTypeDef,
    GlobalReplicationGroupTypeDef,
    IncreaseNodeGroupsInGlobalReplicationGroupMessageTypeDef,
    IncreaseNodeGroupsInGlobalReplicationGroupResultResponseTypeDef,
    IncreaseReplicaCountMessageTypeDef,
    IncreaseReplicaCountResultResponseTypeDef,
    KinesisFirehoseDestinationDetailsTypeDef,
    ListAllowedNodeTypeModificationsMessageTypeDef,
    ListTagsForResourceMessageTypeDef,
    LogDeliveryConfigurationRequestTypeDef,
    LogDeliveryConfigurationTypeDef,
    ModifyCacheClusterMessageTypeDef,
    ModifyCacheClusterResultResponseTypeDef,
    ModifyCacheParameterGroupMessageTypeDef,
    ModifyCacheSubnetGroupMessageTypeDef,
    ModifyCacheSubnetGroupResultResponseTypeDef,
    ModifyGlobalReplicationGroupMessageTypeDef,
    ModifyGlobalReplicationGroupResultResponseTypeDef,
    ModifyReplicationGroupMessageTypeDef,
    ModifyReplicationGroupResultResponseTypeDef,
    ModifyReplicationGroupShardConfigurationMessageTypeDef,
    ModifyReplicationGroupShardConfigurationResultResponseTypeDef,
    ModifyUserGroupMessageTypeDef,
    ModifyUserMessageTypeDef,
    NodeGroupConfigurationTypeDef,
    NodeGroupMemberTypeDef,
    NodeGroupMemberUpdateStatusTypeDef,
    NodeGroupTypeDef,
    NodeGroupUpdateStatusTypeDef,
    NodeSnapshotTypeDef,
    NotificationConfigurationTypeDef,
    PaginatorConfigTypeDef,
    ParameterNameValueTypeDef,
    ParameterTypeDef,
    PendingLogDeliveryConfigurationTypeDef,
    PendingModifiedValuesTypeDef,
    ProcessedUpdateActionTypeDef,
    PurchaseReservedCacheNodesOfferingMessageTypeDef,
    PurchaseReservedCacheNodesOfferingResultResponseTypeDef,
    RebalanceSlotsInGlobalReplicationGroupMessageTypeDef,
    RebalanceSlotsInGlobalReplicationGroupResultResponseTypeDef,
    RebootCacheClusterMessageTypeDef,
    RebootCacheClusterResultResponseTypeDef,
    RecurringChargeTypeDef,
    RegionalConfigurationTypeDef,
    RemoveTagsFromResourceMessageTypeDef,
    ReplicationGroupMessageResponseTypeDef,
    ReplicationGroupPendingModifiedValuesTypeDef,
    ReplicationGroupTypeDef,
    ReservedCacheNodeMessageResponseTypeDef,
    ReservedCacheNodeTypeDef,
    ReservedCacheNodesOfferingMessageResponseTypeDef,
    ReservedCacheNodesOfferingTypeDef,
    ResetCacheParameterGroupMessageTypeDef,
    ReshardingConfigurationTypeDef,
    ReshardingStatusTypeDef,
    ResponseMetadataTypeDef,
    RevokeCacheSecurityGroupIngressMessageTypeDef,
    RevokeCacheSecurityGroupIngressResultResponseTypeDef,
    SecurityGroupMembershipTypeDef,
    ServiceUpdateTypeDef,
    ServiceUpdatesMessageResponseTypeDef,
    SlotMigrationTypeDef,
    SnapshotTypeDef,
    StartMigrationMessageTypeDef,
    StartMigrationResponseResponseTypeDef,
    SubnetOutpostTypeDef,
    SubnetTypeDef,
    TagListMessageResponseTypeDef,
    TagTypeDef,
    TestFailoverMessageTypeDef,
    TestFailoverResultResponseTypeDef,
    TimeRangeFilterTypeDef,
    UnprocessedUpdateActionTypeDef,
    UpdateActionResultsMessageResponseTypeDef,
    UpdateActionTypeDef,
    UpdateActionsMessageResponseTypeDef,
    UserGroupPendingChangesTypeDef,
    UserGroupResponseTypeDef,
    UserGroupsUpdateStatusTypeDef,
    UserResponseTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AddTagsToResourceMessageTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-elasticache` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-elasticache docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elasticache/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
