# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GenaiKnowledgeBaseArgs', 'GenaiKnowledgeBase']

@pulumi.input_type
class GenaiKnowledgeBaseArgs:
    def __init__(__self__, *,
                 datasources: pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseDataSourceArgs']]],
                 embedding_model_uuid: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 added_to_agent_at: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_indexing_jobs: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseLastIndexingJobArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GenaiKnowledgeBase resource.
        :param pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseDataSourceArgs']]] datasources: Data sources for the knowledge base
        :param pulumi.Input[_builtins.str] embedding_model_uuid: The unique identifier of the embedding model
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project to which the knowledge base belongs.
        :param pulumi.Input[_builtins.str] added_to_agent_at: The time when the knowledge base was added to the agent.
        :param pulumi.Input[_builtins.str] database_id: The unique identifier of the DigitalOcean OpenSearch database this knowledge base will use
        :param pulumi.Input[_builtins.bool] is_public: Indicates whether the knowledge base is public or private.
        :param pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseLastIndexingJobArgs']]] last_indexing_jobs: The last indexing job for the knowledge base.
        :param pulumi.Input[_builtins.str] name: The name of the knowledge base.
        :param pulumi.Input[_builtins.str] vpc_uuid: The unique identifier of the VPC to which the knowledge base belongs.
        """
        pulumi.set(__self__, "datasources", datasources)
        pulumi.set(__self__, "embedding_model_uuid", embedding_model_uuid)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "region", region)
        if added_to_agent_at is not None:
            pulumi.set(__self__, "added_to_agent_at", added_to_agent_at)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if last_indexing_jobs is not None:
            pulumi.set(__self__, "last_indexing_jobs", last_indexing_jobs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @_builtins.property
    @pulumi.getter
    def datasources(self) -> pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseDataSourceArgs']]]:
        """
        Data sources for the knowledge base
        """
        return pulumi.get(self, "datasources")

    @datasources.setter
    def datasources(self, value: pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseDataSourceArgs']]]):
        pulumi.set(self, "datasources", value)

    @_builtins.property
    @pulumi.getter(name="embeddingModelUuid")
    def embedding_model_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the embedding model
        """
        return pulumi.get(self, "embedding_model_uuid")

    @embedding_model_uuid.setter
    def embedding_model_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "embedding_model_uuid", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the project to which the knowledge base belongs.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="addedToAgentAt")
    def added_to_agent_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the knowledge base was added to the agent.
        """
        return pulumi.get(self, "added_to_agent_at")

    @added_to_agent_at.setter
    def added_to_agent_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "added_to_agent_at", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the DigitalOcean OpenSearch database this knowledge base will use
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the knowledge base is public or private.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_public", value)

    @_builtins.property
    @pulumi.getter(name="lastIndexingJobs")
    def last_indexing_jobs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseLastIndexingJobArgs']]]]:
        """
        The last indexing job for the knowledge base.
        """
        return pulumi.get(self, "last_indexing_jobs")

    @last_indexing_jobs.setter
    def last_indexing_jobs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseLastIndexingJobArgs']]]]):
        pulumi.set(self, "last_indexing_jobs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the knowledge base.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the VPC to which the knowledge base belongs.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.input_type
class _GenaiKnowledgeBaseState:
    def __init__(__self__, *,
                 added_to_agent_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datasources: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseDataSourceArgs']]]] = None,
                 embedding_model_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_indexing_jobs: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseLastIndexingJobArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GenaiKnowledgeBase resources.
        :param pulumi.Input[_builtins.str] added_to_agent_at: The time when the knowledge base was added to the agent.
        :param pulumi.Input[_builtins.str] created_at: The time when the knowledge base was created.
        :param pulumi.Input[_builtins.str] database_id: The unique identifier of the DigitalOcean OpenSearch database this knowledge base will use
        :param pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseDataSourceArgs']]] datasources: Data sources for the knowledge base
        :param pulumi.Input[_builtins.str] embedding_model_uuid: The unique identifier of the embedding model
        :param pulumi.Input[_builtins.bool] is_public: Indicates whether the knowledge base is public or private.
        :param pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseLastIndexingJobArgs']]] last_indexing_jobs: The last indexing job for the knowledge base.
        :param pulumi.Input[_builtins.str] name: The name of the knowledge base.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project to which the knowledge base belongs.
        :param pulumi.Input[_builtins.str] vpc_uuid: The unique identifier of the VPC to which the knowledge base belongs.
        """
        if added_to_agent_at is not None:
            pulumi.set(__self__, "added_to_agent_at", added_to_agent_at)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if datasources is not None:
            pulumi.set(__self__, "datasources", datasources)
        if embedding_model_uuid is not None:
            pulumi.set(__self__, "embedding_model_uuid", embedding_model_uuid)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if last_indexing_jobs is not None:
            pulumi.set(__self__, "last_indexing_jobs", last_indexing_jobs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @_builtins.property
    @pulumi.getter(name="addedToAgentAt")
    def added_to_agent_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the knowledge base was added to the agent.
        """
        return pulumi.get(self, "added_to_agent_at")

    @added_to_agent_at.setter
    def added_to_agent_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "added_to_agent_at", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the knowledge base was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the DigitalOcean OpenSearch database this knowledge base will use
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def datasources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseDataSourceArgs']]]]:
        """
        Data sources for the knowledge base
        """
        return pulumi.get(self, "datasources")

    @datasources.setter
    def datasources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseDataSourceArgs']]]]):
        pulumi.set(self, "datasources", value)

    @_builtins.property
    @pulumi.getter(name="embeddingModelUuid")
    def embedding_model_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the embedding model
        """
        return pulumi.get(self, "embedding_model_uuid")

    @embedding_model_uuid.setter
    def embedding_model_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "embedding_model_uuid", value)

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the knowledge base is public or private.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_public", value)

    @_builtins.property
    @pulumi.getter(name="lastIndexingJobs")
    def last_indexing_jobs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseLastIndexingJobArgs']]]]:
        """
        The last indexing job for the knowledge base.
        """
        return pulumi.get(self, "last_indexing_jobs")

    @last_indexing_jobs.setter
    def last_indexing_jobs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiKnowledgeBaseLastIndexingJobArgs']]]]):
        pulumi.set(self, "last_indexing_jobs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the knowledge base.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the project to which the knowledge base belongs.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the VPC to which the knowledge base belongs.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.type_token("digitalocean:index/genaiKnowledgeBase:GenaiKnowledgeBase")
class GenaiKnowledgeBase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 added_to_agent_at: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datasources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceArgs', 'GenaiKnowledgeBaseDataSourceArgsDict']]]]] = None,
                 embedding_model_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_indexing_jobs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseLastIndexingJobArgs', 'GenaiKnowledgeBaseLastIndexingJobArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a GenaiKnowledgeBase resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] added_to_agent_at: The time when the knowledge base was added to the agent.
        :param pulumi.Input[_builtins.str] database_id: The unique identifier of the DigitalOcean OpenSearch database this knowledge base will use
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceArgs', 'GenaiKnowledgeBaseDataSourceArgsDict']]]] datasources: Data sources for the knowledge base
        :param pulumi.Input[_builtins.str] embedding_model_uuid: The unique identifier of the embedding model
        :param pulumi.Input[_builtins.bool] is_public: Indicates whether the knowledge base is public or private.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseLastIndexingJobArgs', 'GenaiKnowledgeBaseLastIndexingJobArgsDict']]]] last_indexing_jobs: The last indexing job for the knowledge base.
        :param pulumi.Input[_builtins.str] name: The name of the knowledge base.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project to which the knowledge base belongs.
        :param pulumi.Input[_builtins.str] vpc_uuid: The unique identifier of the VPC to which the knowledge base belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GenaiKnowledgeBaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GenaiKnowledgeBase resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GenaiKnowledgeBaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GenaiKnowledgeBaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 added_to_agent_at: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datasources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceArgs', 'GenaiKnowledgeBaseDataSourceArgsDict']]]]] = None,
                 embedding_model_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_indexing_jobs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseLastIndexingJobArgs', 'GenaiKnowledgeBaseLastIndexingJobArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GenaiKnowledgeBaseArgs.__new__(GenaiKnowledgeBaseArgs)

            __props__.__dict__["added_to_agent_at"] = added_to_agent_at
            __props__.__dict__["database_id"] = database_id
            if datasources is None and not opts.urn:
                raise TypeError("Missing required property 'datasources'")
            __props__.__dict__["datasources"] = datasources
            if embedding_model_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'embedding_model_uuid'")
            __props__.__dict__["embedding_model_uuid"] = embedding_model_uuid
            __props__.__dict__["is_public"] = is_public
            __props__.__dict__["last_indexing_jobs"] = last_indexing_jobs
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_uuid"] = vpc_uuid
            __props__.__dict__["created_at"] = None
        super(GenaiKnowledgeBase, __self__).__init__(
            'digitalocean:index/genaiKnowledgeBase:GenaiKnowledgeBase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            added_to_agent_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            datasources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceArgs', 'GenaiKnowledgeBaseDataSourceArgsDict']]]]] = None,
            embedding_model_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            is_public: Optional[pulumi.Input[_builtins.bool]] = None,
            last_indexing_jobs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseLastIndexingJobArgs', 'GenaiKnowledgeBaseLastIndexingJobArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'GenaiKnowledgeBase':
        """
        Get an existing GenaiKnowledgeBase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] added_to_agent_at: The time when the knowledge base was added to the agent.
        :param pulumi.Input[_builtins.str] created_at: The time when the knowledge base was created.
        :param pulumi.Input[_builtins.str] database_id: The unique identifier of the DigitalOcean OpenSearch database this knowledge base will use
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceArgs', 'GenaiKnowledgeBaseDataSourceArgsDict']]]] datasources: Data sources for the knowledge base
        :param pulumi.Input[_builtins.str] embedding_model_uuid: The unique identifier of the embedding model
        :param pulumi.Input[_builtins.bool] is_public: Indicates whether the knowledge base is public or private.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiKnowledgeBaseLastIndexingJobArgs', 'GenaiKnowledgeBaseLastIndexingJobArgsDict']]]] last_indexing_jobs: The last indexing job for the knowledge base.
        :param pulumi.Input[_builtins.str] name: The name of the knowledge base.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project to which the knowledge base belongs.
        :param pulumi.Input[_builtins.str] vpc_uuid: The unique identifier of the VPC to which the knowledge base belongs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GenaiKnowledgeBaseState.__new__(_GenaiKnowledgeBaseState)

        __props__.__dict__["added_to_agent_at"] = added_to_agent_at
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["datasources"] = datasources
        __props__.__dict__["embedding_model_uuid"] = embedding_model_uuid
        __props__.__dict__["is_public"] = is_public
        __props__.__dict__["last_indexing_jobs"] = last_indexing_jobs
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_uuid"] = vpc_uuid
        return GenaiKnowledgeBase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addedToAgentAt")
    def added_to_agent_at(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time when the knowledge base was added to the agent.
        """
        return pulumi.get(self, "added_to_agent_at")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the knowledge base was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique identifier of the DigitalOcean OpenSearch database this knowledge base will use
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def datasources(self) -> pulumi.Output[Sequence['outputs.GenaiKnowledgeBaseDataSource']]:
        """
        Data sources for the knowledge base
        """
        return pulumi.get(self, "datasources")

    @_builtins.property
    @pulumi.getter(name="embeddingModelUuid")
    def embedding_model_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the embedding model
        """
        return pulumi.get(self, "embedding_model_uuid")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the knowledge base is public or private.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter(name="lastIndexingJobs")
    def last_indexing_jobs(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiKnowledgeBaseLastIndexingJob']]]:
        """
        The last indexing job for the knowledge base.
        """
        return pulumi.get(self, "last_indexing_jobs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the knowledge base.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the project to which the knowledge base belongs.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique identifier of the VPC to which the knowledge base belongs.
        """
        return pulumi.get(self, "vpc_uuid")

