# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVpcNatGatewayResult',
    'AwaitableGetVpcNatGatewayResult',
    'get_vpc_nat_gateway',
    'get_vpc_nat_gateway_output',
]

@pulumi.output_type
class GetVpcNatGatewayResult:
    """
    A collection of values returned by getVpcNatGateway.
    """
    def __init__(__self__, created_at=None, egresses=None, icmp_timeout_seconds=None, id=None, name=None, region=None, size=None, state=None, tcp_timeout_seconds=None, type=None, udp_timeout_seconds=None, updated_at=None, vpcs=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if egresses and not isinstance(egresses, list):
            raise TypeError("Expected argument 'egresses' to be a list")
        pulumi.set(__self__, "egresses", egresses)
        if icmp_timeout_seconds and not isinstance(icmp_timeout_seconds, int):
            raise TypeError("Expected argument 'icmp_timeout_seconds' to be a int")
        pulumi.set(__self__, "icmp_timeout_seconds", icmp_timeout_seconds)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tcp_timeout_seconds and not isinstance(tcp_timeout_seconds, int):
            raise TypeError("Expected argument 'tcp_timeout_seconds' to be a int")
        pulumi.set(__self__, "tcp_timeout_seconds", tcp_timeout_seconds)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if udp_timeout_seconds and not isinstance(udp_timeout_seconds, int):
            raise TypeError("Expected argument 'udp_timeout_seconds' to be a int")
        pulumi.set(__self__, "udp_timeout_seconds", udp_timeout_seconds)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if vpcs and not isinstance(vpcs, list):
            raise TypeError("Expected argument 'vpcs' to be a list")
        pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def egresses(self) -> Sequence['outputs.GetVpcNatGatewayEgressResult']:
        return pulumi.get(self, "egresses")

    @_builtins.property
    @pulumi.getter(name="icmpTimeoutSeconds")
    def icmp_timeout_seconds(self) -> _builtins.int:
        return pulumi.get(self, "icmp_timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tcpTimeoutSeconds")
    def tcp_timeout_seconds(self) -> _builtins.int:
        return pulumi.get(self, "tcp_timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="udpTimeoutSeconds")
    def udp_timeout_seconds(self) -> _builtins.int:
        return pulumi.get(self, "udp_timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Sequence['outputs.GetVpcNatGatewayVpcResult']:
        return pulumi.get(self, "vpcs")


class AwaitableGetVpcNatGatewayResult(GetVpcNatGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcNatGatewayResult(
            created_at=self.created_at,
            egresses=self.egresses,
            icmp_timeout_seconds=self.icmp_timeout_seconds,
            id=self.id,
            name=self.name,
            region=self.region,
            size=self.size,
            state=self.state,
            tcp_timeout_seconds=self.tcp_timeout_seconds,
            type=self.type,
            udp_timeout_seconds=self.udp_timeout_seconds,
            updated_at=self.updated_at,
            vpcs=self.vpcs)


def get_vpc_nat_gateway(id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcNatGatewayResult:
    """
    ## Example Usage

    Get the VPC NAT Gateway by name:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    my_imported_vpc_nat_gateway = digitalocean.get_vpc_nat_gateway(name=my_existing_vpc_nat_gateway["name"])
    ```

    Get the VPC NAT Gateway by ID:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    my_imported_vpc_nat_gateway = digitalocean.get_vpc_nat_gateway(id=my_existing_vpc_nat_gateway["id"])
    ```


    :param _builtins.str id: The ID of VPC NAT Gateway.
    :param _builtins.str name: The name of VPC NAT Gateway.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getVpcNatGateway:getVpcNatGateway', __args__, opts=opts, typ=GetVpcNatGatewayResult).value

    return AwaitableGetVpcNatGatewayResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        egresses=pulumi.get(__ret__, 'egresses'),
        icmp_timeout_seconds=pulumi.get(__ret__, 'icmp_timeout_seconds'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        size=pulumi.get(__ret__, 'size'),
        state=pulumi.get(__ret__, 'state'),
        tcp_timeout_seconds=pulumi.get(__ret__, 'tcp_timeout_seconds'),
        type=pulumi.get(__ret__, 'type'),
        udp_timeout_seconds=pulumi.get(__ret__, 'udp_timeout_seconds'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        vpcs=pulumi.get(__ret__, 'vpcs'))
def get_vpc_nat_gateway_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcNatGatewayResult]:
    """
    ## Example Usage

    Get the VPC NAT Gateway by name:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    my_imported_vpc_nat_gateway = digitalocean.get_vpc_nat_gateway(name=my_existing_vpc_nat_gateway["name"])
    ```

    Get the VPC NAT Gateway by ID:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    my_imported_vpc_nat_gateway = digitalocean.get_vpc_nat_gateway(id=my_existing_vpc_nat_gateway["id"])
    ```


    :param _builtins.str id: The ID of VPC NAT Gateway.
    :param _builtins.str name: The name of VPC NAT Gateway.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('digitalocean:index/getVpcNatGateway:getVpcNatGateway', __args__, opts=opts, typ=GetVpcNatGatewayResult)
    return __ret__.apply(lambda __response__: GetVpcNatGatewayResult(
        created_at=pulumi.get(__response__, 'created_at'),
        egresses=pulumi.get(__response__, 'egresses'),
        icmp_timeout_seconds=pulumi.get(__response__, 'icmp_timeout_seconds'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        size=pulumi.get(__response__, 'size'),
        state=pulumi.get(__response__, 'state'),
        tcp_timeout_seconds=pulumi.get(__response__, 'tcp_timeout_seconds'),
        type=pulumi.get(__response__, 'type'),
        udp_timeout_seconds=pulumi.get(__response__, 'udp_timeout_seconds'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        vpcs=pulumi.get(__response__, 'vpcs')))
