# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PartnerAttachmentArgs', 'PartnerAttachment']

@pulumi.input_type
class PartnerAttachmentArgs:
    def __init__(__self__, *,
                 connection_bandwidth_in_mbps: pulumi.Input[_builtins.int],
                 naas_provider: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 vpc_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 bgp: Optional[pulumi.Input['PartnerAttachmentBgpArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PartnerAttachment resource.
        :param pulumi.Input[_builtins.int] connection_bandwidth_in_mbps: The connection bandwidth in Mbps
        :param pulumi.Input[_builtins.str] naas_provider: The NaaS provider
        :param pulumi.Input[_builtins.str] region: The region where the Partner Attachment will be created
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_ids: The list of VPC IDs to attach the Partner Attachment to
        :param pulumi.Input[_builtins.str] name: The name of the Partner Attachment
        :param pulumi.Input[_builtins.str] parent_uuid: The UUID of the Parent Partner Attachment
        :param pulumi.Input[_builtins.str] redundancy_zone: The redundancy zone for the NaaS
        """
        pulumi.set(__self__, "connection_bandwidth_in_mbps", connection_bandwidth_in_mbps)
        pulumi.set(__self__, "naas_provider", naas_provider)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vpc_ids", vpc_ids)
        if bgp is not None:
            pulumi.set(__self__, "bgp", bgp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_uuid is not None:
            pulumi.set(__self__, "parent_uuid", parent_uuid)
        if redundancy_zone is not None:
            pulumi.set(__self__, "redundancy_zone", redundancy_zone)

    @_builtins.property
    @pulumi.getter(name="connectionBandwidthInMbps")
    def connection_bandwidth_in_mbps(self) -> pulumi.Input[_builtins.int]:
        """
        The connection bandwidth in Mbps
        """
        return pulumi.get(self, "connection_bandwidth_in_mbps")

    @connection_bandwidth_in_mbps.setter
    def connection_bandwidth_in_mbps(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "connection_bandwidth_in_mbps", value)

    @_builtins.property
    @pulumi.getter(name="naasProvider")
    def naas_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The NaaS provider
        """
        return pulumi.get(self, "naas_provider")

    @naas_provider.setter
    def naas_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "naas_provider", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region where the Partner Attachment will be created
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of VPC IDs to attach the Partner Attachment to
        """
        return pulumi.get(self, "vpc_ids")

    @vpc_ids.setter
    def vpc_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "vpc_ids", value)

    @_builtins.property
    @pulumi.getter
    def bgp(self) -> Optional[pulumi.Input['PartnerAttachmentBgpArgs']]:
        return pulumi.get(self, "bgp")

    @bgp.setter
    def bgp(self, value: Optional[pulumi.Input['PartnerAttachmentBgpArgs']]):
        pulumi.set(self, "bgp", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Partner Attachment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentUuid")
    def parent_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the Parent Partner Attachment
        """
        return pulumi.get(self, "parent_uuid")

    @parent_uuid.setter
    def parent_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_uuid", value)

    @_builtins.property
    @pulumi.getter(name="redundancyZone")
    def redundancy_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The redundancy zone for the NaaS
        """
        return pulumi.get(self, "redundancy_zone")

    @redundancy_zone.setter
    def redundancy_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundancy_zone", value)


@pulumi.input_type
class _PartnerAttachmentState:
    def __init__(__self__, *,
                 bgp: Optional[pulumi.Input['PartnerAttachmentBgpArgs']] = None,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 connection_bandwidth_in_mbps: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 naas_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PartnerAttachment resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] childrens: The children uuids of Partner Attachment
        :param pulumi.Input[_builtins.int] connection_bandwidth_in_mbps: The connection bandwidth in Mbps
        :param pulumi.Input[_builtins.str] created_at: The date and time when the Partner Attachment was created
        :param pulumi.Input[_builtins.str] naas_provider: The NaaS provider
        :param pulumi.Input[_builtins.str] name: The name of the Partner Attachment
        :param pulumi.Input[_builtins.str] parent_uuid: The UUID of the Parent Partner Attachment
        :param pulumi.Input[_builtins.str] redundancy_zone: The redundancy zone for the NaaS
        :param pulumi.Input[_builtins.str] region: The region where the Partner Attachment will be created
        :param pulumi.Input[_builtins.str] state: The state of the Partner Attachment
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_ids: The list of VPC IDs to attach the Partner Attachment to
        """
        if bgp is not None:
            pulumi.set(__self__, "bgp", bgp)
        if childrens is not None:
            pulumi.set(__self__, "childrens", childrens)
        if connection_bandwidth_in_mbps is not None:
            pulumi.set(__self__, "connection_bandwidth_in_mbps", connection_bandwidth_in_mbps)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if naas_provider is not None:
            pulumi.set(__self__, "naas_provider", naas_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_uuid is not None:
            pulumi.set(__self__, "parent_uuid", parent_uuid)
        if redundancy_zone is not None:
            pulumi.set(__self__, "redundancy_zone", redundancy_zone)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vpc_ids is not None:
            pulumi.set(__self__, "vpc_ids", vpc_ids)

    @_builtins.property
    @pulumi.getter
    def bgp(self) -> Optional[pulumi.Input['PartnerAttachmentBgpArgs']]:
        return pulumi.get(self, "bgp")

    @bgp.setter
    def bgp(self, value: Optional[pulumi.Input['PartnerAttachmentBgpArgs']]):
        pulumi.set(self, "bgp", value)

    @_builtins.property
    @pulumi.getter
    def childrens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The children uuids of Partner Attachment
        """
        return pulumi.get(self, "childrens")

    @childrens.setter
    def childrens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "childrens", value)

    @_builtins.property
    @pulumi.getter(name="connectionBandwidthInMbps")
    def connection_bandwidth_in_mbps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The connection bandwidth in Mbps
        """
        return pulumi.get(self, "connection_bandwidth_in_mbps")

    @connection_bandwidth_in_mbps.setter
    def connection_bandwidth_in_mbps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_bandwidth_in_mbps", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the Partner Attachment was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="naasProvider")
    def naas_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The NaaS provider
        """
        return pulumi.get(self, "naas_provider")

    @naas_provider.setter
    def naas_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "naas_provider", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Partner Attachment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentUuid")
    def parent_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the Parent Partner Attachment
        """
        return pulumi.get(self, "parent_uuid")

    @parent_uuid.setter
    def parent_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_uuid", value)

    @_builtins.property
    @pulumi.getter(name="redundancyZone")
    def redundancy_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The redundancy zone for the NaaS
        """
        return pulumi.get(self, "redundancy_zone")

    @redundancy_zone.setter
    def redundancy_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundancy_zone", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the Partner Attachment will be created
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the Partner Attachment
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of VPC IDs to attach the Partner Attachment to
        """
        return pulumi.get(self, "vpc_ids")

    @vpc_ids.setter
    def vpc_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_ids", value)


@pulumi.type_token("digitalocean:index/partnerAttachment:PartnerAttachment")
class PartnerAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp: Optional[pulumi.Input[Union['PartnerAttachmentBgpArgs', 'PartnerAttachmentBgpArgsDict']]] = None,
                 connection_bandwidth_in_mbps: Optional[pulumi.Input[_builtins.int]] = None,
                 naas_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Create a PartnerAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] connection_bandwidth_in_mbps: The connection bandwidth in Mbps
        :param pulumi.Input[_builtins.str] naas_provider: The NaaS provider
        :param pulumi.Input[_builtins.str] name: The name of the Partner Attachment
        :param pulumi.Input[_builtins.str] parent_uuid: The UUID of the Parent Partner Attachment
        :param pulumi.Input[_builtins.str] redundancy_zone: The redundancy zone for the NaaS
        :param pulumi.Input[_builtins.str] region: The region where the Partner Attachment will be created
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_ids: The list of VPC IDs to attach the Partner Attachment to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PartnerAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PartnerAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PartnerAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PartnerAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp: Optional[pulumi.Input[Union['PartnerAttachmentBgpArgs', 'PartnerAttachmentBgpArgsDict']]] = None,
                 connection_bandwidth_in_mbps: Optional[pulumi.Input[_builtins.int]] = None,
                 naas_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PartnerAttachmentArgs.__new__(PartnerAttachmentArgs)

            __props__.__dict__["bgp"] = bgp
            if connection_bandwidth_in_mbps is None and not opts.urn:
                raise TypeError("Missing required property 'connection_bandwidth_in_mbps'")
            __props__.__dict__["connection_bandwidth_in_mbps"] = connection_bandwidth_in_mbps
            if naas_provider is None and not opts.urn:
                raise TypeError("Missing required property 'naas_provider'")
            __props__.__dict__["naas_provider"] = naas_provider
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_uuid"] = parent_uuid
            __props__.__dict__["redundancy_zone"] = redundancy_zone
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if vpc_ids is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_ids'")
            __props__.__dict__["vpc_ids"] = vpc_ids
            __props__.__dict__["childrens"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["state"] = None
        super(PartnerAttachment, __self__).__init__(
            'digitalocean:index/partnerAttachment:PartnerAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bgp: Optional[pulumi.Input[Union['PartnerAttachmentBgpArgs', 'PartnerAttachmentBgpArgsDict']]] = None,
            childrens: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            connection_bandwidth_in_mbps: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            naas_provider: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            redundancy_zone: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'PartnerAttachment':
        """
        Get an existing PartnerAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] childrens: The children uuids of Partner Attachment
        :param pulumi.Input[_builtins.int] connection_bandwidth_in_mbps: The connection bandwidth in Mbps
        :param pulumi.Input[_builtins.str] created_at: The date and time when the Partner Attachment was created
        :param pulumi.Input[_builtins.str] naas_provider: The NaaS provider
        :param pulumi.Input[_builtins.str] name: The name of the Partner Attachment
        :param pulumi.Input[_builtins.str] parent_uuid: The UUID of the Parent Partner Attachment
        :param pulumi.Input[_builtins.str] redundancy_zone: The redundancy zone for the NaaS
        :param pulumi.Input[_builtins.str] region: The region where the Partner Attachment will be created
        :param pulumi.Input[_builtins.str] state: The state of the Partner Attachment
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_ids: The list of VPC IDs to attach the Partner Attachment to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PartnerAttachmentState.__new__(_PartnerAttachmentState)

        __props__.__dict__["bgp"] = bgp
        __props__.__dict__["childrens"] = childrens
        __props__.__dict__["connection_bandwidth_in_mbps"] = connection_bandwidth_in_mbps
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["naas_provider"] = naas_provider
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_uuid"] = parent_uuid
        __props__.__dict__["redundancy_zone"] = redundancy_zone
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        __props__.__dict__["vpc_ids"] = vpc_ids
        return PartnerAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bgp(self) -> pulumi.Output['outputs.PartnerAttachmentBgp']:
        return pulumi.get(self, "bgp")

    @_builtins.property
    @pulumi.getter
    def childrens(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The children uuids of Partner Attachment
        """
        return pulumi.get(self, "childrens")

    @_builtins.property
    @pulumi.getter(name="connectionBandwidthInMbps")
    def connection_bandwidth_in_mbps(self) -> pulumi.Output[_builtins.int]:
        """
        The connection bandwidth in Mbps
        """
        return pulumi.get(self, "connection_bandwidth_in_mbps")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the Partner Attachment was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="naasProvider")
    def naas_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The NaaS provider
        """
        return pulumi.get(self, "naas_provider")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Partner Attachment
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentUuid")
    def parent_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The UUID of the Parent Partner Attachment
        """
        return pulumi.get(self, "parent_uuid")

    @_builtins.property
    @pulumi.getter(name="redundancyZone")
    def redundancy_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The redundancy zone for the NaaS
        """
        return pulumi.get(self, "redundancy_zone")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the Partner Attachment will be created
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the Partner Attachment
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of VPC IDs to attach the Partner Attachment to
        """
        return pulumi.get(self, "vpc_ids")

