# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ReservedIpArgs', 'ReservedIp']

@pulumi.input_type
class ReservedIpArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ReservedIp resource.
        :param pulumi.Input[_builtins.str] region: The region that the reserved IP is reserved to.
        :param pulumi.Input[_builtins.int] droplet_id: The ID of Droplet that the reserved IP will be assigned to.
        :param pulumi.Input[_builtins.str] ip_address: The IP Address of the resource
        """
        pulumi.set(__self__, "region", region)
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region that the reserved IP is reserved to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of Droplet that the reserved IP will be assigned to.
        """
        return pulumi.get(self, "droplet_id")

    @droplet_id.setter
    def droplet_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "droplet_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP Address of the resource
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)


@pulumi.input_type
class _ReservedIpState:
    def __init__(__self__, *,
                 droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_ip_urn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReservedIp resources.
        :param pulumi.Input[_builtins.int] droplet_id: The ID of Droplet that the reserved IP will be assigned to.
        :param pulumi.Input[_builtins.str] ip_address: The IP Address of the resource
        :param pulumi.Input[_builtins.str] region: The region that the reserved IP is reserved to.
        :param pulumi.Input[_builtins.str] reserved_ip_urn: The uniform resource name of the reserved ip
        """
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_ip_urn is not None:
            pulumi.set(__self__, "reserved_ip_urn", reserved_ip_urn)

    @_builtins.property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of Droplet that the reserved IP will be assigned to.
        """
        return pulumi.get(self, "droplet_id")

    @droplet_id.setter
    def droplet_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "droplet_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP Address of the resource
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region that the reserved IP is reserved to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedIpUrn")
    def reserved_ip_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The uniform resource name of the reserved ip
        """
        return pulumi.get(self, "reserved_ip_urn")

    @reserved_ip_urn.setter
    def reserved_ip_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_ip_urn", value)


@pulumi.type_token("digitalocean:index/reservedIp:ReservedIp")
class ReservedIp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DigitalOcean reserved IP to represent a publicly-accessible static IP addresses that can be mapped to one of your Droplets.

        > **NOTE:** Reserved IPs can be assigned to a Droplet either directly on the `ReservedIp` resource by setting a `droplet_id` or using the `ReservedIpAssignment` resource, but the two cannot be used together.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example = digitalocean.Droplet("example",
            name="example",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-22-04-x64",
            region=digitalocean.Region.NYC3,
            ipv6=True,
            private_networking=True)
        example_reserved_ip = digitalocean.ReservedIp("example",
            droplet_id=example.id,
            region=example.region)
        ```

        ## Import

        Reserved IPs can be imported using the `ip`, e.g.

        ```sh
        $ pulumi import digitalocean:index/reservedIp:ReservedIp myip 192.168.0.1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] droplet_id: The ID of Droplet that the reserved IP will be assigned to.
        :param pulumi.Input[_builtins.str] ip_address: The IP Address of the resource
        :param pulumi.Input[_builtins.str] region: The region that the reserved IP is reserved to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReservedIpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean reserved IP to represent a publicly-accessible static IP addresses that can be mapped to one of your Droplets.

        > **NOTE:** Reserved IPs can be assigned to a Droplet either directly on the `ReservedIp` resource by setting a `droplet_id` or using the `ReservedIpAssignment` resource, but the two cannot be used together.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example = digitalocean.Droplet("example",
            name="example",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-22-04-x64",
            region=digitalocean.Region.NYC3,
            ipv6=True,
            private_networking=True)
        example_reserved_ip = digitalocean.ReservedIp("example",
            droplet_id=example.id,
            region=example.region)
        ```

        ## Import

        Reserved IPs can be imported using the `ip`, e.g.

        ```sh
        $ pulumi import digitalocean:index/reservedIp:ReservedIp myip 192.168.0.1
        ```

        :param str resource_name: The name of the resource.
        :param ReservedIpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReservedIpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReservedIpArgs.__new__(ReservedIpArgs)

            __props__.__dict__["droplet_id"] = droplet_id
            __props__.__dict__["ip_address"] = ip_address
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_ip_urn"] = None
        super(ReservedIp, __self__).__init__(
            'digitalocean:index/reservedIp:ReservedIp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            droplet_id: Optional[pulumi.Input[_builtins.int]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_ip_urn: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReservedIp':
        """
        Get an existing ReservedIp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] droplet_id: The ID of Droplet that the reserved IP will be assigned to.
        :param pulumi.Input[_builtins.str] ip_address: The IP Address of the resource
        :param pulumi.Input[_builtins.str] region: The region that the reserved IP is reserved to.
        :param pulumi.Input[_builtins.str] reserved_ip_urn: The uniform resource name of the reserved ip
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReservedIpState.__new__(_ReservedIpState)

        __props__.__dict__["droplet_id"] = droplet_id
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_ip_urn"] = reserved_ip_urn
        return ReservedIp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of Droplet that the reserved IP will be assigned to.
        """
        return pulumi.get(self, "droplet_id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP Address of the resource
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region that the reserved IP is reserved to.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reservedIpUrn")
    def reserved_ip_urn(self) -> pulumi.Output[_builtins.str]:
        """
        The uniform resource name of the reserved ip
        """
        return pulumi.get(self, "reserved_ip_urn")

