# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcNatGatewayArgs', 'VpcNatGateway']

@pulumi.input_type
class VpcNatGatewayArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 vpcs: pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayVpcArgs']]],
                 icmp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 udp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a VpcNatGateway resource.
        :param pulumi.Input[_builtins.str] region: The region for the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] size: The size of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] type: The type of the VPC NAT Gateway.
        :param pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayVpcArgs']]] vpcs: The ingress VPC configuration of the VPC NAT Gateway, the supported arguments are
               documented below.
        :param pulumi.Input[_builtins.int] icmp_timeout_seconds: The egress timeout value for ICMP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] name: The name of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] tcp_timeout_seconds: The egress timeout value for TCP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] udp_timeout_seconds: The egress timeout value for UDP connections of the VPC NAT Gateway.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpcs", vpcs)
        if icmp_timeout_seconds is not None:
            pulumi.set(__self__, "icmp_timeout_seconds", icmp_timeout_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tcp_timeout_seconds is not None:
            pulumi.set(__self__, "tcp_timeout_seconds", tcp_timeout_seconds)
        if udp_timeout_seconds is not None:
            pulumi.set(__self__, "udp_timeout_seconds", udp_timeout_seconds)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region for the VPC NAT Gateway.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        The size of the VPC NAT Gateway.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the VPC NAT Gateway.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayVpcArgs']]]:
        """
        The ingress VPC configuration of the VPC NAT Gateway, the supported arguments are
        documented below.
        """
        return pulumi.get(self, "vpcs")

    @vpcs.setter
    def vpcs(self, value: pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayVpcArgs']]]):
        pulumi.set(self, "vpcs", value)

    @_builtins.property
    @pulumi.getter(name="icmpTimeoutSeconds")
    def icmp_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The egress timeout value for ICMP connections of the VPC NAT Gateway.
        """
        return pulumi.get(self, "icmp_timeout_seconds")

    @icmp_timeout_seconds.setter
    def icmp_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "icmp_timeout_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC NAT Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimeoutSeconds")
    def tcp_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The egress timeout value for TCP connections of the VPC NAT Gateway.
        """
        return pulumi.get(self, "tcp_timeout_seconds")

    @tcp_timeout_seconds.setter
    def tcp_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_timeout_seconds", value)

    @_builtins.property
    @pulumi.getter(name="udpTimeoutSeconds")
    def udp_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The egress timeout value for UDP connections of the VPC NAT Gateway.
        """
        return pulumi.get(self, "udp_timeout_seconds")

    @udp_timeout_seconds.setter
    def udp_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_timeout_seconds", value)


@pulumi.input_type
class _VpcNatGatewayState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 egresses: Optional[pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayEgressArgs']]]] = None,
                 icmp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayVpcArgs']]]] = None):
        """
        Input properties used for looking up and filtering VpcNatGateway resources.
        :param pulumi.Input[_builtins.str] created_at: Created at timestamp for the VPC NAT Gateway.
        :param pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayEgressArgs']]] egresses: Embeds the list of public egresses assigned to the VPC NAT Gateway: resolves as list of
               `public_gateways` embedding the reserved `ipv4` addresses.
        :param pulumi.Input[_builtins.int] icmp_timeout_seconds: The egress timeout value for ICMP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] name: The name of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] region: The region for the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] size: The size of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] state: State of the VPC NAT Gateway
        :param pulumi.Input[_builtins.int] tcp_timeout_seconds: The egress timeout value for TCP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] type: The type of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] udp_timeout_seconds: The egress timeout value for UDP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] updated_at: Updated at timestamp for the VPC NAT Gateway.
        :param pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayVpcArgs']]] vpcs: The ingress VPC configuration of the VPC NAT Gateway, the supported arguments are
               documented below.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if egresses is not None:
            pulumi.set(__self__, "egresses", egresses)
        if icmp_timeout_seconds is not None:
            pulumi.set(__self__, "icmp_timeout_seconds", icmp_timeout_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tcp_timeout_seconds is not None:
            pulumi.set(__self__, "tcp_timeout_seconds", tcp_timeout_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if udp_timeout_seconds is not None:
            pulumi.set(__self__, "udp_timeout_seconds", udp_timeout_seconds)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpcs is not None:
            pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Created at timestamp for the VPC NAT Gateway.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def egresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayEgressArgs']]]]:
        """
        Embeds the list of public egresses assigned to the VPC NAT Gateway: resolves as list of
        `public_gateways` embedding the reserved `ipv4` addresses.
        """
        return pulumi.get(self, "egresses")

    @egresses.setter
    def egresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayEgressArgs']]]]):
        pulumi.set(self, "egresses", value)

    @_builtins.property
    @pulumi.getter(name="icmpTimeoutSeconds")
    def icmp_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The egress timeout value for ICMP connections of the VPC NAT Gateway.
        """
        return pulumi.get(self, "icmp_timeout_seconds")

    @icmp_timeout_seconds.setter
    def icmp_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "icmp_timeout_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC NAT Gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region for the VPC NAT Gateway.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the VPC NAT Gateway.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the VPC NAT Gateway
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimeoutSeconds")
    def tcp_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The egress timeout value for TCP connections of the VPC NAT Gateway.
        """
        return pulumi.get(self, "tcp_timeout_seconds")

    @tcp_timeout_seconds.setter
    def tcp_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_timeout_seconds", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the VPC NAT Gateway.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="udpTimeoutSeconds")
    def udp_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The egress timeout value for UDP connections of the VPC NAT Gateway.
        """
        return pulumi.get(self, "udp_timeout_seconds")

    @udp_timeout_seconds.setter
    def udp_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_timeout_seconds", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Updated at timestamp for the VPC NAT Gateway.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayVpcArgs']]]]:
        """
        The ingress VPC configuration of the VPC NAT Gateway, the supported arguments are
        documented below.
        """
        return pulumi.get(self, "vpcs")

    @vpcs.setter
    def vpcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcNatGatewayVpcArgs']]]]):
        pulumi.set(self, "vpcs", value)


@pulumi.type_token("digitalocean:index/vpcNatGateway:VpcNatGateway")
class VpcNatGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 icmp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcNatGatewayVpcArgs', 'VpcNatGatewayVpcArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a DigitalOcean VPC NAT Gateway resource. This can be used to create, modify,
        read and delete VPC NAT Gateways.

        NOTE: VPC NAT Gateway is currently in Private Preview.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        my_vpc = digitalocean.Vpc("my-vpc",
            name="terraform-example",
            region="nyc3")
        my_vpc_nat_gateway = digitalocean.VpcNatGateway("my-vpc-nat-gateway",
            name="terraform-example",
            type="PUBLIC",
            region="nyc3",
            size=1,
            vpcs=[{
                "vpc_uuid": my_vpc.id,
            }],
            udp_timeout_seconds=30,
            icmp_timeout_seconds=30,
            tcp_timeout_seconds=30)
        ```

        ## Import

        VPC NAT Gateways can be imported using their `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/vpcNatGateway:VpcNatGateway my-vpc-nat-gateway-id 38e66834-d741-47ec-88e7-c70cbdcz0445
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] icmp_timeout_seconds: The egress timeout value for ICMP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] name: The name of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] region: The region for the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] size: The size of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] tcp_timeout_seconds: The egress timeout value for TCP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] type: The type of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] udp_timeout_seconds: The egress timeout value for UDP connections of the VPC NAT Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcNatGatewayVpcArgs', 'VpcNatGatewayVpcArgsDict']]]] vpcs: The ingress VPC configuration of the VPC NAT Gateway, the supported arguments are
               documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcNatGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean VPC NAT Gateway resource. This can be used to create, modify,
        read and delete VPC NAT Gateways.

        NOTE: VPC NAT Gateway is currently in Private Preview.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        my_vpc = digitalocean.Vpc("my-vpc",
            name="terraform-example",
            region="nyc3")
        my_vpc_nat_gateway = digitalocean.VpcNatGateway("my-vpc-nat-gateway",
            name="terraform-example",
            type="PUBLIC",
            region="nyc3",
            size=1,
            vpcs=[{
                "vpc_uuid": my_vpc.id,
            }],
            udp_timeout_seconds=30,
            icmp_timeout_seconds=30,
            tcp_timeout_seconds=30)
        ```

        ## Import

        VPC NAT Gateways can be imported using their `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/vpcNatGateway:VpcNatGateway my-vpc-nat-gateway-id 38e66834-d741-47ec-88e7-c70cbdcz0445
        ```

        :param str resource_name: The name of the resource.
        :param VpcNatGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcNatGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 icmp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 udp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcNatGatewayVpcArgs', 'VpcNatGatewayVpcArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcNatGatewayArgs.__new__(VpcNatGatewayArgs)

            __props__.__dict__["icmp_timeout_seconds"] = icmp_timeout_seconds
            __props__.__dict__["name"] = name
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["tcp_timeout_seconds"] = tcp_timeout_seconds
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["udp_timeout_seconds"] = udp_timeout_seconds
            if vpcs is None and not opts.urn:
                raise TypeError("Missing required property 'vpcs'")
            __props__.__dict__["vpcs"] = vpcs
            __props__.__dict__["created_at"] = None
            __props__.__dict__["egresses"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["updated_at"] = None
        super(VpcNatGateway, __self__).__init__(
            'digitalocean:index/vpcNatGateway:VpcNatGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            egresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcNatGatewayEgressArgs', 'VpcNatGatewayEgressArgsDict']]]]] = None,
            icmp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            tcp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            udp_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcNatGatewayVpcArgs', 'VpcNatGatewayVpcArgsDict']]]]] = None) -> 'VpcNatGateway':
        """
        Get an existing VpcNatGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Created at timestamp for the VPC NAT Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcNatGatewayEgressArgs', 'VpcNatGatewayEgressArgsDict']]]] egresses: Embeds the list of public egresses assigned to the VPC NAT Gateway: resolves as list of
               `public_gateways` embedding the reserved `ipv4` addresses.
        :param pulumi.Input[_builtins.int] icmp_timeout_seconds: The egress timeout value for ICMP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] name: The name of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] region: The region for the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] size: The size of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] state: State of the VPC NAT Gateway
        :param pulumi.Input[_builtins.int] tcp_timeout_seconds: The egress timeout value for TCP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] type: The type of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.int] udp_timeout_seconds: The egress timeout value for UDP connections of the VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] updated_at: Updated at timestamp for the VPC NAT Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcNatGatewayVpcArgs', 'VpcNatGatewayVpcArgsDict']]]] vpcs: The ingress VPC configuration of the VPC NAT Gateway, the supported arguments are
               documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcNatGatewayState.__new__(_VpcNatGatewayState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["egresses"] = egresses
        __props__.__dict__["icmp_timeout_seconds"] = icmp_timeout_seconds
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["state"] = state
        __props__.__dict__["tcp_timeout_seconds"] = tcp_timeout_seconds
        __props__.__dict__["type"] = type
        __props__.__dict__["udp_timeout_seconds"] = udp_timeout_seconds
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpcs"] = vpcs
        return VpcNatGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Created at timestamp for the VPC NAT Gateway.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def egresses(self) -> pulumi.Output[Sequence['outputs.VpcNatGatewayEgress']]:
        """
        Embeds the list of public egresses assigned to the VPC NAT Gateway: resolves as list of
        `public_gateways` embedding the reserved `ipv4` addresses.
        """
        return pulumi.get(self, "egresses")

    @_builtins.property
    @pulumi.getter(name="icmpTimeoutSeconds")
    def icmp_timeout_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        The egress timeout value for ICMP connections of the VPC NAT Gateway.
        """
        return pulumi.get(self, "icmp_timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the VPC NAT Gateway.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region for the VPC NAT Gateway.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the VPC NAT Gateway.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the VPC NAT Gateway
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tcpTimeoutSeconds")
    def tcp_timeout_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        The egress timeout value for TCP connections of the VPC NAT Gateway.
        """
        return pulumi.get(self, "tcp_timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the VPC NAT Gateway.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="udpTimeoutSeconds")
    def udp_timeout_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        The egress timeout value for UDP connections of the VPC NAT Gateway.
        """
        return pulumi.get(self, "udp_timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Updated at timestamp for the VPC NAT Gateway.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> pulumi.Output[Sequence['outputs.VpcNatGatewayVpc']]:
        """
        The ingress VPC configuration of the VPC NAT Gateway, the supported arguments are
        documented below.
        """
        return pulumi.get(self, "vpcs")

