import * as kms from '../../aws-kms';
import { SecretValue } from '../../core';
import { Construct as CoreConstruct } from '../../core';
/**
 * Properties for a BasicAuth
 */
export interface BasicAuthProps {
    /**
     * The username
     */
    readonly username: string;
    /**
     * The password
     *
     * @default - A Secrets Manager generated password
     */
    readonly password?: SecretValue;
    /**
     * The encryption key to use to encrypt the password when it's generated
     * in Secrets Manager
     *
     * @default - default master key
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * A Basic Auth configuration
 */
export interface BasicAuthConfig {
    /**
     * Whether to enable Basic Auth
     */
    readonly enableBasicAuth: boolean;
    /**
     * The username
     */
    readonly username: string;
    /**
     * The password
     */
    readonly password: string;
}
/**
 * Basic Auth configuration
 */
export declare class BasicAuth {
    private readonly props;
    /**
     * Creates a Basic Auth configuration from a username and a password
     *
     * @param username The username
     * @param password The password
     */
    static fromCredentials(username: string, password: SecretValue): BasicAuth;
    /**
     * Creates a Basic Auth configuration with a password generated in Secrets
     * Manager.
     *
     * @param username The username
     * @param encryptionKey The encryption key to use to encrypt the password in
     * Secrets Manager
     */
    static fromGeneratedPassword(username: string, encryptionKey?: kms.IKey): BasicAuth;
    constructor(props: BasicAuthProps);
    /**
     * Binds this Basic Auth configuration to an App
     */
    bind(scope: CoreConstruct, id: string): BasicAuthConfig;
}
