"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicAuth = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const secretsmanager = require("../../aws-secretsmanager");
/**
 * Basic Auth configuration
 */
class BasicAuth {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_amplify_BasicAuthProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BasicAuth);
            }
            throw error;
        }
    }
    /**
     * Creates a Basic Auth configuration from a username and a password
     *
     * @param username The username
     * @param password The password
     */
    static fromCredentials(username, password) {
        try {
            jsiiDeprecationWarnings.monocdk_SecretValue(password);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromCredentials);
            }
            throw error;
        }
        return new BasicAuth({ username, password });
    }
    /**
     * Creates a Basic Auth configuration with a password generated in Secrets
     * Manager.
     *
     * @param username The username
     * @param encryptionKey The encryption key to use to encrypt the password in
     * Secrets Manager
     */
    static fromGeneratedPassword(username, encryptionKey) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_kms_IKey(encryptionKey);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedPassword);
            }
            throw error;
        }
        return new BasicAuth({ username, encryptionKey });
    }
    /**
     * Binds this Basic Auth configuration to an App
     */
    bind(scope, id) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const config = {
            enableBasicAuth: true,
            username: this.props.username,
        };
        if (this.props.password) {
            return {
                ...config,
                password: this.props.password.unsafeUnwrap(),
            };
        }
        const secret = new secretsmanager.Secret(scope, id, {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({ username: this.props.username }),
                generateStringKey: 'password',
            },
        });
        return {
            ...config,
            password: secret.secretValueFromJson('password').unsafeUnwrap(),
        };
    }
}
exports.BasicAuth = BasicAuth;
_a = JSII_RTTI_SYMBOL_1;
BasicAuth[_a] = { fqn: "monocdk.aws_amplify.BasicAuth", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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