"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasePathMapping = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in
 * the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 */
class BasePathMapping extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigateway_BasePathMappingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BasePathMapping);
            }
            throw error;
        }
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (!props.basePath.match(/^[a-zA-Z0-9$_.+!*'()-]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()", received: ${props.basePath}`);
            }
        }
        // if restApi is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        const stage = props.stage ?? (props.restApi instanceof restapi_1.RestApiBase
            ? props.restApi.deploymentStage
            : undefined);
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage && stage.stageName,
        });
    }
}
exports.BasePathMapping = BasePathMapping;
_a = JSII_RTTI_SYMBOL_1;
BasePathMapping[_a] = { fqn: "monocdk.aws_apigateway.BasePathMapping", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,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