"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const path = require("path");
const lambda = require("../../../aws-lambda");
const core_1 = require("../../../core");
const lib_1 = require("../../lib");
/*
 * Stack verification steps:
 * * `curl -s -o /dev/null -w "%{http_code}" <url>` should return 401
 * * `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: deny' <url>` should return 403
 * * `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: allow' <url>` should return 200
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'TokenAuthorizerInteg');
const authorizerFn = new lambda.Function(stack, 'MyAuthorizerFunction', {
    runtime: lambda.Runtime.NODEJS_14_X,
    handler: 'index.handler',
    code: lambda.AssetCode.fromAsset(path.join(__dirname, 'integ.token-authorizer.handler')),
});
const restapi = new lib_1.RestApi(stack, 'MyRestApi');
const authorizer = new lib_1.TokenAuthorizer(stack, 'MyAuthorizer', {
    handler: authorizerFn,
});
restapi.root.addMethod('ANY', new lib_1.MockIntegration({
    integrationResponses: [
        { statusCode: '200' },
    ],
    passthroughBehavior: lib_1.PassthroughBehavior.NEVER,
    requestTemplates: {
        'application/json': '{ "statusCode": 200 }',
    },
}), {
    methodResponses: [
        { statusCode: '200' },
    ],
    authorizer,
});
//# sourceMappingURL=data:application/json;base64,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