"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIamAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("../../../aws-apigatewayv2");
/**
 * Authorize HTTP API Routes with IAM
 */
class HttpIamAuthorizer {
    bind(_options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_HttpRouteAuthorizerBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            authorizationType: aws_apigatewayv2_1.HttpAuthorizerType.IAM,
        };
    }
}
exports.HttpIamAuthorizer = HttpIamAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpIamAuthorizer[_a] = { fqn: "monocdk.aws_apigatewayv2_authorizers.HttpIamAuthorizer", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWFtLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaWFtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLGdFQUttQztBQUVuQzs7R0FFRztBQUNILE1BQWEsaUJBQWlCO0lBQ3JCLElBQUksQ0FBQyxRQUF3Qzs7Ozs7Ozs7OztRQUNsRCxPQUFPO1lBQ0wsaUJBQWlCLEVBQUUscUNBQWtCLENBQUMsR0FBRztTQUMxQyxDQUFDO0tBQ0g7O0FBTEgsOENBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBIdHRwQXV0aG9yaXplclR5cGUsXG4gIEh0dHBSb3V0ZUF1dGhvcml6ZXJCaW5kT3B0aW9ucyxcbiAgSHR0cFJvdXRlQXV0aG9yaXplckNvbmZpZyxcbiAgSUh0dHBSb3V0ZUF1dGhvcml6ZXIsXG59IGZyb20gJy4uLy4uLy4uL2F3cy1hcGlnYXRld2F5djInO1xuXG4vKipcbiAqIEF1dGhvcml6ZSBIVFRQIEFQSSBSb3V0ZXMgd2l0aCBJQU1cbiAqL1xuZXhwb3J0IGNsYXNzIEh0dHBJYW1BdXRob3JpemVyIGltcGxlbWVudHMgSUh0dHBSb3V0ZUF1dGhvcml6ZXIge1xuICBwdWJsaWMgYmluZChfb3B0aW9uczogSHR0cFJvdXRlQXV0aG9yaXplckJpbmRPcHRpb25zKTogSHR0cFJvdXRlQXV0aG9yaXplckNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGF1dGhvcml6YXRpb25UeXBlOiBIdHRwQXV0aG9yaXplclR5cGUuSUFNLFxuICAgIH07XG4gIH1cbn0iXX0=