"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpPrivateIntegration = void 0;
const aws_apigatewayv2_1 = require("../../../../aws-apigatewayv2");
/**
 * The HTTP Private integration resource for HTTP API
 *
 * @internal
 */
class HttpPrivateIntegration extends aws_apigatewayv2_1.HttpRouteIntegration {
    constructor() {
        super(...arguments);
        this.httpMethod = aws_apigatewayv2_1.HttpMethod.ANY;
        this.payloadFormatVersion = aws_apigatewayv2_1.PayloadFormatVersion.VERSION_1_0; // 1.0 is required and is the only supported format
        this.integrationType = aws_apigatewayv2_1.HttpIntegrationType.HTTP_PROXY;
        this.connectionType = aws_apigatewayv2_1.HttpConnectionType.VPC_LINK;
    }
    /**
     * Adds a vpcLink to the API if not passed in the options
     *
     * @internal
     */
    _configureVpcLink(bindOptions, configOptions) {
        let vpcLink = configOptions.vpcLink;
        if (!vpcLink) {
            if (!configOptions.vpc) {
                throw new Error('One of vpcLink or vpc should be provided for private integration');
            }
            vpcLink = bindOptions.route.httpApi.addVpcLink({ vpc: configOptions.vpc });
        }
        return vpcLink;
    }
}
exports.HttpPrivateIntegration = HttpPrivateIntegration;
//# sourceMappingURL=data:application/json;base64,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