"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketMockIntegration = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("../../../aws-apigatewayv2");
/**
 * Mock WebSocket Integration
 */
class WebSocketMockIntegration extends aws_apigatewayv2_1.WebSocketRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     */
    constructor(id) {
        super(id);
    }
    bind(options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketRouteIntegrationBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        options;
        return {
            type: aws_apigatewayv2_1.WebSocketIntegrationType.MOCK,
            uri: '',
        };
    }
}
exports.WebSocketMockIntegration = WebSocketMockIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketMockIntegration[_a] = { fqn: "monocdk.aws_apigatewayv2_integrations.WebSocketMockIntegration", version: "1.191.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9jay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1vY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsZ0VBS21DO0FBRW5DOztHQUVHO0FBQ0gsTUFBYSx3QkFBeUIsU0FBUSw0Q0FBeUI7SUFFckU7O09BRUc7SUFDSCxZQUFZLEVBQVU7UUFDcEIsS0FBSyxDQUFDLEVBQUUsQ0FBQyxDQUFDO0tBQ1g7SUFFRCxJQUFJLENBQUMsT0FBNkM7Ozs7Ozs7Ozs7UUFDaEQsT0FBTyxDQUFDO1FBQ1IsT0FBTztZQUNMLElBQUksRUFBRSwyQ0FBd0IsQ0FBQyxJQUFJO1lBQ25DLEdBQUcsRUFBRSxFQUFFO1NBQ1IsQ0FBQztLQUNIOztBQWZILDREQWdCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIFdlYlNvY2tldFJvdXRlSW50ZWdyYXRpb24sXG4gIFdlYlNvY2tldEludGVncmF0aW9uVHlwZSxcbiAgV2ViU29ja2V0Um91dGVJbnRlZ3JhdGlvbkNvbmZpZyxcbiAgV2ViU29ja2V0Um91dGVJbnRlZ3JhdGlvbkJpbmRPcHRpb25zLFxufSBmcm9tICcuLi8uLi8uLi9hd3MtYXBpZ2F0ZXdheXYyJztcblxuLyoqXG4gKiBNb2NrIFdlYlNvY2tldCBJbnRlZ3JhdGlvblxuICovXG5leHBvcnQgY2xhc3MgV2ViU29ja2V0TW9ja0ludGVncmF0aW9uIGV4dGVuZHMgV2ViU29ja2V0Um91dGVJbnRlZ3JhdGlvbiB7XG5cbiAgLyoqXG4gICAqIEBwYXJhbSBpZCBpZCBvZiB0aGUgdW5kZXJseWluZyBpbnRlZ3JhdGlvbiBjb25zdHJ1Y3RcbiAgICovXG4gIGNvbnN0cnVjdG9yKGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihpZCk7XG4gIH1cblxuICBiaW5kKG9wdGlvbnM6IFdlYlNvY2tldFJvdXRlSW50ZWdyYXRpb25CaW5kT3B0aW9ucyk6IFdlYlNvY2tldFJvdXRlSW50ZWdyYXRpb25Db25maWcge1xuICAgIG9wdGlvbnM7XG4gICAgcmV0dXJuIHtcbiAgICAgIHR5cGU6IFdlYlNvY2tldEludGVncmF0aW9uVHlwZS5NT0NLLFxuICAgICAgdXJpOiAnJyxcbiAgICB9O1xuICB9XG59XG4iXX0=